/*  project.h
 *
 *  General defines and such for the project.
 */

#ifndef _PROJECT_H
#define _PROJECT_H

#include <stdio.h>

#define FALSE 0
#define TRUE !FALSE

typedef unsigned char byte;
typedef unsigned int word;
typedef long Fixedpoint;
typedef Fixedpoint Xform[4][4];
typedef Fixedpoint Xvect[4];

#define FIXED_TO_INT(a) (int)((a) >> 16)
#define INT_TO_FIXED(a) ((Fixedpoint)(a) << 16)
#define FIXED_TO_FLOAT(a) (float)((a) / 65536.0)
#define FLOAT_TO_FIXED(a) (Fixedpoint)((a) * 65536.0)

typedef struct {
  Fixedpoint i;
  Fixedpoint j;
  Fixedpoint k;
} VECTOR;

typedef struct {
  int x;
  int y;
} POINT_2D;

typedef struct {
  Fixedpoint x;
  Fixedpoint y;
  Fixedpoint z;
} POINT;

typedef struct {
  byte red;
  byte green;
  byte blue;
} COLOR;

typedef struct {
  COLOR color[256];
} PALETTE;

typedef struct {
  byte start;
  byte num;
  COLOR color[256];
} APALETTE;

typedef struct {
  float red;
  float green;
  float blue;
} TFloatColor;

typedef struct {
  TFloatColor color[256];
} TFloatPalette;

extern FILE *yyin;

void report(char *, ...);
int yyparse(void);
void yyrestart(FILE *);

#endif /* _PROJECT_H */

