/*  math.h
 *
 *  Include stuff for math routines.
 *
 *  Written and copyright (c) 1994 by Steve Madsen.
 */

#ifndef _MATH_H
#define _MATH_H

/* miscellaneous defines */

#define PI 3.14159265358979323846
#define DEGREES 256

#define deg2rad(a) (((a) * PI) / (DEGREES >> 1))

/* variables */

extern Fixedpoint sin_table[];
extern Fixedpoint cos_table[];

/* prototypes from fixed.asm */

void ConcatXforms(Xform, Xform, Xform);
Fixedpoint FixedDiv(Fixedpoint, Fixedpoint);
Fixedpoint FixedMul(Fixedpoint, Fixedpoint);
void XformPt(Xform, Fixedpoint *, Fixedpoint *);
void XformVec(Xform, Fixedpoint *, Fixedpoint *);

/* prototypes from math.c */

void CalcNewPoint(POINT *, POINT *, Xform);
Fixedpoint DotProduct(VECTOR *, VECTOR *);
void NormalizeVector(VECTOR *);
void RotationMatrix(byte, byte, byte, Xform);
int sign(long);

#endif /* _MATH_H */

