/*  math.c
 *
 *  Additional math support routines to complement the code in fixed.asm.
 *  Thanks to Michael Abrash for making his integer math routines free
 *  for public use!
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <xlib_all.h>
#include "project.h"
#include "math.h"
#include "sincos.inc"

Fixedpoint DotProduct(VECTOR *v1, VECTOR *v2)
{
  return (FixedMul(v1->i, v2->i) + FixedMul(v1->j, v2->j) + FixedMul(v1->k, v2->k));
}

void NormalizeVector(VECTOR *vector)
{
  Fixedpoint length, length2;
  Fixedpoint a, b, c;

  a = FixedMul(vector->i, vector->i);
  b = FixedMul(vector->j, vector->j);
  c = FixedMul(vector->k, vector->k);
  length2 = a + b + c;
  length = FLOAT_TO_FIXED(sqrt(FIXED_TO_FLOAT(length2)));
  if (length == 0) {
    x_text_mode();
    printf("NormalizeVector() -- vector length is zero!\n");
    printf("%lx %lx\n", length2, length);
    exit(1);
  }
  vector->i = FixedDiv(vector->i, length);
  vector->j = FixedDiv(vector->j, length);
  vector->k = FixedDiv(vector->k, length);
}

void RotationMatrix(byte xangle, byte yangle, byte zangle, Xform m)
{
  Fixedpoint sinz_siny, cosz_siny;

  m[0][0] = FixedMul(cos_table[zangle], cos_table[yangle]);
  m[0][1] = FixedMul(-sin_table[zangle], cos_table[yangle]);
  m[0][2] = sin_table[yangle];
  m[0][3] = 0L;
  m[1][0] = FixedMul(sin_table[zangle], cos_table[xangle]) +
            FixedMul(cosz_siny = FixedMul(cos_table[zangle], sin_table[yangle]), sin_table[xangle]);
  m[1][1] = FixedMul(cos_table[zangle], cos_table[xangle]) -
            FixedMul(sinz_siny = FixedMul(sin_table[zangle], sin_table[yangle]), sin_table[xangle]);
  m[1][2] = FixedMul(-cos_table[yangle], sin_table[xangle]);
  m[1][3] = 0L;
  m[2][0] = FixedMul(sin_table[zangle], sin_table[xangle]) -
            FixedMul(cosz_siny, cos_table[xangle]);
  m[2][1] = FixedMul(sinz_siny, cos_table[xangle]) +
            FixedMul(cos_table[zangle], sin_table[xangle]);
  m[2][2] = FixedMul(cos_table[yangle], cos_table[xangle]);
  m[2][3] = 0L;
  m[3][0] = 0L;
  m[3][1] = 0L;
  m[3][2] = 0L;
  m[3][3] = INT_TO_FIXED(1);
}

int sign(long num)
{
  if (num > 0)
    return 1;
  else
    if (num < 0)
      return -1;
    else
      return 0;
}

