/*  gfx.h
 *
 *  Include file for graphics routines.
 *
 *  Written and copyright (c) 1994 by Steve Madsen.
 */

#ifndef _GFX_H
#define _GFX_H

#include "project.h"
#include "object.h"

#define FUDGE 277

#define BLACK 0
#define SHADES 32
#define GREY_BASE (256 - SHADES + 1)
#define BLUE_BASE (GREY_BASE - SHADES + 1)
#define GREEN_BASE (BLUE_BASE - SHADES + 1)
#define RED_BASE (GREEN_BASE - SHADES + 1)

#define GIF 1
#define NONE 2

/* types */

typedef struct {
  POINT_2D ul, lr;
} RECT;

/* variables */

extern word screenheight;
extern POINT eye;
extern POINT light;
extern byte background;
extern PALETTE defpal;
extern byte backcolor;

/* function prototypes -- these are contained in gfx.asm */

void GetPalette(PALETTE *);
void GetPaletteColor(byte, COLOR *);
void SetPaletteColor(byte, COLOR *);
void WaitRetrace(void);

/* function prototypes -- these are contained in gfx_c.c */

void DrawBackground(void);
void ExtendRectangle(POINT_2D *);
void FadeIn(PALETTE *);
void FadeOut(COLOR *);
void GraphicsDone(void);
void GraphicsInit(void);
void Line(POINT *, POINT *, int);
void Line_2d(POINT_2D *, POINT_2D *, int);
void LoadBackground(char *, int);
POINT *MakePoint(float, float, float, POINT *);
void MoveEye(POINT *);
void MoveLight(POINT *);
void PageFlip(void);
void Polygon(POINT *, int, int);
void Polygon_2d(POINT_2D *, int, int);
void Project(POINT *, POINT_2D *);
void Rectangle(POINT *, POINT *, POINT *, POINT *, int);
void ResyncPalette(void);
void SetBackground(byte);
void SetPalette(PALETTE *);
void ShadedPaletteInit(void);
void SpinPalette(int);

/* function prototypes -- these are contained in drawtexp.c */

void DrawTexturedPolygon(POINT_2D *, int, POINT_2D *, BITMAP *);

#endif /* _GFX_H */

