; gfx.asm
;
; Additional graphics routines to complement Xlib.
;
; Written and copyright (c) 1994 by Steve Madsen.

        IDEAL
        LOCALS
        P386N
        MODEL   LARGE,C

; *****************************************************************************

        CODESEG

        PUBLIC  GetPalette
        PUBLIC  GetPaletteColor
        PUBLIC  _SetPalette
        PUBLIC  SetPaletteColor
        PUBLIC  WaitRetrace

; *****************************************************************************
; void GetPalette(TPalette *)
; *****************************************************************************

PROC    GetPalette
        ARG     palette:DWORD

        cli
        push    di
        mov     dx,3C7h
        mov     al,0                    ; starting at color index 0
        out     dx,al
        mov     dx,3C9h
        les     di,[palette]
        mov     cx,256                  ; 256 color palette
@@next_color:
        in      al,dx
        mov     [es:di],al              ; red
        in      al,dx
        mov     [es:di+1],al            ; green
        in      al,dx
        mov     [es:di+2],al            ; blue
        add     di,3                    ; point to next color
        loop    @@next_color
        pop     di
        sti
        ret

ENDP    GetPalette

; *****************************************************************************
; void GetPaletteColor(byte, TColor *)
; *****************************************************************************

PROC    GetPaletteColor
        ARG     whichcolor:BYTE,colorentry:DWORD

        push    di
        mov     dx,3C7h
        mov     al,[whichcolor]
        out     dx,al
        mov     dx,3C9h
        les     di,[colorentry]
        in      al,dx
        mov     [es:di],al              ; red
        in      al,dx
        mov     [es:di+1],al            ; green
        in      al,dx
        mov     [es:di+2],al            ; blue
        pop     di
        ret

ENDP    GetPaletteColor

; *****************************************************************************
; void _SetPalette(TPalette *)
; *****************************************************************************

PROC    _SetPalette
        ARG     palette:DWORD

        cli
        push    di
        mov     dx,3C8h
        mov     al,0                    ; starting at color index 0
        out     dx,al
        mov     dx,3C9h
        les     di,[palette]
        mov     cx,128                  ; first half of 256 color palette
        call    WaitRetrace
@@first_chunk:
        mov     al,[es:di]              ; red
        out     dx,al
        mov     al,[es:di+1]            ; green
        out     dx,al
        mov     al,[es:di+2]            ; blue
        out     dx,al
        add     di,3                    ; point to next color
        loop    @@first_chunk
        mov     cx,128                  ; second half of 256 color palette
        call    WaitRetrace
@@second_chunk:
        mov     al,[es:di]              ; red
        out     dx,al
        mov     al,[es:di+1]            ; green
        out     dx,al
        mov     al,[es:di+2]            ; blue
        out     dx,al
        add     di,3                    ; point to next color
        loop    @@second_chunk
        pop     di
        sti
        ret

ENDP    _SetPalette

; *****************************************************************************
; void SetPaletteColor(byte, TColor *)
; *****************************************************************************

PROC    SetPaletteColor
        ARG     whichcolor:BYTE,colorentry:DWORD

        push    di
        mov     dx,3C8h
        mov     al,[whichcolor]
        out     dx,al
        mov     dx,3C9h
        les     di,[colorentry]
        mov     al,[es:di]              ; red
        out     dx,al
        mov     al,[es:di+1]            ; green
        out     dx,al
        mov     al,[es:di+2]            ; blue
        out     dx,al
        pop     di
        ret

ENDP    SetPaletteColor

; *****************************************************************************
; void WaitRetrace(void)
;
; Waits for the vertical retrace sync to complete.  Waiting for this signal
; before doing any intensive video operations assures that there will be no
; flicker in the image for the duration of the operation.
; *****************************************************************************

PROC    WaitRetrace

        push    dx
        push    ax
        mov     dx,03DAh
@@wait_for_bit_clear:
        in      al,dx
        test    al,00001000b
        jnz     @@wait_for_bit_clear
@@wait_for_bit_set:
        in      al,dx
        test    al,00001000b
        jz      @@wait_for_bit_set
        pop     ax
        pop     dx
        ret

ENDP    WaitRetrace

        ENDS

; *****************************************************************************

        END

