unit dev4_1; {Developer program version 4, unit 1. Stfan Viljoen
              Internet: 9128476@pukrs3.puk.ac.za
              Main unit for Develop4, the program to use with my tsr
              snap4. Develop4 also saves sprites in the .CSF format for
              use with my unit sgraph.}

INTERFACE

uses dos,graph,crt,sgraph;

const version = '4.0';

      leftupcorner = true;
      rightlowcorner = false;
      yes = true;
      no = false;

      boxframecolor = lightblue;
      boxheadcolor = lightcyan;
      boxtextcolor = lightmagenta;
      texthighcolor = lightred;

      specialkey = #0;
      tab = #9;
      enter = #13;
      escape = #27;
      f1 = #59;
      f2 = #60;
      f3 = #61;
      f4 = #62;
      f5 = #63;
      f6 = #64;
      f7 = #65;
      f8 = #66;
      f9 = #67;
      home = #71;
      uparrow = #72;
      pgup = #73;
      lfarrow = #75;
      rtarrow = #77;
      endkey = #79;
      dnarrow = #80;
      pgdwn = #81;
      ctrlf1 = #94;
      altf6 = #109;
      altf7 = #110;
      altf8 = #111;
      altf9 = #112;
      altf10 = #113;

      altkeydown: byte = $0008;
      stanmode: byte = 0;
      spreditmode: byte = 1;

      stanboxdispdelay: word = 750;
      stanflashdelay: word = 50;
      stanflashloop: word = 15;

type boxrecord = record
                   x1,y1,x2,y2: integer;
                   color,step: byte;
                   curcorner: boolean;
                   frozen: boolean;
                   maxstep,minstep: word;
                 end;

     rectrecord = record
                    x1,y1,x2,y2: word;
                  end;

var boxrec: boxrecord;
    letter: char;
    marksprarr: array[1..255] of rectrecord;
    marksprarridx,progmode,editsprbox,frombox,tobox: byte;
    picfilename,csffilename,xysfilename,palfilename: string;
    picfile,xysfile,palfile: file;
    masterscrp: pointer;
    boxdispdelay,flashdelay,flashloop: word;
    tsrscreen: boolean;

{-Logic-}
procedure initvars;
procedure storemasterscr;
procedure restoremasterscr;
{-Screen-}
procedure vgamode;
procedure drawbox;
procedure showcurcorner;
procedure checkboundaries;
procedure marksprite_drwreportrect;
procedure marksprite;
procedure unmarksprite;
procedure editsprites;
procedure savesprites;
procedure showspritesequence;
procedure movelogicalsprite(pfrombox,ptobox: byte);
procedure savepalette;
procedure dispselectedsprites;
procedure savescreen;
{-Screen.info boxes-}
procedure askexitbox;
procedure helpbox;
procedure statusbox;
{-Utility-}
procedure givefilenames;

IMPLEMENTATION

{-Logic-}

procedure initvars;
var clearloop: integer;
begin
  with boxrec do
  begin
    x1:= 0;
    y1:= 0;
    x2:= 319;
    y2:= 199;
    step:= 1;
    curcorner:= leftupcorner;
    frozen:= no;
  end;
  for clearloop:= 1 to 255 do
  begin
    marksprarr[clearloop].x1:= 0;
    marksprarr[clearloop].y1:= 0;
    marksprarr[clearloop].x2:= 0;
    marksprarr[clearloop].y2:= 0;
  end;
  marksprarridx:= 1;
  progmode:= stanmode;
  if tsrscreen = no then picfilename:= paramstr(1) else picfilename:= '';
  csffilename:= '';
  xysfilename:= '';
  palfilename:= '';
  editsprbox:= 1;
  frombox:= 0;
  tobox:= 0;
 {These must later be read form a file to make them changeable.}
  boxdispdelay:= stanboxdispdelay;
  flashdelay:= stanflashdelay;
  flashloop:= stanflashloop;
  with boxrec do
  begin
    color:= 15;
    maxstep:= 20;
    minstep:= 1;
  end;
end;

procedure storemasterscr;
begin
  sgraph_copyscr(hidscr,visscr);
  getmem(masterscrp,64000);
  move(mem[$0a000:$00000],masterscrp^,64000);
end;

procedure restoremasterscr;
begin
  move(masterscrp^,hidscrp^,64000);
end;

{-Screen-}

procedure vgamode;
var card,mode: integer;
begin
  card:= installuserdriver('VGA256',nil);
  initgraph(card,mode,'');
end;

procedure drawbox;
var color,loop: byte;
begin
  color:= boxrec.color;
  setcolor(boxrec.color);
  sgraph_copyscr(hidscr,visscr);
  if progmode = stanmode then
  begin
    with boxrec do
    begin
      rectangle(x1,y1,x2,y2);
    end;
  end
  else
  begin
    for loop:= 1 to flashloop do
    begin
      rectangle(marksprarr[editsprbox].x1,marksprarr[editsprbox].y1,
        marksprarr[editsprbox].x2,marksprarr[editsprbox].y2);
      if color = 0 then color:= boxrec.color else color:= 0;
      setcolor(color);
      delay(flashdelay);
    end;
    setcolor(boxrec.color);
    rectangle(marksprarr[editsprbox].x1,marksprarr[editsprbox].y1,
      marksprarr[editsprbox].x2,marksprarr[editsprbox].y2);
  end;
end;

procedure showcurcorner;
var showloop: byte;
    x,y,xa,ya: integer;
begin
  if boxrec.curcorner = leftupcorner then
  begin
    x:= boxrec.x1;
    y:= boxrec.y1;
  end
  else
  begin
    x:= boxrec.x2;
    y:= boxrec.y2;
  end;
  xa:= x;
  ya:= y;
  for showloop:= 1 to 10 do
  begin
    rectangle(x,y,xa,ya);
    dec(x);
    dec(y);
    inc(xa);
    inc(ya);
  end;
  delay(50);
  sgraph_copyscr(hidscr,visscr);
end;

procedure checkboundaries;
var startaddr,xlength,ylength: word;
begin
  sgraph_copyscr(hidscr,visscr);
{$R-}
  startaddr:= 320 * boxrec.y1;
  startaddr:= startaddr + boxrec.x1;
{$R+}
  xlength:= boxrec.x2 - boxrec.x1 + 1;
  ylength:= boxrec.y2 - boxrec.y1 + 1;
  asm
    mov  ax,0a000h
    mov  es,ax
    mov  bx,startaddr
    mov  cx,ylength
    mov  dh,15
   @yloop:
    push cx
    mov  cx,xlength
   @xloop:
    mov  dl,byte ptr es:[bx]
    cmp  dl,0
    je   @nochange
    mov  byte ptr es:[bx],dh
   @nochange:
    inc  bx
    loop @xloop
    add  bx,320
    sub  bx,xlength
    pop  cx
    loop @yloop
  end;
  setcolor(lightblue);
  with boxrec do
  begin
    rectangle(x1,y1,x2,y2);
  end;
end;

procedure marksprite_drwreportrect;
begin
  sgraph_setpal(oldpalp);
  sgraph_filledevensizerect(0,0,122,20,black);
  setcolor(boxframecolor);
  rectangle(0,0,122,20);
  setcolor(boxtextcolor);
end;

procedure marksprite;
var marksprstr: string;
begin
  if marksprarridx < 255 then
  begin
    marksprite_drwreportrect;
    outtextxy(2,2,'Marked sprite');
    str(marksprarridx,marksprstr);
    outtextxy(2,11,'number: '+marksprstr);
    delay(boxdispdelay);
    sgraph_setpal(palp);
    with boxrec do
    begin
      marksprarr[marksprarridx].x1:= x1;
      marksprarr[marksprarridx].y1:= y1;
      marksprarr[marksprarridx].x2:= x2;
      marksprarr[marksprarridx].y2:= y2;
      inc(marksprarridx);
      editsprbox:= marksprarridx - 1;
      sgraph_copyscr(hidscr,visscr);
      setcolor(boxrec.color);
      rectangle(x1,y1,x2,y2);
      sgraph_copyscr(visscr,hidscr);
    end;
  end
  else
  begin
    sgraph_setpal(oldpalp);
    sgraph_filledevensizerect(0,0,106,20,black);
    setcolor(boxframecolor);
    rectangle(0,0,106,20);
    setcolor(boxtextcolor);
    outtextxy(2,2,'Max sprs have');
    outtextxy(2,11,'been marked');
    readkey;
    sgraph_setpal(palp);
    sgraph_copyscr(hidscr,visscr);
  end;
end;

procedure unmarksprite;
var marksprstr: string;
    redrawloop: byte;
begin
  if marksprarridx > 1 then
  begin
    dec(marksprarridx);
    marksprite_drwreportrect;
    sgraph_setpal(oldpalp);
    outtextxy(2,2,'Unmarked sprite');
    str(marksprarridx,marksprstr);
    outtextxy(2,11,'number: '+marksprstr);
    delay(boxdispdelay);
    sgraph_copyscr(hidscr,visscr);
    setcolor(0);
    rectangle(marksprarr[marksprarridx].x1,marksprarr[marksprarridx].y1,
      marksprarr[marksprarridx].x2,marksprarr[marksprarridx].y2);
    marksprarr[marksprarridx].x1:= 0;
    marksprarr[marksprarridx].y1:= 0;
    marksprarr[marksprarridx].x2:= 0;
    marksprarr[marksprarridx].y2:= 0;
    restoremasterscr;
    sgraph_copyscr(hidscr,visscr);
    if marksprarridx >= 1 then
    begin
      setcolor(boxrec.color);
      for redrawloop:= 1 to marksprarridx - 1 do
      begin
        rectangle(marksprarr[redrawloop].x1,
          marksprarr[redrawloop].y1,marksprarr[redrawloop].x2,
            marksprarr[redrawloop].y2);
      end;
    end;
    sgraph_copyscr(visscr,hidscr);
    sgraph_setpal(palp);
  end
  else
  begin
    marksprite_drwreportrect;
    sgraph_setpal(oldpalp);
    outtextxy(2,2,'No sprites to');
    str(marksprarridx-1,marksprstr);
    outtextxy(2,11,'unmark');
    readkey;
    sgraph_setpal(palp);
    sgraph_copyscr(hidscr,visscr);
  end;
end;

procedure editsprites;
begin
  if ((marksprarridx > 1) and (progmode <> spreditmode)) then
  begin
    marksprite_drwreportrect;
    outtextxy(2,2,'Sprite edit');
    outtextxy(2,11,'mode active');
    delay(boxdispdelay);
    progmode:= spreditmode;
  end
  else
  begin
    marksprite_drwreportrect;
    sgraph_setpal(oldpalp);
    if progmode = stanmode then
    begin
      outtextxy(2,2,'No sprites to');
      outtextxy(2,11,'seq edit');
      readkey;
    end
    else
    begin
      outtextxy(2,2,'Normal mode');
      outtextxy(2,11,'active');
      delay(boxdispdelay);
      progmode:= stanmode;
    end;
    sgraph_setpal(palp);
    sgraph_copyscr(hidscr,visscr);
  end;
end;

procedure savesprites;
Var spriteloop: byte;
    savestatus: boolean;
    tempfile: file;
begin
  marksprite_drwreportrect;
  sgraph_setpal(oldpalp);
  if length(csffilename) > 0 then
  begin
    if sgraph_fileexists(csffilename) then
    begin
      outtextxy(2,2,'Overwrite the');
      outtextxy(2,11,'existing file?');
      letter:= readkey;
      letter:= upcase(letter);
      if letter = 'Y' then
      begin
        savestatus:= yes;
        assign(tempfile,csffilename);
        reset(tempfile,1);
        erase(tempfile);
        close(tempfile);
      end
      else if letter = 'N' then savestatus:= yes else savestatus:= no;
      letter:= #0;
      marksprite_drwreportrect;
      sgraph_setpal(oldpalp);
    end
    else
    begin
      savestatus:= yes;
    end;
  end
  else
  begin
    marksprite_drwreportrect;
    outtextxy(2,2,'Need a CSF');
    outtextxy(2,11,'filename');
    readkey;
    sgraph_copyscr(hidscr,visscr);
    marksprite_drwreportrect;
    outtextxy(2,2,'Use F9 to');
    outtextxy(2,11,'supply name');
    readkey;
    savestatus:= no;
  end;
  if savestatus = yes then
  begin
    if marksprarridx > 1 then
    begin
      outtextxy(2,2,'Saving marked');
      outtextxy(2,11,'sprites');
      delay(stanboxdispdelay);
      sgraph_copyscr(hidscr,visscr);
      for spriteloop:= 1 to marksprarridx - 1 do
      begin
        sgraph_capturesprite(marksprarr[spriteloop].x1+1,
          marksprarr[spriteloop].y1+1,marksprarr[spriteloop].x2,
            marksprarr[spriteloop].y2,spriteloop-1);
      end;
      sgraph_savesprites(csffilename,1,Marksprarridx - 1);
      sgraph_releasesprites(1,marksprarridx - 1);
      sgraph_copyscr(hidscr,visscr);
      marksprite_drwreportrect;
      outtextxy(2,2,'Done saving');
      outtextxy(2,11,'sprites');
      readkey;
    end
    else
    begin
      outtextxy(2,2,'No sprites to');
      outtextxy(2,11,'save');
      readkey;
    end;
  end;
  sgraph_setpal(palp);
  sgraph_copyscr(hidscr,visscr);
end;

procedure showspritesequence;
var showloop,loop,color: byte;
begin
  sgraph_setpal(oldpalp);
  marksprite_drwreportrect;
  if marksprarridx > 1 then
  begin
    outtextxy(2,2,'Enter for');
    outtextxy(2,11,'sequence');
    readkey;
    sgraph_copyscr(hidscr,visscr);
    for showloop:= 1 to marksprarridx - 1 do
    begin
      for loop:= 1 to flashloop do
      begin
        rectangle(marksprarr[showloop].x1,marksprarr[showloop].y1,
          marksprarr[showloop].x2,marksprarr[showloop].y2);
        if color = 0 then color:= boxrec.color else color:= 0;
        setcolor(color);
        delay(flashdelay);
      end;
      setcolor(boxrec.color);
      rectangle(marksprarr[showloop].x1,marksprarr[showloop].y1,
          marksprarr[showloop].x2,marksprarr[showloop].y2);
    end;
  end
  else
  begin
    outtextxy(2,2,'No sprites to');
    outtextxy(2,11,'sequence disp');
    readkey;
  end;
  sgraph_copyscr(hidscr,visscr);
  sgraph_setpal(palp);
end;

procedure movelogicalsprite(pfrombox,ptobox: byte);
var temprec: rectrecord;
begin
  with temprec do
  begin
    x1:= marksprarr[ptobox].x1;
    y1:= marksprarr[ptobox].y1;
    x2:= marksprarr[ptobox].x2;
    y2:= marksprarr[ptobox].y2;
  end;
  marksprarr[ptobox].x1:= marksprarr[pfrombox].x1;
  marksprarr[ptobox].y1:= marksprarr[pfrombox].y1;
  marksprarr[ptobox].x2:= marksprarr[pfrombox].x2;
  marksprarr[ptobox].y2:= marksprarr[pfrombox].y2;
  with temprec do
  begin
    marksprarr[pfrombox].y1:= y1;
    marksprarr[pfrombox].x1:= x1;
    marksprarr[pfrombox].y2:= y2;
    marksprarr[pfrombox].x2:= x2;
  end;
end;

procedure savepalette;
var esreg,dxreg: word;
    tempp: pointer;
    savestatus: boolean;
begin
  savestatus:= yes;
  marksprite_drwreportrect;
  sgraph_setpal(oldpalp);
  if length(palfilename) > 0 then
  begin
    if sgraph_fileexists(palfilename) then
    begin
      outtextxy(2,2,'Overwrite the');
      outtextxy(2,11,'existing file?');
      letter:= readkey;
      letter:= upcase(letter);
      if letter = 'Y' then savestatus:= yes else savestatus:= no;
    end;
  end
  else
  begin
    outtextxy(2,2,'Need a PAL');
    outtextxy(2,11,'filename');
    readkey;
    sgraph_copyscr(hidscr,visscr);
    marksprite_drwreportrect;
    outtextxy(2,2,'Use F9 to');
    outtextxy(2,11,'supply name');
    readkey;
    savestatus:= no;
  end;
  sgraph_copyscr(hidscr,visscr);
  sgraph_setpal(palp);
  if savestatus = yes then
  begin
    getmem(tempp,768);
    assign(palfile,palfilename);
    rewrite(palfile,1);
    esreg:= seg(tempp^);
    dxreg:= ofs(tempp^);
    asm
      Mov  ES,esreg
      Mov  DX,dxreg
      Mov  BX,0
      Mov  CX,256
      Mov  AL,17h
      Mov  AH,10h
      Int  10h
    end;
    blockwrite(palfile,tempp^,768);
    close(palfile);
  end;
end;

procedure dispselectedsprites;
var spriteloop: byte;
begin
  marksprite_drwreportrect;
  sgraph_setpal(oldpalp);
  if marksprarridx > 1  then
  begin
    outtextxy(2,2,'Displaying');
    outtextxy(2,11,'sel sprites');
    delay(stanboxdispdelay);
    sgraph_setpal(palp);
    for spriteloop:= 1 to marksprarridx - 1 do
    begin
      sgraph_copyscr(hidscr,visscr);
      sgraph_capturesprite(marksprarr[spriteloop].x1+1,
          marksprarr[spriteloop].y1+1,marksprarr[spriteloop].x2,
            marksprarr[spriteloop].y2,spriteloop-1);
      sgraph_displaysprite(0,0,spriteloop-1);
      readkey;
      freemem(sprdataarr[spriteloop-1],
          memw[seg(sprdataarr[spriteloop-1]^):
            ofs(sprdataarr[spriteloop-1]^)]);
    end;
    sgraph_copyscr(hidscr,visscr);
    marksprite_drwreportrect;
    sgraph_setpal(oldpalp);
    outtextxy(2,2,'Done with');
    outtextxy(2,11,'spr display');
    readkey;
  end
  else
  begin
    if marksprarridx <= 1 then
    begin
      outtextxy(2,2,'No sprites sel');
      outtextxy(2,11,'to display');
    end
    else
    begin
      outtextxy(2,2,'Save sprs ');
      outtextxy(2,11,'first');
    end;
    readkey;
  end;
  sgraph_setpal(palp);
  sgraph_copyscr(hidscr,visscr);
end;

procedure savescreen;
begin
  marksprite_drwreportrect;
  sgraph_setpal(oldpalp);
  if length(picfilename) > 0 then
  begin
    if sgraph_fileexists(picfilename) then
    begin
      outtextxy(2,2,'Overwrite the');
      outtextxy(2,11,'existing file?');
      letter:= readkey;
      letter:= upcase(letter);
      if letter = 'Y' then
      begin
        sgraph_setpal(palp);
        sgraph_copyscr(hidscr,visscr);
        sgraph_savepicture(picfilename,visscr);
      end;
      letter:= #0;
    end
    else
    begin
      sgraph_setpal(palp);
      sgraph_copyscr(hidscr,visscr);
      sgraph_savepicture(picfilename,visscr);
    end;
  end
  else
  begin
    marksprite_drwreportrect;
    outtextxy(2,2,'Need a PIC');
    outtextxy(2,11,'filename');
    readkey;
    sgraph_copyscr(hidscr,visscr);
    marksprite_drwreportrect;
    outtextxy(2,2,'Use F9 to');
    outtextxy(2,11,'supply name');
    readkey;
    sgraph_setpal(palp);
    sgraph_copyscr(hidscr,visscr);
  end;
end;

{-Screen.info boxes-}

procedure askexitbox;
begin
  sgraph_filledevensizerect(0,0,106,20,black);
  setcolor(boxframecolor);
  rectangle(0,0,106,20);
  setcolor(boxheadcolor);
  outtextxy(2,2,'EXIT');
  setcolor(boxtextcolor);
  outtextxy(2,11,'Are you sure?');
end;

procedure helpbox;
const rx = 162;
      lx = 2;
var helppage: byte;
begin
  helppage:= 1;
  sgraph_setpal(oldpalp);
  repeat
    if progmode = stanmode then
    begin
      if helppage = 1 then
      begin
        sgraph_filledevensizerect(0,0,320,200,black);
        setcolor(boxframecolor);
        rectangle(0,0,319,199);
        setcolor(boxheadcolor);
        outtextxy(2,2,'Help-1 (More: pgdn)');
       {-left side-}
        setcolor(boxframecolor);
        line(159,0,159,118);
        line(159,118,319,118);
        setcolor(texthighcolor);
        outtextxy(lx,11,'F2');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F2') + 4,11,'Status');
        setcolor(texthighcolor);
        outtextxy(lx,20,'F3');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F3') + 4,20,'Show spr boundary');
        setcolor(texthighcolor);
        outtextxy(lx,30,'F4');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F4') + 4,30,'Mark sprite');
        setcolor(texthighcolor);
        outtextxy(lx,40,'F5');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F5') + 4,40,'Unmark last');
        outtextxy(lx + textwidth('F5') + 4,50,'sprite');
        setcolor(texthighcolor);
        outtextxy(lx,60,'F6');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F6') + 4,60,'Edit marked');
        outtextxy(lx + textwidth('F6') + 4,70,'sprite sequence');
        setcolor(texthighcolor);
        outtextxy(lx,80,'F7');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F7') + 4,80,'Save marked');
        outtextxy(lx + textwidth('F7') + 4,90,'sprites in .CSF');
        outtextxy(lx + textwidth('F7') + 4,100,'file format');
        setcolor(texthighcolor);
        outtextxy(lx,110,'F8');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F8') + 4,110,'Save picture in');
        outtextxy(lx + textwidth('F8') + 4,120,'.PIC file format');
        setcolor(texthighcolor);
        outtextxy(lx,130,'F9');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F9') + 4,130,'Enter filenames');
        setcolor(texthighcolor);
        outtextxy(lx,140,'F10');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('F10') + 4,140,'Adjust delay(s)');
        setcolor(texthighcolor);
        outtextxy(lx,150,'Alt-F1');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('Alt-F1') + 4,150,'Save sprite');
        outtextxy(lx + textwidth('Alt-F1') + 4,160,'xy''s');
        setcolor(texthighcolor);
        outtextxy(lx,170,'Alt-F2');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('Alt-F2') + 4,170,'Load sprite');
        outtextxy(lx + textwidth('Alt-F2') + 4,180,'xy''s');
        setcolor(texthighcolor);
        outtextxy(lx,190,'Alt-F3');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('Alt-F3') + 4,190,'Load .CSF');
       {-right side-}
        setcolor(texthighcolor);
        outtextxy(rx,2,'Keypad');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('Keypad') + 4,2,'Move box or');
        outtextxy(rx,11,'corners/pather box');
        setcolor(texthighcolor);
        outtextxy(rx,20,'/');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('/') + 4,20,'Switch box step');
        outtextxy(rx,30,'size to max/min');
        setcolor(texthighcolor);
        outtextxy(rx,40,'*');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('*') + 4,40,'Freeze/unfreeze');
        outtextxy(rx,50,'box');
        setcolor(texthighcolor);
        outtextxy(rx,60,'-');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('-') + 4,60,'Shrink box');
        setcolor(texthighcolor);
        outtextxy(rx,70,'+');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('+') + 4,70,'Expand box');
        setcolor(texthighcolor);
        outtextxy(rx,80,'Tab');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('Tab') + 4,80,'Switch corners');
        setcolor(texthighcolor);
        outtextxy(rx,90,'Numlock - up & down');
        setcolor(boxtextcolor);
        outtextxy(rx,100,'up/down box color');
        setcolor(texthighcolor);
        outtextxy(rx,110,'Esc -');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('Esc - '),110,'Exit');
        setcolor(texthighcolor);
        outtextxy(rx,120,'Alt-F4');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('Alt-F4') + 4,120,'Load .PIC');
        setcolor(texthighcolor);
        outtextxy(rx,130,'Alt-F5');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('Alt-F5') + 4,130,'Show files');
        setcolor(texthighcolor);
        outtextxy(rx,140,'Alt-F6');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('Alt-F6') + 4,140,'Show sprites');
        outtextxy(rx + textwidth('Alt-F6') + 4,150,'selected for/');
        outtextxy(rx + textwidth('Alt-F6') + 4,160,'in .CSF file');
        setcolor(texthighcolor);
        outtextxy(rx,170,'Alt-F7');
        setcolor(boxtextcolor);
        outtextxy(rx + textwidth('Alt-F7') + 4,170,'Animate the');
        outtextxy(rx + textwidth('Alt-F7') + 4,180,'selected');
        outtextxy(rx + textwidth('Alt-F7') + 4,190,'sprites');
      end
      else
      if helppage = 2 then
      begin
        sgraph_filledevensizerect(0,0,320,200,black);
        setcolor(boxframecolor);
        rectangle(0,0,319,199);
        setcolor(boxheadcolor);
        outtextxy(2,2,'Help-2 (More: pgup)');
        setcolor(texthighcolor);
        outtextxy(lx,12,'Alt-F8');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('Alt-F8') + 4,12,
          'Show current file names');
        setcolor(texthighcolor);
        outtextxy(lx,21,'Alt-F9');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('Alt-F9') + 4,21,
          'Adjust program settings');
        setcolor(texthighcolor);
        outtextxy(lx,30,'Alt-F10');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('Alt-F10') + 4,30,
          'Show current sprite sequence');
        setcolor(texthighcolor);
        outtextxy(lx,40,'Ctrl-F1');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('Ctrl-F1') + 4,40,
          'Save current palette to file');
        setcolor(texthighcolor);
        outtextxy(lx,190,'Esc');
        setcolor(boxtextcolor);
        outtextxy(lx + textwidth('Esc') + 4,190,
          '- Exit');
      end;
      letter:= readkey;
      if letter = specialkey then
      begin
        letter:= readkey;
        if letter = pgdwn then
        begin
          if helppage < 2 then inc(helppage);
        end
        else
        if letter = pgup then
        begin
          if helppage > 1 then dec(helppage);
        end;
      end;
    end
    else
    begin
      sgraph_filledevensizerect(0,0,320,200,black);
      setcolor(boxframecolor);
      rectangle(0,0,319,199);
      setcolor(boxheadcolor);
      outtextxy(lx,2,'Help: Sprite sequence editing');
      setcolor(boxtextcolor);
      outtextxy(lx,11,'Use');
      setcolor(texthighcolor);
      outtextxy(lx+textwidth('Use') + 4,11,'left');
      setcolor(boxtextcolor);
      outtextxy(lx+textwidth('Use left')+2,11,'and');
      setcolor(texthighcolor);
      outtextxy(lx+textwidth('Use left and')+2,11,'right');
      setcolor(boxtextcolor);
      outtextxy(lx+textwidth('Use left and right')+2,11,
        'arrows to select a');
      outtextxy(lx,20,'sprite to move. Press enter. Then use');
      outtextxy(lx,30,'the arrows to select a sprite location');
      outtextxy(lx,40,'to move the selected sprite to. Press');
      setcolor(texthighcolor);
      outtextxy(lx,50,'Enter');
      setcolor(boxtextcolor);
      outtextxy(lx+textwidth('Enter')+2,50,'to move the sprite logically.');
      outtextxy(lx,60,'Note: You''l see no movement on the');
      outtextxy(lx,70,'screen itself. Press');
      setcolor(texthighcolor);
      outtextxy(lx+textwidth('screen itself. Press')+4,70,'F6');
      setcolor(boxtextcolor);
      outtextxy(lx+textwidth('screen itself. Press F6'),70,
        'again when done');
      outtextxy(lx,80,'editing. Use');
      setcolor(texthighcolor);
      outtextxy(lx+textwidth('editing. Use')+4,80,'Alt-F10');
      setcolor(boxtextcolor);
      outtextxy(lx+textwidth('editing. Use Alt-F10'),80,'to see the new');
      outtextxy(lx,90,'sequence the sprites are now in.');
      letter:= readkey;
    end;
  until letter = escape;
  sgraph_setpal(palp);
  sgraph_copyscr(hidscr,visscr);
  letter:= #0;
end;

procedure statusbox;
var x1,y1,x2,y2,boxsize,boxcolor,boxstep,markedsprites,progmodestr: string;
    xl,yl,boxsizei: longint;
begin
  sgraph_filledevensizerect(0,0,320,200,black);
  setcolor(boxframecolor);
  rectangle(0,0,319,199);
  setcolor(boxheadcolor);
  outtextxy(2,2,'Status');
  str(boxrec.x1,x1);
  str(boxrec.x2,x2);
  str(boxrec.y1,y1);
  str(boxrec.y2,y2);
  xl:= boxrec.x2 - boxrec.x1;
  yl:= boxrec.y2 - boxrec.y1;
  boxsizei:= xl * yl;
  str(boxsizei,boxsize);
  str(boxrec.color,boxcolor);
  str(boxrec.step,boxstep);
  str(marksprarridx-1,markedsprites);
  if progmode = stanmode then progmodestr:= 'Normal' else
    if progmode = spreditmode then progmodestr:= 'Sprite edit';
  setcolor(texthighcolor);
  outtextxy(2,11,'Box coordinates:');
  setcolor(boxtextcolor);
  outtextxy(2 + textwidth('Box coordinates:'),11,x1+','+y1+','+x2+','+y2);
  setcolor(texthighcolor);
  outtextxy(2,20,'Box size:');
  setcolor(boxtextcolor);
  outtextxy(2 + textwidth('Box size:'),20,boxsize);
  setcolor(texthighcolor);
  outtextxy(2,30,'Box color:');
  setcolor(boxtextcolor);
  outtextxy(2 + textwidth('Box color:'),30,boxcolor);
  setcolor(texthighcolor);
  outtextxy(2,40,'Box step size:');
  setcolor(boxtextcolor);
  outtextxy(2 + textwidth('Box step size:'),40,boxstep);
  setcolor(texthighcolor);
  outtextxy(2,50,'Box corner:');
  setcolor(boxtextcolor);
  if boxrec.curcorner = leftupcorner then
    outtextxy(2 + textwidth('Box corner:'),50,'Left Upper') else
        outtextxy(2 + textwidth('Box corner:'),50,'Right Lower');
  setcolor(texthighcolor);
  outtextxy(2,60,'Box frozen:');
  setcolor(boxtextcolor);
  if boxrec.frozen = yes then
    outtextxy(2 + textwidth('Box forzen:'),60,'Yes') else
      outtextxy(2 + textwidth('Box forzen:'),60,'No');
  setcolor(texthighcolor);
  outtextxy(2,70,'Marked sprites:');
  setcolor(boxtextcolor);
  outtextxy(2 + textwidth('Marked sprites:'),70,markedsprites);
  setcolor(texthighcolor);
  outtextxy(2,80,'Program mode:');
  setcolor(boxtextcolor);
  outtextxy(2 + textwidth('Program mode:'),80,progmodestr);
  setcolor(texthighcolor);
  outtextxy(2,90,'CSF filename given:');
  setcolor(boxtextcolor);
  if length(csffilename) > 0 then
    outtextxy(2 + textwidth('CSF filename given:'),90,'Yes') else
      outtextxy(2 + textwidth('CSF filename given:'),90,'No');
  setcolor(texthighcolor);
  outtextxy(2,100,'XYS filename given:');
  setcolor(boxtextcolor);
  if length(xysfilename) > 0 then
    outtextxy(2 + textwidth('XYS filename given:'),100,'Yes') else
      outtextxy(2 + textwidth('XYS filename given:'),100,'No');
  setcolor(texthighcolor);
  outtextxy(2,110,'PIC filename given:');
  setcolor(boxtextcolor);
  if length(picfilename) > 0 then
    outtextxy(2 + textwidth('PIC filename given:'),110,'Yes') else
      outtextxy(2 + textwidth('PIC filename given:'),110,'No');
  setcolor(texthighcolor);
  outtextxy(2,120,'PAL filename given:');
  setcolor(boxtextcolor);
  if length(palfilename) > 0 then
    outtextxy(2 + textwidth('PAL filename given:'),120,'Yes') else
      outtextxy(2 + textwidth('PAL filename given:'),120,'No')
end;

{-Utility-}

procedure givefilenames;
var namein: string;
begin
  closegraph;
  textcolor(lightgray);
  clrscr;
  writeln('Supply filenames');
  write('CSF file: ');
  textcolor(lightcyan);
  readln(namein);
  if namein <> '' then
  begin
    if pos('.',namein) = 0 then namein:= namein + '.CSF';
    csffilename:= namein;
  end
  else
  begin
    writeln('Old .CSF name preserved.');
    readkey;
  end;
  textcolor(lightgray);
  write('PIC file: ');
  textcolor(lightcyan);
  readln(namein);
  if namein <> '' then
  begin
    if pos('.',namein) = 0 then namein:= namein + '.PIC';
    picfilename:= namein;
  end
  else
  begin
    writeln('Old .PIC name preserved.');
    readkey;
  end;
  textcolor(lightgray);
  write('XYS file: ');
  textcolor(lightcyan);
  readln(namein);
  if namein <> '' then
  begin
    if pos('.',namein) = 0 then namein:= namein + '.XYS';
    xysfilename:= namein;
  end
  else
  begin
    writeln('Old .XYS name preserved.');
    readkey;
  end;
  textcolor(lightgray);
  write('PAL file: ');
  textcolor(lightcyan);
  readln(namein);
  if namein <> '' then
  begin
    if pos('.',namein) = 0 then namein:= namein + '.PAL';
    palfilename:= namein
  end
  else
  begin
    writeln('Old .PAL name preserved.');
    readkey;
  end;
  textcolor(lightgray);
  textbackground(black);
  clrscr;
  vgamode;
  sgraph_setpal(palp);
  drawbox;
end;

end.