Program BIN2MFO;
Uses Dos,Crt,Utils;

const
 {$I UPDATE.INC }

var
 F              :File;
 Ut             :File;

 B              :Byte;
 Data           :Array[1..16] of Byte;

 Height,
 Width,
 FirstChar      :Byte;
 TotalChars,
 TotalCalc      :Word;

 BytesRead      :Word;

BEGIN
 WriteLn('BIN2MFO v1.0 - Eddy L O Jansson  ['+Compiled+']');
 WriteLn;

 if NOT Exist(ParamStr(1)) then Error('infile not found!');
 if (Exist(ParamStr(2))) and not ParamExist('-o') then Error('outfile already exists');
 if Va(ParamStr(3))=0 then Error('Must supply font height');

 WriteLn(' Infile: ',ParamStr(1));
 WriteLn('Outfile: ',ParamStr(2));


 Assign(F,ParamStr(1));   Reset(F,1);
 Assign(Ut,ParamStr(2));  ReWrite(UT,1);

 Height:=Va(ParamStr(3));
 Width:=8;
 BlockWrite(Ut,Height,1);
 WriteLn('Character Height: ',Height);

 FirstChar:=0;
 BlockWrite(Ut,FirstChar,1);
 WriteLn('First Character: #',FirstChar);

 TotalCalc:=FileSize(F) div Height; { Total Chars }
 WriteLn('Total Chars Calculated: ',TotalCalc);
 if TotalCalc>255 then TotalCalc:=255;
 BlockWrite(Ut,Byte(TotalCalc),1);

 TotalChars:=0;
 While NOT EoF(F) do
  begin
   BlockRead(F,Data,Height,BytesRead);
   BlockWrite(ut,Width,1);
   BlockWrite(ut,Data,BytesRead);
   Inc(TotalChars);
  end;

 Write('Total Chars Written: ',TotalChars,', ');
 if TotalChars>255 then TotalChars:=255;
 if TotalChars<>TotalCalc then
  begin
   Write('Inconsistency. Fixing header. ');
   Seek(UT,2);
   BlockWrite(Ut,Byte(TotalChars),1);
  end;
 WriteLn('Ok.');

 Close(F);
 Close(UT);
 WriteLn('Done.');
END.
