Program Play;

{ Plays wavefiles from the resource (PLAYWAV.RSC) or from itself
  (PLAY.EXE).

  Last update: 20/10/1996
  Author:      N. De Smedt (alias ThunderByte) member of
               << Houses of Immortality -- Belgium >>
}

Uses CRT,ResUnit,SB;

Type  TRes = Object(TRSC)
        Function ReadBuffer(Var Buffer: Byte; Size: Word): Boolean; VIRTUAL;
        Procedure PlayIt(WaveId: String);
      end;

      Buf = Array[0..65520] of Byte;
      PBuf = ^Buf;

Var Freq,PlaySize: Word;
    SBPresent,Ok: Boolean;
    Res: TRes;
    PlayBuf: PBuf;
    IdString: String;
    Ch: Char;


Procedure BackToDOS; FAR;
Begin
  Res.Done;
  If SBPresent then
     Restore_IRQ;
end;

Function TRes.ReadBuffer(Var Buffer: Byte; Size: Word): Boolean;
Begin
  If Longint(PlaySize)+Longint(Size) > 65520 then
     Begin
       Size := 65520-PlaySize;
     end;
  Move(Buffer,PlayBuf^[PlaySize],Size);
  INC(PlaySize,Size);
end;

Procedure TRes.PlayIt(WaveId: String);
Begin
  Ok := Res.ReadRSC(WaveId);
  If Not Ok then
     Writeln('Error!')
  Else
     If SBPresent then
        Play_oneBlock(Ptr(Seg(PlayBuf^[45]),Ofs(PlayBuf^[45])),
                      PlaySize-45); { Plays only the first 64K or less! }
end;

Begin
  SBPresent := UseBlasterEnv;
  If SBPresent then
     Begin
       Freq := 11025;
       InitBlaster(Freq,False,False); { 11KHz, 8 bit mono }
       Set_Ready_IRQ(NIL);
     end;
  ExitProc := @BackToDos;
  { PLAYWAV.RSC must be made with the resource binder (RB.EXE) }
(*  If Res.InitRSCFile('PLAYWAV.RSC') then*)
  { Use InitRSC if the resource is coming from the .EXE
    (PLAY.EXE) self. The resource has been added with RB.EXE }
    If Res.InitRSC then
     Begin
       New(PlayBuf);
       Clrscr;
       Writeln('1. Sound 1');
       Writeln('2. Sound 2');
       Writeln('3. Sound 3');
       Writeln('0. Quit');
       Writeln;
       Write('Your choice? ');
       Repeat
         Repeat
           Ch := ReadKey;
         Until Ch in ['0'..'3'];
         Case Ch of
           '1': IdString := 'sound1';
           '2': IdString := 'sound2';
           '3': IdString := 'sound3';
           '0': Halt(0);
         end; { CASE }
         PlaySize := 0;
         Res.PlayIt(IdString);
       Until False;
     end;
end.