/////////////////////////////////////////////////////////////////////////////
//                                RDBASE.CPP
/////////////////////////////////////////////////////////////////////////////
// A word about this program,
//
// This code is intended to show how a dBase III database is formed, where
// the information is stored, and how it can be readed, note that with this
// code you're not able to see the data stored, or write to the database...
//
// Use this code, experiment with it, modify it! LEARN! LEARN! LEARN! q:o)
//
// Note :
//
//       I'm NOT responsible for any damage or data loss in your databases,
//       use this code at your own risk.
//
/////////////////////////////////////////////////////////////////////////////
// Usage :
//
//        RDBASE file.dbf <enter>
//
/////////////////////////////////////////////////////////////////////////////
// Future plans,
//
// Well, I'm now writing a data browser... read-only mode, then I'll write
// a data editor, and finally a data engine to be used in C++.
//
// Someone (If not everyone) must be thinking 'this guy is crazy' 'why is
// he working in something outdated (dos apps and dbase)' well, it's very
// simple... I want to learn.
/////////////////////////////////////////////////////////////////////////////
// Author : Jemil Marcos                    //
// E-Mail : jmarcos@ccr.dsi.uanl.mx         //          * ART  *
// Web    : dusk.ml.org/next/frontdoor.htm  //          * AMDG *
// IRC    : \\NeXT\\ at UnderNet.Org #emu   //
/////////////////////////////////////////////////////////////////////////////
// Last update : August 22nd,1997
/////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

//Structure defs//
struct s_fields {
	char name[12];
	char type;
	unsigned long address;
	unsigned char flen;
	unsigned char count;
	char reserved[15];
} fields[255];

//Variable defs//
unsigned int i,x,hlen,rlen,index;
unsigned char yy,mm,dd,version;
unsigned long regs;
fpos_t pos,CurrPos;
FILE *fp;

//Function prototypes//
void showpos();

void main(int argc, char *argv[]) {

	clrscr();

	//Assign the file pointer to a filename given in the command line//
	//and attempt to open it                                         //
	fp=fopen(argv[1],"r");
	//fp=fopen("sample.dbf","r");
	//If the file can't be opened, it displays an error message an   //
	//the program terminates                                         //
	if (fp==NULL) {
		printf("Error loading file");
		exit(1);
	}
	//If the file is opened successfully                             //
	else {
		//get the first byte, which is the version 0x03 if a normal  //
		//dBase III file or 0x83 if it has a DBT file attached       //
		fread(&version,1,1,fp);
		//get the next three bytes which are the date of last update //
		fread(&yy,1,1,fp);
		fread(&mm,1,1,fp);
		fread(&dd,1,1,fp);
		//the next four bytes represents the number of records that  //
		//are stored in the database, it a long type (32bit number)  //
		fread(&regs,4,1,fp);
		//then get the header length which is stored as a 16 bit num //
		//that means 2 bytes                                         //
		fread(&hlen,2,1,fp);
		//finally we get the record length which is also a 16 bit num//
		fread(&rlen,2,1,fp);

		//we need to jump to byte 32, here starts the info about the //
		//fields                                                     //
		pos=32;
		fsetpos(fp,&pos);

		i=0;

		//the field information is stored in blocks of 32 bytes each //
		//so, we need to make a loop to get all the blocks.          //
		do {
			//the first 11 bytes contains the name of the field in   //
			//ASCII format                                           //
			fread(&fields[i].name,11,1,fp);
			//we add the null character to the string as a terminator//
			fields[i].name[12] = NULL;
			//the next byte is the field type (C,N,L,D or M) in ASCII//
			fread(&fields[i].type,1,1,fp);
			//this is followed by a 32bit number which represents the//
			//field's data address                                   //
			fread(&fields[i].address,4,1,fp);
			//get the field lenght which is stored as 1 byte         //
			fread(&fields[i].flen,1,1,fp);
			//then the field's decimal places (if number)            //
			fread(&fields[i].count,1,1,fp);
			//and finally the 14 reserved bytes (v 1.00)             //
			fread(&fields[i].reserved,14,1,fp);

			//If the current position on the file is equal to the    //
			//header length, then we are done with the fields info   //
			fgetpos(fp,&pos);
			if (pos>=hlen)
				break;

			//if not, we increment out counter in one...             //
			i++;
		} while (!kbhit());

		textcolor(15);
		textbackground(1);
		clrscr();

		if (version==3)
			cprintf("dBase version 3 without DBT file\r\n");
		else
			cprintf("dBase version 3 with DBT file\r\n");

		cprintf("Last Update             : %d/%d/%d\r\n",dd,mm,yy);
		cprintf("Number of Records       : %d \r\n",regs);
		cprintf("Header Length           : %d bytes\r\n",hlen);
		cprintf("Record Length           : %d bytes\r\n\r\n",rlen);
		cprintf("Number fields           : %d \r\n",i+1);
		printf("==============================================================================\n");
		printf("Name\t\t\tType\tLength\t\tDecimals\tAddress\n");
		printf("==============================================================================\n");
		for (x=0;x<=i;x++) {
			printf("%s     \t\t",fields[x].name);
			printf("%c\t ",fields[x].type);
			printf("%u\t\t",fields[x].flen);
			printf("%u\t\t",fields[x].count);
			printf("%ld\n",fields[x].address);

			if (x==i) {
				printf("<Enter to exit>\n");
				getch();
			}
			else {
				if (x>10) {
					printf("-More-\n");
					getch();
				}
			}
		}
	}

	do {
	} while(!kbhit());
	fclose(fp);
	getch();
	textbackground(0);
	clrscr();
	printf("dBase III database header reader v 1.0\n");
	printf("===========================================\n");
	printf("Author      : Jemil Marcos next@dusk.ml.org\n");
	printf("Last update : August 22, 1997\n");
	printf("AMDG\n");
}

//This sub is used for debugging purposes"
void showpos() {
		fgetpos(fp,&pos);
		printf("position : %d\n",pos);
}
