Program OS2DoorTest; // test program for OS2DOOR unit.

(*
   FOR SWAG

   This is a little test program to use with OS2DOOR unit.  Compile it,
   and run as a door from a BBS, or locally.  For running from a
   BBS, command line parameters are:

   OS2DTEST.EXE <porthandle> <dropfilepath>

   Where <porthandle> is a OS/2 handle for open com port,
   <dropfilepath> is a FULL path INCLUDING FILENAME to
   DORINFO/DOOR.SYS drop files.

   To run (test) locally, specify 'LOCAL' as an argument:

   OS2DTEST.EXE LOCAL

   COPYRIGHT (C) 1997  BY ANDREW EIGUS.   NO RIGHTS RESERVED.
*)

uses OS2def, Crt, OS2Misc, OS2Door, AnsiIO;

{$IFDEF VPDEMO}
{&DYNAMIC VP11DEMO.LIB}  // for those using demo version
{$ENDIF}

const
  // used color attributes
  WhiteOnBlue   = White + Blue shl 4;
  YellowOnBlue  = Yellow + Blue shl 4;

  VersionStr    = 'v1.0'; // version of demo
var
  PortHandle : HFile;
  DropFilePath, S : string;
  F : text;
  counter : byte; // row counter for DoorMorePrompt()

Function ParseCommandLineArgs : boolean;
{ Returns FALSE if no params on command line }
var
  Param : string;
Begin
  if ParamCount > 0 then
  begin
    Param := ToUpper(ParamStr(1));  // get 1st param
    LocalMode := (Param = 'LOCAL');
    if not LocalMode then
    begin
      PortHandle := Str2Int(ParamStr(1)); // get port handle
      DropFilePath := ParamStr(2); // door.sys or dorinfo path
      ParseCommandLineArgs := (PortHandle > 0) and (DropFilePath <> '');
    end else ParseCommandLineArgs := True
  end else ParseCommandLineArgs := False;
  ParseCommandLineArgs := ParamCount > 0
End; { ParseCommandLineArgs }

Procedure DoorErrorMsg(const Message : string);
Begin
  DoorWriteLn(AnsiAttr(LightRed) + Message + AnsiAttr(LightGray))
End; { DoorErrorMsg }

Begin
  if not ParseCommandLineArgs then // parse command line arguments
  begin
    WriteLn('ParseCommandLineArgs: usage: ' + CRLF +
      '  OS2DOOR LOCAL' + CRLF + '  or' + CRLF +
      '  OS2DOOR <port handle> <door.sys/doorinfo?.def path>' + CRLF);
    Halt(1)  // exit if no arguments specified
  end;
  if not LocalMode then
    if not DoorLoadConfig(DropFilePath) then // loaded DOOR.SYS or DORINFOx?
    begin
      WriteLn('DoorLoadConfig: error: cannot load configuration from ' + DropFilePath);
      Halt(2)
    end;
  DoorInit(PortHandle);  // initialise OS2DOOR interface

  DoorWrite(AnsiAttr(WhiteOnBlue)); DoorClrLine;
  DoorWrite(' VIRTUAL PASCAL OS/2 DOOR INTERFACE DEMONSTRATION '
    + AnsiAttr(YellowOnBlue) + VersionStr + AnsiAttr(WhiteOnBlue) + ' by Andrew Eigus');
  DoorWriteLn(AnsiAttr(LightGray) + CRLF);

  DoorWrite('DoorWaitToGo demo: hit any key to continue...');
  DoorWaitToGo(False);  // no standard prompt
  DoorWriteLn(CRLF); // same as DoorWriteLn('') two times =)

  DoorWrite('DoorMorePrompt demo: filename to view [os2dtest.pas]: ');
  if DoorReadLn(S, 'os2dtest.pas', 20, False) > 0 then // filename entered?
  begin
    Assign(f, S);
    Reset(f);
    if IOResult = 0 then
    begin
      DoorWriteLn(AnsiAttr(Cyan));
      counter := 0;
      while (not Eof(f)) and DoorMorePrompt(counter) do
      begin
        ReadLn(f, S);
        DoorWriteLn(S);
        Inc(counter);  // increment counter and check if it reached bottom
                       // of the screen, then do more prompt
      end;
      Close(f);
      DoorWriteLn(AnsiAttr(LightGray))
    end else DoorErrorMsg('Reset: cannot open file ' + S)
  end;

  DoorWrite(CRLF + 'DoorPipeWrite demo: ');
  DoorPipeWriteLn('|7Cool |8Things |9Are |10Always |11Cool|7.');

  DoorWrite(CRLF + 'DoorKeyPrompt demo: ');
  if DoorKeyPrompt('Isn''t OS2DOOR great stuff?',
    'Yn', 'Y', White, Yellow) = 'Y' then
    DoorPipeWrite('|7Surely it is! :-)')
  else
    DoorPipeWrite('!7Well, write one that is better.  :-)');
  Delay(1000);
  DoorClrLine; DoorWrite(CRLF);
  DoorOutDebugInfo;

  DoorWrite(CRLF);
  if not LocalMode then
  begin
    DoorPipeWriteLn('You may press |14Alt-O|7 to toggle output and |14Alt-C|7 to chat'+CRLF+
      'with the remote user.'+CRLF);
    DoorWaitToGo(True)
  end;

  DoorWriteLn(CRLF + AnsiAttr(White) +
    'End of OS2DOOR demonstration.  Have a good coding day.' + AnsiAttr(LightGray))
End.
