/*
    a simple graphics library
    copyright (c) march 27, 1997 John Paul D'India
*/

#include <i86.h>
#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include "mygraph.h"

/* video functions */
void VideoInit ( void )
{
    union REGPACK regs;

    memset ( &regs, 0, sizeof(union REGPACK) );
    regs.w.ax = 0x13;
    intr ( 0x10, &regs );
}

void VideoDone ( void )
{
    union REGPACK regs;

    memset ( &regs, 0, sizeof(union REGPACK) );
    regs.w.ax = 0x03;
    intr ( 0x10, &regs );
}

void VideoRetrace ( void )
{
    do
    {
    }
    while ((inp(0x3da) & 0x08));
    do
    {
    }
    while (!(inp(0x3da) & 0x08));
}

/* palette functions */
int PaletteLoad ( struct TPalette * pal, char * s )
{
    FILE * f;

    f = fopen ( s, "rb" );
    if (!f)
        return 0;
    fread ( pal->rgb, 768, 1, f );
    fclose ( f );
    return 1;
}

void PaletteUpdate ( struct TPalette * pal )
{
    int i;
    char * ptr;

    ptr = pal->rgb;
    outp ( 0x3c8, 0 );
    i = 768;
    do
    {
        outp ( 0x3c9, *ptr  );
        ptr++;
    }
    while (--i);
}

void PaletteDone ( struct TPalette * pal )
{
    pal = pal;
}

/* screen functions */
void ScreenInit ( struct TScreen * scr )
{
    scr->bmp = (char *) malloc ( 64000 );
}

void ScreenDone ( struct TScreen * scr )
{
    free ( scr->bmp );
}

void ScreenClear ( struct TScreen * scr )
{
    memset ( scr->bmp, 0, 64000 );
}

void ScreenUpdate ( struct TScreen * scr )
{
    memcpy ( MK_FP(0xA000,0x0000), scr->bmp, 64000 );
}

/* sprite functions */
int SpriteLoad ( struct TSprite * spr, char * s )
{
    FILE * f;

    f = fopen ( s, "rb" );
    if (!f)
        return 0;
    fseek ( f, 2, SEEK_SET );
    fread ( &spr->w, 2, 1, f );
    fread ( &spr->h, 2, 1, f );
    spr->bmp = (char *) malloc ( spr->w*spr->h );
    if (!spr->bmp)
        return 0;
    fseek ( f,800, SEEK_SET );
    fread ( spr->bmp, spr->w*spr->h, 1, f );
    fclose ( f );
    return 1;
}

void SpriteDone ( struct TSprite * spr )
{
    spr->w = 0;
    spr->h = 0;
    free ( spr->bmp );
}

void SpritePut ( struct TSprite * spr, struct TScreen * scr, int x, int y )
{
    int tx,ty;
    char * outscr;
    char * inspr;

    outscr = (scr->bmp)+y*320+x;
    inspr = spr->bmp;
    tx = spr->w;
    ty = spr->h;
    do
    {
        memcpy ( outscr, inspr, tx );
        outscr += 320;
        inspr += tx;
    }
    while (--ty);
}
