/*
    PROCARGS.C is the DOS argument analyser! Its purpose is
    to check what the user has written on command-line.

    Almost no missuse of arguments are checked, so misstyping on
    the command-line could cause the program to make very strange
    results.....

    Ola Andersson, 1996-01-04
*/

#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include "mandel.h"

void explain_pgm( void )
{
    printf( "..........MandelBrot Realtime Zoom and view......\n" );
    printf( "\n" );
    printf( "Usage 1:   mandel  [ OutFileName ] [ switches ]\n" );
    printf( "\n" );
    printf( "Switches:  /Dxx           = Factor to decrease when zooming\n");
    printf( "           /H             = display program usage\n" );
    printf( "           /Mxx           = Maximal iteration per pixel...\n");
    printf( "           /Pfilename     = palette filename\n");
    printf( "           /Sxx           = number of steps to zoom\n");
    printf( "           /Tx:nnn        = target mandel x-coordinate\n");
    printf( "           /Ty:nnn        = target mandel y-coordinate\n");
    printf( "           /Vx:nnn        = Maximal screen x-xoordinate\n");
    printf( "           /Vy:nnn        = Maximal screen y-xoordinate\n");
    printf( "           /W             = Writing mode is ON\n");
    printf( "           /Z             = Zooming mode is ON\n");
    printf( "\n" );
    printf( "Usage 2:   mandel  [ InFileName ] [ /R ]\n" );
    printf( "           /R             = Restore mode is ON\n");
    printf( "\n" );
    printf( ".................................................\n" );
}

void process_args( int argc, char *argv[] )
{
    char fn[256];       /* path to Output file */
    int i;
    char *p;
    char sw;
    long double factor;

    fn[0] = 0;

    for( i = 1; i < argc; i++ )
    {
        if( (*argv[i] == '-') || (*argv[i] == '/') )
        {
            sw = *(argv[i] + 1);
            switch( toupper(sw) )
            {
                case 'D' :
                    sscanf( argv[i]+2, "%Lf", &factor );
                    dec_coord = (int) (100.0 / factor);
                    break;

                case 'H' :
                    explain_pgm();
                    exit( 0 );
                    break;

                case 'M' :
                    sscanf( argv[i]+2, "%d", &Maxit );
                    break;

                case 'P' :
                    sscanf( argv[i]+2, "%s", gPaletteFile );
                    break;

                case 'R' :
                    mandel_restore = 1;
                    break;

                case 'S' :
                    sscanf( argv[i]+2, "%d", &step_zoom );
                    break;

                case 'T' :
                    switch(*(argv[i]+2)) {
                        case 'x':   sscanf( argv[i]+4, "%Lf", &dX ); break;
                        case 'y':   sscanf( argv[i]+4, "%Lf", &dY ); break;
                    }
                    break;

                case 'V' :
                    switch(*(argv[i]+2)) {
                        case 'x':   sscanf( argv[i]+4, "%d", &Maxx ); break;
                        case 'y':   sscanf( argv[i]+4, "%d", &Maxy ); break;
                        }
                        break;

                case 'W' :
                    disk_pot = 1;
                    break;

                case 'Z' :
                    mandel_zoom = 1;
                    break;

                default:
                    printf( "Unknown switch '%s' ignored\n",
                                argv[i] );
                    break;
            }
        }
        else    /* presumably a file identifier */
        {
            strcpy( fn, argv[i] );
            p = strchr( fn, '.' );

            if( p == 0 )
                strcat( fn, ".fly" );
            else if( *(p+1) == NULL )
                *p = NULL;
        }
    }

    if(*fn != NULL)
    {
       if(mandel_restore && !disk_pot)
          strcpy(gRestoreFile, fn);
       else
          strcpy(gFileName, fn);
    }

}
