; ************************************************************************
;       Mbrot.ASM  contains "c" function:
;
;       void CalcLine(char far *ScanLine);
;
;       a function that generates a Mandelbrot ScanLine using
;       current settings and stored in memory.
;
;
;       Settings below are fudged with the dPow factor 2^27
;       (sX1, sY1)      = upper left corner of mandelbrot set
;       (sX2, sY2)      = lower right corner of mandelbrot set
;
;       Maxit           = Maximal iteration used in mandelbrot set
;       Bailout         = Bailoutvalue for [r]. default is 4 * dPow
;       Maxx            = x-size of bitmap
;       Maxy            = y-size of bitmap
;
;       void CopyLine(char far *ScanLine, char far *bitmap, int row);
;
;       a function that copies a scanline of the Maxx length into
;       bitmap on the specified row.
;
;       Ola Andersson, 1996-01-04
;
; ************************************************************************

IFDEF ??version
  MASM51
  QUIRKS
ENDIF

.MODEL  medium,c
DGROUP  group   _DATA,_DATA2

.8086

_DATA2          segment DWORD PUBLIC 'DATA'

MBY             equ     27                    ; 2**MBY hardcoded fudge factor
BITMAP_ARG      equ     [bp+6]                ; first argument in 16 far

; ************************ External variables *****************************

public          sX1,sY1,sX2,sY2               ; caller sets these
public          delta_X,delta_Y
public          pX, pY
public          Bailout,Maxx,Maxy,Maxit       ; caller sets these
public          dPow                          ; caller use this.....
public          ScanLinePtr

; ************************ Internal variables *****************************
                align     4
dPow            dd      134217728             ; Constant: 2^27
sX1             dd     -335544320             ; Upper left  x [-2.5 * dPow]
sY1             dd      201326592             ; Upper left  y [ 1.5 * dPow]
sX2             dd      201326592             ; lower right x [ 1.5 * dPow]
sY2             dd     -201326592             ; lower right y [-1.5 * dPow]
Bailout         dd      536870912             ; Bailout value Default: 4*dPow

delta_X         dd      0                     ; delta_X = (sX2 - sX1) / Maxx
delta_Y         dd      0                     ; delta_X = (sY2 - sY1) / Maxy
pX              dd      0                     ;
pY              dd      0                     ;
oldr            dd      0

Maxx            dw      320                   ; Default x-size bmp
Maxy            dw      200                   ; Default y-size bmp
Maxit           dw      150                   ; Default iteration Max

ScanLinePtr     dw      0                     ;
k               dw      0                     ; iteration counter
cplk            dw      0
col             dw      0
period          dw      0

_DATA2          ends

.code

; ***************** Function CalcLine(char far *ScanLine) ************

        public  CalcLine          ; main function
CalcLine  PROC  far argScanLine:far ptr byte

        les     di,argScanLine          ; load far bitmap pointer
        mov     ScanLinePtr, di         ; video_ptru = offset bitmap

; 386-specific code starts here ......................................

        .386

        mov     eax, sX1
        mov     pX, eax                 ; pX = sX1

        mov     cx, Maxx                ; clear cx for counting blocks
next_x:
        mov     esi, pX                 ; use ESI for pX
        mov     edi, pY                 ; use EDI for pY
        mov     ax, Maxit               ;
        mov     k, ax                   ; k = MAXIT
        mov     oldr, -1                ; oldr = -1

k_not_zero:
        mov     eax,esi                 ;
        imul    esi                     ;
        shrd    eax,edx,MBY             ;
        shr     edx,MBY-1               ;
        jne     found_pixel_get_out     ; bailout if too high
        mov     ebx,eax                 ; ebx = x*x

        mov     eax,edi
        imul    edi
        shrd    eax,edx,MBY
        shr     edx,MBY-1               ; eax = y*y
        jne     found_pixel_get_out     ; bailout if too high

        mov     edx,ebx                 ;
        sub     ebx,eax                 ; ebx = x*x - y*y

        add     edx,eax                 ; edx = x*x + y*y
        cmp     edx,Bailout             ; if(x*x + y*y >= BAILOUT)
        jae     found_pixel_get_out     ;   goto found_pixel....

        mov     eax,edi                 ; eax = y
        imul    esi                     ; eax = x*y
        shrd    eax,edx,MBY-1           ;
        add     eax,pY                  ; eax = 2*x*y + pY

        mov     edi,eax                 ; [NEW] y = 2*x*y + pY
        add     ebx,pX                  ; ebx = x*x - y*y + pX

        mov     esi,ebx                 ; [NEW] x = x*x - y*y + pX

;        cmp     period,0                ; if(period && k > Maxit-50 && !(k % 2))
;        je      skip_period             ; {
;        mov     ax, Maxit               ;    goto do_period
;        sub     ax, 150                 ;
;        cmp     k, ax                   ;
;        jg      skip_period             ;
;        xor     cplk, 1                 ;
;        je      do_period               ;

skip_period:
        dec     k                       ; if(--k)
        jnz     short k_not_zero        ;    goto k_not_zero
        mov     ax, 1                   ; color = 1 cause we are in lake
        mov     period, 1               ; period = 1;
        jmp     go_lake

;------------------------------------------------------
do_period:
        mov     eax, edx
        sub     edx, oldr               ; edx = r - oldr
        cmp     edx, 0                  ; if(edx > 0) ...
        jge     skip_n                  ; else
        neg     edx                     ;   edx = -edx;
skip_n: cmp     edx, 4096               ; if(edx > 1024)
        jge     not_period              ;   no_period
        mov     ax, 1                   ; period => color = 1
        jmp     go_lake

not_period:
        mov     oldr, eax               ; oldr = r
        jmp     skip_period
;------------------------------------------------------
found_pixel_get_out:
        mov     period, 0
        mov     ax, Maxit               ; color = Maxit - k
        sub     ax, k

        cmp     ax, 0                   ; if(ax == 0)
        jne     go_lake                 ;    ax = 0x01;
        mov     ax, 1                   ;

go_lake:
        mov     di,ScanLinePtr          ; di = ScanLinePtr => before stosw
        inc     ScanLinePtr             ;
        stosb                           ;

        mov     eax, delta_X
        add     pX, eax

        dec     cx
        jnz     next_x

;
;  writes last pixel value that we missed!!
;
        mov     ax, Maxit               ; color = Maxit - k
        sub     ax, k                   ;
                                        ; newcolor = lastcolor
        cmp     ax, 0                   ; if(ax == 0)
        jne     skip_change_ax2         ;    ax = 0x0101;
        mov     ax, 1                   ;

skip_change_ax2:
        mov     di,ScanLinePtr          ; di = ScanLinePtr => before stosb
        stosb                           ; yupp!

we_are_done_4_today:
;80386 code ends here ................................................
        .8086

        ret
CalcLine        endp

; *** Function CopyLine(char *ScanLine, char far *Bitmap, int row) ****

        public  CopyLine                ; main function
CopyLine proc   far argScanLine:far ptr byte, argBitmap:far ptr byte, argRow:word
        push    ds

        cld
        mov     cx, Maxx                ; LDS changes the segments as you know

        mov     ax, argRow              ; Maxx could be anything so do not
        mul     Maxx                    ; assume and try shifting...
.386
        lds     si, dword ptr argScanLine
        les     di, dword ptr argBitmap ; load far bitmap pointer
        add     di, ax                  ; row on bitmap = Maxx * row

        shr     cx, 1                   ; Maxx / 2
        jnc     try_do_4                ; if even try Maxx / 4
        rep     movsw                   ; else put words
        movsb
        jmp     even2
try_do_4:
        shr     cx, 1
        rep     movsd                   ; put words
        jnc     even2                   ; if even jump
        movsw                           ; else put byte

even2:
.8086
        pop     ds
        ret
CopyLine  endp

;
;    void show_on_screen(unsigned char far *bmp, int maxx, int maxy)
;

        public
show_on_screen proc far bmp:far ptr byte, lx:word, ly:word
        push    ds
        push    es
        mov     ax, 0a000h
        mov     es, ax
.386
        lds     si, bmp
;
;       centers output on screen...
;       mov     di, (320*(200-MAXY)+(320-MAXX))/2
;       correction terminated!  changes undone.
;
        mov     ax,200          ; ax = 200
        sub     ax,ly           ; ax = 200 - ly
        mov     di,320
        sub     di,lx           ; di = 320 - lx

        shr     ax,8            ; ax = 256y
        add     di,ax           ; di = 256y + x
        shl     ax,2            ; ax = 64y
        add     di,ax           ; di = 256y + 64y + x
        shr     di,1            ; di /= 2

        cld
        mov     dx,ly
        mov     cx,lx
        shr     cx,1
        jnc     do_4

;
;  do_2 makes a output to screen using movsw, movsb
;
do_2:   mov     cx, lx
        shr     cx, 1
        rep     movsw
        jnc     skip_b
        movsb
skip_b: mov     ax, 320
        sub     ax, lx
        add     di, ax
        dec     dx
        jnz     do_2
        jmp     done

;
;  do_4 makes a output to screen using movsd, movsw
;  (Maxx % 2) == 0 so use
;
do_4:   mov     cx, lx
        shr     cx, 2
        rep     movsd
        jnc     skip_w
        movsw
skip_w: mov     ax, 320
        sub     ax, lx
        add     di, ax
        dec     dx
        jnz     do_4
done:
.8086
        pop     es
        pop     ds

        ret
show_on_screen  endp
        end
