/*
    INITMOD.C initializes the most of the system for working with
    the program, alot is made in inline assembler for easy
    writing. All values in this file are default values that may
    be altered when using the program.

    Ola Andersson, 1996-01-04
*/
#pragma inline

/* Initialize module */
#include <dos.h>
#include <alloc.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "mandel.h"


unsigned char far palette[256][3];      /* Palette offsets */
unsigned char far bitmap[64000L];       /* bitmap were to put fractal */
unsigned char far ScanLine[320];


/* global filepointer */
char gFileName[256]     = "mandzoom.fly";
char gRestoreFile[256]  = "mandzoom.fly";
char gPaletteFile[256]  = "default.map";

/* default values for program */
int break_handle = 0;
int mandel_restore = 0;
int mandel_zoom = 0;
int step_zoom = 100;    /* how many steps in the zooming */
int dec_coord = 20;     /* = (100 / (percent 2 decrease)) */
int disk_pot  = 0;      /* if true => save to disk */
int on_screen = 1;      /* if true => show on screen */
int mouse_on  = 0;      /* if true => mouse can be used */
int video_on  = 0;      /* if true => video is configured */
int julia     = 0;      /* if true => output is a julia */

long double tX1 = -2.5,
            tY1 =  1.5,
            tX2 =  1.5,
            tY2 = -1.5; /* position coordinates */

long double dX = -1.78,
            dY =     0; /* target coordinates */


/*
   These variables are for saving when restore mode is on
   (Note that they are only Localy initialized)
*/

static int sys_Maxx, sys_Maxy,
           sys_step_zoom;

static long double
            sys_tX1 = -2.5,
            sys_tY1 =  1.5,
            sys_tX2 =  1.5,
            sys_tY2 = -1.5, /* position coordinates */
            sys_dX = -1.78,
            sys_dY =     0; /* target coordinates */

/*
    saves current values before restoremode
*/

void save_settings( void )
{
   sys_Maxx = Maxx;
   sys_Maxy = Maxy;
   sys_step_zoom = step_zoom;
   sys_tX1 = tX1;
   sys_tY1 = tY1;
   sys_tX2 = tX2;
   sys_tY2 = tY2;
   sys_dX =  dX;
   sys_dY =  dY;
}


/*
    restore current values after restoremode
*/

void restore_settings( void )
{
   Maxx = sys_Maxx;
   Maxy = sys_Maxy;
   step_zoom = sys_step_zoom;
   tX1 = sys_tX1;
   tY1 = sys_tY1;
   tX2 = sys_tX2;
   tY2 = sys_tY2;
   dX = sys_dX;
   dY = sys_dY;
}


/*
    initierar paletten
*/
void init_palette(void)
{
    asm {
        xor bx, bx
        mov cx, 0xff
        mov ax, seg _palette
        mov es, ax
        mov dx, offset _palette
        mov ax, 0x1012
        int 0x10
    }
}

/*
    initerar mcga 320*200*256 videolge + palette
*/
void init_video(int mode)
{
    asm {
        mov ax, mode                /* mcga 320*200*256 */
        int 0x10
    }


    if((*(gPaletteFile) != NULL) && (mode == 0x13))
        init_palette();
}

int load_palette(void)
{
    FILE *fp;
    int i;
    int r, g, b;


    if((fp = fopen(gPaletteFile, "rt")) != NULL)
    {
        for(i = 0; i < 256; i++ )
        {
            fscanf( fp, "%d %d %d", &r, &g, &b );
            palette[i][0] = r >> 2;
            palette[i][1] = g >> 2;
            palette[i][2] = b >> 2;
        }
        fclose( fp );
    }
    else
        *gPaletteFile = NULL;

return 1;
}

int get_all_key( void )
{
    asm xor ax,ax;
    asm int 0x16;

return _AX;
}


int evaluate_keys( void )
{
    asm mov ax, 0x0100;
    asm int 0x16;
    asm jnz skip_change
    asm xor ax, ax

skip_change:;
return _AX;
}

/*
    restore your saved mandelbrot file and shows it on screen.
*/
void mandel_restore_show( void )
{
    volatile int step;

    save_settings();

    if(!video_on)
    {
        init_video(0x13);
        video_on = 1;
    }

    if((gFileHandle = open_file_read(gRestoreFile)) != -1)
    {
        read_buffer(gFileHandle, &Maxx, 2);
        read_buffer(gFileHandle, &Maxy, 2);
        read_buffer(gFileHandle, &step_zoom, 2);

        step = step_zoom;

        while((step-- > 0) && (!break_handle))
        {
            decode( (char far *) bitmap, Maxx*Maxy);
            show_on_screen( bitmap, Maxx, Maxy );

            delay(100);

            if(evaluate_keys() == K_Esc)
                break_handle = 1;
        }

        close_file(gFileHandle);
        get_all_key();
        break_handle = 0;
    }

    if(video_on)
    {
        init_video(0x03);
        video_on = 0;
    }

    restore_settings();
}
