/* Graph.h The new graphics interface for Borland C++ 3.1 and others */
#ifndef __GRAPH_H__
#define __GRAPH_H__

const char MCGA = 0x13;
const char CO80 = 0x03;

/* initialize sets the graphics mode to use */
void _fastcall cls13all(int fcolor)
{
 asm{
 push ax
 push	bp
 push es
 pushf

 mov  ax,0xA000
 mov	es,ax
 mov  di,0
 mov    cx,64000
 mov	ax,fcolor
 rep    stosb

 popf
 pop es
 pop bp
 pop ax
 }
}

void init_video(char mode)
{
	asm {
		push	ax
		push	bp
		xor	ax,ax
		mov	al,mode
		int	0x10
		pop	bp
		pop	ax
		}
}

/* cls13 clears specified part of screen in 320*200/256 colors
	with specified color */
void cls13(int x1, int y1, int xl, int yl, int color)
{
 asm {
	 push	   ax
	 push    bp
	 push	   es
    mov     ax,0xA000
    mov     es,ax

    mov     ax,y1
    mov     di,x1

    xchg    ah,al
    add     di,ax
    shr     ax,2
    add     di,ax

	mov	bx,yl
	dec	bx
	mov	ax,color
	mov	dx,xl
	}
igen:;
 asm {
	mov	cx,dx
	cld
	rep	stosb
	add	di,320
	sub	di,dx
	dec	bx
    cmp bx,0
    jge igen
	pop	es
	pop	bp
	pop	ax
	}
}


void _fastcall pp13(int x, int y, int color)
{
asm {
/*    The (start)offset and segment initializer  */
			push 	es

			mov	ax,y          /* adressen till (x,y) */
			mov	bx,x
			xchg	ah,al         /* ax = 256y */
			add	bx,ax         /* bx = 256y + x */
			shr	ax,2          /* ax = 64y */
			add	bx,ax         /* bx = 64y + 256y + x = 320y + x */
			mov	di,bx				/* di <- adressen */
			mov	ax,0xA000		/* es <- 0xA000 */
			mov	es,ax
			mov	ax,color
			mov	es:[di],al		/* do it!!*/

			pop	es
	}
}

char _fastcall gp13(int x, int y)
{
unsigned char color;
asm {
/*    The (start)offset and segment initializer  */
			push	ax
			push 	es

			mov	ax,y          /* adressen till (x,y) */
			mov	bx,x
			xchg	ah,al
			add	bx,ax
			shr	ax,2
			add	bx,ax
			mov	di,bx				/* di <- adressen */
			mov	ax,0xA000		/* es <- 0xA000 */
			mov	es,ax
			mov	dl,es:[di]		/* do it!!*/
			mov	color,dl

			pop	es
			pop	ax
	}

return color;
}

void setpalette13(char number, char red, char green, char blue)
{
asm {	push	ax
		push	bp

		mov 	al,0x10

        mov bx,word ptr green
		mov	ch,bl

		mov	dx,word ptr blue
		mov	cl,dl

		mov	bx,word ptr red
		mov	dh,bl
		mov	bx, word ptr number

		int	0x10
		pop	bx
		pop	ax
	}
}
#endif
