#include <process.h>
#include <stdio.h>

void ShowInfo( void );
void ReadPaletteFile(char *Filename);
void Convert2Asm(char *FileFrom, char *FileTo);

pal[256][3];

int main(int argc, char **argv)
{

   if(argc == 3)
   {
     ReadPaletteFile(argv[1]);
     Convert2Asm(argv[1],argv[2]);
   }
   else
   {
     ShowInfo();
   }

return 0;
}

void ShowInfo( void )
{
   printf("\nPaletteFile 2 Assembler:\n\n");
   printf("SYNTAX: pal2asm palette.map palette.inc\n\n");
   printf("ver no: UNKNOWN STATUS\n");
   exit(0);
}

void ReadPaletteFile(char *Filename)
{
FILE *fp;
int i, temp;
int r, g, b;


	if((fp = fopen(Filename, "rt")) != NULL)
	{
		for(i = 0; i < 256; i++ )
		{
			fscanf( fp, "%d %d %d", &r, &g, &b );
			pal[i][0] = r >> 2;
         pal[i][1] = g >> 2;
         pal[i][2] = b >> 2;
		}
	}
   else
   {
      ShowInfo();
   }

	fclose( fp );
}

void Convert2Asm(char *FileFrom, char *FileTo)
{
   FILE *fp;
   int i;

   if((fp = fopen(FileTo, "wt")) == NULL)
     ShowInfo();

   fprintf(fp, ";   Palette Map taken from [%s]\n", FileFrom);
   fprintf(fp, ";   Palette numbers in range 0-63\n", FileFrom);
   fprintf(fp, "Pal256");

   for(i = 0; i != 256; i += 2)
   {
      fprintf(fp, "\tdb %d,%d,%d,%d,%d,%d\n",pal[i][0], pal[i][1], pal[i][2],
                                        pal[i+1][0], pal[i+1][1],pal[i+1][2]);
   }

}







