/****************** MENU.C ********************/
/* Menu engine (C) Jani Uusi-Rantala          */
/* 									          */
/* Home address:					          */
/* 			Jani Uusi-Rantala		          */
/*			Timpurinkatu 35			          */
/*			28800 Pori Finland		          */
/*                                            */
/* Telephone number: +358-2-6482651           */
/*									          */
/* E-Mail address: janiur@cedunet.com         */
/* 		       or: jani.uusi-rantala@mbnet.fi */
/*                                            */
/* You can use this free of charge if you     */
/* give me some credit in your work.	      */
/*											  */
/* If you use this then send me some mail and */
/* probably your work where you use this or   */
/* modified version                           */
/*											  */
/* Slight modifications and customization     */
/* allowed!                                   */
/*                                            */
/* This is Turbo C - version, Watcom 32-bit   */
/* Version coming soon.						  */
/*                                            */
/* Bug reports with E-Mail.					  */
/*                                            */
/*											  */
/* 		   !!!!!! ATTENTION !!!!!!			  */
/*                                            */
/* I'm willing to take some game ideas under  */
/* construction & programming. And some order */
/* programming with cheap prices.			  */
/*											  */
/* Thanks to Dentist, who ordered this engine.*/
/*											  */
/**********************************************/

#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <dos.h>
#include <graphics.h>

#define MENU_ITEMS 30 /* You only have to change this to as many as you want */

/* These are your menu options. MAX 21 characters. These are as many as your MENU_ITEMS */

char *menu_names[MENU_ITEMS] =
	{" 1=MENU 1 "," 2=MENU 2 "," 3=MENU 3 "," 4=MENU 4 "," 5=MENU 5 ",
	 " 6=MENU 6 "," 7=MENU 7 "," 8=MENU 8 "," 9=MENU 9 "," 10=MENU 10 ",
	 " 11=MENU 11 "," 12=MENU 12 "," 13=MENU 13 "," 14=MENU 14 "," 15=MENU 15 ",
	 " 16=MENU 16 "," 17=MENU 17 "," 18=MENU 18 "," 19=MENU 19 "," 20=MENU 20 ",
	 " 21=MENU 21 "," 22=MENU 22 "," 23=MENU 23 "," 24=MENU 24 "," 25=MENU 25 ",
	 " 26=MENU 26 "," 27=MENU 27 "," 28=MENU 28 "," 29=MENU 29 "," 30=MENU 30 "};

/* These are your menu descriptions. MAX 50 characters. As many as items */

char *menu_desc[MENU_ITEMS] =
	{"Description 1","Description 2","Description 3","Description 4",
	 "Description 5","Description 6","Description 7","Description 8",
	 "Description 9","Description 10","Description 11","Description 12",
	 "Description 13","Description 14","Description 15","Description 16",
	 "Description 17","Description 18","Description 19","Description 20",
	 "Description 21","Description 22","Description 23","Description 24",
	 "Description 25","Description 26","Description 27","Description 28",
	 "Description 29","Description 30"};
int x=10,y=7;
int menuitem=0;  /* Help variable */
int menu_low=0;  /* Uppest menu option */
int menu_high=3; /* Lowest menu option */
int menu_name=0; /* Currently selected menu option */

#define MODE_0      {textattr(WHITE | (BLACK << 4));}
#define MODE_1      {textattr(RED   | (BLACK << 4));}
#define MODE_2      {textattr(BLACK | (BLUE << 4));}
#define MODE_3      {textattr(GREEN | (BLACK << 4));}
#define MODE_4      {textattr(WHITE | (BLACK << 4));}
#define MODE_5      {textattr(WHITE | (BLACK << 4));}
#define MODE_7      {textattr(RED | (YELLOW << 4));}
#define MODE_6      {textattr(YELLOW |(RED   << 4));}
#define MODE_13      {textattr(WHITE |(BLACK  << 4));}
#define MODE_8      {textattr(WHITE |(BLUE  << 4));}
#define MODE_9      {textattr(WHITE |(BLUE   << 4));}
#define MODE_12      {textattr(WHITE |(RED   << 4));}
#define MODE_14      {textattr(YELLOW |(BLACK   << 4));}

void init()
{
	gotoxy(x,menuitem+9);
	MODE_8;
	cprintf("%s",menu_names[menu_name]);
	MODE_14;
	gotoxy(1,25);
	cprintf("%-50s",menu_desc[menu_name]);
	sound(45);
	delay(10);
	nosound();

}

void menu_up()
{
	MODE_9;
	if(menuitem==0)
	{
		if(menu_low==0)
		{
			menu_low=0;
			menu_high=3;
		}
		else
		{
			menu_low--;
			menu_high--;
		}
		menuitem=0;
	}
	else menuitem--;

	if(menu_name==0) menu_name=0;
	else menu_name--;
}

void menu_down()
{
	MODE_9;
	if(menuitem==3)
	{
		if(menu_high==MENU_ITEMS-1)
		{
			menu_high=MENU_ITEMS-1;
			menu_low=MENU_ITEMS-4;
		}
		else
		{
			menu_high++;
			menu_low++;
		}
		menuitem=3;
	}
	else menuitem++;
	if(menu_name==MENU_ITEMS-1) menu_name=MENU_ITEMS-1;
	else menu_name++;
}

void mainmenu1(void)
{
	MODE_9;
	while (getch () != 27) ;
	MODE_9;
	clrscr();
}

void mainmenu2(void)
{
	clrscr();

	while (getch () != 27) ;
	MODE_9;
	clrscr();
}

void mainvalg() /* Function for doing stuff */
{
	switch (menu_name) {
		case 0:
			mainmenu1 ();
			break;
		case 1:
			break;
		case 2:
			break;
		case 3:
			mainmenu2 ();
			break;
	   case 4:
			break;
		
  };
}


void main(void)
{
	int i;
	init();
	y=9;
	x=21;
	MODE_9;
	clrscr();
	while(1) {
		gotoxy(19,7);

		MODE_13;
		cprintf("\n\xDA\xC4\xC4MAIN MENU\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xBF\r");
		for(i=menu_low; i<menu_high+1; i++)
		{
			gotoxy(19,i-menu_low+8);
			cprintf("\n\xB3 %-21s\xB3\r",menu_names[i]);
		}
		gotoxy(19,12);
		cprintf("\n\xC0\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xC4\xD9\n\r");

		textcolor(BLACK);
		gotoxy(43,9);
		cprintf("");
		textcolor(BLACK);
		gotoxy(43,10);
		cprintf("");
		textcolor(BLACK);
		gotoxy(43,11);
		cprintf("");
		textcolor(BLACK);
		gotoxy(43,12);
		cprintf("");
		textcolor(BLACK);
		gotoxy(43,13);
		cprintf("");
		textcolor(BLACK);
		gotoxy(22,13);
		textcolor(BLACK);
		cprintf("\n\r");

		MODE_0;
		init();
		switch(getch()) {
			case '\x48':
				menu_up();
				break;

			case '\x50':
				menu_down();
				break;

			case 13:
				mainvalg();
				break;

			case '\x1B':
			MODE_0;
			clrscr();
			exit(1);

			default:
				sound(333);
				delay(33);
				nosound();

			while(!kbhit());
		}
	}
}
