/*  svc.c  --  service functions  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "svc.h"

/* Takes a string of 1-byte length/data format, and make an ASCIIZ */
char *makeasciiz(unsigned char *lstring)
{
  char *asciizstring;
  unsigned char stringlength = *lstring++;

  if ((asciizstring = malloc((int) stringlength + 1)) == NULL)
     return (NULL);

  strncpy(asciizstring, (signed char *) lstring, stringlength);
  asciizstring[stringlength] = '\0';

  return (asciizstring);
}


/* Writes to the output stream. This function adds an exception-handling
   layer to disk I/O. It handles abnormal program termination, and warnings
   to both stderr and output. Three types of messages can be handled:
     Message - simply printed to a file
     Warning - print to a file AND stderr
     Error   - same as Warning, but terminate with abnormal exit code
*/
void output (MESSAGETYPE msgtype, FILE *stream, char *outputformat, ...)
{
  char outputbuffer[133];
  va_list varargp;

  va_start(varargp, outputformat);
  vsprintf(outputbuffer, outputformat, varargp);

  /* if this is (non-fatal) warning or (fatal) error, also send it to stderr */
  if (msgtype != message)
     fprintf(stderr, "\a%s", outputbuffer);

  /* regardless, attempt to send message to output file - exception check */
  if (stream != NOFILE)
     if ((size_t) fprintf(stream, outputbuffer) != strlen(outputbuffer))
      {
        fprintf(stderr, "\aDisk Write Failure!\n");
        abort();
      }

  /* if this was (fatal) error message, abort on the spot [and any other bodily function ...] */
  if (msgtype == error)
   {
     flushall();
     fcloseall();
     abort();
   }

  va_end(varargp);
  return;
}



