/*  ole.h  --  global include for the Object Library Engine  */

#define THEADR               0x80          /* OMF module header */
#define COMENT               0x88          /* OMF comment record */
#define MODEND               0x8a          /* OMF module end record */
#define LIBMOD               0xa3          /* library module name commet class */
#define LIBHEADER            0xf0          /* LIB file header */
#define MARKER_RECORD        0xf1          /* marker between modules and dictionary */
#define NUMBUCKETS           37            /* number of buckets per block */
#define DICTBLOCKSIZE        512           /* bytes per symbol dictionary block */
#define DICTBLKFULL          0xff          /* symbol dictionary block full */

#define UNDEFINED            -1            /* to indicate non-initialised data */
#define STR_EQUAL            0             /* string equality */

/* these two macros will rotate the word operand opw by nbits bits (0 - 16) */
#define WORDBITS             16
#define ROL(opw, nbits)      (((opw) << (nbits)) | ((opw) >> (WORDBITS - (nbits))))
#define ROR(opw, nbits)      (((opw) >> (nbits)) | ((opw) << (WORDBITS - (nbits))))

typedef enum { FALSE, TRUE } BOOL;

#pragma pack(1)

typedef struct {
                 unsigned char rectype;
                 int reclength;
               } OMFHEADER;

typedef struct {
                 unsigned char rectype;
                 int reclength;
                 unsigned char attrib;
                 unsigned char commentclass;
               } COMMENTHEADER;

typedef struct {                           /* record type 0xf0 */
                 int pagesize;              /* header length (excluding first 3 bytes
                                              == page size (module at page boundary) */
                 long dictionaryoffset;    /* file offset of symbol dictionary */
                 int numdictblocks;        /* number of symbol dictionary blocks
                                              <= 251 512-byte dictionary pages */
                 unsigned char flags;      /* only valid flag is 0x01 == case-sensitive */
                 BOOL iscasesensitive;
                 BOOL islibmodformat;      /* is MS extension type LIBMOD present ? */
               } LIBHDR;

typedef struct {
                 int blocknumber;
                 int bucketnumber;
                 unsigned char *symbolp;
                 long modulefilepos;
                 BOOL isfound;
               } DICTENTRY;

typedef struct {
                 int blockhash;
                 int blockovfl;
                 int buckethash;
                 int bucketovfl;
               }  hasht;

void getlibheader(LIBHDR *libheader, FILE *inlibfh);
hasht hash(char symbolz[], int numhashblocks);
DICTENTRY findsymbol(char *symbolz, LIBHDR *libheader, FILE *inlibfh);
void getsymdictblock(int blocknumber, LIBHDR *libheader, FILE *inlibfh);
long findmodule(char *modulename, LIBHDR *libheader, FILE *inlibfh);
DICTENTRY getsymdictentry(int blocknumber, int bucketnumber, LIBHDR *libheader, FILE *inlibfh);
char *getmodulename(long modulefilepos, LIBHDR *libheader, FILE *inlibfh);
BOOL findlibmod(FILE *inlibfh);
BOOL findobjrecord(FILE *objfh, unsigned char rectype);
BOOL extractmodule(char *modulename, char *newmodulename, LIBHDR *libheader, FILE *inlibfh);
void copyobjmodule(FILE *newobjfh, long filepos, FILE *inlibfh);