{ Simple star field                               }
{                                                 }
{                  by Crom / Spanish Lords Feb 96 }
UNIT Stars3D;
INTERFACE
PROCEDURE MakeStars3D;

IMPLEMENTATION
Uses
  Crt, Mcga, Lib3DFP;

Const
  NumStars   = 1024;

Var
  StarsField : Array [1..NumStars] of TPoint3D;
  StarsF     : Array [1..NumStars] of TPoint3D;
  OldStars   : Array [1..NumStars] of TPoint2D;
  CntStar    : Word;
  Xf,Yf      : longint;

Procedure GetRandomStar (NumStar:Word);
Begin
  StarsField [NumStar].x := Random (320)-160;
  StarsField [NumStar].y := Random (200)-100;
  StarsField [NumStar].z :=                0;
End;

Procedure CreateStarField;
Begin
  For CntStar:=1 to NumStars do GetRandomStar (CntStar);
End;

Procedure CreatePalette;
Var
  Cnt : Byte;
Begin
  For Cnt:=1 to 64 do PutColor (Cnt,Cnt,Cnt,0);
End;

PROCEDURE MakeStars3D;
begin
  McgaOn;
  Randomize;
  CreateStarField;
  CreatePalette;
  Repeat
    VerticalRetrace;
    For CntStar:=1 to NumStars do
      Begin
        Xf := XCenter+Trunc((XOrg*StarsField[CntStar].Z - StarsField[CntStar].X*ZOrg)/(StarsField[CntStar].Z-ZOrg));
        Yf := YCenter+Trunc((YOrg*StarsField[CntStar].Z - StarsField[CntStar].Y*ZOrg)/(StarsField[CntStar].Z-ZOrg));
        PutPixel ($A0000,OldStars [CntStar].x,OldStars [CntStar].y,0);
        If (Xf>=XCenter*2) or (Yf>=YCenter*2) then GetRandomStar (CntStar)
                                              else PutPixel ($A0000,Xf,Yf,Trunc(StarsField [CntStar].z));
        StarsField [CntStar].z:=StarsField [CntStar].z+1;
        If StarsField [CntStar].z>=ZOrg then GetRandomStar (CntStar);
        OldStars [CntStar].x:=Xf;
        OldStars [CntStar].y:=Yf;
      End;
  Until Keypress;
  McgaOff;
end;
END.


