{-------------------------------------------------------------------------}
{                                                                         }
{        M C G A     U N I T                                              }
{        -* Mode 13h only *-                                              }
{        TmT pascal version      jeje, Protected Mode age is already here }
{                                                                         }
{                         ,---------------------------------------------, }
{                         | LearnWare Code by Crom / Spanish Lords      | }
{                         '-=========------=======---- crom@ergos.es ---' }
{                                                                         }
{*************************************************************************}
{                                                                         }
{    V i S i T    t H e    S p A n I s H    d E m O s C e N e    W e B    }
{                     http://www.demos.ergos.es                           }
{   Spanish Lords ftp site: ftp.blastersound.ergos.es/blastersound/SLORDS }
{                                                                         }
{*************************************************************************}
{-------------------------------------------------------------------------}
Unit MCGA;

INTERFACE
CONST
  LogicalWide   : longint = 320;
  LogicalHeight : longint = 200;
  ClipX1        : longint =   0;
  ClipY1        : longint =   0;
  ClipX2        : longint = 319;
  ClipY2        : longint = 199;

VAR
  AuxPalette    : Array [0..255,1..3] of Byte;

{ MCGA/VGA functions }
PROCEDURE McgaOn;
PROCEDURE VGA80x50;
PROCEDURE McgaOff;
PROCEDURE SetTextMode;
PROCEDURE VerticalRetrace;
PROCEDURE HorizontalBlank;
PROCEDURE ChangeVGAOff  (VGAOff:Word);
PROCEDURE PutColor      (Color,R,G,B:Byte);
PROCEDURE GetColor      (Color:Byte;Var R,G,B:Byte);
PROCEDURE CopyColor     (Desde:Byte;Hasta:Byte);
PROCEDURE RotaPal       (Color1,Color2:Byte);
PROCEDURE PutPalette    (PalMem:dword);
PROCEDURE GetPalette    (PalMem:dword);
PROCEDURE GetFadePalette;
PROCEDURE FadeUp;
PROCEDURE FadeDown;
{ MISCELLANEOUS functions }
FUNCTION  Mcga2Off      (X,Y:word):dword;
FUNCTION  KeyPress : boolean;
{ MEMORY functions }
PROCEDURE Copy64K       (Org,Des:dword);
PROCEDURE Fill64K       (Des:dword;Data:byte);
PROCEDURE CopyBytes     (Org,Des,Amount:dword);
PROCEDURE FillBytes     (Des,Amount:dword;Data:byte);
{ SPRITE functions }
PROCEDURE PutSprite     (Org,Des,XDim,YDim:dword);
PROCEDURE CopySprite    (Org,Des,XDim,YDim:dword);
PROCEDURE PutSpriteClip (Org,Des:dword;XDes,YDes:longint;XDim,YDim:dword);
{ GFX files functions }
FUNCTION  FileExists    (FileName:String):Boolean;
PROCEDURE ReadRaw       (Var DestinoPtr:Pointer;FileName:String);
PROCEDURE ReadPCXFile   (Buffer:dword;NameOfFile:String;OffFile,LenFile:LongInt;PalOnOff:Boolean);
{ Pix, lines and fillers functions }
PROCEDURE PutPixel      (Des:dword;X,Y:longint;Color:byte);
PROCEDURE DrawLine      (Des:dword;X1,Y1,X2,Y2:longint;Color:byte);
PROCEDURE FlatFill      (Des:dword;X1,Y1,X2,Y2,X3,Y3:longint;Col:byte);
PROCEDURE GouraudFill   (Des:dword;X1,Y1,X2,Y2,X3,Y3:longint;Col1,Col2,Col3:byte);

IMPLEMENTATION
Uses Dos, { ONLY for file error }
     crt; { ONLY for KeyPress   }

Const
  OldMode    : Byte = $FF;

{                  }
{ ERROR PROCESSING }
{                  }
PROCEDURE Error (ErrorStr:String; ErrorNum:Word);
Begin
  If OldMode <> $FF then McgaOff;
  If ErrorNum<>   0 then WriteLn ('Error ', ErrorNum,': ',ErrorStr)
                    else WriteLn ('Error: ',ErrorStr);
  Halt (ErrorNum);
End;
{                                                      }
{ MCGA/VGA FUNCTIONS                                   }
{                                                      }
{ PROCEDURE McgaOn;                                    }
{ PROCEDURE VGA80x50;                                  }
{ PROCEDURE McgaOff;                                   }
{ PROCEDURE SetTextMode;                               }
{ PROCEDURE VerticalRetrace;                           }
{ PROCEDURE HorizontalBlank;                           }
{ PROCEDURE ChangeVGAOff  (VGAOff:dword);              }
{ PROCEDURE PutColor      (Color,R,G,B:byte);          }
{ PROCEDURE GetColor      (Color:byte;Var R,G,B:byte); }
{ PROCEDURE CopyColor     (Desde:byte;Hasta:byte);     }
{ PROCEDURE RotaPal       (Color1,Color2:byte);        }
{ PROCEDURE PutPalette    (PalMem:dword);              }
{ PROCEDURE GetPalette    (PalMem:dword);              }
{ PROCEDURE GetFadePalette;                            }
{ PROCEDURE FadeUp;                                    }
{ PROCEDURE FadeDown;                                  }
{                                                      }
PROCEDURE McgaOn;assembler;
Asm
  mov  ah,0Fh
  int  10h
  mov  [OldMode],al
  mov  ax,13h
  int  10h
End;

PROCEDURE VGA80x50;assembler;
Asm
  mov  ah,0Fh
  int  10h
  mov  [OldMode],al
  mov  ax,13h
  int  10h

  cli                          { Come oN with Jare's cat & dog mode :}

  mov  dx,3C4h                 { Port 3C4h                           }
 {-------------------------------------------------------------------}
  mov  ax,604h                 { Index 04-Value 06.                  }
  out  dx,ax                   { Tweak mode init                     }
  mov  ax,0F02h                { Index 02-Value 0Fh.                 }
  out  dx,ax                   { Enable write to all planes.         }

  mov  dx,3D4h                 { Port 3D4h                           }
 {-------------------------------------------------------------------}
  mov  ax,14h                  { Index 14h-Value 0                   }
  out  dx,ax                   { Disable dword mode.                 }
  mov  ax,0E317h               { Index 17h- Value E3h.               }
  out  dx,ax                   { Enable byte mode.                   }
  mov  al,9                    { Index 09                            }
  out  dx,al
  inc  dx
  in   al,dx                   { Read 3D4h register index 09         }
  and  al,0E0h                 { Set to 0 max. scan lines.           }
  add  al,7                    { Set 8 scan lines per character row. }
  out  dx,al
  sti                          { That's all folks! Do you want more  }
                               { comments? Write them! X-DDDD        }

  mov edi,0A0000h              { ...and now... cLeAr sCrEeN.         }
  xor eax,eax
  mov ecx,16000
  rep stosd
End;

PROCEDURE McgaOff;assembler;
Asm
  mov  al,[OldMode]
  xor  ah,ah
  int  10h
End;

PROCEDURE SetTextMode;assembler;
asm
  mov ax, 3
  int 10h
end;

PROCEDURE VerticalRetrace;assembler;
Asm
  mov  dx,3DAh
@@1:
  in   al,dx
  test al,8
  jnz  @@1
@@2:
  in   al,dx
  test al,8
  jz   @@2
End;

PROCEDURE HorizontalBlank;assembler;
Asm
  mov  dx,03DAh
@@1:
  in   al,dx
  test al,01h
  jz   @@1
End;

PROCEDURE ChangeVGAOff (VGAOff:Word);assembler;
Asm
  mov   dx,3DAh
@@1:                           { Wait for vertical retrace start     }
  in    al,dx
  test  al,8
  jnz   @@1

  mov   bx,[VGAOff]            { Change video offset...              }
  mov   dx,3D4h                { Port 3D4h                           }
 {-------------------------------------------------------------------}
  mov   al,0Ch                 { Index 0C                            }
  mov   ah,bh                  { Value: High VGAOff byte             }
  out   dx,ax
  inc   ax                     { Index 0D                            }
  mov   ah,bl                  { Value: Low VGAOff byte              }
  out   dx,ax                  { ...video offset changed.            }

  mov   dx,3DAh
@@2:                           { Wait for vertical retrace end       }
  in    al,dx
  test  al,8
  jz    @@2
End;

PROCEDURE PutColor (Color,R,G,B:Byte);assembler;
Asm
  mov  dx,03C8h
  mov  al,[Color]
  cli
  out  dx,al
  inc  dx
  mov  al,[R]
  out  dx,al
  mov  al,[G]
  out  dx,al
  mov  al,[B]
  out  dx,al
  sti
End;

PROCEDURE GetColor(Color:Byte; VAR R,G,B:Byte);
Begin
  Port[$3C7]:=Color;
  R:=Port[$3C9];
  G:=Port[$3C9];
  B:=Port[$3C9];
End;

PROCEDURE GetColor2 (Color:Byte;Var R,G,B:Byte);assembler;
Asm
  mov  dx,03C7h
  mov  al,Color
  cli
  out  dx,al
  mov  dx,03C9h
  in   al,dx
  mov  BYTE PTR [R],al
  in   al,dx
  mov  BYTE PTR [G],al
  in   al,dx
  sti
  mov  BYTE PTR [B],al
End;

PROCEDURE CopyColor  (Desde:Byte;Hasta:Byte);
Var
  R,G,B : Byte;
Begin
  GetColor (Desde,R,G,B);
  PutColor (Hasta,R,G,B);
End;

PROCEDURE PutPalette (PalMem:dword);assembler;
Asm
     cli
     mov    dx,03C8h
     xor    al,al
     out    dx,al
     sti
     mov    esi,[PalMem]
     xor    cx,cx
@@Loop:
     cli
     mov    al,cl
     out    dx,al
     inc    dx
     mov    al,[esi]
     out    dx,al
     inc    esi
     mov    al,[esi]
     out    dx,al
     inc    esi
     mov    al,[esi]
     out    dx,al
     inc    esi
     sti
     dec    dx
     inc    cl
     jnz    @@Loop
End;

PROCEDURE GetPalette (PalMem:dword);assembler;
Asm
  mov  edi,[PalMem]
  xor  cl,cl
@@Another:
  mov  dx,03C7h
  mov  al,cl
  cli
  out  dx,al
  mov  dx,03C9h
  in   al,dx
  mov  [edi],al
  inc  edi
  in   al,dx
  mov  [edi],al
  inc  edi
  in   al,dx
  sti
  mov  [edi],al
  inc  edi
  inc  cl
  jnz  @@Another
End;

PROCEDURE GetFadePalette;
Begin
  GetPalette (Ofs(AuxPalette));
End;

PROCEDURE RotaPal (Color1,Color2:Byte);
Var
  Cnt    : Byte;

  CAux1R : Byte;
  CAux1G : Byte;
  CAux1B : Byte;

  CAux2R : Byte;
  CAux2G : Byte;
  CAux2B : Byte;
Begin
  If Color2>Color1 then
    Begin
      GetColor (Color1,CAux1R,CAux1G,CAux1B);
      For Cnt:=Color1+1 to Color2 do
        Begin
          GetColor (Cnt,CAux2R,CAux2G,CAux2B);
          PutColor (Cnt-1,CAux2R,CAux2G,CAux2B);
        End;
      PutColor (Color2,CAux1R,CAux1G,CAux1B);
    End
  else
    Begin
      GetColor (Color1,CAux1R,CAux1G,CAux1B);
      For Cnt:=Color1-1 downto Color2 do
        Begin
          GetColor (Cnt,CAux2R,CAux2G,CAux2B);
          PutColor (Cnt+1,CAux2R,CAux2G,CAux2B);
        End;
      PutColor (Color2,CAux1R,CAux1G,CAux1B);
    End;
End;

PROCEDURE FadeUp;
Var
  Cnt1  : Word;
  Cnt2  : Word;
  Red   : Byte;
  Green : Byte;
  Blue  : Byte;
Begin
  For Cnt1:=1 to 64 do
    Begin
      Verticalretrace;
      For Cnt2:=0 to 255 do
        Begin
          GetColor (Cnt2,Red,Green,Blue);
          If Red  < AuxPalette[Cnt2,1] Then Inc (Red);
          If Green< AuxPalette[Cnt2,2] Then Inc (Green);
          If Blue < AuxPalette[Cnt2,3] Then Inc (Blue);
          PutColor (Cnt2,Red,Green,Blue);
      End;
    End;
End;

PROCEDURE FadeDown;
Var
  Cnt1  : Word;
  Cnt2  : Word;
  Red   : Byte;
  Green : Byte;
  Blue  : Byte;
Begin
  For Cnt1:=1 to 64 do
    Begin
      Verticalretrace;
      For Cnt2:=0 to 255 do
        Begin
          GetColor (Cnt2,Red,Green,Blue);
          If Red  > 0 Then Dec (Red);
          If Green> 0 Then Dec (Green);
          If Blue > 0 Then Dec (Blue);
          PutColor (Cnt2,Red,Green,Blue);
      End;
    End;
End;
{                                              }
{ MISCELLANEOUS functions                      }
{                                              }
{ FUNCTION Mcga2Off (X,Y:Word):Word;assembler; }
{ FUNCTION KeyPress : boolean;                 }
{                                              }
FUNCTION Mcga2Off (X,Y:word):dword;assembler;
Asm
  xor  eax,eax
  xor  ebx,ebx
  mov  ax,[Y]
  mov  bx,[X]
  mov  edx,eax
  xchg dh,dl
  shl  eax,6
  add  eax,edx
  add  eax,ebx
End;

FUNCTION KeyPress:boolean;
var
  teclilla : char;
begin
  if keypressed then begin
                       teclilla:=readkey;
                       if teclilla=#27 then begin
                                              SetTextMode;
                                              Halt(0);
                                            end;
                       KeyPress:=True;
                     end
                else KeyPress:=False;
end;
{                                                                    }
{ MEMORY functions                                                   }
{                                                                    }
{ PROCEDURE Copy64K       (SegOrg,SegDes:Word);                      }
{ PROCEDURE Fill64K       (SegDes:Word;Data:Byte);                   }
{ PROCEDURE CopyBytes     (SegOrg,OffOrg,SegDes,Offdes,Amount:Word); }
{ PROCEDURE FillBytes     (SegDes,OffDes,Amount:Word;Data:Byte);     }
{                                                                    }
PROCEDURE Copy64K    (Org,Des:dword);assembler;
Asm
  mov  esi,[Org]
  mov  edi,[Des]
  mov  ecx,16000
  rep  movsd
End;

PROCEDURE Fill64K    (Des:dword;Data:byte);assembler;
Asm
  mov  edi,[Des]
  xor  eax,eax
  xor  ebx,ebx
  mov  al,[Data]
  mov  ah,al
  mov  bx,ax
  shl  ebx,16
  or   eax,ebx
  mov  ecx,16000
  rep  stosd
End;

PROCEDURE CopyBytes    (Org,Des,Amount:dword);assembler;
Asm
  mov  edi,[Des]
  mov  esi,[Org]
  mov  ecx,[Amount]
  mov  edx,ecx
  shr  ecx,2
  rep  movsd
  and  edx,3
  jz   @@End
  mov  ecx,edx
  rep  movsb
@@End:
End;

PROCEDURE FillBytes    (Des,Amount:dword;Data:byte);assembler;
Asm
  mov  edi,[Des]
  mov  al, [Data]
  mov  ah,al
  mov  bx,ax
  shl  ebx,16
  or   eax,ebx
  mov  ecx,[Amount]
  mov  edx,ecx
  shr  ecx,2
  rep  stosd
  and  edx,3
  jz   @@End
  mov  ecx,edx
  rep  stosb
@@End:
End;
{                                                                           }
{ SPRITE functions                                                          }
{                                                                           }
{ PROCEDURE PutSprite     (Org,Des,XDim,YDim:dWord);                        }
{ PROCEDURE CopySprite    (Org,Des,XDim,YDim:dWord);                        }
{ PROCEDURE PutSpriteClip (Org,Des:dword;XDes,YDes:longint;XDim,YDim:dword);}
{                                                                           }
PROCEDURE PutSprite (Org,Des,XDim,YDim:dword);assembler;
Asm
  mov  esi,[Org]
  mov  edi,[Des]
  mov  ebx,LogicalWide
  sub  ebx,[XDim]             { Wide Cte }
  mov  edx,[YDim]
@@MoreY:
  mov  ecx,[XDim]
@@MoreX:
  mov  al,[esi]
  cmp  al,0
  je   @@NoPut
  mov  [edi],al
@@NoPut:
  inc  edi
  inc  esi
  dec  ecx
  jnz  @@MoreX
  add  edi,ebx
  add  esi,ebx
  dec  edx
  jnz  @@MoreY
End;

PROCEDURE CopySprite (Org,Des,XDim,YDim:dword);assembler;
Asm
  mov  esi,[Org]
  mov  edi,[Des]
  mov  edx,[LogicalWide]
  sub  edx,[XDim]             { Wide Cte }
  mov  ebx,[YDim]
@@MoreY:
  mov  ecx,[XDim]
  rep  movsb
  add  esi,edx
  dec  ebx
  jnz  @@MoreY
End;

PROCEDURE PutSpriteClip (Org,Des:dword;XDes,YDes:LongInt;XDim,YDim:dword);
label OutNOW;
var
  Aux  : longint;
  Des1 : dword;
begin
  if (XDes>ClipX2)        then goto OutNOW;
  if (YDes>ClipY2)        then goto OutNOW;
  if ((XDes+XDim)<ClipX1) then goto OutNOW;
  if ((YDes+YDim)<ClipY1) then goto OutNOW;
  if (XDes<ClipX1) then
    begin
      Aux      := ClipX1 - XDes;
      XDim     := XDim-Aux;
      Org      := Org+Aux;
      XDes     := ClipX1;
    end;
  if (YDes<ClipY1) then
    begin
      Aux      := ClipY1 - YDes;
      YDim     := YDim-Aux;
      Org      := Org+(LogicalWide*Aux);
      YDes     := ClipY1;
    end;
  Aux := XDes+XDim;
  if (Aux>ClipX2) then XDim:=XDim-(Aux-ClipX2);
  Aux := YDes+YDim;
  if (Aux>ClipY2) then YDim:=YDim-(Aux-ClipY2);
  Des1:=Des+(YDes*LogicalWide)+XDes;
  if (XDim>0) and (YDim>0) then PutSprite  (Org,Des1,XDim,YDim);
  OutNOW:
end;

{                                                                           }
{ GFX files functions                                                       }
{                                                                           }
{ FUNCTION FileExists(FileName:String):Boolean;                             }
{ PROCEDURE ReadRaw (Var DestinoPtr:Pointer;FileName:String);               }
{ PROCEDURE ReadPCXFile (BufferSeg:Word;NameOfFile:String;PalOnOff:Boolean);}
{                                                                           }
FUNCTION FileExists(FileName:String):Boolean;
Var
 FAttr : Word;
 FFile : FILE;
Begin
  Assign  (FFile, FileName);
  GetFAttr(FFile, FAttr);
  FileExists := DosError = 0;
End;

PROCEDURE ReadRaw (Var DestinoPtr:Pointer;FileName:String);
Var
  FFile : File;
Begin
  If Not FileExists (FileName) then Error ('File not found.',0);
  Assign (FFile,FileName);
  Reset  (FFile,1);
  BlockRead(FFile,DestinoPtr^,64768);
  Close  (FFile);
End;

{ Only supports 256 colours modes              }
{ Decompress memory zone MUST to have offset 0 }
PROCEDURE ReadPCXFile (Buffer:dword;NameOfFile:String;OffFile,LenFile:LongInt;PalOnOff:Boolean);
Type PCXHeader = Record
                   Manufacturer : Byte;
                   Version      : Byte;
                   Encoding     : Byte;
                   BitsPerPixel : Byte;
                   XMin, YMin   : Word;
                   XMax, YMax   : Word;
                   HRes         : Word;
                   VRes         : Word;
                   Palette      : Array [0..47] of Byte;
                   Reserved     : Byte;
                   ColourPlanes : Byte;
                   BytesPerLine : Word;
                   PaletteType  : Word;
                   Filler       : Array [0..57] of Byte;
                 End;
Var
  PCXFile   : File;
  Header    : PCXHeader;
  Check     : Byte;
  Palette   : Array [0..767] of Byte;
  Width     : Word;
  Height    : Word;
  NumBytes  : Word;
  CntLines  : Word;
  CntBytes  : Word;
  Len       : Byte;
  CntRLE    : Byte;
  BufferOff : dword;

Begin
  If Not FileExists (NameOfFile) then Error ('File not Found',0);
  Assign    (PCXFile,NameOfFile);
  Reset     (PCXFile,1);
  Seek      (PCXFile,OffFile);
  BlockRead (PCXFile,Header, SizeOf (Header));
{ Checking kind of file...        }
  If (Header.Manufacturer=10) and (Header.Version=5) and
     (Header.BitsPerPixel=8)  and (Header.ColourPlanes=1)
     then Begin
            If LenFile<>0 then Seek (PCXFile, LenFile-769)
                          else Seek (PCXFile, FileSize (PCXFile)-769);
            BlockRead (PCXFile, Check, 1);
            If (Check=12) then
              Begin
                BlockRead (PCXFile, Palette,768);
                For CntBytes:=0 to 767 do Palette [CntBytes]:=Palette [CntBytes] shr 2;
                Seek      (PCXFile, OffFile+128);
                Width    :=Header.XMax-Header.XMin+1;
                Height   :=Header.YMax-Header.YMin+1;
              { Clip to 320x200 }
                If Width >320 then Height:=320;
                If Height>200 then Height:=200;
                NumBytes :=Header.BytesPerLine;
                If PalOnOff then PutPalette (Ofs(Palette));
                for CntLines:=0 to Height-1 do
                  Begin
                    BufferOff:=CntLines*320;
                    CntBytes :=0;
                    while (CntBytes<NumBytes) do
                      Begin
                       BlockRead (PCXFile, Check, 1);
                       If ((Check and 192)=192) then
                         Begin
                           Len:=Check and 63;
                           BlockRead (PCXFile, Check, 1);
                           CntBytes:=CntBytes+Len;
                           For CntRLE:=0 to Len-1 do
                             asm
                               mov  edi,[Buffer]
                               add  edi,[BufferOff]
                               mov  al,[Check]
                               mov  [edi],al
                               inc  [BufferOff]
                             end;
{                               mem [Buffer+BufferOff]:=Check;
                               Inc (BufferOff);}
                         End
                       else
                         Begin
                           CntBytes:=CntBytes+1;
                             asm
                               mov  edi,[Buffer]
                               add  edi,[BufferOff]
                               mov  al,[Check]
                               mov  [edi],al
                               inc  [BufferOff]
                             end;
{                           mem [Buffer+BufferOff]:=Check;
                           Inc (BufferOff);}
                         End;
                      End;
                  End;
              End
            else
              Begin
                Close (PCXFile);
                Error ('Palette error.',0);
              End;
          End
     else
       Begin
         Close (PCXFile);
         Error ('Not a 256 colour PCX file.',0);
       End;
    Close (PCXFile);
End;

{                                                                                     }
{ Pix, lines and fillers functions                                                    }
{                                                                                     }
{ PROCEDURE PutPixel      (SegDes:Word;X,Y:Integer;Color:Byte);                       }
{ PROCEDURE DrawLine      (Des:dword;X1,Y1,X2,Y2:longint;Color:byte);                 }
{ PROCEDURE FlatFill      (SegDes:Word;X1,Y1,X2,Y2,X3,Y3:Integer;Col:Byte);           }
{ PROCEDURE GouraudFill   (SegDes:Word;X1,Y1,X2,Y2,X3,Y3:Integer;Col1,Col2,Col3:Byte);}
{                                                                                     }
PROCEDURE PutPixel   (Des:dword;X,Y:longint;Color:byte);assembler;
Asm
  mov  ebx,[X]
  mov  edi,[Y]
  cmp  ebx,[ClipX1]
  jl   @@End
  cmp  edi,[ClipY1]
  jl   @@End
  cmp  ebx,[ClipX2]
  jg   @@End
  cmp  edi,[ClipY2]
  jg   @@End
  mov  al,[Color]
  mov  edx,edi
  xchg dh,dl
  shl  edi,6
  add  edi,edx
  add  edi,ebx
  add  edi,[Des]
  mov  [edi],al
@@End:
End;
PROCEDURE DrawLine (Des:dword;X1,Y1,X2,Y2:longint;Color:byte);
label
  NoBresem;
var
  dx,dy,x,y,xEnd,p : longint;
begin
  if Y1=Y2 then
    begin
      if X1>X2 then begin
                      X1:=x;
                      X1:=X2;
                      X2:=x;
                    end;
      if X1>ClipX2 then goto NoBresem;
      if X2<ClipX1 then goto NoBresem;
      if X1<ClipX1 then X1:=ClipX1;
      if X2>ClipX2 then X2:=ClipX2;
      asm
        mov  ebx,[X1]
        mov  ecx,[X2]
        mov  al,[Color]
        mov  ah,al
        push ax
        shl  eax,16
        pop  ax
        mov  edi,[Y1]
        mov  edx,edi
        xchg dh,dl
        shl  edi,6
        add  edi,edx
        add  edi,ebx
        add  edi,[Des]
        sub  ecx,ebx
        jz   @@NoLine
        mov  edx,ecx
        shr  ecx,2
        rep  stosd
        and  edx,3
        jz   @@NoLine
        mov  ecx,edx
        rep  stosb
      @@NoLine:
      end;
      goto NoBresem
    end;
  if X1=X2 then
    begin
      if Y1>Y2 then begin
                      Y1:=y;
                      Y1:=Y2;
                      Y2:=y;
                    end;
      if Y1>ClipY2 then goto NoBresem;
      if Y2<ClipY1 then goto NoBresem;
      if Y1<ClipY1 then Y1:=ClipY1;
      if Y2>ClipY2 then Y2:=ClipY2;
      asm
        mov  edi,[Y1]
        mov  ecx,[Y2]
        sub  ecx,edi
        jz   @@NoLine
        mov  al,[Color]
        mov  ah,al
        push ax
        shl  eax,16
        pop  ax
        mov  edx,edi
        xchg dh,dl
        shl  edi,6
        add  edi,edx
        add  edi,[X1]
        add  edi,[Des]
        mov  edx,[LogicalWide]
      @@AnotherPix:
        mov  [edi],al
        add  edi,edx
        dec  ecx
        jnz  @@AnotherPix
      @@NoLine:
      end;
      goto NoBresem
    end;
  dx := abs (X1-X2);
  dy := abs (Y1-Y2);
  p  := 2 * dy - dx;
  if X1 > X2 then begin
                    x   :=X2;
                    y   :=Y2;
                    xEnd:=X1;
                  end
             else begin
                    x   :=X1;
                    y   :=Y1;
                    xEnd:=X2;
                  end;
  PutPixel (Des,x,y,Color);
  while x < xEnd do
    begin
      inc (x);
      if p < 0 then p:=p+2*dy
               else begin
                      inc (y);
                      p:=p+2*(dy-dx);
                    end;
      PutPixel (Des,x,y,Color);
    end;
NoBresem:
end;
{                                                                  }
{ Fillers are TOO slow, but... easy to understand LearnWare rulezzz}
{                                                                  }
PROCEDURE FlatFill (Des:dword;X1,Y1,X2,Y2,X3,Y3:longint;Col:Byte);
Var
  Edge1   : Array [0..199] of longint;
  Edge2   : Array [0..199] of longint;
  SwapVar : longint;
  FixX    : longint;
  AuxFix  : longint;
  Incline : longint;
  CntY    : longint;
  XH1,XH2 : longint;
Begin
{ X1 to upper }
  If Y1>Y2 then Begin { Changes (X1,Y1) (X2,Y2) }
                  SwapVar:=X1;
                  X1:=X2;
                  X2:=SwapVar;
                  SwapVar:=Y1;
                  Y1:=Y2;
                  Y2:=SwapVar;
                End;
  If Y1>Y3 then Begin { Changes (X1,Y1) (X3,Y3) }
                  SwapVar:=X1;
                  X1:=X3;
                  X3:=SwapVar;
                  SwapVar:=Y1;
                  Y1:=Y3;
                  Y3:=SwapVar;
                End;
{ 1-2 line will be the largest ;)     }
  If (Y2-Y1)<(Y3-Y1) then Begin { Changes (X2,Y2) (X3,Y3) }
                            SwapVar:=X2;
                            X2:=X3;
                            X3:=SwapVar;
                            SwapVar:=Y2;
                            Y2:=Y3;
                            Y3:=SwapVar;
                          End;
  Incline:=(X2-X1);{ sal 16;}
  asm mov eax,[Incline];sal eax,16;mov [Incline],eax end;
  If (Y2-Y1)<>0 then Incline:=Incline div (Y2-Y1)
                else Incline:=0;
  FixX:=X1;{ sal 16;}
  asm mov eax,[FixX];sal eax,16;mov [FixX],eax end;
  For CntY:=Y1 to Y2 do
    Begin
      If (CntY>=ClipY1) and (CntY<=ClipY2) then
        Begin
          AuxFix:=FixX;
          asm mov eax,[AuxFix];sar eax,16;mov [AuxFix],eax end;
          Edge1[CntY]:=AuxFix;
        End;
      FixX:=FixX+Incline;
    End;
  Incline:=(X3-X1);{ sal 16;}
  asm mov eax,[Incline];sal eax,16;mov [Incline],eax end;
  If (Y3-Y1)<>0 then Incline:=Incline div (Y3-Y1)
                else Incline:=0;
  FixX:=X1;{ shl 16;}
  asm mov eax,[FixX];sal eax,16;mov [FixX],eax end;
  For CntY:=Y1 to Y3 do
    Begin
      If (CntY>=ClipY1) and (CntY<=ClipY2) then
        Begin
          AuxFix:=FixX;
          asm mov eax,[AuxFix];sar eax,16;mov [AuxFix],eax end;
          Edge2[CntY]:=AuxFix;
        End;
      FixX:=FixX+Incline;
    End;
  Incline:=(X2-X3);{ sal 16;}
  asm mov eax,[Incline];sal eax,16;mov [Incline],eax end;
  If (Y2-Y3)<>0 then Incline:=Incline div (Y2-Y3)
                else Incline:=0;
  FixX:=X3;{ sal 16;}
  asm mov eax,[FixX];sal eax,16;mov [FixX],eax end;
  For CntY:=Y3 to Y2 do
    Begin
      If (CntY>=ClipY1) and (CntY<=ClipY2) then
        Begin
          AuxFix:=FixX;
          asm mov eax,[AuxFix];sar eax,16;mov [AuxFix],eax end;
          Edge2[CntY]:=AuxFix;
        End;
      FixX:=FixX+Incline;
    End;
{ Cliiiiiiiiiiping Y }
  If Y1<ClipY1 then Y1:=ClipY1;
  If Y2>ClipY2 then Y2:=ClipY2;
  For CntY:=Y1 to Y2 do
    Begin
      XH1:=Edge1[CntY];
      XH2:=Edge2[CntY];
      If XH1>XH2 then Begin { Changes (XH1,YH1) (XH2,YH2) }
                       SwapVar:=XH1;
                       XH1:=XH2;
                       XH2:=SwapVar;
                      End;
      Asm
        mov  ebx,[XH1]
        mov  ecx,[XH2]
        cmp  ebx,[ClipX1]      { First, Clip X                        }
        jg   @@NoClip1
        mov  ebx,[ClipX1]
      @@NoClip1:
        cmp  ebx,[ClipX2]
        jl   @@NoClip2
        mov  ebx,[ClipX2]
      @@NoClip2:
        cmp  ecx,[ClipX1]
        jg   @@NoClip3
        mov  ecx,[ClipX1]
      @@NoClip3:
        cmp  ecx,[ClipX2]
        jl   @@NoClip4
        mov  ecx,[ClipX2]
      @@NoClip4:
        mov  al,[Col]
        mov  ah,al
        push ax
        shl  eax,16
        pop  ax
        mov  edi,[CntY]
        mov  edx,edi
        xchg dh,dl
        shl  edi,6
        add  edi,edx
        add  edi,ebx
        add  edi,[Des]
        sub  ecx,ebx        { Lon }
        jz   @@NoLine
        mov  edx,ecx
        shr  ecx,2
        rep  stosd
        and  edx,3
        jz   @@NoLine
        mov  ecx,edx
        rep  stosb
@@NoLine:
    End;
  End;
End;

PROCEDURE GouraudFill (Des:dword;X1,Y1,X2,Y2,X3,Y3:longint;Col1,Col2,Col3:byte);
Var
{ Edge arrays:  }
{   0 - Edge    }
{   1 - Color   }
  Edge1   : Array [0..199,0..1] of longint;
  Edge2   : Array [0..199,0..1] of longint;
  SwapVar : longint;
  FixX    : longint;
  FixCol  : longint;
  AuxFix  : longint;
  Incline : longint;
  IncCol  : integer;
  CntY    : longint;
  XH1,XH2 : longint;
  CH1,CH2 : longint;
  IncColH : longint;
Begin
{ X1 to upper }
  If Y1>Y2 then Begin { Changes (X1,Y1) (X2,Y2) }
                  SwapVar:=X1;
                  X1:=X2;
                  X2:=SwapVar;
                  SwapVar:=Y1;
                  Y1:=Y2;
                  Y2:=SwapVar;
                  SwapVar:=Col1;
                  Col1:=Col2;
                  Col2:=SwapVar;
                End;
  If Y1>Y3 then Begin { Changes (X1,Y1) (X3,Y3) }
                  SwapVar:=X1;
                  X1:=X3;
                  X3:=SwapVar;
                  SwapVar:=Y1;
                  Y1:=Y3;
                  Y3:=SwapVar;
                  SwapVar:=Col1;
                  Col1:=Col3;
                  Col3:=SwapVar;
                End;
{ 1-2 line will be the largest ;)     }
  If (Y2-Y1)<(Y3-Y1) then Begin { Changes (X2,Y2) (X3,Y3) }
                            SwapVar:=X2;
                            X2:=X3;
                            X3:=SwapVar;
                            SwapVar:=Y2;
                            Y2:=Y3;
                            Y3:=SwapVar;
                            SwapVar:=Col2;
                            Col2:=Col3;
                            Col3:=SwapVar;
                          End;
  Incline:=(X2-X1);asm mov eax,[Incline];sal eax,16;mov [Incline],eax end;
  IncCol :=(Col2-Col1);asm mov ax,[IncCol];sal ax,8;mov [IncCol],ax end;
  If (Y2-Y1)<>0 then Begin
                       Incline:=Incline div (Y2-Y1);
                       IncCol :=IncCol  div (Y2-Y1);
                     End
                else Begin
                       Incline:=0;
                       IncCol :=0;
                     End;
  FixX  :=X1;asm mov eax,[FixX];sal eax,16;mov [FixX],eax end;
  FixCol:=Col1 shl 8;
  For CntY:=Y1 to Y2 do
    Begin
      If (CntY>=ClipY1) and (CntY<=ClipY2) then
        Begin
          AuxFix:=FixX;asm mov eax,[AuxFix];sar eax,16;mov [AuxFix],eax end;
          Edge1[CntY,0]:=AuxFix;
          Edge1[CntY,1]:=FixCol shr 8;
        End;
      Inc (FixX,Incline);
      Inc (FixCol,IncCol);
    End;
  Incline:=(X3-X1);asm mov eax,[Incline];sal eax,16;mov [Incline],eax end;
  IncCol :=(Col3-Col1);asm mov ax,[IncCol];sal ax,8;mov [IncCol],ax end;
  If (Y3-Y1)<>0 then Begin
                       Incline:=Incline div (Y3-Y1);
                       IncCol :=IncCol  div (Y3-Y1);
                     End
                else Begin
                       Incline:=0;
                       IncCol :=0;
                     End;
  FixX  :=X1;asm mov eax,[FixX];sal eax,16;mov [FixX],eax   end;
  FixCol:=Col1 shl 8;
  For CntY:=Y1 to Y3 do
    Begin
      If (CntY>=ClipY1) and (CntY<=ClipY2) then
        Begin
          AuxFix:=FixX;asm mov eax,[AuxFix];sar eax,16;mov [AuxFix],eax end;
          Edge2[CntY,0]:=AuxFix;
          Edge2[CntY,1]:=FixCol shr 8;
        End;
      Inc (FixX,Incline);
      Inc (FixCol,IncCol);
    End;
  Incline:=(X2-X3);asm mov eax,[Incline];sal eax,16;mov [Incline],eax end;
  IncCol :=(Col2-Col3);asm mov ax,[IncCol];sal ax,8;mov [IncCol],ax end;
  If (Y2-Y3)<>0 then Begin
                       Incline:=Incline div (Y2-Y3);
                       IncCol :=IncCol  div (Y2-Y3);
                     End
                else Begin
                       Incline:=0;
                       IncCol:=0;
                     End;
  FixX  :=X3;asm mov eax,[FixX];sal eax,16;mov [FixX],eax end;
  FixCol:=Col3 shl 8;
  For CntY:=Y3 to Y2 do
    Begin
      If (CntY>=ClipY1) and (CntY<=ClipY2) then
        Begin
          AuxFix:=FixX;asm mov eax,[AuxFix];sar eax,16;mov [AuxFix],eax end;
          Edge2[CntY,0]:=AuxFix;
          Edge2[CntY,1]:=FixCol shr 8;
        End;
      Inc (FixX,Incline);
      Inc (FixCol,IncCol);
    End;
{ Cliiiiiiiiiiping Y }
  If Y1<ClipY1 then Y1:=ClipY1;
  If Y2>ClipY2 then Y2:=ClipY2;
  For CntY:=Y1 to Y2 do
    Begin
      XH1:=Edge1[CntY,0];
      XH2:=Edge2[CntY,0];
      CH1:=Edge1[CntY,1] shl 8;
      CH2:=Edge2[CntY,1] shl 8;
      If XH1>XH2 then Begin { Changes (XH1,YH1,CH1) (XH2,YH2,CH2) }
                       SwapVar:=XH1;
                       XH1:=XH2;
                       XH2:=SwapVar;
                       SwapVar:=CH1;
                       CH1:=CH2;
                       CH2:=SwapVar;
                      End;
    { Calculate color inc... }
      If (XH2-XH1)<>0 then IncColH:=(CH2-CH1) div (XH2-XH1)
                      else IncColH:=0;
    { ... and now clip x and COLOR. }
      If (XH1<ClipX1) then Begin
                             CH1:=CH1+((ClipX1-XH1)*IncColH);
                             XH1:=ClipX1;
                           End;
      If (XH1>ClipX2) then Begin
                             CH1:=CH1+((ClipX2-XH1)*IncColH);
                             XH1:=ClipX2;
                           End;
      If (XH2<ClipX1) then Begin
                             CH2:=CH2+((ClipX1-XH2)*IncColH);
                             XH2:=ClipX1;
                           End;
      If (XH2>ClipX2) then Begin
                             CH2:=CH2+((ClipX2-XH2)*IncColH);
                             XH2:=ClipX2;
                           End;
      asm
        mov  ebx,[XH1]
        mov  ecx,[XH2]
        sub  ecx,ebx        { Lon }
        jz   @@NoLine
        mov  edi,[CntY]
        mov  edx,edi
        xchg dh,dl
        shl  edi,6
        add  edi,edx
        add  edi,ebx
        add  edi,[Des]
        mov  edx,[IncColH]
        mov  ebx,[CH1]
      @@Another:
        mov  [edi],bh
        add  ebx,edx
        inc  edi
        dec  ecx
        jnz  @@Another
      @@NoLine:
      End;
    End;
End;
END.
