NAME    INT6
TITLE   'Uninstall TSRs and stops prgs. that requires a higher CPU.'
;
;Ŀ
;                                                       
;* TSR = program that remains in memory after finished  
;  its execution (Terminate & Stay Residen). Like life  
;  after death. ;-)                                     
;  Examples: mouse drivers, keyboard ones, trainers, ...
;* This program (INT6) prevents that a computer hangs   
;  due a program needs a higher CPU for his execution.  
;  (For example, if you have a 386 and the program      
;  requires a 486), stopping the program execution and  
;  taking back control to DOS.                          
;* There are 4 choiceables ways of residency for INT6.  
;  The ones that have interrupts vectors can also       
;  uninstall others TSRs, and even programs, loaded     
;  after it.                                            
;* Tecnichally, this program uses too many tricks. The  
;  most interesting is the partial & total superescribe 
;  of the PSP, and even the partial of the MCB (I've    
;  never seen so daring). Also it's interesting the way 
;  how it redims itself, once finished the execution.   
;  And the option of having four ways of remain resident
;  (others TSRs only have one). For further details,    
;  look at the source.                                  
;* For compiling this program, you must use a compatible
;  compiler with TASM (which comes with all versions of 
;  Turbo C of Borland or Borland C++, ...).             
;  For compiling with TASM, just write:                 
;      TASM int6.asm                                    
;      TLINK /t int6.obj                                
;  Sorry, but MASM users need to make a little changes  
;  before. I don't know what they are. ;-)              
;* In a 8086 or 8088 this program cannot stop programs  
;  that requires a higher CPU. If you think, you will   
;  see why. (Intel didn't make a special INT for his    
;  first proccesor to stop undefined opcodes).          
;*  If a program runs in protected mode in a 80286      
;  (at the moment, i haven't seen anyone), it isn't     
;  imposible to go back to normal mode (DOS mode, the   
;  segmented one) if you don't reboot your machine.     
;  This fault of bad design of microprocessor, they say 
;  it was IBM's. In 386+, they fixed up that.           
;* Do not execute this program to take off from memory  
;  disk caches programs (like SMARTDRV or NCACHE) or    
;  printers controllers (like PRINT), due it can        
;  originate a data loss in printing or in files that   
;  theorically was copied.                              
;* Due the fact that INT6 versions containing vectors   
;  restore the vectors, if you have loaded a TSR after  
;  INT6 and you execute a program that requires a higher
;  CPU, INT6 will uninstall and the TSR and the program 
;  authomatically, because it can remain in memory,     
;  wasting it innecesarilly. Due that, the TSR will also
;  be unistalled. If you want to solve it, you can      
;  install INT6 again before the suspicious program and 
;  in this way, it doesn't uninstall the TSR. ;-)       
;                                                       
;
;

;Ŀ
;              EQUATES                                  
;

b               EQU     byte ptr
w               EQU     word ptr
nl              EQU     0Dh, 0Ah
$$_08_M         EQU     084dh
$$long_PSP      EQU     0100h           ;length of PSP
$$say_yes       EQU     015h            ;'Y' key
$$off_small     EQU     05ch
$$off_giant     EQU     05ch
$$bytes_to_comp EQU     010d            ;bytes to compare once resident
;Ŀ
; The '$$off_small' and '$$off_giant' variables can be  
;changed for at a minimum of 032h without problems.     
; I don't make this change because they say it isn't    
;too much good, but I didn't have problems. If you want,
;change it.                                             
;


;Ŀ
;              MACROS                                   
;
P&p     MACRO   Var1, Var2
        push    Var1
        pop     Var2
ENDM

PushX   MACRO   R1, R2, R3, R4, R5, R6, R7, R8
	IFNB <R1>
                PUSH    R1                              
                PushX   R2, R3, R4, R5, R6, R7, R8
	ENDIF
ENDM

PopX    MACRO   R1, R2, R3, R4, R5, R6, R7, R8
	IFNB <R1>
                POP     R1                              
                PopX    R2, R3, R4, R5, R6, R7, R8
        ENDIF
ENDM

Look_txt MACRO   texto
        push    dx
        lea     dx, texto
        call Output_text
        pop     dx
ENDM


Vector_Int    SEGMENT AT      0000h
        org     006h * 004h
  vector_INT6     dd      ?
        org     01ch * 004h
  vector_INT1C    dd      ?
Vector_Int    ENDS


.MODEL TINY


;Ŀ
;       C O D E   S E G M E N T                         
;
.CODE

PSP_init        LABEL   BYTE
        org     0ah
  Offset_int22  LABEL   BYTE
        org     080h
  Cmd_line_args LABEL   BYTE
        org     0100h
PSP_end         LABEL   BYTE


;Ŀ
;       Start of program.                               
;
FirstInit:
        jmp Init


;Ŀ
;       Fat Method (1184 bytes).                        
;       Posible uninstall TSRs.                         
;
Start_n1_INT6 LABEL BYTE
N1_int06h:
        mov     ax, 0003h       ;change video mode
        int 010h

        P&p     cs, ds
        lea     dx, txt_cpu - $$long_PSP - 03h

        db      081h, 0c2h      ;\ add dx, w Value_move
Value_move      dw      ?       ;/

        mov     ah, 09h
        int 021h

;
;Restore all interrupt vectors
;
        xor     ax, ax
        mov     es, ax
        P&p     cs, ds

        xor     di, di
        lea     si, Old_vectors - $$long_PSP - 03h      ; 03h -> 'jmp far Init'

        db      081h, 0c6h      ;\ add si, w Value2_move
Value2_move     dw      ?       ;/

        cld
        cli
        mov     cx, (0256d*04d)/02d
        rep movsw

;
; Destroy all not useful memory blocks
;
        mov     cx, cs
                db      0BBh    ;\ mov bx, w FirstMCB
FirstMCB        dw      ?       ;/

@@lookfor_block:
        mov     es, bx
        add     bx, w es:[0003h]
        inc     bx

        cmp     bx, 0A000h
        jae     @@end_takeoff3

        cmp     cx, w es:[0001h]
        jae @@lookfor_block
        mov     ax, es
        inc     ax
        mov     es, ax
        mov     ah, 049h
        int 021h
        jmp short @@lookfor_block
@@end_takeoff3:

        mov     ax, 04c01h      ;Exit to DOS with ErrorCode
        int 021h                ;Kill actual program

txt_cpu db      'INT6: Program requires a higher CPU.$'

Old_INT6    LABEL BYTE
        Off_before_INT6 dw      ?
        Seg_before_INT6 dw      ?

        Old_vectors     db 01024d dup(0)
End_n1_int06h  LABEL   BYTE


;Ŀ
;   TSR Method: Tiny  -> (32 bytes)                     
; Only show a '>' on the screen, trying to say that the 
; program requires a higher proccesor. I could do one   
; that only requires 16 bytes, but it'll stop the       
; program, and you never know what happens.             
;
Start_2_resid  LABEL   BYTE
N2_int6:
        mov     ax, 0003h
        int 010h
        mov     dl, '>'
        mov     ah, 02h
        int 021h
        mov     ah, 04ch
        int 021h
Old2_INT6   LABEL BYTE
        off2_before_INT6   dw      ?
        seg2_before_INT6   dw      ?
End_2_resid     LABEL   BYTE

;Ŀ
;        Once TSR, this part is rejected                
;
N1_int_28h:
;
; Get back Int 28h
;
        PushX   ax, bx, cx, dx, ds, es, di, si
        pushf
        P&p     cs, ds

        inc     w cs:[Counter_int28h]
        cmp     w cs:[Counter_int28h], 0002h    ;Better 0004h
        jb @@before_old_28h

        cli
        mov     ax, 02528h
        mov     ds, w cs:[Old_28h_segment]
        mov     dx, w cs:[Old_28h_offset]
        int 021h
;
;Move resident bytes
;
        mov     ax, cs
        mov     ds, ax
        cmp     Byte_destino, 000Dh
        mov     dx, Byte_destino
        jne @@no_tiny_method
        dec     ax
  @@no_tiny_method:
        mov     es, ax
        cld
        cli
        mov     si, Byte_origin
        mov     di, Byte_destino
        mov     cx, Bytes_to_move
        rep movsb

        cli
        mov     ax, es
        mov     ds, ax
        mov     ax, 02506h
        int 021h
;
; SetBlock
;
        cli
        mov     ax, cs
        mov     es, ax
        mov     ah, 04ah
        mov     bx, w cs:[Size_second_res]
        int 021h

        jnc @@no_error_set_block
        mov     ah, 09h
        lea     dx, cs:[txt_no_move]
        int 021h

  @@no_error_set_block:
;
;Restore block to program via MCB, no DOS
;
        mov     bx, cs
        dec     bx
        mov     es, bx
        inc     bx
        mov     di, 01d
        mov     w es:[di], bx

  @@before_old_28h:
        popf
        PopX    si, di, es, ds, dx, cx, bx, ax

Old_28h LABEL BYTE
        db      0eah         ;opcode of 'jmp far Int 28h'
Old_28h_offset  dw      ?
Old_28h_segment dw      ?
;
;       Call has an IRET (pop ip, pop cs, popf)
;

        Byte_destino    dw      ?
        Byte_origin     dw      ?
        Bytes_to_move   dw      ?
        Size_second_res dw      ?
        Counter_int28h  dw      0000h
txt_no_move     db      'Cannot redim memory block$'

End_first_TSR LABEL BYTE

SIZE_RES = OFFSET End_first_TSR - OFFSET Start_n1_INT6
SIZE_MEM = (SIZE_RES + $$long_PSP + 015d)/016d


;Ŀ
;        Beginning, after execution of resident part.   
;

Init:
        call Credits

        call Test_286

        call Test_DOS

        call Free_actual_environment

        call Get_1MCB

        call Test_if_TSR

        call Take_arguments

        call Exec_orders

        retn                            ;Exit to DOS
                                        ;It can be 'INT 020h' either


;Ŀ
;         Texts and data used in program                
;                                                       
;
Text_and_Data:

        even

Last_int6       dw      ?
MCB_1           dw      ?
Args            dw      ?
TSR_method      dw      ?
Dist_a_Old_INT6 dw      ?
CS_pre_INT6     dw      ?
Seg_vectors     dw      ?
Off_vectors     dw      ?
Disk_access     dw      ?
Env_or_data     dw      ?

txt_no_286      db   nl, 'This program requiers a 80286 for total execution. Continue'
                db   nl, 'anyway (only useful for uninstall programs) (Y/N)?$'
txt_vers_03h    db   nl, 'DOS version under 3.00. This may cause errors in execution.$'
                db   nl, 'Continue (Y/N)?$'
txt_vers_04h    db   nl, 'DOS version under 4.00. This may cause problems in information,'
                db   nl, 'not in execution. Continue (Y/N)?$'
txt_what_do     db   'INT6 v1.01 (C) David Villar Couto, 1997. Freeware program.'
                db   nl, 'INT6 stops execution of programs that requires a higher CPU than you have,'
                db   nl, 'which hang the computer. It can also uninstall TSR installed after INT6.', nl, '$'
txt_args        db   nl, 'Ussage:   INT6 <command>',nl
                db   '  Valid Commands:',nl
                db   'ESC,  0, p, @  -> Exit.', nl
                db   'h, q, 1, x, a  -> Help, Question', nl
                db   'b, r, 2        -> Search last INT6 in memory', nl
                db   's, c, 3        -> Install Small method   ( 128 bytes). With PSP, w/o Vectors', nl
                db   't, d, 4        -> Install Tiny method    (  32 bytes). W/o  PSP, w/o Vectors', nl
                db   'u, e, 5        -> Uninstall TSRs and/or INT6', nl
                db   'f, v, 6        -> Install Fat method     (1184 bytes). W/o  PSP, with Vectors', nl
                db   'g, w, 7        -> Instalar Giant method  (1264 bytes). With PSP, with Vectors', nl
                db   'Make your choice:$'
txt_help        db   nl, 'ESC,  0, p, @ -> Exit actual program (INT6) doing nothing.         INT6Ŀ'
                db   nl, 'r, b, 2       -> Search INT6s in memory if not founded yet.         HELP   '
                db   nl, 'u, e, 5       -> Uninstall residents programs (TSRs) and/or INT6   ON-LINE '
                db   nl, 'h, a, 1, q, x -> This help screen.                                 '
                db   nl,' There are 4 ways of residency for INT6, all choiceable. The most safety and  '
                db   nl, 'advisable is the 7 one. Methods 3 and 4 only stop programs, without restoring'
                db   nl, 'interrupt vectors, which may cause hanging the computer.                     '
                db   nl, 'Methods 6 and 7, with vectors, are more safe, requiring more memory, but also'
                db   nl, 'can uninstall TSRs from memory. Methods 4 and 6 (without PSP) are not so safe'
                db   nl, 'to execute under .BAT files or DOS managers (like PCTools, Norton Commander, '
                db   nl, 'MS-Shell, ...) due they self-redim. Option 5, if INT6 has vectors, uninstall '
                db   nl, 'all programs loaded in memory after it (if wanted), even debuggers or DOS    '
                db   nl, 'managers, if you execute INT6 thru these ones.$'
txt_yet_tsr     db   nl, 'INT6 already installed!. $'
txt_takeoff_tsr db   nl, 'Uninstall TSRs installed after INT6 (Y/N)? $'
txt_no_tsr_INT6 db   nl, 'INT6 not installed. How can I then uninstall it?.', 07h, '$'
txt_no_PC       db   nl, 'Or programs is bad copied or this computer is not a PC 100% compatible or this'
                db   nl, 'program is not under DOS.$'
txt_no_takeoff  db   '-> Error! Cannot uninstall', 07h, '$'
txt_ENV         db   ' + Environment$'
txt_Data        db   ' + Datas$'
txt_prg_uninst  db   nl, 0ah, 'Programs to uninstall:', nl, '$'
txt_no_D_INT6   db   nl, 'I cannot uninstall INT6.$'
txt_method6     db   'TSR Method = Fat   (1184 bytes) Posible uninstall TSRs.$'
txt_method7     db   'TSR Method = Giant (1264 bytes) Posible uninstall TSRs.$'
txt_method4     db   'TSR Method = Tiny    (32 bytes) Cannot uninstall TSRs.$'
txt_method3     db   'TSR Method = Small  (128 bytes) Cannot uninstall TSRs.$'
txt_INT6_tsr    db   nl, 'INT6 has been detected before!.', 07h, '$'
txt_INT6s_mem   db   nl, 'Kinds of INT6 found in memory:$'
txt_out_int6    db   nl, 0ah, 'Uninstall INT6 (Y/N)?','$'
txt_INT6_losed  db   nl, 'INT6 not found in memory!', 07h, '$'


;Ŀ
;      Uninstall TSRs from memory                       
;
Takeoff_tsr       PROC    NEAR
        cmp     w cs:[TSR_method], 0006h
        jb @@no_takeoff

        Look_txt txt_takeoff_tsr
        xor     ah, ah
        int 016h
        cmp     ah, $$say_yes
        jne @@no_takeoff

        call Free_all_TSR

  @@no_takeoff:
        call Takeoff_INT6
        retn
Takeoff_tsr       ENDP


;Ŀ
;            Get first MCB of DOS                       
; I use an undocumented DOS function, but if Micro$oft  
; (or others), do not include it in theirs Operating    
; Systems (Windows 95, DR-DOS, IBM-DOS, MS-DOS, OS/2,   
; Compaq DOS, ...), I'll do it also 'by hand'.          
;
Get_1MCB    PROC    NEAR
        mov     ah, 052h
        int 021h
        sub     bx, 02h
        mov     ax, w es:[bx]
        mov     es, ax
        cmp     w es:[0000h], $$_08_M
        je @@MCB_1_yet_gotten
  @@lookfor_1_MCB:
        xor     ax, ax
  @@looking_1_MCB:
        mov     es, ax
        inc     ax
        or      ax, ax
        jz @@this_isnt_a_PC
        cmp     b es:[0000], 'M'
        jne @@looking_1_MCB
        cmp     w es:[0001h], 0008h
        jne @@looking_1_MCB

  @@MCB_1_yet_gotten:
        mov     w cs:MCB_1, ax
        mov     w cs:FirstMCB, ax
        jmp short @@end_get_1MCB

  @@this_isnt_a_PC:
        Look_txt txt_no_PC
        add     sp, 04h
  @@end_get_1MCB:
        retn            ;return call or DOS
Get_1MCB    ENDP

;Ŀ
;            Free all TSRs under INT6                   
;
Free_all_TSR    PROC    NEAR
;
;Take Disk Interrupt (013h)
;
        P&p     cs, ds
        mov     ax, 03513h
        int 021h
        mov     w cs:[Seg_int13h], es
        mov     w cs:[Off_int13h], bx
        lea     dx, N1_int13h
        mov     ax, 02513h
        int 021h
;
;Restore all interrupts vectors, if there is anyone
        xor     ax, ax
        mov     es, ax
        assume  es:Vector_Int
        mov     ax, w es:[vector_INT6 + 02h]
        mov     ds, ax
        lea     si, Old_vectors - $$long_PSP - 03h
        cmp     w cs:[TSR_method], 0007h
        jne @@no_add_value
        add     si, 05ch
  @@no_add_value:
        mov     w cs:[Seg_vectors], ds
        mov     w cs:[Off_vectors], si
        xor     di, di
        cld

  @@no_Disk:
        cmp     w cs:[Disk_access], 0000h
        jne @@no_Disk

        cli
        mov     cx, (0256d*04d)/02d

        rep movsw
        sti

        call Restore_PSP

        Look_txt txt_prg_uninst
;
;Destroy memory blocks
;
        mov     cx, cs
        mov     ds, cx
        mov     ax, Last_int6
  @@no_eliminable:
;
;Owner DOS (0008h) or void (0000h)
;
        dec     ax
        mov     es, ax
        add     ax, w es:[0003h]         ;Next MCB
        inc     ax
        mov     es, ax                   ;ES=MCB
        inc     ax                       ;PSP or ENV
        cmp     ax, w es:[0001h]         ;Is DOS one?
        jne @@no_eliminable
        cmp     ax, cx                   ;Actual program?
        je @@end_takeoff1

        push    ax
        mov     es, ax
        call    Put_name
        mov     ah, 049h
        int 021h
        pop     ax
        jc @@no_uninstallable

        mov     bx, w cs:[MCB_1]        ;From first MCB
        mov     es, bx
  @@no_block_to_kill:
        add     bx, w es:[0003h]
        inc     bx
        mov     es, bx

        cmp     bx, 0A000h
        jae @@no_eliminable

        mov     dx, w es:[0001h]

        cmp     ax, dx
        jne @@no_block_to_kill
        push    ax
        inc     bx
        mov     es, bx
        call Put_Type
        mov     ah, 049h                ;Free block
        int 021h
        pop     ax
        jc @@no_uninstallable
        dec     bx
        mov     es, bx

        jmp @@no_block_to_kill

  @@no_uninstallable:
        Look_txt txt_no_takeoff

  @@end_takeoff1:
        retn
Free_all_TSR     ENDP

;Ŀ
; Procedure thath only puts if block is an environment  
; or data one.                                          
;
Put_Type         PROC   NEAR
        PushX   ax, dx, ds, es

        cmp     w cs:[Env_or_data], 0001h
        je @@block_is_Data
        P&p     ax, es
        cmp     w es:[02Ch], bx
        jne @@block_is_Data
        lea     dx, txt_ENV
        mov     w cs:[Env_or_data], 0001h
        jmp short @@put_info1
  @@block_is_Data:
        lea     dx, txt_Data
  @@put_info1:
        call Output_text

        PopX    es, ds, dx, ax
        retn
Put_Type         ENDP

;Ŀ
; Procedure that shows the program name to be           
;uninstalled. It reads it from the program MCB.         
;
Put_name        PROC    NEAR
        PushX   ax, di, cx, dx, ds

        mov     w cs:[Env_or_data], 0000h
        mov     ah, 02h
        mov     dl, 0Dh
        int 021h
        mov     ah, 02h
        mov     dl, 0Ah
        int 021h

        mov     ax, es
        dec     ax
        mov     ds, ax
        mov     di, 07h
        mov     cx, 08h
  @@put_text:
        inc     di
        mov     dl, [di]
        cmp     dl, 032d
        jb @@end_put_text
        mov     ah, 02h
        mov     dl, [di]
        int 021h
        loop @@put_text
  @@end_put_text:

        PopX    ds, dx, cx, di, ax
        retn
Put_name        ENDP

;Ŀ
; Tests CPU, to know if it is a 8086 or 8088            
;
Test_286        PROC    NEAR
        mov     dx, sp
        P&p     sp, ax
        cmp     ax, dx
        je @@end_286

        Look_txt txt_no_286

        xor     ah, ah
        int 016h
        cmp     ah, $$say_yes
        je @@end_286
        add     sp, 02h
  @@end_286:
        retn            ;return call or DOS
Test_286        ENDP

;Ŀ
;    Free INT6 Environment (Not needed)                 
; In PSP:[002ch] is stored the direction of the program 
;environment block. In this block, you can see the DOS  
;environments, the famous 'SET' (SET BLASTER=A220 I7 D1)
;
Free_actual_environment   PROC    NEAR
        mov     ah, 051h        ;PSP segment in BX
        int 021h
        mov     ds, bx
        mov     es, w ds:[002ch]
        mov     ah, 049h        ;free Enviroment
        int 021h
        retn
Free_actual_environment  ENDP

;Ŀ
; Simple method for knowing if it's yet resident.       
; It only looks for the INT 06h direction.              
; For further, use Trace_INT6.                          
;
Test_if_TSR     PROC    NEAR
        mov     w cs:TSR_method, 0000h
        xor     ax, ax
        mov     ds, ax
        assume  ds: Vector_Int
        mov     di, w vector_INT6
        mov     cx, w vector_INT6 + 02h
        mov     es, cx
        mov     w cs:Last_int6, cx
        P&p     cs, ds
        lea     si, N1_int06h
        mov     cx, $$bytes_to_comp
        rep cmpsb

        jne @@no_tsr2
        sub     di, $$bytes_to_comp
        cmp     di, $$off_giant
        je @@method_7
        mov     w cs:TSR_method, 0006h
        lea     dx, txt_method6
        jmp short @@pre_end_test_if_TSR
  @@method_7:
        mov     w cs:TSR_method, 0007h
        lea     dx, txt_method7
        jmp short @@pre_end_test_if_TSR

  @@no_tsr2:
        xor     ax, ax
        mov     ds, ax
        assume  ds: Vector_Int
        mov     di, w vector_INT6
        P&p     cs, ds
        lea     si, N2_int6
        mov     cx, $$bytes_to_comp
        rep cmpsb

        jne @@end_test_if_TSR
        sub     di, $$bytes_to_comp
        cmp     di, $$off_small
        je @@method_3
        mov     w cs:TSR_method, 0004h
        lea     dx, txt_method4
        jmp short @@pre_end_test_if_TSR
  @@method_3:
        mov     w cs:TSR_method, 0003h
        lea     dx, txt_method3
  @@pre_end_test_if_TSR:
        Look_txt txt_yet_TSR
        call Output_text
  @@end_test_if_TSR:
        retn
Test_if_TSR     ENDP

;Ŀ
;      See  DOS Version                                 
;
Test_DOS        PROC    NEAR
        mov     ah, 030h
        int 021h
        cmp     al, 03h
        jae @@superior_03h
        Look_txt txt_vers_03h
        jmp short @@cont_vers
  @@superior_03h:
        cmp     al, 04h
        jae @@no_old_version
        Look_txt txt_vers_04h
  @@cont_vers:
        xor     ah, ah
        int 016h
        cmp     ah, $$say_yes
        je @@no_old_version
        add     sp, 0002h
  @@no_old_version:
        retn                    ;return call or DOS
Test_DOS        ENDP

;Ŀ
; Uninstall only INT6 and restore the vectors.          
;
Takeoff_INT6      PROC    NEAR
Dist_1184bytes = OFFSET old_INT6  - OFFSET Start_n1_INT6
Dist_32bytes   = OFFSET old2_INT6 - OFFSET Start_2_resid

        cmp     w cs:[TSR_method], 0000h
        jne @@ask_takeoff_INT6
        Look_txt txt_no_tsr_INT6
        jmp short @@no_takeoff_INT6
  @@ask_takeoff_INT6:
        P&p     cs, ds
        Look_txt txt_out_int6
        xor     ah, ah
        int 016h
        cmp     ah, $$say_yes
        jne @@no_takeoff_INT6
;
;Get back previous INT 06h, looking in the TSR
;
        cmp     w cs:[TSR_method], 0005h
        jb @@32bytes_Model
        mov     w cs:[Dist_a_Old_INT6], Dist_1184bytes
        jmp short @@lookfor_last_int6
  @@32bytes_Model:
        mov     w cs:[Dist_a_Old_INT6], Dist_32bytes
  @@lookfor_last_int6:
        xor     ax, ax
        mov     es, ax
        assume  es:Vector_Int
        mov     ax, w es:[vector_INT6]
        mov     dx, w es:[vector_INT6+02h]
        mov     w cs:[CS_pre_INT6], dx
        mov     ds, dx
        mov     si, ax

        add     si, w cs:[Dist_a_Old_INT6]
        mov     di, 06d*04d
        movsw
        movsw

        mov     ax, w cs:[CS_pre_INT6]
        cmp     w cs:[TSR_method], 0004h
        jne @@no_tiny_add
        inc     ax
  @@no_tiny_add:
        mov     es, ax
        mov     ah, 049h
        int 021h
        jnc @@no_takeoff_INT6
        P&p     cs, ds
        Look_txt txt_no_D_INT6
  @@no_takeoff_INT6:
        retn
Takeoff_INT6      ENDP


;Ŀ
;              Take the command line                    
;
Take_arguments   PROC NEAR
        mov     w cs:Args, 0000h
        mov     ax, w cs:Cmd_line_args
        cmp     ax, 02002h              ;2 characters & space
        jne @@without_args
        mov     ax, w cs:Cmd_line_args + 02d
        and     ax, 0000000000001111b

        cmp     ax, 08h
        jbe @@end_args
  @@without_args:
        xor     ax, ax
  @@end_args:
        mov     w cs:Args, ax
        retn
Take_arguments   ENDP

;Ŀ
;    Credits                                            
;
Credits         PROC NEAR
        Look_txt txt_what_do
        retn
Credits         ENDP

;Ŀ
;    Texts Putter                                       
;
Output_text       PROC    NEAR
        PushX   ax, ds

        P&p     cs, ds
        mov     ah, 09h
        int 021h

        PopX    ds, ax
        retn
Output_text       ENDP

;Ŀ
;    Take orders manager                                
;
Ask_orders   PROC    NEAR
        Look_txt txt_args
  @@ask_again:
        xor     ah, ah
        int 016h
        cmp     ah, 01h
        jne @@no_ESC
        add     sp, 04h
        retn
  @@no_ESC:
        and     ax, 0000000000001111b
        cmp     ax, 08d
        jbe @@well_taken
        mov     ah, 02h
        mov     dl, 07h
        int 021h
        jmp short @@ask_again
  @@well_taken:
        mov     w cs:Args, ax
        retn
Ask_orders      ENDP

;Ŀ
;     Get the correct orders and do not execute others  
;
Exec_orders    PROC    NEAR
        cmp     w cs:Args, 0000h
        je @@ask_command
  @@ini_exec_orders:
        cmp     w cs:Args, 0008h
        je @@show_help
        cmp     w cs:Args, 0001h        ;Long help
        jne @@no_help
  @@show_help:
        Look_txt txt_help
  @@ask_command:
        call Ask_orders
        jmp short @@ini_exec_orders

  @@no_help:
        cmp     w cs:Args, 0002h        ;Search INT6
        jne @@no_lookfor
        call Trace_INT6
        jmp short @@ask_command

  @@no_lookfor:
        cmp     w cs:Args, 0000h        ;Exit
        je short @@end_exec_orders

  @@no_exit:
        cmp     w cs:Args, 0005h        ;Uninstall
        jne @@no_uninstall
        call Takeoff_tsr
        jmp short @@end_exec_orders

  @@no_uninstall:
        cmp     w cs:Args, 0003h        ;Tiny
        je      @@Make_Small
        cmp     w cs:Args, 0004h        ;Small
        je      @@Make_Tiny
        cmp     w cs:Args, 0006h        ;Big - Fat
        je      @@Make_Big
  @@Make_Giant:
        call Make_Giant
        jmp short @@end_exec_orders     ;Innecesary
  @@Make_Tiny:
        call Make_Tiny
        jmp short @@end_exec_orders     ;Innecesary
  @@Make_Small:
        call Make_Small
        jmp short @@end_exec_orders     ;Innecesary
  @@Make_Big:
        call Make_Big
        jmp short @@end_exec_orders     ;Innecesary

  @@end_exec_orders:
        retn
Exec_orders    ENDP

;Ŀ
;  TSR Big (or Fat), without PSP, with MOVS (1184 bytes)
;
Make_Big       PROC    NEAR
Big_bytes = OFFSET End_n1_int06h - OFFSET Start_n1_INT6
SIZE_BIG2 = OFFSET End_n1_int06h - OFFSET Start_n1_INT6
SIZE_BIG  = (SIZE_BIG2 + 0Fh) / 016d

        P&p     cs, ds
        mov     ax, 03506h
        int     021h
        mov     w cs:[Off_before_INT6], bx
        mov     w cs:[Seg_before_INT6], es

        mov     w cs:[Value_move], 0000h
        mov     w cs:[Value2_move], 0000h

        mov     w cs:[Byte_origin], OFFSET Start_n1_INT6
        mov     w cs:[Byte_destino], 0000h
        mov     w cs:[Bytes_to_move], Big_bytes
        mov     w cs:[Size_second_res], SIZE_BIG

        mov     dx, w cs:[Byte_destino]
        mov     ax, 02506h
        int 021h
;
;Keep vectors before break down all
;
        P&p     cs, es
        xor     ax, ax
        mov     ds, ax
        xor     si, si
        lea     di, Old_vectors
        mov     cx, (0256d*04d)/02d
        cli
        rep movsw

        P&p     cs, ds
        mov     ax, 03528h
        int 021h
        mov     Old_28h_segment, es
        mov     Old_28h_offset, bx
        lea     dx, N1_int_28h
        mov     ax, 02528h
        int 021h

        mov     dx, SIZE_MEM    ;size of paragraphs
        mov     ax, 03100h      ;Make TSR witout ErrorCode
        int 021h                ;Execute it
        retn                    ;Innecesary, it remain TSR
Make_Big       ENDP

;Ŀ
;  Tiny Model,  without PSP neither MOVS (32 bytes)     
;
Make_Tiny      PROC    NEAR
Tiny_bytes = OFFSET End_2_resid - OFFSET Start_2_resid
SIZE_TINY  = 0001h             ;I know this, I make this in that way
        mov     ax, 03506h
        int     021h
        mov     w cs:[Off2_before_INT6], bx
        mov     w cs:[Seg2_before_INT6], es

        mov     w cs:[Byte_origin], OFFSET N2_int6
        mov     w cs:[Byte_destino], 000Dh
        mov     w cs:[Bytes_to_move], Tiny_bytes
        mov     w cs:[Size_second_res], SIZE_TINY

        mov     ax, cs
        dec     ax
        mov     ds, ax
        mov     dx, w cs:[Byte_destino]
        mov     ax, 02506h
        int 021h

        P&p     cs, ds
        mov     ax, 03528h
        int 021h
        mov     w cs:Old_28h_segment, es
        mov     w cs:Old_28h_offset, bx
        lea     dx, N1_int_28h
        mov     ax, 02528h
        int 021h

        mov     dx, SIZE_MEM    ;size of paragrahs
        mov     ax, 03100h      ;Make TSR without Errorcode
        int 021h                ;Execute all
        retn                    ;Never returns. Stupid line.
Make_Tiny      ENDP

;Ŀ
;   Small Model,  with PSP, without MOVS (128 bytes)    
;
Make_Small      PROC    NEAR
Small_bytes = OFFSET End_2_resid - OFFSET Start_2_resid
SIZE_Small  = (Small_bytes + $$off_small + 0Fh) / 016d
        mov     ax, 03506h
        int     021h
        mov     w cs:[off2_before_INT6], bx
        mov     w cs:[seg2_before_INT6], es


        mov     ax, cs
        mov     ds, ax
        mov     es, ax
        mov     dx, $$off_small
        mov     ax, 02506h
        int 021h
;
; Move bytes
;
        mov     si, OFFSET N2_int6
        mov     di, $$off_small
        mov     cx, Small_bytes
        rep movsb

        mov     dx, SIZE_Small  ;size of paragraphs
        mov     ax, 03100h      ;Exit remaining resident
        int 021h                ;Execute interrupt
        retn                    ;What can I say?
Make_Small      ENDP


;Ŀ
; Modeo Giant, with PSP, with MOVS (1264 bytes)         
;
Make_Giant     PROC    NEAR
Giant_bytes = OFFSET End_n1_INT06h - OFFSET Start_n1_INT6
SIZE_Giant  = (Giant_bytes + $$off_giant + 0Fh) / 016d
        mov     ax, 03506h
        int     021h
        mov     w cs:[Off_before_INT6], bx
        mov     w cs:[Seg_before_INT6], es

        mov     w cs:[Value_move], $$off_giant
        mov     w cs:[Value2_move], $$off_giant

        mov     ax, cs
        mov     ds, ax
        mov     dx, $$off_giant
        mov     ax, 02506h
        int 021h

        P&p     cs, es
        xor     ax, ax
        mov     ds, ax
        xor     si, si
        lea     di, Old_vectors
        mov     cx, 01024d/02d
        cli
        rep movsw
;
; Move bytes
;
        mov     ax, cs
        mov     ds, ax
        mov     es, ax

        mov     si, OFFSET Start_n1_INT6
        mov     di, $$off_giant
        mov     cx, Giant_bytes
        rep movsb

        mov     dx, SIZE_Giant  ;Size in paragraphs
        mov     ax, 03100h      ;make TSR w/o ErrorCode
        int 021h                ;and execute interrupt
        retn                    ;Once again. It never execute this line.
Make_Giant     ENDP

;Ŀ
;  Restore vectors 22h, 23h and 24h in my own PSP, coz, 
; if not, commands interpreters (like COMMAND.COM,      
; 4DOS.COM, NDOS.COM, ...) will hang my program.        
;
Restore_PSP     PROC    NEAR
        PushX   cx, ds, si, es, di

        P&p     cs, es
        lea     di, w cs:[Offset_int22]
        mov     ds, w cs:[Seg_vectors]
        mov     si, w cs:[Off_vectors]
        add     si, 022h*04h
        mov     cx, 012d
        cld
        cli
        rep movsb
        sub     si, 0002h
        movsw
        sti

        PopX    di, es, si, ds, cx
        retn
Restore_PSP     ENDP

;Ŀ
; Take disk interrupt, to avoid make stupid things if   
; you are saving something.                             
;
N1_int13h       PROC    NEAR
        mov     w cs:[Disk_access], 0001h
;
;Anti-IRET
;
        pushf
        db      09ah            ;opcode of 'call far'
Off_int13h      dw      ?
Seg_int13h      dw      ?
        mov     w cs:[Disk_access], 0000h
        iret
N1_int13h       ENDP

;Ŀ
;  If, at begining, program cannot detect itself, with  
; this manner, it WILL do it.                           
;
Trace_INT6      PROC    NEAR
        Look_txt txt_INT6s_mem

        P&p     cs, ds
        mov     w cs:TSR_method, 0000h
        mov     ax, w cs:MCB_1
        mov     es, ax
        mov     bx, ds
        inc     ax

  @@lookfor_another_block:
        dec     ax
        mov     es, ax
        add     ax, w es:[0003h]
        inc     ax
        mov     es, ax
        inc     ax

        cmp     ax, bx
        jae @@no_lookfor_INT6

        cmp     ax, w es:[0001h]
        jne @@lookfor_another_block             ;ENV or Data

        mov     di, 016d-03d
        mov     cx, $$bytes_to_comp
        lea     si, N2_int6
        rep cmpsb

        jne @@no_tiny
        mov     w cs:TSR_method, 0004h          ;Tiny
        lea     dx, txt_method4
        jmp short @@text_&_jump

  @@no_tiny:
        mov     es, ax
        xor     di, di
        mov     cx, $$bytes_to_comp
        lea     si, N1_int06h
        rep cmpsb

        jne @@no_big                            ;Fat
        mov     w cs:TSR_method, 0006h
        lea     dx, txt_method6
        jmp short @@text_&_jump

  @@no_big:
        mov     di, $$off_small
        mov     cx, $$bytes_to_comp
        lea     si, N2_int6
        rep cmpsb

        jne @@no_small                          ;Small
        mov     w cs:TSR_method, 0003h
        lea     dx, txt_method3
        jmp short @@text_&_jump

  @@no_small:
        mov     di, $$off_giant
        mov     cx, $$bytes_to_comp
        lea     si, N1_int06h
        rep cmpsb

        jne @@lookfor_another_block
        mov     w cs:TSR_method, 0007h          ;Giant
        lea     dx, txt_method7
  @@text_&_jump:
        call Txt_&_Vector06
        jmp short @@lookfor_another_block

  @@no_lookfor_INT6:
        cmp     w cs:TSR_method, 0000h
        jne @@end_Trace_INT6
        Look_txt txt_INT6_losed
  @@end_Trace_INT6:
        retn
Trace_INT6      ENDP

;Ŀ
;  Shows texts and restore INT 06h, which was taked by  
; another program.                                      
;
Txt_&_Vector06  PROC    NEAR
        PushX   ax, dx, ds

        push    dx
        mov     ah, 02h
        mov     dl, 0Dh
        int 021h
        mov     ah, 02h
        mov     dl, 0Ah
        int 021h
        pop     dx

        call Output_text
        mov     dx, di
        sub     dx, $$bytes_to_comp
        P&p     es, ds
        mov     ax, 02506h
        int 021h
        mov     w cs:[Last_int6], es

        PopX    ds, dx, ax
        retn
Txt_&_Vector06  ENDP


        END FirstInit
