Program TestTCP;

Uses CRT,DOS,
     PPP,      {Point to Point Protocol Unit}
     TCP,      {TCP and Sockets Unit}
     DNS,      {DOMAIN Name Resolver}
     UDP,      {User Datagram Protocol}
     MODEM;

Const
  PFC        : Array[1..4] of byte = (7,2,8,2);
  CRLF = #13#10;

Var
 ip2 : iptype;
 _ComPort : byte;
 _Speed   : longint;
 _Phone   : string;
  ch : char;
  done : boolean;
  dnsptr : pDNS;
  ppp_stage : byte;
  oldip : string;
  tcpsocket : pSocket;
  tcpsocketdata : pbyte;
  tcpsocketsize : word;
  tcpdatap      : pbyte;
  tcpalloc      : word;
  temp : string;

Procedure Terminal;
var
 done : Boolean;
 ch : char;
Begin
  ch := #0;
  done := false;
  repeat
    while (modem.numchars>0) do write(getchar);
    if keypressed then
     Begin
       ch := readkey;
       if ch<>#0 then
        Begin
          sendchar(ch);
          if ch=#27 then done := true;
        end else
        Begin
          ch := readkey;
          write(ch);
        end;
     end;
  until done;
end;

Procedure DNSLookup;
var
 s : string;
Begin
  if dnsptr<>nil then
   Begin
     writeln('Still Looking for : ',dnsptr^.domain);
     exit;
   end;
  write('Host to lookup >');
  readln(s);
  dnsptr := gethostbyname(s);
end;

Procedure WRITEDNS;
Begin
  if dnsptr=nil then exit;
  if dnsptr^.complete then
    Begin
      writeln('DNS   : '+dnsptr^.domain);
      writeln('---------------------------------------------------');
      writeln('IP    : '+dnsptr^.ips);
      writeln('TTL   : ',dnsptr^.time_to_live);
      writeln('ERROR : ',dnsptr^.error);
      DNS_DONE(dnsptr);
    end;
end;

Procedure PPP_Callback;
const
  IPRECEIVE : Array[1..6] of byte = (3,6,0,0,0,0);
  PFC        : Array[1..4] of byte = (7,2,8,2);
Begin
  if not(oPPP.carrier) then exit;
  case (ppp_stage) of
     4 : Begin
           oPPP.packet_driver;
           DNS_Callback;
           Handle_Sockets;
         end;
     0 : Begin
           oPPP.sendlcp(1,random(256),4,oPPP.makeptr(PFC));
           inc(ppp_stage);
         end;
     1 : Begin
           oPPP.packet_driver;
           if length(oPPP.IPString)>0 then
            Begin
              oPPP.SendNCD(Configure_Request,random(256),6,oPPP.Makeptr(IPRECEIVE));
              inc(ppp_stage);
            end;
         end;
     2 : Begin
           oPPP.packet_driver;
           oldip := oPPP.IPString;
           inc(ppp_stage);
         end;
     3 : Begin
           oPPP.packet_driver;
           if oPPP.IPstring<>oldip then
            Begin
              clrscr;
              inc(ppp_stage);
              writeln;
              writeln('Assigned IP Address : '+oPPP.IPSTRING);
              writeln;
              writeln('<Q> Quit          <D> DNS Lookup  <O> Open Socket');
              writeln('<C> Close Socket  <S> Send Data   <H> This Help Menu');
              writeln('<U> Test UDP Packet');
            end;
         end;
  end;
end;

Procedure writeports;
Begin
  clrscr;
  writeln('Some Useful Port #''s to test');
  writeln('------------------------------------------------');
  writeln('13   Daytime');
  writeln('17   Quote of the Day');
  writeln('21   FTP (Control)');
  writeln('25   Simple Mail Transfer Protocol (Send E-Mail)');
  writeln('37   Time');
  writeln('43   Who Is');
  writeln('80   HTTP');
  writeln('70   Finger');
  writeln('110  Post Office Protocol v3 (Receive E-Mail)');
  writeln('119  Network News Transfer Protocol');
  writeln('------------------------------------------------');
end;

Procedure TestUDP;
var
 u : pudp;
 ds : word;
 s : string;
 dp : pbyte;
Begin
 u := oUDP.GetUDPFrame(PORT,37,0);
 if u<>nil then
   Begin
     ds := u^.datasize;
     dp := u^.data;
     s := '';
     while (ds>0) do
       Begin
        dec(ds);
        s := s + chr(dp^);
        inc(dp);
       end;
     writeln(s);
   end;
end;

Procedure OpenSocket;
var
 s : string;
 p : word;
Begin
  if (tcpsocket<>nil) then
    Begin
      Writeln('Closing Socket');
      close_socket(tcpsocket);
    end;
  writeln;
  write('Host >');
  readln(s);
  writeports;
  write('Port >');
  readln(p);
  tcpsocket := Open_Socket(s,getsocket,p);
end;

Procedure CloseSocket;
Begin
  if tcpsocket=nil then exit;
  writeln('Closing Socket');
  close_socket(tcpsocket);
  tcpsocket := nil;
end;



Function Fillbuffer:boolean;
Begin
  fillbuffer := true;
  if (tcpsocket<>nil) then freemem(tcpsocket,tcpsocketsize);
  Read_Socket(tcpsocket,tcpsocketsize,tcpsocketdata);
  if tcpsocketsize=0 then
     Begin
       fillbuffer := false;
       exit;
     end;
  tcpdatap := tcpsocketdata;
  tcpalloc := tcpsocketsize;
end;

Function Getbyte(var ok:boolean):byte;
Begin
  ok := false;
  getbyte := 250;
  if (tcpsocketsize=0) then if not (fillbuffer) then exit;
  dec(tcpsocketsize);
  getbyte := tcpdatap^;
  inc(tcpdatap);
  ok := true;
end;

Function GetCommand:string;
var
  s : string;
  c,c2 : char;
  done : boolean;
  stage : byte;
  _ok : boolean;
Begin
  done := false;
  stage := 0;
  s := ''; getcommand := '';
  repeat
      c := char(getbyte(_ok));
      if not _ok then done := true else
      Begin
        if c=#13 then
          Begin
            c2 := char(getbyte(_ok));
            if _ok then
              Begin
                if c2=#10 then done := true else s := s + c + c2;
              end else
               Begin
                 s := s + c;
                 done := true;
               end;
          end else s := s + c;
      end;
  until done;
  if not (_ok) then
    Begin
      temp := temp+s;
      getcommand := '';
    end else
    Begin
      getcommand := temp+s;
      temp := '';
    end;
end;

Function WS(cs:string):byte;
var
 t3,t32 : ppp.pbyte;
 l : word;
Begin
  cs := cs + CRLF;
  l := length(cs);
  t3 := str2pbyte(cs);
  t32 := t3;
  ws := Write_Socket(tcpsocket,length(cs),t3);
  freemem(t32,l);
end;

Procedure SendTCP;
var
 s : string;
Begin
  if tcpsocket=nil then exit;
  writeln;
  write('Data >');
  readln(s);
  WS(s);
end;

Procedure ReceiveTCP;
var
 s : string;
Begin
  if tcpsocket=nil then exit;
  s := getcommand;
  if length(s)>0 then write(s);
{  Read_Socket(tcpsocket,datasize,data);
  if datasize=0 then exit;
  d2 := data;
  for x := 1 to datasize do
   Begin
     write(chr(d2^));
     inc(d2);
   end;
  freemem(data,datasize);}
end;



Begin
  clrscr;
  writeln('Internet Protocol Test Program v1.0');
  writeln('Copyright (C) 1997 - Trilliun Software Products');
  writeln;
  write('Com Port : ');
  readln(_Comport);
  write('Speed    : ');
  readln(_Speed);
  write('Phone    : ');
  readln(_phone);
  writeln;
  writeln('When you have established a PPP session, press <ESC>');
  writeln('to activate the PPP driver.');
  writeln;
  writeln('Dialing....');

  tcpsocket := nil;
  ppp_stage := 0;
  dnsptr := nil;
  oPPP.Init(_comport,_speed,nil); {Initialize PPP Layer with correct info}
  oPPP.Dial('','',_phone,'');
  terminal;
  done := false;
  oPPP.sendlcp(1,random(256),4,oPPP.makeptr(PFC));
  oPPP.FormatIP(204,181,152,2,ip2);

  repeat
    if dnsptr<>nil then writedns;
    PPP_CALLBACK;
    RECEIVETCP;
    TESTUDP;
    if keypressed then
      Begin
        ch := readkey;
        if ch=#0 then
         Begin
           ch := readkey;
         end else
         Begin
           case upcase(ch) of
             'Q' : done := true;
             'D' : DNSLOOKUP;
             'O' : OPENSOCKET;
             'C' : CLOSESOCKET;
             'S' : SENDTCP;
             'U' : oUDP.SendUDP(666,ip2,37,37,0,nil);
             'H' : Begin
                     writeln('<Q> Quit          <D> DNS Lookup  <O> Open Socket');
                     writeln('<C> Close Socket  <S> Send Data   <H> This Help Menu');
                     writeln('<U> Test UDP Packet');
                   end;
           end;
         end;
      end;
  until done;
  oPPP.Done;
end.
