Program TestPPP;

Uses PPP,UDP,TCP,IP,ICMP,DNS,crt,mail;

Const
  CIP : Array[1..12] of byte = (3,6,0,0,0,0,2,6,0,45,15,0);
  UDP_Packet : Array[1..10] of byte = (1,2,3,4,5,6,7,8,9,10);
  NCD_Packet : Array[1..4] of byte = (2,4,0,33);
  PFC        : Array[1..4] of byte = (7,2,8,2);
  IPRECEIVE : Array[1..6] of byte = (3,6,0,0,0,0);

var
 DNS_RESULT : pDNS;
 done : boolean;
 ch : char;
 test : psocket;
 t3,test2,test2p : pbyte;
 x : word;
 l : word;
 cs : string;
 port : word;
 curport : word;

Procedure Call_PPP_Provider;
Begin
  done := false;
  oPPP.Dial('tsp','canttell!','444-3504','');
  oPPP.Terminal;
  repeat
    oPPP.packet_driver;
    if keypressed then
      Begin
        ch := upcase(readkey);
        case ch of
          'Q' : DONE := TRUE;
        end;
      end;
     if length(oPPP.ipstring)>0 then done := true;
  until done;
  oPPP.SendNCD(Configure_Request,random(256),6,oPPP.Makeptr(IPRECEIVE));
end;

Procedure Communicate;
var
 ip3,ip2 : iptype;
 dnsquery : string;
Begin
  clrscr;
  writeln(' (PPP) Connection Established');
  writeln('  IP Address : ',oPPP.IPString);
  oPPP.FormatIP(204,181,152,2,ip2);
  oPPP.FormatIP(129,79,26,27,ip3);
  done := false;
  repeat
    oPPP.packet_driver;
    DNS_Callback;
    Handle_Sockets;

    if keypressed then
      Begin
        ch := upcase(readkey);
        case ch of
          #27 : oPPP.SendLCP(5,random(255),0,nil);
          'P' : oICMP.SendICMP(ECHO_REQUEST,0,random(32000),ip2);
          {'C' : oICMP.SendICMP(ECHO_REQUEST,0,random(32000),ip3);}
          'L' : oICMP.SendICMP(ECHO_REQUEST,0,random(32000),oPPP.IPAddr);
          'D' : Begin
                  writeln;
                  write('DOMAIN NAME>');
                  readln(dnsquery);
                  DNS_RESULT := Gethostbyname(dnsquery); {Add DNS Search to DNS Stack}
                end;
          'I' : oPPP.SendNCD(1,random(256),6,oPPP.makeptr(IPRECEIVE));
          'Q' : DONE := TRUE;
          {'O' : test := Open_Socket('ares.csd.net',110,110);}
          'S' : Begin
                  if test<>nil then close_socket(test);
                  writeln;
                  write('DOMAIN >');
                  readln(dnsquery);
                  write('PORT >');
                  readln(port);
                  inc(curport);
                  test := Open_Socket(dnsquery,curport,port);
                end;
          'C' : Begin
                  writeln;
                  write('COMMAND >');
                  readln(cs);
                  cs := cs + #10 + #13;
                  t3 := str2pbyte(cs);
                  Write_Socket(test,length(cs),t3);
                  freemem(t3,length(cs));
                end;
          'X' : if test<>nil then writeln('Socket : ',close_socket(test));
          'T' : if test<>nil then
                Begin
                writeln('Socket Status');
                writeln('---------------------------------------');
                writeln('Domain : ',test^.domain);
                writeln('IP     : ',oPPP.IPSTR(test^.ip));
                writeln('Status : ',test^.status);
                writeln('In     : ',test^.datainsize);
                writeln('Out    : ',test^.dataoutsize);
                writeln('Error  : ',test^.lasterror);
                writeln('---------------------------------------');
                end;
          'R' : Begin
                  {test2 := Read_Socket(test);}
                  test2p := test2;
                  l := oUDP.getbyte(test2p) shl 8;
                  inc(l,oUDP.getbyte(test2p));
                  if (test2<>nil) then
                    Begin
                      for x := 1 to l do write(chr(oUDP.getbyte(test2p)));
                      freemem(test2,l+2);
                    end;
                end;
        end;
      end;
     {if oPPP.Terminate_ok then done := true;}
          if DNS_RESULT<>nil then
            if DNS_RESULT^.complete then
                    Begin
                      writeln('-----------------------------------------------');
                      writeln('Domain Name : ',DNS_RESULT^.domain);
                      writeln('IP          : ',DNS_RESULT^.ips);
                      writeln('Error Level : ',DNS_RESULT^.error);
                      writeln('TTL         : ',DNS_RESULT^.time_to_live);
                      writeln('-----------------------------------------------');
                      DNS_DONE(DNS_RESULT); {Delete information from DNS Stack}
                    end;

  until done;
end;

Begin
  curport := 0;
  test := nil;
  oPPP.Init(2,57600,nil);
  call_PPP_provider;
  {clrscr;}
  writeln;
  writeln('  IP ADDRESS : ',oPPP.ipstring);
  writeln;
  communicate;
  oPPP.Done;
end.
