{$DEFINE DEBUG}
Unit SMTP;

Interface

Uses TCP,PPP,SB;

Procedure SENDMAIL(address:string;fname:string); {Initializes SMTP Routines}
Procedure SMTP_Callback; {Handles Sending MAIL}

Const
  SMTP_PORT = 25;
  hostaddress = 'tsp@ares.csd.net';
  hostdomain = 'csd.net';
  CRLF = #13#10;

var
  temp : string;
  smtp_active : boolean;
  {$IFDEF DEBUG} f : text; {$ENDIF}
  msg : text;
  ts : string;
  smtp_callback_id : longint;
  smtp_stage : byte;
  smtp_socket : pSOCKET;
  smtp_data  : pbyte;
  smtp_datap : pbyte;
  smtp_datasize : word;
  smtp_allocsize : word;
  maildomain : string;
  user : string;
  filename : string;
  message_sent : boolean;
  message_size : longint;

Implementation

uses win,global,mimecode;

Procedure SENDMAIL(address:string;fname:string);
var
 s : string;
 x : byte;
 t : file;
Begin
  if smtp_active then
    Begin
      if (smtp_stage<4) then
        Begin
          Delete_Callback(nil,get_handle_callback(smtp_callback_id));
          Close_Socket(smtp_socket);
          if (smtp_allocsize)>0 then
          Begin
            freemem(smtp_data,smtp_allocsize);
            smtp_allocsize := 0;
            smtp_data := nil;
          end;
        end else
      Begin
        close(lf);
        message_box('SMTP','Mail session already in progress!',OK,4,0);
        exit;
      end;
    end;
  smtp_active := true;
  smtp_stage := 0;
  smtp_callback_id := unique_id;
  smtp_data := nil;
  smtp_datap := nil;
  smtp_allocsize := 0;
  smtp_datasize := 0;
  temp := '';
  message_sent := false;
  filename := fname;

  assign(t,filename);
  {$I-}
  reset(t,1);
  if (IORESULT<>0) then
    Begin
      smtp_active := false;
      message_box('SMTP','Invalid Message File!',OK,4,0);
      exit;
    end;
  message_size := filesize(t);
  close(t);

  x := pos('@',address);
  if (x=0) then
    Begin
      message_box('SMTP','Invalid E-mail : '+address,OK,4,0);
      exit;
    end;
  user := address;
  delete(user,x,255);
  maildomain := address;
  delete(maildomain,1,x);
  Add_Callback(smtp_callback_id,nil,smtp_callback_id,1);
  {$IFDEF DEBUG} assign(f,'SMTP.LOG'); rewrite(f); {$ENDIF}
end;

Function Fillbuffer:boolean;
Begin
  fillbuffer := true;
  if (smtp_data<>nil) then freemem(smtp_data,smtp_allocsize);
  Read_Socket(smtp_socket,smtp_datasize,smtp_data);
  if smtp_datasize=0 then
     Begin
       fillbuffer := false;
       exit;
     end;
  smtp_datap := smtp_data;
  smtp_allocsize := smtp_datasize;
end;

Function Getbyte(var ok:boolean):byte;
Begin
  ok := false;
  getbyte := 250;
  if (smtp_datasize=0) then if not (fillbuffer) then exit;
  dec(smtp_datasize);
  getbyte := smtp_datap^;
  inc(smtp_datap);
  ok := true;
end;

Function GetCommand:string;
var
  s : string;
  c,c2 : char;
  done : boolean;
  stage : byte;
  _ok : boolean;
Begin
  done := false;
  stage := 0;
  s := ''; getcommand := '';
  repeat
      c := char(getbyte(_ok));
      if not _ok then done := true else
      Begin
        if c=#13 then
          Begin
            c2 := char(getbyte(_ok));
            if _ok then
              Begin
                if c2=#10 then done := true else s := s + c + c2;
              end else
               Begin
                 s := s + c;
                 done := true;
               end;
          end else s := s + c;
      end;
  until done;
  if not (_ok) then
    Begin
      temp := temp+s;
      getcommand := '';
    end else
    Begin
      getcommand := temp+s;
      temp := '';
    end;
  {$IFDEF DEBUG} if length(s)>0 then writeln(f,s); {$ENDIF}
end;

Function WS(cs:string):byte;
var
 t3,t32 : ppp.pbyte;
 l : word;
Begin
  cs := cs + CRLF;
  l := length(cs);
  t3 := str2pbyte(cs);
  t32 := t3;
  ws := Write_Socket(smtp_socket,length(cs),t3);
  freemem(t32,l);
  {$IFDEF DEBUG} write(f,cs);{$ENDIF}
end;

Procedure SMTP_Callback;
var
 s : string;
 x : byte;
 count : longint;
Begin
  if not (smtp_active) then exit;
  case smtp_stage of
    {Open Socket}
    0 : Begin
          if smtp_socket<>nil then close_socket(smtp_socket);
          smtp_socket := Open_Socket(maildomain,getsocket,SMTP_Port);
          inc(smtp_stage);
        end;

    {Check if Socket has been opened}
    1 : if smtp_socket^.status=S_SOCKET_OPEN then inc(smtp_stage);

    {Read Socket for greeting}
    2 : Begin
          ts := Getcommand;
          if (length(ts)>=4) and (ts[4]='-') then exit;
          if length(ts)>0 then
             if pos('220',ts)=1 then inc(smtp_stage) else smtp_stage := 254;
        end;
    3 : Begin
          ws('HELO '+hostdomain); inc(smtp_stage);
        end;

    4 : Begin
          ts := Getcommand;
          if (length(ts)>=4) and (ts[4]='-') then exit;
          if length(ts)>0 then if pos('250',ts)=1 then inc(smtp_stage) else smtp_stage := 254;
        end;
    5 : Begin
          ws('MAIL FROM:<'+hostaddress+'>'); inc(smtp_stage);
        end;
    6 : Begin
          ts := Getcommand;
          if (length(ts)>=4) and (ts[4]='-') then exit;
          if length(ts)>0 then if pos('250',ts)=1 then inc(smtp_stage) else smtp_stage := 254;
        end;
    7 : Begin
          ws('RCPT TO:<'+user+'@'+maildomain+'>'); inc(smtp_stage);
        end;
    8 : Begin
          ts := GetCommand;
          if (length(ts)>=4) and (ts[4]='-') then exit;
          if length(ts)>0 then if pos('250',ts)=1 then inc(smtp_Stage) else smtp_stage := 254;
        end;
    9 : Begin
          ws('DATA'); inc(smtp_stage);
        end;
    10 : Begin
           ts := Getcommand;
           if (length(ts)>=4) and (ts[4]='-') then exit;
           if length(ts)>0 then if pos('354',ts)=1 then
             Begin
               inc(smtp_stage);
               assign(msg,filename);
               reset(msg);
               statusbarwin('Sending Message',message_size);
             end else smtp_stage := 254;
         end;
    11 : Begin
           count := 0;
          for x := 1 to 50 do
             if eof(msg) then
               Begin
                 ws('.');
                 statusbarwinclose;
                 close(msg);
                 smtp_stage := 12;
                 message_box('SMTP','Message sent, waiting for reply...',0,0,0);
                 exit;
               end else
               if not eof(msg) then
               Begin
                 if (smtp_socket^.dataoutsize<MAX_DATA_SIZE-256) and (oPPP.canwrite) then
                  Begin
                    readln(msg,ts); if ts='.' then ts:=ts+'.';
                    ws(ts);
                    inc(count,length(ts));
                  end;
               end;
            if count>0 then update_bar(count);
          end;
    12  : Begin
            ts := Getcommand;
            if (length(ts)>=4) and (ts[4]='-') then exit;
            if (length(ts)>0) then
             Begin
               if(pos('250',ts)=1) then
                Begin
                  standard_close(true);
                  message_sent := true;
                  smtp_stage := 254;
                end else smtp_stage := 254;
             end {else ws('.');}
          end;
    253 : Begin
            message_box('SMTP','Session did not terminate properly!',OK,4,0);
            smtp_stage := 252;
          end;
    254 : Begin
            ws('QUIT');
            inc(smtp_stage);
          end;
    255 : Begin
            ts := GetCommand;
            if (length(ts)>=4) and (ts[4]='-') then exit;
            if length(ts)>0 then
            Begin
              if not(message_sent) then message_box('SMTP','Error Sending Message',OK,4,0) else
                                        message_box('SMTP','Message Sent Successfully',OK,4,0);
              Delete_Callback(nil,get_handle_callback(smtp_callback_id));
              Close_Socket(smtp_socket);
              smtp_stage := 253;
              if (smtp_allocsize)>0 then
               Begin
                 freemem(smtp_data,smtp_allocsize);
                 smtp_allocsize := 0;
                 smtp_data := nil;
               end;
              {$IFDEF DEBUG} close(f);{$ENDIF}
              smtp_active := false;
            end;
          end;
  end;
end;

Begin
  smtp_active := false;
  smtp_socket := nil;
end.

Implementation


end.
