Unit windows;

Interface

Uses crt,dos,vesa,fontvesa,
     mouseu,routine,filer,
     global,colors,input,s_new
     {$IFDEF DPMI},strings{$ENDIF};

Const
  Minimize_Button  = 1;
  Maximize_Button  = 2;
  Close_Button     = 4;
  Sizeable         = 8;
  Moveable         = 16;
  Modal            = 32;
  Help_Button      = 64;
  OK               = 1;
  CANCEL           = 2;
  YES              = 4;
  NO               = 8;
  REBOOT_BUTTON    = 16;
  HORZ             = 0;
  VERT             = 1;
  NO_HSB           = 0;
  NO_VSB           = 0;
  SELECT           = TRUE;
  NO_SELECT        = FALSE;

  About_Dialog    = 0;
  File_Dialog     = 1;
  Print_Dialog    = 2;
  Help_Dialog     = 3;
  Menu_Dialog     = 4;
  Toolbar_Dialog  = 5;
  Standard_Dialog = 6;

  String_Field      = 255;
  Phone_Field       = 254;
  Amount_Field      = 253;
  Credit_Card_Field = 252;
  Time_Field        = 251;
  Date_Field        = 250;
  Password_Field    = 249;
  Character_Field   = 248;
  Byte_Field        = 247;
  Integer_Field     = 246;
  Word_Field        = 245;
  Real_Field        = 244;
  Memo_Field        = 243;
  Credit_Expiration_Field = 242;
  Account_Field = 240;
  DB_EDIT         = 1;
  DB_TEXT         = 2;

  {$I INPUT.INC}

Type
  filtertype = set of char;


VAR
	ExitProcSave: POINTER;
	Int8Save: POINTER;
	Int8CallFract: WORD;
	Int8CallOverflow: WORD;
	TimerCounter: LONGINT;

        strfilter,
        amountfilter,
        realfilter,
        timefilter,
        datefilter,
        charfilter,
        creditfilter,
        numfilter : filtertype;
        filter : filtertype;


  {$I SB.INC}
  {$I MENU.INC}
  {$I DATA.INC}
  {$I LB.INC}
  {$I BMP.INC}
  {$I BTN.INC}
  {$I TEXT.INC}
  {$I CB.INC}
  {$I CLIENT.INC}
  {$I DROP.INC}
  {$I ACCEL.INC}
  {$I CALLBACK.INC}

  handle_dialog = ^Dialog_Type;
  Dialog_Type = Record
                  id          : longint;
                  dtype       : byte;
                  name        : string;
                  xpos,ypos   : integer;
                  xpos1,ypos1 : integer;
                  x1,y1,x2,y2 : integer;
                  flags       : byte;

                  first_button,last_button,cur_button : handle_button;
                  first_text,last_text,cur_text       : handle_text;
                  first_data,last_data,cur_data       : handle_data;
                  first_menu,last_menu,cur_menu       : ml;
                  first_sb,last_sb,cur_sb             : handle_scrollbar;
                  first_lb,last_lb,cur_lb             : handle_listbox;
                  first_cb,last_cb,cur_cb             : handle_checkbox;
                  first_bmp,last_bmp,cur_bmp          : handle_bmp;
                  first_client,last_client,cur_client : handle_client;
                  first_accelerator,last_accelerator,cur_accelerator : handle_accelerator;
                  first_callback,last_callback,cur_callback : handle_callback;

                  state       : byte;
                  min,max     : boolean;
                  active      : boolean;
                  prev,next   : handle_dialog;

                  oxpos,oypos,oxpos1,oypos1           : integer;

                  pu_present : boolean;
                  pu_xpos,pu_ypos,pu_xpos1,pu_ypos1   : integer;
                  pu_image : pbyte;
                  pu_mem : longint;

                  horz_sb,vert_sb                     : handle_scrollbar;

                  minimize_func,maximize_func,
                  close_func,help_func,
                  inclientfunct                 : longint;

                  tminimize_func,tmaximize_func,
                  tclose_func,thelp_func,
                  tinclientfunct                : longint;

                  cursorx,cursory : integer;
                  cursorstate : byte;
                  cursorvisible : boolean;

                  callback_procedure:procedure(idn:longint);
                  z : byte;
                end;

Var
 mbox : longint;

 First_Dialog,
 Last_Dialog,
 Cur_Dialog : handle_dialog;
 dialog_id : longint;

 First_Callback,
 Last_Callback,
 Cur_Callback : handle_callback;

 Background_Color,Border_Color1,Border_Color2,Border_Color3,
 Menu_Color,Title_Color,Active_Title_Bar_Color,
 Disabled_Title_Bar_Color,Minimize_Color : byte;
 Maximize_Color,Client_Background_Color,Client_Text_Color,Close_Color,
 Scrollbar_Border1,Scrollbar_Border2,Scrollbar_Background,Scrollbar_Text_Color,
 Listbox_title,Listbox_Border1,Listbox_Border2,Listbox_Background : byte;
 ListBox_Text,CheckBox_Border1,CheckBox_Border2,CheckBox_Background,
 CheckBox_Text,Data_Border1,Data_Border2,Data_Background,Data_Text,
 Checkbox_disabled,Menu_Border1,Menu_Border2,Menu_Background,Menu_Text :byte;
 Disabled_Menu,Popup_Border1,Popup_Border2,Popup_Background,Popup_Text,
 Disabled_Popup,Button_Background,Button_Border1,Button_Border2 : byte;
 Button_Text,Disabled_Button: byte;

 curz : byte;

 xofs,yofs : integer;

 cursor : array[1..8] of byte;

Procedure Create_Dialog(resid:longint;title:string;xp1,yp1,xp2,yp2:integer;cdtype:byte;
                        mode:byte;helpfunc,minfunc,maxfunc,closefunc,icfunc:longint;
                        horzsbid,vertsbid,horzsb,vertsb:longint);
Function  Get_Handle_Dialog(id:longint):handle_dialog;
Procedure Close_Dialog(dlg:handle_dialog);
Procedure Close_All_Dialogs;
Procedure Standard_Close(_refresh:boolean);
Procedure Draw_Dialog(dlg:handle_dialog);
Procedure Draw_Client_Screen(dlg:handle_dialog);

Function Mousein(x1,y1,x2,y2:integer):boolean;
Procedure DialogMouseRoutine;
Procedure SetActive(id:longint);
Procedure Redraw_All(refresh_cur:boolean);
Procedure Refresh;
Function  Unique_ID:longint;
Procedure SetMouseextents(x1,y1,x2,y2:integer);
Procedure DefaultMouseExtents;

Procedure Message_Box(title,message:string;flags:byte;b1,b2:longint);

Function  Assign_String(s:string;id:longint):boolean;
Function  Retrievepchar(id:longint):string;
Function  Lpad(s:string;x:integer):string;
Function  Rpad(s:string;x:integer):string;
Function  Cpad(s:string;x:integer):string;
Procedure SetClip(dlg:handle_dialog);

Procedure Add_Text(id:longint;dlg:handle_dialog;xpos,ypos:integer;s:string;funcnum:longint);
Procedure Delete_Text(dlg:handle_dialog;tlp:handle_text);
Procedure Delete_All_Text(dlg:handle_dialog);
Procedure Draw_Text(dlg:handle_dialog;ht:handle_text);
Function  Get_Handle_Text(id:longint):handle_text;

Procedure Add_Button(id:longint;dlg:handle_dialog;xpos,ypos:integer;bt:byte;s:string;bmpid:longint;enabled:boolean;fn:longint);
Procedure Delete_button(dlg:handle_dialog;blp:handle_button);
Procedure Delete_All_Buttons(dlg:handle_dialog);
Procedure Enable_Button(id:longint);
Procedure Disable_Button(id:longint);
Function  Assign_Button_Function(id:longint;dlg:handle_dialog;funcnum:longint):boolean;
Procedure Draw_Button(dlg:handle_dialog;blp:handle_button);
Function  Get_Handle_button(id:longint):handle_button;

Procedure Add_Data(id:longint;
                   dlg:handle_dialog;
                   xpos,ypos:integer;
                   req:boolean;        {required?}
                   fieldwidth:byte;    {fieldwidth on screen}
                   maxlength:word;     {maximum field length}
                   ft : byte;s:string; {fieldtype}
                   data:string;        {default data}
                   funcnum:longint);   {}

Procedure Assign_Data(dataid:longint;s:string);
Procedure Delete_Data(dlg:handle_dialog;tlp:handle_data);
Procedure Draw_Data(dlg:handle_dialog;blp:handle_data);
Function  Get_Handle_Data(id:longint):handle_Data;
Procedure Draw_All_Data(dlg:handle_dialog);

Procedure Add_Menu(dlg:handle_dialog;name:string);
Procedure Delete_Menu(dlg:handle_dialog;tlp:ml);
Procedure Delete_All_Menu(dlg:handle_dialog);

Procedure Add_Menu_Item(id:longint;m:ml;name:string;fn:longint);
Procedure Delete_Menu_Item(m:ml;tlp:handle_menu_item);
Procedure Delete_All_Menu_Item(m:ml);
Function  Get_Handle_Menu_Item(id:longint):handle_menu_item;

Procedure Add_Scrollbar(id:longint;dlg:handle_dialog;xpos,ypos,length:integer;min,max,curpos,step,jump:longint;
                        horv:byte;funcnum:longint);
Procedure Delete_Scrollbar(dlg:handle_dialog;sbp:handle_scrollbar);
Procedure Delete_All_Scrollbars(dlg:handle_dialog);
Procedure Draw_Scrollbar(dlg:handle_dialog;sbp:handle_scrollbar);
Function  Get_Handle_Scrollbar(id:longint):handle_scrollbar;
Procedure Set_Scrollbar(this:handle_scrollbar;min,max,curpos,step,jump:longint);

Procedure Add_ListBox(id:longint;dlg:handle_dialog;title:string;xpos,ypos,xpos1,ypos1:integer;hscrollid,vscrollid:longint;
                      selectfunc:longint;df:handle_data;inclientfunct:longint);
Procedure Delete_ListBox(dlg:handle_dialog;tlp:handle_listbox);
Procedure Delete_all_listboxes(dlg:handle_dialog);
Procedure Draw_ListBox(dlg:handle_dialog;blp:handle_listbox;drawbox:boolean);
Procedure Draw_Listboxes(dlg:handle_dialog);
Function  Get_Handle_listbox(id:longint):handle_listbox;
Procedure Sort_Listbox(hl:handle_listbox);
Function  Assign_Listbox_Select(id,func:longint):boolean;

Procedure Add_Listbox_Item(m:handle_listbox;name:string;ml:longint;ref:longint);
Procedure Delete_ListBox_Item(m:handle_listbox;tlp:lt;dsb : boolean);
Procedure Delete_All_Listbox_items(tlp:handle_listbox);
Procedure Draw_ListBox_Item(blp:handle_listbox;lbi:lt;xpos,ypos,xofs,maxx,maxy:word;drawbox,db2:boolean);

Procedure Add_Checkbox(id:longint;dlg:handle_dialog;xpos,ypos:integer;s:string;enabled,selected:boolean;funcnum:longint);
Procedure Delete_checkbox(dlg:handle_dialog;tlp:handle_checkbox);
Procedure Delete_All_Checkboxes(dlg:handle_dialog);
Procedure Draw_Checkbox(dlg:handle_dialog;checkbox:handle_checkbox);
Procedure Draw_Checkboxes(dlg:handle_dialog);
Function  Get_Handle_Checkbox(id:longint):handle_checkbox;

Procedure Add_BMP(id:longint;dlg:handle_dialog;xpos,ypos:integer;puttype:byte;fname:string;funcnum:longint);
Procedure Delete_BMP(dlg:handle_dialog;tlp:handle_bmp);
Procedure Delete_All_BMPS(dlg:handle_dialog);
Procedure Draw_BMP(dlg:handle_dialog;bmp:handle_bmp);
Procedure Draw_All_BMPS(dlg:handle_dialog);
Function  Get_Handle_BMP(id:longint):handle_bmp;

Procedure Add_Client(id:longint;dlg:handle_dialog;xpos,ypos,width,height:integer;speed:longint);
Procedure Delete_Client(dlg:handle_dialog;tlp:handle_client);
Procedure Delete_All_Clients(m:handle_dialog);
Procedure Draw_All_Clients(dlg:handle_dialog);
Procedure Draw_Client(dlg:handle_dialog;client:handle_client);
Function  Get_Handle_Client(id:longint):handle_Client;

Procedure Add_Accelerator(id:longint;dlg:handle_dialog;functionkey:byte;character:byte;funcnum:longint);
Procedure Delete_Accelerator(dlg:handle_dialog;tlp:handle_accelerator);
Procedure Delete_All_Accelerators(dlg:handle_dialog);
Procedure Setup_Accelerators(dlg:handle_dialog);

Procedure Add_Callback(id:longint;dlg:handle_dialog;funcnum:longint;speed:longint);
Procedure Delete_Callback(dlg:handle_dialog;tlp:handle_callback);
Procedure Delete_All_Callbacks(dlg:handle_dialog);
Function  Get_Handle_Callback(id:longint):handle_callback;

Function BitSet(b:byte;o:byte):boolean;

Implementation


Uses Resource;

Procedure EraseCursor(dlg:handle_dialog); forward;
Procedure DrawCursor(dlg:handle_dialog); forward;
Procedure SetCursor(dlg:handle_dialog;data:handle_data); forward;

var
 count : byte;

{$I TIMER.INC}

Function Assign_String(s:string;id:longint):boolean;
var
 hdta : handle_data;
Begin
 hdta := get_handle_data(id);
 if hdta<>nil then
  Begin
   hdta^.data.done;
   hdta^.data.init(hdta^.maxlength);
   hdta^.data.addstring(s);
   Assign_String := true;
  end else Assign_String := False;
end;


Function Set_Underline(s:string;var upos:byte):string;
var
 u : byte;
Begin
 upos := pos('&',s);
 if upos>0 then delete(s,upos,1);
 Set_Underline := s;
end;


Procedure Set_Client_Offset(dlg:handle_dialog);
Begin
  if dlg^.horz_sb<>nil then xofs := -dlg^.horz_sb^.curpos else xofs := 0;
  if dlg^.vert_sb<>nil then yofs := -dlg^.vert_sb^.curpos else yofs := 0;
end;

Procedure SetMouseextents(x1,y1,x2,y2:integer);
Begin
 setminmaxhorzcurspos (x1 shl 1,x2 shl 1);
 setminmaxvertcurspos (y1,y2);
end;

Procedure DefaultMouseExtents;
Begin
 setminmaxhorzcurspos (0,mousemaxx shl 1);
 setminmaxvertcurspos (0,mousemaxy);
end;

Function  Unique_ID:longint;
Begin
  inc(mbox);
  unique_id := mbox;
end;

Procedure Reorder_Windows;
var
 zlist : array[0..255] of handle_dialog;
 loop : byte;
 tval : byte;
 this : handle_dialog;
 last : handle_dialog;
Begin
 this := first_dialog;
 if (this=nil) then exit;
 for loop := 0 to 255 do zlist[loop] := nil;
 while (this<>nil) do
   Begin
     zlist[this^.z] := this;
     this := this^.next;
   end;

 last := nil;
 first_dialog := nil;
 last_dialog := nil;
 for loop := 0 to 255 do
     if (zlist[loop]<>nil) then
      Begin
        if (first_dialog=nil) then first_dialog := zlist[loop];
        zlist[loop]^.prev := last;
        zlist[loop]^.next := nil;
        if last<>nil then last^.next := zlist[loop];
        last := zlist[loop];
      end;
 last_dialog := last;
 {Reassigns Z Values}
 curz := 0;
 this := first_dialog;
 while (this<>nil) do
   Begin
     this^.z := curz;
     inc(curz);
     this := this^.next;
   end;
end;

Function Get_Handle_Text(id:longint):handle_text;
var
 this : handle_text;
 dlg : handle_dialog;
Begin
 Get_Handle_Text := nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_text;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_text := this;
            exit;
          end;
        this := this^.next;
      end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_BMP(id:longint):handle_bmp;
var
 this : handle_bmp;
 dlg : handle_dialog;
Begin
 Get_Handle_bmp:= nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_bmp;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_bmp := this;
            exit;
          end;
        this := this^.next;
      end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_button(id:longint):handle_button;
var
 this : handle_button;
 dlg : handle_dialog;
Begin
 Get_Handle_button := nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_button;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_button := this;
            exit;
          end;
        this := this^.next;
      end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_Data(id:longint):handle_Data;
var
 this : handle_data;
 dlg : handle_dialog;
Begin
 Get_Handle_Data:= nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_data;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_data := this;
            exit;
          end;
        this := this^.next;
      end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_listbox(id:longint):handle_listbox;
var
 this : handle_listbox;
 dlg : handle_dialog;
Begin
 Get_Handle_listbox:= nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_lb;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_listbox := this;
            exit;
          end;
        this := this^.next;
      end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_Menu_Item(id:longint):handle_menu_item;
var
 this : ml;
 this_item : handle_menu_item;
 dlg : handle_dialog;
Begin
 Get_Handle_menu_item:= nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_menu;
    while (this<>nil) do
      Begin
        this_item := this^.first_item;
        while (this_item<>nil) do
         Begin
           if this_item^.id=id then
          Begin
            get_handle_menu_item := this_item;
            exit;
          end;
        this_item := this_item^.next;
      end;
      this := this^.next;
    end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_Scrollbar(id:longint):handle_scrollbar;
var
 this : handle_scrollbar;
 dlg : handle_dialog;
Begin
 Get_Handle_scrollbar:= nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_sb;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_scrollbar := this;
            exit;
          end;
        this := this^.next;
      end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_Client(id:longint):handle_Client;
var
 this : handle_Client;
 dlg : handle_dialog;
Begin
 Get_Handle_Client:= nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_client;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_Client := this;
            exit;
          end;
        this := this^.next;
      end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_Callback(id:longint):handle_callback;
var
 this : handle_callback;
 dlg : handle_dialog;
Begin
 Get_Handle_Callback := nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_callback;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_callback := this;
            exit;
          end;
        this := this^.next;
      end;
    dlg := dlg^.next;
  end;

  this := first_callback;
  while (this<>nil) do
    Begin
      if this^.id=id then
        Begin
          get_handle_callback := this;
          exit;
        end;
        this := this^.next;
    end;
end;


Function Get_Handle_Checkbox(id:longint):handle_checkbox;
var
 this : handle_checkbox;
 dlg : handle_dialog;
Begin
 Get_Handle_checkbox:= nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    this := dlg^.first_cb;
    while (this<>nil) do
      Begin
        if this^.id=id then
          Begin
            get_handle_checkbox := this;
            exit;
          end;
        this := handle_checkbox(this^.next);
      end;
    dlg := dlg^.next;
  end;
end;

Function Get_Handle_Dialog(id:longint):handle_dialog;
var
 dlg : handle_dialog;
Begin
 Get_Handle_dialog := nil;
 dlg := first_dialog;
 while (dlg<>nil) do
  Begin
    if dlg^.id=id then
      Begin
        Get_Handle_Dialog := dlg;
        exit;
      end;
    dlg := dlg^.next;
  end;
end;

Procedure Set_Scrollbar(this:handle_scrollbar;min,max,curpos,step,jump:longint);
Begin
  if this<>nil then
     Begin
       if (min>-1) then this^.min := min;
       if (max>-1) then this^.max := max;
       if (curpos>-1) then this^.curpos := curpos;
       if (step>-1) then this^.step := step;
       if (jump>-1) then this^.jump := jump;

     end;
end;

Function  Retrievepchar(id:longint):string;
var
 hdta : handle_data;
Begin
 hdta := get_handle_data(id);
 if hdta=nil then
   Begin
     retrievepchar := '';
     exit;
   end;
 retrievepchar := hdta^.data.pstr;
end;


Function  Assign_Button_Function(id:longint;dlg:handle_dialog;funcnum:longint):boolean;
var
 hbtn : handle_button;
Begin
 assign_button_function := false;
 hbtn := get_handle_button(id);
 if hbtn=nil then exit else hbtn^.funcnum := funcnum;
 if dlg<>nil then
   Begin
     delete_all_accelerators(dlg);
     setup_accelerators(dlg);
   end;
end;

Function  Assign_Listbox_Select(id,func:longint):boolean;
var
 hlb: handle_listbox;
Begin
 assign_listbox_select := false;
 hlb := get_handle_listbox(id);
 if hlb=nil then exit else hlb^.selectfunc := func;
 assign_listbox_select := true;
end;

Procedure Enable_Button(id:longint);
var
 hbtn : handle_button;
Begin
 hbtn := get_handle_button(id);
 if (hbtn<>nil) then hbtn^.enabled := true;
end;

Procedure Disable_Button(id:longint);
var
 hbtn : handle_button;
Begin
 hbtn := get_handle_button(id);
 if (hbtn<>nil) then hbtn^.enabled := false;
end;

Function BitSet(b:byte;o:byte):boolean;
Begin
  if (b and o)=o then bitset := true else bitset := false;
end;

Procedure SetClip(dlg:handle_dialog);
Begin
  if dlg<>nil then
  with dlg^ do clipset(x1,y1,x2,y2);
end;

Procedure SetClipdlg(dlg:handle_dialog);
Begin
  if dlg<>nil then
  with dlg^ do clipset(xpos,ypos,xpos1,ypos1);
end;

Procedure SaveBox(dlg:handle_dialog);
var
 p : pbyte;
 x,y : integer;
Begin
 hm;
 dlg^.pu_mem := (dlg^.pu_ypos1-dlg^.pu_ypos+1);
 dlg^.pu_mem := dlg^.pu_mem*(dlg^.pu_xpos1-dlg^.pu_xpos+2);
 getmem(p,dlg^.pu_mem);
 dlg^.pu_present := true;
 dlg^.pu_image := p;
 vgetrect(dlg^.pu_image,dlg^.pu_xpos,dlg^.pu_ypos,dlg^.pu_xpos1-dlg^.pu_xpos+2,dlg^.pu_ypos1-dlg^.pu_ypos+1,
          dlg^.pu_xpos1-dlg^.pu_xpos+2);
 sm;
end;

Procedure RestoreBox(dlg:handle_dialog);
var
 x,y : integer;
 p : pbyte;
Begin
 hm;
 if dlg=nil then exit;
 with dlg^ do
 Begin
   vputrect(dlg^.pu_image,dlg^.pu_xpos,dlg^.pu_ypos,dlg^.pu_xpos1-dlg^.pu_xpos+2,dlg^.pu_ypos1-dlg^.pu_ypos+1,
            dlg^.pu_xpos1-dlg^.pu_xpos+2,0);
   freemem(pu_image,pu_mem);
   pu_present := false;
 end;
sm;
end;

Procedure Box3d(x1,y1,x2,y2,c1,c2,c3:integer);
Begin
  fill(x1,y1,x2,y2,c1);

  hline(x1,x2,y1,c2);
  hline(x1,x2-1,y1+1,c2);
  vrline(y1,y2,x1,c2);
  vrline(y1,y2-1,x1+1,c2);

  hline(x1+1,x2,y2-1,c3);
  hline(x1,x2,y2,c3);
  vrline(y1,y2,x2,c3);
  vrline(y1+1,y2,x2-1,c3);
end;

Function Mousein(x1,y1,x2,y2:integer):boolean;
var
 mx,my : integer;
Begin
  mx := mousex shr 1;
  my := mousey;
  if (mx>=x1) and (mx<=x2) and (my>=y1) and (my<=y2) then mousein := true else
   mousein := false;
end;

Procedure dialogerror(s:string);
Begin
  textmode($3);
  writeln('Invalid Program Termination : ');
  writeln(s);
  writeln;
  halt(1);
end;

Procedure Close_Box(dlg:handle_dialog);
Begin
  if dlg=nil then exit;
  if not(bitset(dlg^.flags,close_button)) then exit;
  with dlg^ do
  Begin
    Box3d(xpos1-17,ypos+6,xpos1-4,ypos+17,Close_Color,Border_Color1,Border_Color2);
    TC(Border_Color1,0);
    Textxystr('x',xpos1-15,ypos+7);
    TC(Border_Color3,0);
    Textxystr('x',xpos1-14,ypos+7);
  end;
end;

Procedure Minimize_Box(dlg:handle_dialog);
Begin
  if dlg=nil then exit;
  if not(bitset(dlg^.flags,minimize_button)) then exit;
  with dlg^ do
  Begin
    Box3d(xpos1-49,ypos+6,xpos1-36,ypos+17,Minimize_Color,Border_Color1,Border_Color2);
    TC(Border_Color3,0);
    if min then
    textxystr('',xpos1-46,ypos+8) else
    textxystr('_',xpos1-46,ypos+7);
  end;
end;

Procedure Maximize_Box(dlg:handle_dialog);
Begin
  if (dlg=nil) then exit;
  if not(bitset(dlg^.flags,maximize_button)) then exit;
  with dlg^ do
    Begin
      Box3d(xpos1-32,ypos+6,xpos1-20,ypos+17,Maximize_Color,Border_Color1,Border_Color2);
      tc(Border_Color3,0);
      if max then
      textxystr(#31,xpos1-30,ypos+8) else
      textxystr(#30,xpos1-30,ypos+8);
    end;
end;


Procedure Help_Box(dlg:handle_dialog);
Begin
  if dlg=nil then exit;
  setclipdlg(dlg);
  if not(bitset(dlg^.flags,help_button)) then exit;
  with dlg^ do
    Begin
      Box3d(xpos+6,ypos+6,xpos+17,ypos+17,menu_color,Border_color1,border_color2);
      TC(Border_Color3,0);
      textxystr('?',xpos+8,ypos+8);
    end;
end;

Procedure Title_Bar(dlg:handle_dialog);
Begin
  if dlg=nil then exit;
  setclipdlg(dlg);
  with dlg^ do
   Begin
     if active then
     Fill(xpos+3,ypos+3,xpos1-3,ypos+19,Active_Title_Bar_Color) else
     Fill(xpos+3,ypos+3,xpos1-3,ypos+19,Disabled_Title_Bar_Color);
     TC(Title_Color,Active_Title_Bar_Color);
     if (bitset(flags,help_button)) then Textxystr(name,xpos+25,ypos+8) else
                                        Textxystr(name,xpos+5,ypos+8);
     Help_Box(dlg);
     Minimize_Box(dlg);
     Maximize_Box(dlg);
     Close_Box(dlg);
   end;
end;

Procedure Draw_BMP(dlg:handle_dialog;bmp:handle_bmp);
var
 w,h : integer;
 x1,y1,x2,y2 : integer;
 p : pbyte;
Begin
  if bmp=nil then exit;
  if bmp^.xpos=-1 then exit;
  setclip(dlg);
  w := bmp^.width;
  h := bmp^.height;
  x1 := bmp^.xpos+dlg^.x1+xofs;
  y1 := bmp^.ypos+dlg^.y1+yofs;
  x2 := bmp^.xpos+w-1+dlg^.x1+xofs;
  y2 := bmp^.ypos+h-1+dlg^.y1+yofs;
  p := bmp^.data;
  while (y1<clipy1) do
    Begin
      inc(p,w);
      inc(y1);
      dec(h);
    end;
  while (x1<clipx1) do
    Begin
      inc(p);
      inc(x1);
      dec(w);
    end;
  while (x2>clipx2) do
    Begin
      dec(w);
      dec(x2);
    end;

  while (y2>clipy2) do
    Begin
      dec(h);
      dec(y2);
    end;
  if (w<1) or (h<1) then exit;
  vputrect(p,x1,y1,w,h,bmp^.width,bmp^.puttype);
end;

Procedure Draw_Client(dlg:handle_dialog;client:handle_client);
var
 w,h : integer;
 x1,y1,x2,y2 : integer;
 p : pbyte;
Begin
  if client=nil then exit;
  setclip(dlg);
  w := client^.width;
  h := client^.height;
  x1 := client^.xpos+dlg^.x1+xofs;
  y1 := client^.ypos+dlg^.y1+yofs;
  x2 := client^.xpos+w-1+dlg^.x1+xofs;
  y2 := client^.ypos+h-1+dlg^.y1+yofs;
  p := client^.data;
  while (y1<clipy1) do
    Begin
      inc(p,w);
      inc(y1);
      dec(h);
    end;
  while (x1<clipx1) do
    Begin
      inc(p);
      inc(x1);
      dec(w);
    end;
  while (x2>clipx2) do
    Begin
      dec(w);
      dec(x2);
    end;

  while (y2>clipy2) do
    Begin
      dec(h);
      dec(y2);
    end;
  if (w<1) or (h<1) then exit;
  if (mousein(x1,y1,x1+w,y1+h)) then hm;
  vputrect(p,x1,y1,w,h,client^.width,0);
 sm;
end;

Procedure Draw_BMP_Btn(dlg:handle_dialog;bmp:handle_bmp;xpos,ypos:integer);
var
 w,h : integer;
 x1,y1,x2,y2 : integer;
 p : pbyte;
Begin
  if bmp=nil then exit;
  setclip(dlg);
  w := bmp^.width;
  h := bmp^.height;
  x1 := xpos;
  y1 := ypos;
  x2 := x1+w;
  y2 := y1+h;
  p := bmp^.data;
  while (y1<clipy1) do
    Begin
      inc(p,w);
      inc(y1);
      dec(h);
    end;
  while (x1<clipx1) do
    Begin
      inc(p);
      inc(x1);
      dec(w);
    end;
  while (x2>clipx2) do
    Begin
      dec(w);
      dec(x2);
    end;

  while (y2>clipy2) do
    Begin
      dec(h);
      dec(y2);
    end;
  if (w<1) or (h<1) then exit;
  if (x1>clipx2) or (x2<x1) or (y1>clipy2) or (y2<y1) then exit;

  vputrect(p,x1,y1,w,h,bmp^.width,bmp^.puttype);
end;

Procedure Draw_Text(dlg:handle_dialog;ht:handle_text);
var
 this : handle_text;
Begin
 if ht=nil then exit;
 if dlg=nil then exit;
 setclip(dlg);
 tc(client_text_color,client_background_color);
 textxystr(ht^.textdata,dlg^.x1+ht^.xpos+xofs,dlg^.y1+ht^.ypos+yofs);
end;

Procedure Draw_Checkbox(dlg:handle_dialog;checkbox:handle_checkbox);
var
 x1,y1,x2,y2 : integer;
 s : string;
 upos : byte;
Begin
    setclip(dlg);
    x1 := dlg^.x1+checkbox^.xpos+xofs;
    y1 := dlg^.y1+checkbox^.ypos+yofs;
    x2 := x1 + 12;
    y2 := y1 + 12;
    if (checkbox^.enabled) then
     Begin
       tc(client_text_color,checkbox_background);
       s := set_underline(checkbox^.data.pstr,upos);
       textxystr(s,dlg^.x1+checkbox^.xpos+14+xofs,dlg^.y1+checkbox^.ypos+3+yofs);
       if (upos>0) then
         Hline(dlg^.x1+checkbox^.xpos+14+xofs+((upos-1)shl 3),
               dlg^.x1+checkbox^.xpos+14+xofs+(upos shl 3)-1,
               dlg^.y1+checkbox^.ypos+yofs+11,client_text_color);
       if checkbox^.selected then
          box3d(x1,y1,x2,y2,Checkbox_Background,Checkbox_Border2,Checkbox_Background) else
          box3d(x1,y1,x2,y2,Checkbox_Background,Checkbox_Border1,Checkbox_Border2);
     end else
     Begin
       box3d(x1,y1,x2,y2,Checkbox_Disabled,CheckBox_Background,Black);
       tc(client_text_color,checkbox_background);
       s := set_underline(checkbox^.data.pstr,upos);
       textxystr(s,dlg^.x1+checkbox^.xpos+14+xofs,dlg^.y1+checkbox^.ypos+3+yofs);
       if (upos>0) then
         Hline(dlg^.x1+checkbox^.xpos+14+xofs+((upos-1)shl 3),
               dlg^.x1+checkbox^.xpos+14+xofs+(upos shl 3)-1,
               dlg^.y1+checkbox^.ypos+yofs+11,client_text_color);
     end;
end;

Procedure Draw_Checkboxes(dlg:handle_dialog);
var
 this : handle_checkbox;
Begin
 this := dlg^.first_cb;
 while this<>nil do
   Begin
     draw_checkbox(dlg,this);
     this := this^.next;
   end;
end;

Procedure Draw_Menu(dlg:handle_dialog);
var
 this : ml;
 xpos : word;
 adjust : byte;
 upos : byte;
 s : string[30];
Begin
 if dlg=nil then exit;
 setclipdlg(dlg);
 if dlg^.first_menu<>nil then
  with dlg^ do
    Begin
      if length(name)>0 then
      Begin
        Box3d(xpos+3,ypos+20,xpos1-3,ypos+36,Menu_Background,Menu_Border1,Menu_Border2);
        adjust := 25;
      end else
      Begin
        Box3d(xpos+3,ypos+2,xpos1-3,ypos+18,Menu_Background,Menu_Border1,Menu_Border2);
        adjust := 7;
      end;
    end;
 xpos := dlg^.xpos+4;
 this := dlg^.first_menu;
 while (this<>nil) do
  Begin
    if this^.first_item=nil then
    tc(disabled_menu,menu_background) else
    tc(menu_text,client_background_color);
    s := set_underline(this^.name,upos);
    textxystr(s,xpos+2,dlg^.ypos+adjust);
    if (upos>0) then
        Hline(xpos+2+((upos-1)shl 3),xpos+2+(upos shl 3)-1,dlg^.ypos+adjust+8,menu_text);
    inc(xpos,(length(s)+2)shl 3+10);
    this := this^.next;
  end;
end;

Procedure Draw_Popup_Text(dlg:handle_dialog;m:ml);
var
 xpos,ypos,xpos1,ypos1 : integer;
 this : handle_menu_item;
 adjust : byte;
 s : string[30];
 upos : byte;
Begin
 setclip(dlg);
 if length(dlg^.name)=0 then adjust := 7 else adjust := 25;
 hm;
 xpos := dlg^.xpos+m^.xpos1;
 xpos1 := m^.width+xpos+6;
 ypos := dlg^.ypos+adjust+11;
 ypos1 := ypos+(m^.height*12)+5;
 dlg^.pu_xpos := xpos;
 dlg^.pu_ypos := ypos;
 dlg^.pu_xpos1 := xpos1;
 dlg^.pu_ypos1 := ypos1-1;
 if m^.first_item<>nil then
 Begin
   this := m^.first_item;
   xpos := xpos+3;
   ypos := ypos+4;
   while this<>nil do
   Begin
     hm;
     if (this^.funcnum=0) then
     tc(disabled_popup,0) else
     tc(popup_text,0);
     if (this^.highlight) and (this^.funcnum>0) then
     box3d(xpos-1,ypos-2,xpos1-2,ypos+10,popup_background,popup_border1,popup_border2) else
     fill(xpos-1,ypos-2,xpos1-2,ypos+10,popup_background);
     s := set_underline(this^.name,upos);
     textxystr(s,xpos+1,ypos+1);
     if (upos>0) then
       Hline(xpos+1+((upos-1) shl 3),xpos+(upos shl 3),ypos+9,popup_text);
     inc(ypos,12);
     this := this^.next;
   end;
  end;
sm;
end;


Procedure Draw_Popup(dlg:handle_dialog;m:ml);
var
 xpos,ypos,xpos1,ypos1 : integer;
 this : handle_menu_item;
 adjust : byte;
 s : string[30];
 upos : byte;
Begin
 if dlg=nil then exit;
 setclip(dlg);
 if length(dlg^.name)=0 then adjust := 7 else adjust := 25;
 hm;
 xpos := dlg^.xpos+m^.xpos1;
 xpos1 := m^.width+xpos+6;
 ypos := dlg^.ypos+adjust+11;
 ypos1 := ypos+(m^.height*12)+4;
 if (dlg^.pu_present) then with dlg^ do restorebox(dlg);
 dlg^.pu_xpos := xpos;
 dlg^.pu_ypos := ypos;
 dlg^.pu_xpos1 := xpos1;
 dlg^.pu_ypos1 := ypos1;
 if m^.first_item<>nil then
 Begin
   savebox(dlg);
   hm;
   box3d(xpos,ypos,xpos1,ypos1,popup_background,popup_border1,popup_border2);
   this := m^.first_item;
   xpos := xpos+3;
   ypos := ypos+4;
   while this<>nil do
   Begin
     if this^.funcnum>0 then
     tc(popup_text,0) else tc(disabled_popup,0);
     if (this^.highlight) and (this^.funcnum>0) then
     box3d(xpos-1,ypos-2,xpos1-2,ypos+10,popup_background,popup_border1,popup_border2) else
     fill(xpos-1,ypos-2,xpos1-2,ypos+10,popup_background);
     s := set_underline(this^.name,upos);
     textxystr(s,xpos+1,ypos+1);
     if (upos>0) then
       Hline(xpos+1+((upos-1) shl 3),xpos+(upos shl 3),ypos+9,popup_text);
     inc(ypos,12);
     this := this^.next;
   end;
  end;
sm;
end;

Procedure Draw_Highlight_menu(dlg:handle_dialog;pu_erase:boolean);
var
 this : ml;
 xpos,xp2 : integer;
 any : boolean;
 m : handle_menu_item;
 adjust : byte;
 s : string[30];
 upos : byte;
Begin
 setclipdlg(dlg);
 any := false;
 hm;
 xpos := dlg^.xpos+4;
 this := dlg^.first_menu;
 setclipdlg(dlg);
 if length(dlg^.name)=0 then adjust := 7 else adjust := 25;
 while (this<>nil) do
  Begin
    if (this^.highlight) and (this^.first_item<>nil) then
     Begin
       s := set_underline(this^.name,upos);
       xp2 := length(s);
       xp2 := xp2 shl 3;
       inc(xp2,6);
       inc(xp2,xpos);
       tc(menu_text,menu_background);
       box3d(xpos,dlg^.ypos+adjust-2{23},xp2-1,dlg^.ypos+adjust+9{34},menu_background,menu_border1,menu_border2);
       textxystr(s,xpos+2,dlg^.ypos+adjust);
       if (upos>0) then
         Hline(xpos+2+((upos-1) shl 3),xpos+2+(upos shl 3)-1,dlg^.ypos+adjust+8,menu_text);
       draw_popup(dlg,this);
       any := true;
     end else
     Begin
       s := set_underline(this^.name,upos);
       xp2 := length(s);
       xp2 := xp2 shl 3;
       inc(xp2,6);
       inc(xp2,xpos);
       if xp2>=dlg^.xpos1-4 then xp2 := dlg^.xpos1-4;
       fill(xpos,dlg^.ypos+adjust-2{23},xp2,dlg^.ypos+adjust+9{34},menu_background);
       if this^.first_item<>nil then
       tc(menu_text,menu_background) else
       tc(disabled_menu,menu_background);
       textxystr(s,xpos+2,dlg^.ypos+{25}adjust);
       if (upos>0) then
        Hline(xpos+2+((upos-1) shl 3),xpos+2+(upos shl 3)-1,dlg^.ypos+adjust+8,menu_text);
     end;
    inc(xpos,(length(s)+2)shl 3+10);
    this := this^.next;
  end;
 if not(any) and (dlg^.pu_present) then restorebox(dlg);
 sm;
end;

Procedure Draw_Button(dlg:handle_dialog;blp:handle_button);
var
 this : handle_button;
 x1,y1,x2,y2:integer;
 w,h : integer;
 s : string[30];
 sl : byte;
 upos : byte;
Begin
 setclip(dlg);
 hm;
 this := blp;
 if (this^.hbmp<>nil) then
   Begin
    w := this^.hbmp^.width+5;
    h := this^.hbmp^.height-12;
    if (h<0) then h := 0;
   end else
   Begin
    w := 0;
    h := 0;
   end;
    s := set_underline(this^.btext.pstr,upos);
    case this^.btype of
      0 : Begin
            x1 := this^.xpos+dlg^.x1+xofs;
            y1 := this^.ypos+dlg^.y1+yofs;
            if (length(s)=0) then
            x2 := this^.xpos+dlg^.x1+xofs+w else
            x2 := this^.xpos+dlg^.x1+(length(s) shl 3)+6+xofs+w;

            y2 := this^.ypos+dlg^.y1+18+yofs+h;
            Case (This^.state) of
              0 : Begin
                    Fill(x1,y1,x2,y2,button_background);
                    Hline(x1,x2,y1,button_border1);
                    Hline(x1,x2-1,y1+1,button_border1);
                    Hline(x1,x2-2,y1+2,button_border1);
                    vrline(y1,y2,x1,button_border1);
                    vrline(y1,y2-1,x1+1,button_border1);
                    vrline(y1,y2-2,x1+2,button_border1);

                    Hline(x1,x2,y2,button_border2);
                    Hline(x1+1,x2,y2-1,button_border2);
                    Hline(x1+2,x2-2,y2-2,button_border2);

                    vrline(y1,y2,x2,button_border2);
                    vrline(y1+1,y2,x2-1,button_border2);
                    vrline(y1+2,y2,x2-2,button_border2);

                    if this^.enabled then
                    tc(button_text,button_background) else
                    tc(disabled_button,button_background);
                    textxystr(s,x1+3+w,y1+6+(h shr 1));
                    if (upos>0) then
                       Hline(x1+3+w+((upos-1) shl 3),x1+3+w+(upos shl 3)-1,y1+6+8+(h shr 1),button_text);
                    if this^.hbmp<>nil then
                    draw_bmp_btn(dlg,this^.hbmp,x1+2,y1+2);
                  end;
              1 : Begin
                    Fill(x1,y1,x2,y2,button_background);
                    Hline(x1,x2,y1,button_border2);
                    Hline(x1,x2-1,y1+1,button_border2);
                    Hline(x1,x2-2,y1+2,button_border2);
                    vrline(y1,y2,x1,button_border2);
                    vrline(y1,y2-1,x1+1,button_border2);
                    vrline(y1,y2-2,x1+2,button_border2);
                    if this^.enabled then
                    tc(button_text,button_background) else
                    tc(disabled_button,button_background);
                    textxystr(s,x1+5+w,y1+8+(h shr 1));
                    if (upos>0) then
                       Hline(x1+5+w+((upos-1) shl 3),x1+5+w+(upos shl 3)-1,y1+8+8+(h shr 1),button_text);
                    if this^.hbmp<>nil then
                    draw_bmp_btn(dlg,this^.hbmp,x1+4,y1+4);
                  end;
              end;
          end;
      2 : Begin
          end;
    end;
 sm;
end;

Procedure Assign_PixPos(dlg:handle_dialog;sbp:handle_scrollbar);
var
 this :handle_scrollbar;
 per : real;
 x1,y1,x2,y2 : integer;
Begin
  this := sbp;
  if dlg=nil then exit;
  if this=nil then exit;
  with this^ do
    Begin
      if (max=min) then per := 0 else
      per := (curpos-min)/(max-min);
      x1 := xpos;
      y1 := ypos;
      x2 := xpos1;
      y2 := ypos1;
      case horv of
       HORZ : curpixpos := (x1+14)+trunc(((xpos1-19)-(xpos+19))*per)+dlg^.x1;
       VERT : curpixpos := (y1+14)+trunc(((ypos1-19)-(ypos+19))*per)+dlg^.y1;
      end;
    end;
end;

Procedure Draw_Scrollbar(dlg:handle_dialog;sbp:handle_scrollbar);
var
 this : handle_scrollbar;
 x1,y1,x2,y2:integer;
 bx1,bx2,by1,by2 : integer;
 per : real;
Begin
 setclip(dlg);
 hm;
 this := sbp;

 if (dlg^.horz_sb=this) or (dlg^.vert_sb=this) then exit;

 with this^ do
  Begin
    if (max=min) then per := 0 else
    per := (curpos-min)/(max-min);

    x1 := xpos+dlg^.x1+xofs;
    y1 := ypos+dlg^.y1+yofs;
    x2 := xpos1+dlg^.x1+xofs;
    y2 := ypos1+dlg^.y1+yofs;

    tc(scrollbar_text_color,0);
    if horv=VERT then
     Begin
       Fill(x1+1,y1+14,x2-1,y2-14,scrollbar_background);
       Box(x1,y1,x2,y2,0);
       Box3d(x1+1,y1+1,x2-1,y1+13,scrollbar_background,scrollbar_border1,scrollbar_border2);
       Box3d(x1+1,y2-13,x2-1,y2-1,scrollbar_background,scrollbar_Border1,scrollbar_Border2);
       bx1 := x1+1;
       bx2 := x2-1;
       by1 := (y1+14)+trunc(((ypos1-19)-(ypos+19))*per);
       by2 := by1+10;
       Box3d(bx1,by1,bx2,by2,scrollbar_background,scrollbar_Border1,scrollbar_Border2);
       textxystr(#30,x1+3,y1+3);
       textxystr(#31,x1+3,y2-10);
       textxystr(#205,bx1+3,by1+2);
       tc(Scrollbar_border1,0);
       textxystr(#205,bx1+2,by1+1);
     end else
     if horv=HORZ then
     Begin
       Fill(x1+14,y1+1,x2-14,y2-1,scrollbar_background);
       Box(x1,y1,x2,y2,0);
       Box3d(x1+1,y1+1,x1+13,y2-1,scrollbar_background,scrollbar_Border1,scrollbar_border2);
       Box3d(x2-13,y1+1,x2-1,y2-1,scrollbar_background,scrollbar_border1,scrollbar_border2);
       bx1 := (x1+14)+trunc(((xpos1-19)-(xpos+19))*per);
       bx2 := bx1+10;
       by1 := y1+1;
       by2 := y2-1;
       Box3d(bx1,by1,bx2,by2,scrollbar_background,scrollbar_border1,scrollbar_border2);
       textxystr(#17,x1+3,y1+4);
       textxystr(#16,x2-11,y1+4);
       textxystr(#186,bx1+1,by1+2);
       tc(Scrollbar_border1,0);
       textxystr(#186,bx1,by1+2);
     end;
  end;
 sm;
end;

Procedure Draw_Dialog_Scrollbar(dlg:handle_dialog);
var
 this : handle_scrollbar;
 x1,y1,x2,y2:integer;
 bx1,bx2,by1,by2 : integer;
 per : real;
Begin
 clipset(dlg^.xpos,dlg^.ypos,dlg^.xpos1,dlg^.ypos1);
 hm;
 this := dlg^.horz_sb;
 if this<>nil then
 with this^ do
  Begin
    if (max=min) then per := 0 else
    per := (curpos-min)/(max-min);
    x1 := xpos+dlg^.x1;
    y1 := ypos+dlg^.y1;
    x2 := xpos1+dlg^.x1;
    y2 := ypos1+dlg^.y1;
    tc(scrollbar_text_color,0);
       Fill(x1+14,y1+1,x2-14,y2-1,scrollbar_background);
       Box(x1,y1,x2,y2,0);
       Box3d(x1+1,y1+1,x1+13,y2-1,scrollbar_background,scrollbar_Border1,scrollbar_border2);
       Box3d(x2-13,y1+1,x2-1,y2-1,scrollbar_background,scrollbar_border1,scrollbar_border2);
       bx1 := (x1+13)+trunc(((x2-13)-(x1+13))*per)-5;
       bx2 := bx1+10;
       by1 := y1+1;
       by2 := y2-1;
       while bx2>(x2-14) do
         Begin
           dec(bx2); dec(bx1);
         end;
       while bx1<(x1+14) do
         Begin
           inc(bx2); inc(bx1);
         end;
       Box3d(bx1,by1,bx2,by2,scrollbar_background,scrollbar_border1,scrollbar_border2);
       textxystr(#17,x1+3,y1+4);
       textxystr(#16,x2-11,y1+4);
  end;
 this := dlg^.vert_sb;
 if this<>nil then
 with this^ do
  Begin
    if (max=min) then per := 0 else
    per := (curpos-min)/(max-min);
    x1 := xpos+dlg^.x1;
    y1 := ypos+dlg^.y1;
    x2 := xpos1+dlg^.x1;
    y2 := ypos1+dlg^.y1;
    tc(Title_Color,0);
       Fill(x1+1,y1+14,x2-1,y2-14,scrollbar_background);
       Box(x1,y1,x2,y2,0);
       Box3d(x1+1,y1+1,x2-1,y1+13,scrollbar_background,scrollbar_border1,scrollbar_border2);
       Box3d(x1+1,y2-13,x2-1,y2-1,scrollbar_background,scrollbar_border1,scrollbar_border2);
       bx1 := x1+1;
       bx2 := x2-1;
       by1 := (y1+11)+trunc(((y2-11)-(y1+11))*per)-5;
       by2 := by1+10;
       while by2>(y2-14) do
         Begin
           dec(by2); dec(by1);
         end;
       while by1<(y1+14) do
         Begin
           inc(by2); inc(by1);
         end;
       Box3d(bx1,by1,bx2,by2,scrollbar_background,scrollbar_border1,scrollbar_border2);
       textxystr(#30,x1+3,y1+3);
       textxystr(#31,x1+3,y2-9);
  end;
 sm;
end;

Procedure Draw_Scrollbars(dlg:handle_dialog);
var
 this : handle_scrollbar;
Begin
 this := dlg^.first_sb;
 while this<>nil do
   Begin
     draw_scrollbar(dlg,this);
     this := this^.next;
   end;
end;

Procedure Draw_Data(dlg:handle_dialog;blp:handle_data);
var
 this : handle_data;
 x1,y1,x2,y2:word;
 l1 : string;
 ts : string;
 sl,fw : word;

Procedure DrawDescription;
Begin
  TC(client_text_color,0);
  textxystr(this^.name,this^.xpos+dlg^.x1+xofs,this^.ypos+dlg^.y1+yofs+2);
end;

Procedure Drawtext(c:byte;ch:char);
var
 s : string;
Begin
  s[0] := #255;
  fillchar(s,sizeof(s),ch);

  tc(c,0);
  fw := this^.fieldwidth;
  sl := this^.data.length;
  l1 := this^.data.pstr;
  while (sl>fw) do
    Begin
      ts := l1;
      delete(ts,fw+1,255);
      delete(l1,1,fw);
      if ch>#0 then
       Begin
         s[0] := chr(fw);
         textxystr(s,x1+4,y1+1);
       end else textxystr(ts,x1+4,y1+1);
      inc(y1,9);
      dec(sl,fw);
    end;
      if (sl>0) then
       Begin
         if ch>#0 then
         Begin
           s[0] := chr(sl);
           textxystr(s,x1+4,y1+1);
         end else textxystr(l1,x1+4,y1+1);
       end;
end;

Begin
 setclip(dlg);
 hm;
 this := blp;
    case this^.fieldtype of
      Account_Field..String_Field:
          Begin
            x1 := this^.x1+dlg^.x1+xofs;
            y1 := this^.y1+dlg^.y1+1+yofs;
            x2 := this^.x2+dlg^.x1+xofs;
            y2 := this^.y2+dlg^.y1+yofs;
            DrawDescription;
            Box3d(x1,y1-1,x2,y2+1,data_background,data_border1,data_border2);
            DrawText(data_text,#0);
          end;
      DB_TEXT :
          Begin
            x1 := this^.x1+dlg^.x1+xofs;
            y1 := this^.y1+dlg^.y1+1+yofs;
            x2 := this^.x2+dlg^.x1+xofs;
            y2 := this^.y2+dlg^.y1+yofs;
            DrawDescription;
            Fill(x1,y1-1,x2,y2+1,Client_Background_Color);
            Box(x1,y1-1,x2,y2+1,data_background);
            DrawText(client_text_color,#0);
          end;
      DB_EDIT :
          case (this^.db_ftype) of
                Account_Field..String_Field:
                    Begin
                      x1 := this^.x1+dlg^.x1+xofs;
                      y1 := this^.y1+dlg^.y1+1+yofs;
                      x2 := this^.x2+dlg^.x1+xofs;
                      y2 := this^.y2+dlg^.y1+yofs;
                      DrawDescription;
                      Box3d(x1,y1-1,x2,y2+1,data_background,data_border1,data_border2);
                      if this^.db_ftype=PASSWORD_FIELD then
                      DrawText(data_text,'*') else
                      DrawText(data_text,#0);
                    end;
                else Message_box(this^.fieldname,itos(this^.db_ftype),OK,standard_close_dialog,0);
          end;
    end;
 sm;
end;

Procedure Draw_ListBox_Item(blp:handle_listbox;lbi:lt;xpos,ypos,xofs,maxx,maxy:word;drawbox,db2:boolean);
var
 nc : word;
 x : integer;
 s : string;
 doit : boolean;
Begin
  inc(xpos);
  doit := not drawbox;
  if lbi=nil then exit;
  if lbi^.data.pchr=nil then exit;
  if (drawbox) or (db2) then
    Begin
      if (lbi^.selected) then
      Begin
        Box3d(xpos-2,ypos-2,maxx+1,ypos+9,listbox_background,listbox_border1,listbox_border2);
        doit := true;
      end else
      if (lbi^.last) or (db2) then
        Begin
          fill(xpos-2,ypos-2,maxx+1,ypos+9,listbox_background);
          lbi^.last := false;
          doit := true;
        end;
    end;
  s := lbi^.data.pstr;
  dec(xofs,1);
  if (xofs>0) then
    Begin
      if (xofs>length(s)) then
           s := '' else delete(s,1,xofs);
       end;
  nc := length(s) shl 3+xpos;
  x := 0;
  while nc>maxx do
    Begin
      inc(x);
      dec(nc,8);
    end;
  if (ypos+7)>maxy then exit;
  if length(s)<x then exit;
  if (x>0) then delete(s,length(s)-x+1,x);
  tc(listbox_text,listbox_background);
  if (length(s)>0) and (doit) then textxystr(s,xpos,ypos);
end;

Procedure Draw_ListBox(dlg:handle_dialog;blp:handle_listbox;drawbox:boolean);
var
 this : handle_listbox;
 curx,cury : word;
 numlines : integer;
 firsty,lasty : integer;
 maxx,maxy : word;
 yp1 : integer;
 x,y : integer;
 lbi : lt;
 rda : boolean;
Begin
 {setclip(dlg);}
 this := blp;
 hm;
  with this^ do
     Begin
       clipset(dlg^.x1+xpos,dlg^.y1+ypos-20,dlg^.x1+xpos1,dlg^.y1+ypos1);
       numlines := ((ypos1-ypos)-8) div 12+1;
       if numlines=0 then exit;
       firsty := (ypos+dlg^.y1+5)+yofs;
       lasty :=  (ypos1+dlg^.y1-2)+yofs-2;
       if lasty>dlg^.y2-3 then lasty := dlg^.y2-3;
       if lasty<firsty then exit;
       rda := false;
       if (horz_sb<>nil) then
          Begin
            curx := horz_sb^.curpos;
            rda := horz_sb^.changed;
            horz_sb^.changed := false;
          end else
           curx := 1;
       if (vert_sb<>nil) then
         Begin
           cury := vert_sb^.curpos;
           if not(rda) then rda := vert_sb^.changed;
           vert_sb^.changed := false;
         end else cury := 1;
       x := 1;
       lbi := first_item;
       maxx := (xpos1+xofs)+dlg^.x1-3;
       if maxx>dlg^.x2-3 then maxx := dlg^.x2-3;
       if (drawbox) then
         Begin
           if system.length(this^.title)>0 then
            Begin
              box3d(xpos+dlg^.x1+1+xofs,ypos+dlg^.y1-12+yofs,xpos1+dlg^.x1+xofs,ypos+dlg^.y1+yofs,
                    listbox_background,listbox_border1,listbox_border2);
              tc(listbox_title,listbox_background);
              textxystr(this^.title,xpos+dlg^.x1+5+xofs,ypos+dlg^.y1-9+yofs);
            end;
              box3d(xpos+dlg^.x1+1+xofs,ypos+dlg^.y1+1+yofs,xpos1+dlg^.x1+xofs,ypos1+dlg^.y1+yofs,
                    listbox_background,listbox_border1,listbox_border2);
         end;
       clipset(dlg^.x1+xpos,dlg^.y1+ypos,dlg^.x1+xpos1-2,dlg^.y1+ypos1-2);
       while (lbi<>nil) do
         Begin
           if (x=cury) then
             Begin
               for y := 1 to numlines do
                 Begin
                   draw_listbox_item(blp,lbi,dlg^.x1+xpos+5+xofs,firsty,curx,maxx,lasty,not drawbox,rda);
                   if lbi<>nil then lbi := lbi^.next;
                   inc(firsty,12);
                   if lbi=nil then
                     Begin
                       fill(dlg^.x1+xpos+3+xofs,firsty,xpos1+dlg^.x1-3+xofs,lasty,listbox_background);
                       sm;
                       exit;
                     end;
                 end;
               sm;
               exit;
             end;
           inc(x);
           lbi := lbi^.next;
         end;
     end;
 sm;
end;

Procedure Draw_Buttons(dlg:handle_dialog);
var
 this : handle_button;
Begin
 this := dlg^.first_button;
 while (this<>nil) do
  Begin
    draw_button(dlg,this);
    this := this^.next;
  end;
end;



Procedure Draw_All_Data(dlg:handle_dialog);
var
 this : handle_data;
Begin
 this := dlg^.first_data;
 while (this<>nil) do
  Begin
    draw_data(dlg,this);
    this := this^.next;
  end;
end;

Procedure Draw_All_Clients(dlg:handle_dialog);
var
 this : handle_client;
Begin
 this := dlg^.first_client;
 while (this<>nil) do
  Begin
    draw_client(dlg,this);
    this := this^.next;
  end;
end;

Procedure Draw_All_BMPS(dlg:handle_dialog);
var
 this : handle_bmp;
Begin
 this := dlg^.first_bmp;
 while (this<>nil) do
  Begin
    draw_bmp(dlg,this);
    this := this^.next;
  end;
end;

Procedure Draw_All_Text(dlg:handle_dialog);
var
 this : handle_text;
Begin
 this := dlg^.first_text;
 while (this<>nil) do
  Begin
    draw_text(dlg,this);
    this := this^.next;
  end;
end;

Procedure Draw_Listboxes(dlg:handle_dialog);
var
 this : handle_listbox;
Begin
 this := dlg^.first_lb;
 while (this<>nil) do
  Begin
    draw_listbox(dlg,this,true);
    this := this^.next;
  end;
end;

Procedure Draw_Dialog(dlg:handle_dialog);
Begin
  hm;
  if (dlg=nil) then exit;

  with dlg^ do
    Begin
      setclipdlg(dlg);
      Set_Client_Offset(dlg);
      Fill(x1,y1,x2,y2,client_background_color); {Client Area}

      if length(name)>0 then Title_Bar(dlg);

      Hline(xpos,xpos1,ypos,0{Border_Color1});
      Hline(xpos,xpos1-1,ypos+1,Border_Color1);
      Hline(xpos,xpos1-2,ypos+2,Border_Color1);

      Hline(xpos,xpos1,ypos1,0{Border_Color2});
      Hline(xpos+1,xpos1-1,ypos1-1,Border_Color2);
      Hline(xpos+1,xpos1-2,ypos1-2,Border_Color2);

      vrline(ypos,ypos1,xpos,0{Border_Color1});
      vrline(ypos+1,ypos1-1,xpos+1,Border_Color1);
      vrline(ypos+2,ypos1-2,xpos+2,Border_Color1);

      vrline(ypos,ypos1,xpos1,0{Border_Color2});
      vrline(ypos+1,ypos1-1,xpos1-1,Border_Color2);
      vrline(ypos+2,ypos1-2,xpos1-2,Border_Color2);

      if length(name)>0 then
       Begin
         Hline(xpos+3,xpos1-3,ypos+20,Border_Color2);
         Hline(xpos+3,xpos1-3,ypos+21,Border_Color2);
         Hline(xpos+3,xpos1-3,ypos+22,0{Border_Color2});
       end;
      Draw_Dialog_Scrollbar(dlg);
      hm;
      Draw_Menu(dlg);
      Draw_All_Text(dlg);
      Draw_All_Data(dlg);
      Draw_Buttons(dlg);
      Draw_Scrollbars(dlg);
      hm;
      Draw_ListBoxes(dlg);
      hm;
      Draw_Checkboxes(dlg);
      hm;
      Draw_All_BMPS(dlg);
      Draw_All_Clients(dlg);
    end;
sm;
end;

Procedure Draw_Client_Screen(dlg:handle_dialog);
Begin
  hm;
  if (dlg=nil) then exit;
  with dlg^ do
    Begin
      setclipdlg(dlg);
      Set_Client_Offset(dlg);
      Fill(x1,y1,x2,y2,client_background_color); {Client Area}
      hm;
      Draw_All_Text(dlg);
      Draw_All_Data(dlg);
      Draw_Buttons(dlg);
      Draw_Scrollbars(dlg);
      hm;
      Draw_ListBoxes(dlg);
      hm;
      Draw_Checkboxes(dlg);
      Draw_All_Bmps(dlg);
      Draw_Dialog_Scrollbar(dlg);
      Draw_All_Clients(dlg);
    end;
sm;
end;

Procedure Redraw_All(refresh_cur:boolean);
var
 this : handle_dialog;
Begin
 if cur_dialog<>nil then cur_dialog^.z := 255;
 reorder_windows;
 hm;
 clipset(0,0,maxx,maxy);
 this := first_dialog;
 while (this<>nil) do
   Begin
     if this<>cur_dialog then draw_dialog(this);
     this := this^.next;
   end;

 if (cur_dialog<>nil) then
 Begin
   if refresh_cur then
    Begin
      usewindowclip := false;
      setclipdlg(cur_dialog);
      draw_dialog(cur_dialog);
      if length(cur_dialog^.name)>0 then title_bar(cur_dialog);
    end else
    Begin
      setclipdlg(cur_dialog);
      draw_dialog(cur_dialog);
      usewindowclip := false;
      if length(cur_dialog^.name)>0 then title_bar(cur_dialog);
    end;
  end;
sm;
end;

Procedure Add_Text(id:longint;dlg:handle_dialog;xpos,ypos:integer;s:string;funcnum:longint);
var
 this : handle_text;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Text');

 this^.id := id;
 this^.xpos := xpos;
 this^.ypos := ypos;
 this^.color := client_text_color;
 this^.textdata := s;
 this^.funcnum := funcnum;
 this^.tfuncnum := funcnum;
 this^.next := nil;
 this^.prev := dlg^.last_text;
 if dlg^.first_text=nil then dlg^.first_text := this;
 if dlg^.last_text<>nil then dlg^.last_text^.next := this;
 dlg^.last_text := this;
 dlg^.cur_text := this;
end;

Procedure Delete_Text(dlg:handle_dialog;tlp:handle_text);
Begin
  if tlp=nil then exit;
  if tlp=dlg^.first_text then
      dlg^.first_text := tlp^.next;
  if tlp=dlg^.last_text then dlg^.last_text := tlp^.prev;
  if tlp=dlg^.cur_text then dlg^.cur_text := nil;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  dispose(tlp);
end;

Procedure Add_Accelerator(id:longint;dlg:handle_dialog;
                          functionkey : byte;
                          character   : byte;
                          funcnum     : longint);
var
 this : handle_accelerator;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Accelerator');

 this^.id := id;
 this^.functionkey := functionkey;
 this^.character := character;
 this^.funcnum := funcnum;
 this^.tfuncnum := funcnum;
 this^.next := nil;
 this^.prev := dlg^.last_accelerator;
 if dlg^.first_accelerator=nil then dlg^.first_accelerator := this;
 if dlg^.last_accelerator<>nil then dlg^.last_accelerator^.next := this;
 dlg^.last_accelerator := this;
 dlg^.cur_accelerator := this;
end;

Procedure Setup_Accelerators(dlg:handle_dialog);
var
 this_button : handle_button;
 this_checkbox : handle_checkbox;
 s : string;
Begin
 if dlg=nil then exit;
 this_button := dlg^.first_button;
 while this_button<>nil do
   Begin
     s := this_button^.btext.pstr;
     if pos('&',s)>0 then
       Add_Accelerator(unique_id,dlg,Alt,ConvertCHAR(s[pos('&',s)+1]),this_button^.funcnum);
     this_button := this_button^.next;
   end;

 this_checkbox:= dlg^.first_cb;
 while this_checkbox<>nil do
   Begin
     this_checkbox:= this_checkbox^.next;
   end;

end;


Procedure Delete_Accelerator(dlg:handle_dialog;tlp:handle_accelerator);
Begin
  if tlp=nil then exit;
  if tlp=dlg^.first_accelerator then
      dlg^.first_accelerator := tlp^.next;
  if tlp=dlg^.last_accelerator then dlg^.last_accelerator := tlp^.prev;
  if tlp=dlg^.cur_accelerator then dlg^.cur_accelerator := nil;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  dispose(tlp);
end;

Procedure Add_Client(id:longint;dlg:handle_dialog;xpos,ypos,width,height:integer;speed:longint);
var
 this : handle_client;
Begin
 if longint(width*height)>memavail then exit;
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Client');

 this^.id := id;
 this^.xpos := xpos;
 this^.ypos := ypos;
 this^.xpos1 := xpos+width-1;
 this^.ypos1 := ypos+height-1;
 this^.width := width;
 this^.height := height;
 this^.speed := speed;
 this^.nexttime := timercounter+speed;
 getmem(this^.data,this^.width*this^.height);
 fillchar(this^.data^,this^.width*this^.height,0);
 this^.next := nil;
 this^.prev := dlg^.last_client;
 if dlg^.first_client=nil then dlg^.first_client := this;
 if dlg^.last_client<>nil then dlg^.last_client^.next := this;
 dlg^.last_client := this;
 dlg^.cur_client := this;
end;

Procedure Delete_Client(dlg:handle_dialog;tlp:handle_client);
Begin
  if tlp=nil then exit;
  if tlp=dlg^.first_client then dlg^.first_client := tlp^.next;
  if tlp=dlg^.last_client then dlg^.last_client := tlp^.prev;
  if tlp=dlg^.cur_client then dlg^.cur_client := nil;
  freemem(tlp^.data,tlp^.width*tlp^.height);
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  dispose(tlp);
end;

Procedure Add_Callback(id:longint;dlg:handle_dialog;funcnum:longint;speed:longint);
var
 this : handle_callback;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Callback');

 this^.id := id;
 this^.funcnum := funcnum;
 this^.tfuncnum := funcnum;
 this^.speed := speed;
 this^.nexttime := timercounter+speed;
 this^.next := nil;
 if dlg<>nil then
  Begin
    this^.prev := dlg^.last_callback;
    if dlg^.first_callback=nil then dlg^.first_callback := this;
    if dlg^.last_callback<>nil then dlg^.last_callback^.next := this;
    dlg^.last_callback:= this;
    dlg^.cur_callback:= this;
  end else
  Begin
    this^.prev := last_callback;
    if first_callback=nil then first_callback := this;
    if last_callback<>nil then last_callback^.next := this;
    last_callback:= this;
    cur_callback:= this;
  end;
end;

Procedure Delete_Callback(dlg:handle_dialog;tlp:handle_callback);
Begin
  if tlp=nil then exit;
  if dlg<>nil then
   Begin
     if tlp=dlg^.first_callback then dlg^.first_callback := tlp^.next;
     if tlp=dlg^.last_callback then dlg^.last_callback := tlp^.prev;
     if tlp=dlg^.cur_callback then dlg^.cur_callback := nil;
     if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
     if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
   end else
   Begin
     if tlp=first_callback then first_callback := tlp^.next;
     if tlp=last_callback then last_callback := tlp^.prev;
     if tlp=cur_callback then cur_callback := nil;
     if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
     if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
   end;
     dispose(tlp);
end;

Procedure Add_Checkbox(id:longint;dlg:handle_dialog;xpos,ypos:integer;s:string;enabled,selected:boolean;funcnum:longint);
var
 this : handle_checkbox;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Checkbox');

 this^.id := id;
 this^.funcnum := funcnum;
 this^.tfuncnum := funcnum;
 this^.xpos := xpos;
 this^.ypos := ypos;
 this^.enabled := enabled;
 this^.selected := selected;
 this^.data.init(length(s));
 this^.data.addstring(s);

 this^.next := nil;
 this^.prev := dlg^.last_cb;
 if dlg^.first_cb=nil then dlg^.first_cb:= this;
 if dlg^.last_cb<>nil then dlg^.last_cb^.next := this;
 dlg^.last_cb:= this;
 dlg^.cur_cb := this;
end;

Procedure Delete_checkbox(dlg:handle_dialog;tlp:handle_checkbox);
Begin
  if tlp=nil then exit;
  if tlp=dlg^.first_cb then
      dlg^.first_cb := tlp^.next;
  if tlp=dlg^.last_cb then dlg^.last_cb := tlp^.prev;
  if tlp=dlg^.cur_cb then dlg^.cur_cb := nil;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  tlp^.data.done;
  dispose(tlp);
end;

Procedure Add_Scrollbar(id:longint;dlg:handle_dialog;xpos,ypos,length:integer;min,max,curpos,step,jump:longint;
                        horv:byte;funcnum:longint);
var
 this : handle_scrollbar;
 hsb : handle_scrollbar;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Scrollbar');

 this^.xpos := xpos;
 this^.ypos := ypos;
 this^.funcnum := funcnum;
 this^.tfuncnum := funcnum;
 this^.id := id;
 if horv=HORZ then
 Begin
   this^.xpos1 := xpos+length;
   this^.ypos1 := ypos+14;
 end else
 Begin
   this^.xpos1 := xpos+14;
   this^.ypos1 := ypos+length;
 end;
 this^.horv := horv;
 this^.min := min;
 this^.max := max;
 this^.step := step;
 this^.jump := jump;
 this^.changed := false;
 this^.curpos := curpos;
 this^.amount := 0;
 this^.next := nil;
 this^.prev := dlg^.last_sb;
 this^.curpixpos := 0;
 if dlg^.first_sb=nil then dlg^.first_sb:= this;
 if dlg^.last_sb<>nil then dlg^.last_sb^.next := this;
 dlg^.last_sb := this;
 dlg^.cur_sb:= this;
end;

Procedure Delete_Scrollbar(dlg:handle_dialog;sbp:handle_scrollbar);
Begin
  if sbp=nil then exit;
  if sbp=dlg^.first_sb then
      dlg^.first_sb := sbp^.next;
  if sbp=dlg^.last_sb then dlg^.last_sb := sbp^.prev;
  if sbp=dlg^.cur_sb then dlg^.cur_sb := nil;
  if (sbp^.prev<>nil) then sbp^.prev^.next := sbp^.next;
  if (sbp^.next<>nil) then sbp^.next^.prev := sbp^.prev;
  dispose(sbp);
end;

Function GetString(s:string;b:byte):string;
var
 t,x,e : integer;
 token : string;
Begin
 token := '';
 t := 0;
 if (b>1) then
 for x := 1 to b-1 do
   Begin
     t := pos(';',s);
     s[t] := #178; {Take out token identifier}
   end;
 x := t+1;
 while ( (s[x]<>';') and (x<=length(s))) do
   Begin
     token := token + s[x];
     inc(x);
   end;
 Getstring := token;
end;


Procedure Assign_Data(dataid:longint;s:string);
var
 hd : handle_data;
Begin
 hd := get_handle_data(dataid);
 if hd=nil then exit;
 hd^.data.done;
 hd^.data.init(hd^.maxlength);
 hd^.data.addstring(s);
end;

{Data Types -
               DB_EDIT - Editable Data field
               s must equal - [ID;FIELDNAME;FIELDTYPE]

               DB_TEXT - Same as DB_EDIT except is not editable}
Procedure Add_Data(id:longint;dlg:handle_dialog;xpos,ypos:integer;
                          req:boolean;
                          fieldwidth:byte;maxlength:word;
                          ft : byte;
                          s:string;data:string;funcnum : longint);
var
 this : handle_data;
 ts : string;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Data');

 this^.id := id;
 this^.xpos := xpos;
 this^.ypos := ypos;
 this^.name := s;
 this^.required := req;
 this^.maxlength := maxlength;
 this^.fieldtype := ft;
 this^.funcnum := funcnum;
 this^.tfuncnum := funcnum;
 this^.fieldwidth := fieldwidth;
 this^.fieldname := '';
 this^.x1 := xpos;
 this^.y1 := ypos+1;
 this^.x2 := xpos+(this^.fieldwidth shl 3)+7;
 this^.y2 := ypos+( (this^.maxlength div this^.fieldwidth)*9)+2;

 if length(this^.name)>0 then
 Begin
   inc(this^.x1,length(this^.name)shl 3+7);
   inc(this^.x2,length(this^.name)shl 3+7);
 end;
 this^.next := nil;
 this^.prev := dlg^.last_data;

 this^.data.init(this^.maxlength);

 case(this^.fieldtype) of
   STRING_FIELD : Begin
                    this^.data.addstring(data);
                    this^.fieldname := '';
                    this^.db_ftype := 0;
                    this^.dbf_id := 0;
                  end;
   DB_TEXT      : if data[1]='[' then
                  Begin
                    this^.data.addstring('');
                    ts := getstring(data,1); delete(ts,1,1); {ID}
                    this^.dbf_id := stoi(ts);
                    ts := getstring(data,2); {Fieldname}
                    this^.fieldname := ts;
                    ts := getstring(data,3); delete(ts,length(ts),1); {FieldType}
                    this^.db_ftype := stoi(ts);
                  end else
                  Begin
                    this^.data.addstring(data);
                    this^.fieldname := '';
                    this^.db_ftype := String_Field;
                    this^.dbf_id := 0;
                  end;
   DB_EDIT      : Begin
                    this^.data.addstring('');
                    ts := getstring(data,1); delete(ts,1,1); {ID}
                    this^.dbf_id := stoi(ts);
                    ts := getstring(data,2); {Fieldname}
                    this^.fieldname := ts;
                    ts := getstring(data,3); delete(ts,length(ts),1); {FieldType}
                    this^.db_ftype := stoi(ts);
                  end;
 end;

 if dlg^.first_data=nil then dlg^.first_data:= this;
 if dlg^.last_data<>nil then dlg^.last_data^.next := this;
 dlg^.last_data:= this;
 dlg^.cur_data:= dlg^.first_data;
end;

Procedure Delete_Data(dlg:handle_dialog;tlp:handle_data);
Begin
  if (tlp=nil) then exit;
  if tlp=dlg^.first_data then
      dlg^.first_data := tlp^.next;
  if tlp=dlg^.last_data then dlg^.last_data := tlp^.prev;
  if tlp=dlg^.cur_data then dlg^.cur_data := nil;
  tlp^.data.done;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  dispose(tlp);
end;

Procedure Add_BMP(id:longint;dlg:handle_dialog;xpos,ypos:integer;puttype:byte;fname:string;funcnum:longint);
var
 this : handle_bmp;
 f : file;
 br : word;
 bh : bmp_header;
 z : integer;
 p : pbyte;
 pal : pal_ptr;
 w1 : longint;
Begin
if not(exists(fname)) then exit;
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_BMP');

 assign(f,fname);
 reset(f,1);
 blockread(f,bh,sizeof(bh),br);
 if (br<>sizeof(bh)) or (bh.bibitcount<>8) or (longint(bh.biwidth*bh.biheight)>memavail) then
  Begin
    close(f);
    dispose(this);
    exit;
  end;

 this^.id := id;
 this^.xpos := xpos;
 this^.ypos := ypos;
 this^.width := bh.biwidth;
 this^.height := bh.biheight;
 this^.puttype := puttype;
 this^.funcnum := funcnum;
 this^.fname := fname;
 pal := makepalette(bh);
 this^.next := nil;
 this^.prev := dlg^.last_bmp;

 getmem(this^.data,longint(this^.width*this^.height));

 p := this^.data;
 w1 := this^.width;
 while (w1 mod 4>0) do inc(w1);

 for z := this^.height downto 1 do
   Begin
     seek(f,longint((z-1)*w1+sizeof(bh)));
     blockread(f,p^,this^.width,br);
    if (br<>this^.width) then
      Begin
        freemem(this^.data,longint(this^.width*this^.height));
        dispose(this);
        exit;
      end;
     inc(p,this^.width);
   end;
 close(f);
 if dlg^.first_bmp=nil then dlg^.first_bmp := this;
 if dlg^.last_bmp<>nil then dlg^.last_bmp^.next := this;
 dlg^.last_bmp := this;
 dlg^.cur_bmp:= this;
 remap(pointer(this^.data),pal,this^.width,this^.height);
 dispose(pal);
end;

Procedure Delete_BMP(dlg:handle_dialog;tlp:handle_bmp);
Begin
  if (tlp=nil) then exit;
  if tlp=dlg^.first_bmp then
      dlg^.first_bmp := tlp^.next;
  if tlp=dlg^.last_bmp then dlg^.last_bmp := tlp^.prev;
  if tlp=dlg^.cur_bmp then dlg^.cur_bmp := nil;
  freemem(tlp^.data,tlp^.width*tlp^.height);
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  dispose(tlp);
end;

Procedure Set_Dialog_Scrollbars(dlg:handle_dialog);
Begin
  if dlg^.horz_sb<>nil then
     Begin
       dlg^.horz_sb^.ypos := dlg^.y2-dlg^.y1+1;
       dlg^.horz_sb^.ypos1 := dlg^.y2-dlg^.y1+15;
       dlg^.horz_sb^.xpos := 0;
       dlg^.horz_sb^.xpos1 := dlg^.x2-dlg^.x1;
       if dlg^.vert_sb<>nil then
          Begin
            dlg^.vert_sb^.ypos := 0;
            dlg^.vert_sb^.ypos1 := dlg^.y2-dlg^.y1+15;
            dlg^.vert_sb^.xpos := dlg^.x2-dlg^.x1+1;
            dlg^.vert_sb^.xpos1 := dlg^.x2-dlg^.x1+15;
          end;
       end else
        if dlg^.vert_sb<>nil then
          Begin
            dlg^.vert_sb^.ypos := 0;
            dlg^.vert_sb^.ypos1 := dlg^.y2-dlg^.y1+1;
            dlg^.vert_sb^.xpos := dlg^.x2-dlg^.x1+1;
            dlg^.vert_sb^.xpos1 := dlg^.x2-dlg^.x1+15;
          end;
end;


Procedure Add_Menu(dlg:handle_dialog;name:string);
var
 this : ml;
 s:string;
 upos:byte;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Menu');

 this^.name := name;
 this^.highlight := false;
 this^.next := nil;
 this^.prev := dlg^.last_menu;
 this^.first_item := nil;
 this^.last_item := nil;
 this^.cur_item := nil;
 this^.width := 0;
 this^.height := 0;
 s := set_underline(this^.name,upos);
 if dlg^.first_menu=nil then
    Begin
      dlg^.first_menu:= this;
      inc(dlg^.y1,15);
      set_dialog_scrollbars(dlg);
    end;
 if dlg^.last_menu<>nil then
   Begin
     this^.xpos1 := this^.prev^.xpos2+10;
     this^.xpos2 := this^.xpos1+((length(s)+2)shl 3);
     dlg^.last_menu^.next := this;
   end else
   Begin
     this^.xpos1 := 4;
     this^.xpos2 := this^.xpos1+((length(s)+2)shl 3);
   end;
 dlg^.last_menu:= this;
 dlg^.cur_menu:= this;
end;


Procedure Add_Menu_Item(id:longint;m:ml;name:string;fn:longint);
var
 this : handle_menu_item;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Menu_Item');

 this^.id := id;
 this^.name := name;
 this^.highlight := false;
 this^.next := nil;
 this^.prev := m^.last_item;
 this^.funcnum := fn;
 this^.tfuncnum := fn;
 if m^.first_item=nil then m^.first_item:= this;
 if m^.last_item<>nil then m^.last_item^.next := this;
 m^.last_item:= this;
 m^.cur_item := this;
 inc(m^.height);
 if length(this^.name)shl 3 > m^.width then m^.width := length(this^.name)shl 3;
end;

Procedure Delete_Menu_Item(m:ml;tlp:handle_menu_item);
Begin
  if tlp=nil then exit;
  if tlp=m^.first_item then m^.first_item := tlp^.next;
  if tlp=m^.last_item then m^.last_item := tlp^.prev;
  if tlp=m^.cur_item then m^.cur_item := nil;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  dec(m^.height);
  dispose(tlp);
end;


{procedure Sort_Listbox(hl:handle_listbox);
var
   Gap,I,J:integer;
   n : longint;
   h1,h2 : lt;
begin
  if hl=nil then exit;
  N := hl^.numitems;

  Gap:=N div 2;

      while (Gap>0) do
      begin
         I:=Gap;
         while (I<N) do
         begin
            J:=I-Gap;
            h1 := element(hl,j);
            h2 := element(hl,j+gap);
            while (J>=0) and (Less_Than(h2^.data.pstr,h1^.data.pstr)) do
            begin
              Swap(h2,h1);
              dec(J,Gap);
            end;
            inc(I);
         end;
         Gap:=Gap div 2;
      end;
end;
}
procedure Sort_Listbox(hl:handle_listbox);
Function Less_Than(s1,s2:string):boolean;
var
 ss1,ss2 : s_type;
 ml : byte;
 x : byte;
 x1,x2 : longint;
Begin
  less_than := false;
  ss1.init(255);
  ss1.addstring(s1);
  ss2.init(255);
  ss2.addstring(s2);
  {$IFDEF DPMI}
  if (strcomp(ss1.strdata,ss2.strdata)<0) then less_than := true;
  {$ENDIF}
  ss1.done;
  ss2.done;
end;

procedure Swap(I,J:lt);
var
 t : lt;
Begin
 new(t);
 move(i^,t^,sizeof(i^));
 move(j^,i^,sizeof(i^)-8);
 move(t^,j^,sizeof(i^)-8);
 dispose(t);
end;

Function Element(hl:handle_listbox;n:longint):lt;
var
 this : lt;
 x : longint;
Begin
 this := hl^.first_item;
 element := nil;
 if (n<0) then exit;
 if (n=0) then
   Begin
     element := this;
     exit;
   end;
 for x := 1 to n do this := this^.next;
 element := this;
end;

procedure Sort(l, r: longint);
var
  i, j, y: longint;
  x : string;
begin
  i := l; j := r; x := element(hl,(l+r) shr 1)^.data.pstr;
  repeat
    while less_than(element(hl,i)^.data.pstr,x) do inc(i);
    while less_than(x,element(hl,j)^.data.pstr) do dec(j);
    if i <= j then
    begin
      swap(element(hl,i),element(hl,j));
      inc(i);
      dec(j);
    end;
  until i > j;
  if l < j then Sort(l,j);
  if i < r then Sort(i,r);
end;

begin {QuickSort};
  exit;
  if hl=nil then exit;
  if hl^.numitems<1 then exit;
  Sort(0,hl^.numitems-1);
end;


Procedure Add_ListBox(id:longint;dlg:handle_dialog;title:string;xpos,ypos,xpos1,ypos1:integer;hscrollid,vscrollid:longint;
                      selectfunc:longint;df:handle_data;inclientfunct:longint);
var
 this : handle_listbox;
 hsb : handle_scrollbar;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Listbox');
 this^.id := id;
 this^.next := nil;
 this^.prev := dlg^.last_lb;
 this^.first_item := nil;
 this^.last_item := nil;
 this^.cur_item := nil;
 this^.data_field := df;
 this^.horz_sb := nil;
 this^.vert_sb := nil;
 this^.title := title;
 this^.numitems := 0;
 this^.xpos := xpos;
 this^.ypos := ypos;
 this^.xpos1 := xpos1;
 this^.ypos1 := ypos1;
 this^.selectfunc := selectfunc;
 this^.tselectfunc := selectfunc;
 this^.selected := 0;
 this^.inclientfunct := inclientfunct;
 this^.tinclientfunct := inclientfunct;
 if (vscrollid>0) then
   Begin
     dec(this^.xpos1,15);
     hsb := get_handle_scrollbar(vscrollid); if (hsb=nil) then
     Begin
       Add_Scrollbar(vscrollid,dlg,this^.xpos1+1,ypos,ypos1-ypos,1,1,1,1,5,vert,0);
       this^.vert_sb := dlg^.cur_sb;
     end else dlg^.vert_sb := hsb;

   end;
 if (hscrollid>0) then
   Begin
     dec(this^.ypos1,15);
     if vscrollid>0 then dec(xpos1,15);
     hsb := get_handle_scrollbar(hscrollid); if (hsb=nil) then
     Begin
        Add_Scrollbar(hscrollid,dlg,xpos,this^.ypos1+1,xpos1-xpos,1,1,1,1,5,horz,0);
        this^.horz_sb := dlg^.cur_sb;
     end else this^.horz_sb := hsb;
   end;
 if dlg^.first_lb =nil then dlg^.first_lb := this;
 if dlg^.last_lb<>nil then dlg^.last_lb^.next := this;
 dlg^.last_lb:= this;
 dlg^.cur_lb:= this;
end;

{Procedure Add_DropDown(id:longint;dlg:handle_dialog;df:handle_data;selectfunc:longint);
var
 this : handle_dropdown;
Begin
 new(this);
 this^.id := id;
 this^.next := nil;
 this^.prev := dlg^.last_dropdown;
 this^.first_item := nil;
 this^.last_item := nil;
 this^.cur_item := nil;
 this^.data_field := df;
 this^.vert_sb := nil;
 this^.numitems := 0;

 this^.xpos := df^.xpos+length(df^.name)shl 3+4;
 this^.ypos := df^.ypos;
 this^.xpos1 := this^.xpos+length(df^.name)shl 3+4;
 this^.ypos1 := df^.ypos+(11*df^.maxlength div df^.fieldlength);

 this^.selectfunc := selectfunc;
 this^.selected := 0;

 dec(this^.xpos1,15);
 Add_Scrollbar(vscrollid,dlg,this^.xpos1+1,ypos,ypos1-ypos,1,1,1,1,5,vert,0);
 this^.vert_sb := dlg^.cur_sb;

 if dlg^.first_dropdown=nil then dlg^.first_dropdown:= this;
 if dlg^.last_dropdown<>nil then dlg^.last_dropdown^.next := this;
 dlg^.last_dropdown:= this;
 dlg^.cur_dropdown:= this;
end;
}

Procedure Add_Listbox_Item(m:handle_listbox;name:string;ml:longint;ref:longint);
var
 this : lt;
 s1,s2 : string;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Listbox_Item');
 this^.next := nil;
 this^.prev := m^.last_item;
 this^.ref := ref;

 if length(name)>ml then
 Begin
   s1 := name;
   delete(s1,ml+1,255);
   s2 := name;
   delete(s2,1,ml);
 end else
 Begin
   s1 := name;
   s2 := '';
 end;

 this^.data.init(length(s1));
 this^.data.addstring(s1);
 this^.maxlength := length(s1);
 this^.selected := false;
 this^.last := true;
 if (m^.first_item=nil) then m^.first_item:= this;
 if (m^.last_item<>nil) then m^.last_item^.next := this;
 m^.last_item:= this;
 m^.cur_item := this;
 inc(m^.numitems);
 if (m^.vert_sb<>nil) then
    Begin
      m^.vert_sb^.max := m^.numitems -((m^.vert_sb^.ypos1-m^.vert_sb^.ypos) div 12)+3;
      m^.vert_sb^.jump := m^.numitems div ((m^.vert_sb^.ypos1-m^.vert_sb^.ypos) div 12);
    end;
 if (m^.horz_sb<>nil) then
   Begin
     if ( (m^.horz_sb^.max+((m^.xpos1-m^.xpos) shr 3))<length(name)) then
          m^.horz_sb^.max := length(name)-((m^.xpos1-m^.xpos) shr 3)+3;
     m^.horz_sb^.jump := 5{m^.horz_sb^.max shr 1};
   end;
 if length(s2)>0 then Add_Listbox_Item(m,s2,ml,ref);
end;

Procedure Delete_ListBox_Item(m:handle_listbox;tlp:lt;dsb : boolean);
Begin
  if tlp=nil then exit;
  if tlp=m^.first_item then m^.first_item := tlp^.next;
  if tlp=m^.last_item then m^.last_item := tlp^.prev;
  if tlp=m^.cur_item then m^.cur_item := nil;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  if (m^.vert_sb<>nil) then
    Begin
      dec(m^.vert_sb^.max);
      m^.vert_sb^.changed := true;
      if dsb then draw_scrollbar(cur_dialog,m^.vert_sb);
    end;
  tlp^.data.done;

  dispose(tlp);
  dec(m^.numitems);
end;

Procedure Delete_All_Menu_Item(m:ml);
Begin
 while (m^.first_item<>nil) do delete_menu_item(m,m^.first_item);
end;

Procedure Delete_All_Callbacks(dlg:handle_dialog);
Begin
 if (dlg=nil) then
 while (first_callback<>nil) do delete_callback(nil,first_callback) else
 while (dlg^.first_callback<>nil) do delete_callback(dlg,dlg^.first_callback);
end;

Procedure Delete_All_Accelerators(dlg:handle_dialog);
Begin
 while (dlg^.first_accelerator<>nil) do delete_accelerator(dlg,dlg^.first_accelerator);
end;

Procedure Delete_All_Clients(m:handle_dialog);
Begin
 while (m^.first_client<>nil) do delete_client(m,m^.first_client);
end;

Procedure Delete_All_BMPS(dlg:handle_dialog);
Begin
 while (dlg^.first_bmp<>nil) do delete_bmp(dlg,dlg^.first_bmp);
end;

Procedure Delete_All_Checkboxes(dlg:handle_dialog);
Begin
 while dlg^.first_cb<>nil do delete_checkbox(dlg,dlg^.first_cb);
end;

Procedure Delete_All_Scrollbars(dlg:handle_dialog);
Begin
 while dlg^.first_sb<>nil do delete_scrollbar(dlg,dlg^.first_sb);
end;

Procedure Delete_All_Text(dlg:handle_dialog);
Begin
 while (dlg^.first_text<>nil) do delete_text(dlg,dlg^.first_text);
end;

Procedure Delete_All_Buttons(dlg:handle_dialog);
Begin
 while (dlg^.first_button<>nil) do delete_button(dlg,dlg^.first_button);
end;

Procedure Delete_All_Data(dlg:handle_dialog);
Begin
 while (dlg^.first_data<>nil) do delete_data(dlg,dlg^.first_data);
end;

Procedure Delete_All_Menu(dlg:handle_dialog);
Begin
 while (dlg^.first_menu<>nil) do delete_menu(dlg,dlg^.first_menu);
end;

Procedure Delete_All_Listbox_items(tlp:handle_listbox);
Begin
 while tlp^.first_item<>nil do delete_listbox_item(tlp,tlp^.first_item,false);
 if (tlp^.vert_sb<>nil) then
    Begin
      tlp^.vert_sb^.max    := 1;
      tlp^.vert_sb^.min    := 1;
      tlp^.vert_sb^.curpos := 1;
    end;
 if (tlp^.horz_sb<>nil) then
    Begin
      tlp^.horz_sb^.max    := 1;
      tlp^.horz_sb^.min    := 1;
      tlp^.horz_sb^.curpos := 1;
    end;
 tlp^.numitems := 0;
end;

Procedure Delete_all_listboxes(dlg:handle_dialog);
Begin
 while (dlg^.first_lb<>nil) do delete_listbox(dlg,dlg^.first_lb);
end;


Procedure Delete_Menu(dlg:handle_dialog;tlp:ml);
Begin
  if tlp=nil then exit;
  if tlp=dlg^.first_menu then
      dlg^.first_menu := tlp^.next;
  if tlp=dlg^.last_menu then dlg^.last_menu := tlp^.prev;
  if tlp=dlg^.cur_menu then dlg^.cur_menu := nil;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  delete_all_menu_item(tlp);
  dispose(tlp);
end;

Procedure Delete_ListBox(dlg:handle_dialog;tlp:handle_listbox);
Begin
  if tlp=nil then exit;
  if tlp=dlg^.first_lb then
      dlg^.first_lb := tlp^.next;
  if tlp=dlg^.last_lb then dlg^.last_lb := tlp^.prev;
  if tlp=dlg^.cur_lb then dlg^.cur_lb := nil;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  delete_all_listbox_items(tlp);
  if tlp^.horz_sb<>nil then delete_scrollbar(dlg,tlp^.horz_sb);
  if tlp^.vert_sb<>nil then delete_scrollbar(dlg,tlp^.vert_sb);
  dispose(tlp);
end;

Procedure Add_Button(id:longint;dlg:handle_dialog;xpos,ypos:integer;bt:byte;s:string;bmpid:longint;enabled:boolean;fn:longint);
var
 this : handle_button;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Add_Button');
 this^.id := id;
 this^.xpos := xpos;
 this^.ypos := ypos;
 this^.btext.init(system.length(s));
 this^.btext.addstring(s);
 this^.btype := bt;
 this^.next := nil;
 this^.state := 0;
 this^.funcnum := fn;
 this^.tfuncnum := fn;
 this^.prev := dlg^.last_button;
 this^.enabled := enabled;
 if bmpid>0 then
 this^.hbmp := get_handle_bmp(bmpid) else
 this^.hbmp := nil;

 if dlg^.first_button=nil then dlg^.first_button:= this;
 if dlg^.last_button<>nil then dlg^.last_button^.next := this;
 dlg^.last_button:= this;
 dlg^.cur_button:= this;
end;

Procedure Delete_button(dlg:handle_dialog;blp:handle_button);
Begin
  if blp=nil then exit;
  if blp=dlg^.first_button then
      dlg^.first_button := blp^.next;
  if blp=dlg^.last_button then dlg^.last_button := blp^.prev;
  if blp=dlg^.cur_button then dlg^.cur_button := nil;
  if (blp^.prev<>nil) then blp^.prev^.next := blp^.next;
  if (blp^.next<>nil) then blp^.next^.prev := blp^.prev;
  dispose(blp);
end;


Procedure Create_Dialog(resid:longint;title:string;xp1,yp1,xp2,yp2:integer;cdtype:byte;
                        mode:byte;helpfunc,minfunc,maxfunc,closefunc,icfunc:longint;
                        horzsbid,vertsbid,horzsb,vertsb:longint);
var
 this : handle_dialog;
Begin
 new(this);
 if (this=NIL) then dialogerror('Out of Memory : Create_Dialog');
 with this^ do
   Begin
     z := curz;
     inc(curz);
     id := resid;
     dtype := cdtype;
     xpos := xp1;     ypos := yp1;  xpos1 := xp2;    ypos1 := yp2;
     oxpos := xp1;    oypos := yp1; oxpos1 := xp2;   oypos1 := yp2;
     x1 := xp1+3;     x2 := xp2-3; y1 := yp1+3;    y2 := yp2-3;
     cursorx := 0; cursory := 0;
     cursorvisible := false; cursorstate := 0;
     max := false;    min := false;
     state := 0; name := title;
     active := false; flags := mode;
     prev := Last_Dialog; next := nil;
     minimize_func := minfunc; maximize_func := maxfunc;
     close_func := closefunc; help_func := helpfunc;
     tminimize_func := minfunc; tmaximize_func := maxfunc;
     tclose_func := closefunc; thelp_func := helpfunc;
     inclientfunct := icfunc;
     tinclientfunct := icfunc;
     first_text := nil;   last_text := nil;   cur_text := nil;
     first_sb := nil;     last_sb := nil;     cur_sb := nil;
     first_lb := nil;     last_lb := nil;     cur_lb := nil;
     first_cb := nil;     last_cb := nil;     cur_cb := nil;
     first_button := nil; last_button := nil; cur_button := nil;
     first_data := nil;   last_data := nil;   cur_data := nil;
     first_menu := nil;   last_menu := nil;   cur_menu := nil;
     first_bmp := nil;    last_bmp := nil;    cur_bmp := nil;
     first_client := nil; last_client := nil; cur_client := nil;
     first_callback := nil; last_callback := nil; cur_callback := nil;
     first_accelerator := nil; last_accelerator := nil; cur_accelerator := nil;

     if (length(name)>0) then inc(y1,19) else
       Begin
         if bitset(flags,close_button) then dec(flags,close_button);
         if bitset(flags,minimize_button) then dec(flags,minimize_button);
         if bitset(flags,maximize_button) then dec(flags,maximize_button);
         if bitset(flags,help_button) then dec(flags,help_button);
         if bitset(flags,moveable) then dec(flags,moveable);
         if bitset(flags,sizeable) then dec(flags,sizeable);
       end;
     pu_present := false;
     if last_dialog<>nil then last_dialog^.next := this;
     last_dialog := this; cur_dialog := this;
     horz_sb := nil; vert_sb := nil;

     if (first_dialog=nil) then  first_dialog := this;

     if (vertsbid>0) then
       Begin
         dec(x2,14);
         add_scrollbar(vertsbid,cur_dialog,x2-x1+1,0,y2-y1,0,0,0,1,5,vert,vertsb);
         vert_sb := cur_sb;
       end;

     if (horzsbid>0) then
       Begin
         dec(y2,14);
         add_scrollbar(horzsbid,cur_dialog,0,y2-y1+1,x2-x1,0,0,0,1,5,horz,horzsb);
         horz_sb := cur_sb;
       end;
     set_dialog_scrollbars(cur_dialog);
   end;
end;

Procedure Close_Dialog(dlg:handle_dialog);
Begin
  if dlg=nil then exit;
  hm;
  with dlg^ do
    Begin
      clipset(0,0,maxx,maxy);
      fill(xpos,ypos,xpos1,ypos1,background_color);
    end;

  delete_all_text(dlg);
  delete_all_buttons(dlg);
  delete_all_data(dlg);
  delete_all_menu(dlg);
  delete_all_listboxes(dlg);
  delete_all_scrollbars(dlg);
  delete_all_checkboxes(dlg);
  delete_all_bmps(dlg);
  delete_all_clients(dlg);
  delete_all_accelerators(dlg);
  delete_all_callbacks(dlg);

  if dlg=first_dialog then first_dialog := dlg^.next;

  if dlg=last_dialog then last_dialog := dlg^.prev;
  if dlg=cur_dialog then cur_dialog := nil;
  if (dlg^.prev<>nil) then dlg^.prev^.next := dlg^.next;
  if (dlg^.next<>nil) then dlg^.next^.prev := dlg^.prev;
  dispose(dlg);
  sm;
end;

Procedure Close_All_Dialogs;
Begin
  while first_dialog<>nil do close_dialog(first_dialog);
end;

Procedure Standard_Close(_refresh:boolean);
Begin
 with cur_dialog^ do
 windowclip(xpos,ypos,xpos1,ypos1);
 erasecursor(cur_dialog);
 close_dialog(cur_dialog);
 usewindowclip := true;
 if _refresh then refresh;
 repeat handlemouse until not(leftmousekeypressed);
end;


Procedure Refresh;
Begin
  if cur_dialog<>nil then erasecursor(cur_dialog);
  cur_dialog := last_dialog;
  if cur_dialog<>nil then cur_dialog^.active := true;
  redraw_all(false);
end;

Procedure HandleListBoxSelection;
var
 this_lb : handle_listbox;
 this_lbi : lt;
 x,highlightnum : integer;
 lbchanged : boolean;
Begin
  lbchanged := false;
  if (cur_dialog=nil) then exit;
  this_lb := cur_dialog^.first_lb;
   while this_lb<>nil do
     Begin
       if (mousein(this_lb^.xpos+cur_dialog^.x1+xofs,this_lb^.ypos+cur_dialog^.y1+yofs,
                   this_lb^.xpos1+cur_dialog^.x1+xofs,this_lb^.ypos1+cur_dialog^.y1+yofs)) and (this_lb^.selectfunc>0) then
         Begin
           if this_lb^.vert_sb<>nil then
              highlightnum := this_lb^.vert_sb^.curpos else highlightnum := 0;
           inc(highlightnum,(mousey-(this_lb^.ypos+cur_dialog^.y1+yofs)+8) div 12-1);
           this_lbi := this_lb^.first_item;
           x := 1;
           while (this_lbi<>nil) do
             Begin
               if (x=highlightnum) then
                 Begin
                   if not(this_lbi^.selected) then
                     Begin
                      if leftmousekeypressed then
                        Begin
                          this_lb^.selected := highlightnum;
                        end;
                      this_lbi^.selected := true;
                      this_lbi^.last := false;
                      this_lb^.cur_item := this_lbi;
                      lbchanged := true;
                     end;
                 end else
                 if (this_lbi^.selected) then
                   Begin
                     this_lbi^.selected := false;
                     this_lbi^.last := true;
                     lbchanged := true;
                   end;
               inc(x);
               if this_lbi<>nil then this_lbi := this_lbi^.next;
             end;
          end else
         if (this_lb^.selectfunc>0) then
         Begin
           this_lbi := this_lb^.first_item;
           while this_lbi<>nil do
             Begin
               if this_lbi^.selected then
                 Begin
                   this_lbi^.selected := false;
                   this_lbi^.last := true;
                   lbchanged := true;
                 end;
               this_lbi := this_lbi^.next;
             end;
         end;
         if (this_lb^.horz_sb<>nil) then
             if (this_lb^.horz_sb^.changed) then lbchanged := true;
         if (this_lb^.vert_sb<>nil) then
             if (this_lb^.vert_sb^.changed) then lbchanged := true;
         if lbchanged then draw_listbox(cur_dialog,this_lb,false);
       lbchanged := false;
       this_lb := this_lb^.next;
     end;

end;

Function HandleListBoxExecution(dlg:handle_dialog):boolean;
var
 this_lb : handle_listbox;
 this_lbi : lt;
 x,highlightnum : integer;
 lbchanged : boolean;
Begin
  handlelistboxexecution := false;
  if (dlg=nil) then exit;
  lbchanged := false;
  this_lb := cur_dialog^.first_lb;
   while this_lb<>nil do
     Begin
       if (mousein(this_lb^.xpos+cur_dialog^.x1+xofs,this_lb^.ypos+cur_dialog^.y1+yofs,
                   this_lb^.xpos1+cur_dialog^.x1+xofs,this_lb^.ypos1+cur_dialog^.y1+yofs)) and (this_lb^.selectfunc>0) then
         Begin
           if (this_lb^.inclientfunct>0) then
             Begin
               dlg^.cur_lb := this_lb;
               handlelistboxexecution := true;
               execute_procedure(this_lb^.inclientfunct);
               exit;
             end;
           if this_lb^.vert_sb<>nil then
              highlightnum := this_lb^.vert_sb^.curpos else highlightnum := 0;
           inc(highlightnum,(mousey-(this_lb^.ypos+cur_dialog^.y1+yofs)+8) div 12-1);
           this_lbi := this_lb^.first_item;
           x := 1;
           while (this_lbi<>nil) do
             Begin
               if (x=highlightnum) then
                 Begin
                   if (this_lb^.selectfunc>0) then
                   Begin
                     cur_dialog^.cur_lb := this_lb;
                     repeat until not leftmousekeypressed;
                      if (this_lb^.data_field<>nil) then
                        Begin
                          this_lb^.data_field^.data.done;
                          this_lb^.data_field^.data.init(this_lb^.data_field^.maxlength);
                          this_lb^.data_field^.data.addstring(this_lbi^.data.pstr);
                          hm;
                          draw_data(cur_dialog,this_lb^.data_field);
                          sm;
                        end;
                     handlelistboxexecution := true;
                     dlg^.cur_lb := this_lb;
                     execute_procedure(this_lb^.selectfunc);
                     repeat handlemouse; until not leftmousekeypressed;
                     exit;
                   end;
                 end;
               inc(x);
               if (this_lbi<>nil) then this_lbi := this_lbi^.next;
             end;
          end;
       this_lb := this_lb^.next;
     end;
end;

Function ProcessWindowSB(dlg:handle_dialog):boolean;
var
 sb_info : array[1..5] of Record
                            x1,y1,x2,y2 : integer;
                          end;

Procedure ProcessSB(this_sb:handle_scrollbar);
Begin
  if this_sb=nil then exit;
       with this_sb^ do
        Begin
          if mousein(this_sb^.xpos+dlg^.x1,this_sb^.ypos+dlg^.y1,
                     this_sb^.xpos1+dlg^.x1,this_sb^.ypos1+dlg^.y1) and
            (this_sb^.min<this_sb^.max) then
          Begin
            Assign_PixPos(dlg,this_sb);
            case this_sb^.horv of
             HORZ : Begin
                      changed := true;
                      sb_info[1].x1 := this_sb^.xpos+dlg^.x1;
                      sb_info[1].y1 := this_sb^.ypos+dlg^.y1;
                      sb_info[1].x2 := sb_info[1].x1+13;
                      sb_info[1].y2 := sb_info[1].y1+11;
                      sb_info[4].x1 := this_sb^.xpos1+dlg^.x1-13;
                      sb_info[4].y1 := this_sb^.ypos1+dlg^.y1-11;
                      sb_info[4].x2 := sb_info[4].x1+13;
                      sb_info[4].y2 := sb_info[4].y1+11;
                      sb_info[2].x1 := sb_info[1].x2+1;
                      sb_info[2].y1 := sb_info[1].y1;
                      sb_info[2].x2 := this_sb^.curpixpos;
                      sb_info[2].y2 := sb_info[1].y2;
                      sb_info[3].x1 := sb_info[2].x2+13;
                      sb_info[3].y1 := sb_info[1].y1;
                      sb_info[3].x2 := sb_info[4].x1-1;
                      sb_info[3].y2 := sb_info[1].y2;
                    end;
             VERT : Begin
                      sb_info[1].x1 := this_sb^.xpos+dlg^.x1;
                      sb_info[1].y1 := this_sb^.ypos+dlg^.y1;
                      sb_info[1].x2 := sb_info[1].x1+11;
                      sb_info[1].y2 := sb_info[1].y1+13;
                      sb_info[4].x1 := this_sb^.xpos1+dlg^.x1-11;
                      sb_info[4].y1 := this_sb^.ypos1+dlg^.y1-13;
                      sb_info[4].x2 := sb_info[4].x1+11;
                      sb_info[4].y2 := sb_info[4].y1+13;
                      sb_info[2].x1 := sb_info[1].x1;
                      sb_info[2].y1 := sb_info[1].y2+1;
                      sb_info[2].x2 := sb_info[1].x2;
                      sb_info[2].y2 := this_sb^.curpixpos;
                      sb_info[3].x1 := sb_info[1].x1;
                      sb_info[3].y1 := sb_info[2].y2+13;
                      sb_info[3].x2 := sb_info[1].x2;
                      sb_info[3].y2 := sb_info[4].y1-1;
                      changed := true;
                   end;
            end;
            if mousein(sb_info[1].x1,sb_info[1].y1,
                       sb_info[1].x2,sb_info[1].y2) then
                        Begin
                          dec(this_sb^.curpos,this_sb^.step);
                          this_sb^.amount := -this_sb^.step;
                          while (this_sb^.curpos<this_sb^.min) do
                            Begin
                              inc(this_sb^.curpos);
                              inc(this_sb^.amount);
                            end;
                          draw_client_screen(dlg);
                          processwindowsb := true;
                          if (this_sb^.funcnum>0) then
                           Begin
                             cur_dialog^.cur_sb := this_sb;
                             execute_procedure(this_sb^.funcnum);
                           end;
                        end else
            if mousein(sb_info[4].x1,sb_info[4].y1,
                       sb_info[4].x2,sb_info[4].y2) then
                        Begin
                          inc(this_sb^.curpos,this_sb^.step);
                          this_sb^.amount := this_sb^.step;
                          while (this_sb^.curpos>this_sb^.max) do
                            Begin
                              dec(this_sb^.curpos);
                              dec(this_sb^.amount);
                            end;
                          draw_client_screen(dlg);
                          processwindowsb := true;
                          if (this_sb^.funcnum>0) then
                           Begin
                             cur_dialog^.cur_sb := this_sb;
                             execute_procedure(this_sb^.funcnum);
                           end;
                        end else
            if mousein(sb_info[2].x1,sb_info[2].y1,
                       sb_info[2].x2,sb_info[2].y2) then
                        Begin
                          dec(this_sb^.curpos,this_sb^.jump);
                          this_sb^.amount := -this_sb^.jump;
                          while (this_sb^.curpos<this_sb^.min) do
                            Begin
                              inc(this_sb^.curpos);
                              inc(this_sb^.amount);
                            end;
                          draw_client_screen(dlg);
                          processwindowsb := true;
                          if (this_sb^.funcnum>0) then
                           Begin
                             cur_dialog^.cur_sb := this_sb;
                             execute_procedure(this_sb^.funcnum);
                           end;
                        end else
            if mousein(sb_info[3].x1,sb_info[3].y1,
                       sb_info[3].x2,sb_info[3].y2) then
                        Begin
                          inc(this_sb^.curpos,this_sb^.jump);
                          this_sb^.amount := this_sb^.jump;
                          while (this_sb^.curpos>this_sb^.max) do
                            Begin
                              dec(this_sb^.curpos);
                              dec(this_sb^.amount);
                            end;
                          processwindowsb := true;
                          draw_client_screen(dlg);
                          if (this_sb^.funcnum>0) then
                           Begin
                             cur_dialog^.cur_sb := this_sb;
                             execute_procedure(this_sb^.funcnum);
                           end;
                        end;
          end;
        end;
end;

Begin
  ProcessWindowsb := false;
  ProcessSB(dlg^.horz_sb);
  ProcessSB(dlg^.vert_sb);
end;

Procedure ProcessMouseKey(dlg:handle_dialog);
var
 this_button : handle_button;
 this_cb : handle_checkbox;
 this_data   : handle_data;
 this_sb     : handle_scrollbar;
 this_lb     : handle_listbox;
 this_lbi    : lt;
 this_text   : handle_text;
 lbchanged : boolean;
 omx,omy : longint;
 w,h : integer;
 bx1,bx2,by1,by2 : integer;
 x : integer;
 sb_info : array[1..5] of Record
                            x1,y1,x2,y2 : integer;
                          end;
Begin
 if (dlg=nil) then exit;
 with dlg^ do
 Begin
   if processwindowsb(dlg) then exit;
   if handlelistboxexecution(dlg) then exit;
   if (mousein(xpos+6,ypos+6,xpos+17,ypos+17)) and (bitset(flags,help_button)) and
      (help_func>0) then
        Begin
          hm;
          execute_procedure(help_func);
          sm;
          exit;
        end;
   if (mousein(xpos1-49,ypos+6,xpos1-36,ypos+17)) and (bitset(flags,minimize_button)) then
        Begin
          if (min) then
          Begin
            hm;
            clipset(xpos,ypos,xpos1,ypos1);
            windowclip(xpos,ypos,xpos1,ypos1);
            fill(xpos,ypos,xpos1,ypos1,background_color);
            sm;
            xpos := oxpos;
            ypos := oypos;
            xpos1 := oxpos1;
            ypos1 := oypos1;
            x1 := xpos+3;
            x2 := xpos1-3;
            y1 := ypos+3;
            if length(name)>0 then inc(y1,19);
            if first_menu<>nil then inc(y1,15);
            y2 := ypos1-3;
            max := false;
            min := false;
            usewindowclip := true;
            if (horz_sb<>nil) then dec(x2,14);
            if (vert_sb<>nil) then dec(y2,14);
            set_dialog_scrollbars(dlg);
            redraw_all(false);
            repeat until not(leftmousekeypressed);
          end else
          Begin
            max := false;
            min := true;
            oxpos := xpos;
            oypos := ypos;
            oxpos1 := xpos1;
            oypos1 := ypos1;
            ypos:=maxy-22;
            ypos1 := maxy;
            x1 := xpos+3;
            x2 := xpos1-3;
            y1 := ypos+3;
            if length(name)>0 then inc(y1,19);
            if first_menu<>nil then inc(y1,15);
            y2 := ypos1-3;
            if (horz_sb<>nil) then dec(x2,14);
            if (vert_sb<>nil) then dec(y2,14);
            set_dialog_scrollbars(dlg);
            hm;
            fill(oxpos,oypos,oxpos1,oypos1,background_color);
            redraw_all(false);
            repeat until not(leftmousekeypressed);
          end;
          hm;
          execute_procedure(minimize_func);
          sm;
          exit;
        end;

   if (mousein(xpos1-32,ypos+6,xpos1-21,ypos+17)) and (bitset(flags,maximize_button)) then
     Begin
       if (max) then
       Begin
         hm;
         clipset(xpos,ypos,xpos1,ypos1);
         windowclip(xpos,ypos,xpos1,ypos1);
         fill(xpos,ypos,xpos1,ypos1,background_color);
         sm;
         xpos := oxpos;
         ypos := oypos;
         xpos1 := oxpos1;
         ypos1 := oypos1;
         x1 := xpos+3;
         x2 := xpos1-3;
         y1 := ypos+3;
         if length(name)>0 then inc(y1,19);
         if first_menu<>nil then inc(y1,15);
         y2 := ypos1-3;
         max := false;
         min := false;
         usewindowclip := true;
         if (horz_sb<>nil) then dec(x2,14);
         if (vert_sb<>nil) then dec(y2,14);
         set_dialog_scrollbars(dlg);
         redraw_all(false);
         repeat until not(leftmousekeypressed);
       end else
       Begin
         max := true;
         min := false;
         oxpos := xpos;
         oypos := ypos;
         oxpos1 := xpos1;
         oypos1 := ypos1;
         xpos:=0;
         ypos:=0;
         xpos1 := maxx;
         ypos1 := maxy;
         x1 := xpos+3;
         x2 := xpos1-3;
         y1 := ypos+3;
         if length(name)>0 then inc(y1,19);
         if first_menu<>nil then inc(y1,15);
         y2 := ypos1-3;
         if (horz_sb<>nil) then dec(x2,14);
         if (vert_sb<>nil) then dec(y2,14);
         set_dialog_scrollbars(dlg);
         draw_dialog(cur_dialog);
         repeat until not(leftmousekeypressed);
       end;
       if (maximize_func>0) then
          Begin
            execute_procedure(maximize_func);
            exit;
          end;
     end;
   if (mousein(xpos1-17,ypos+6,xpos1-6,ypos+17)) and (bitset(flags,close_button)) then
     if (close_func>0) then
       Begin
         hm;
         execute_procedure(close_func);
         sm;
       end else
     Begin
       windowclip(cur_dialog^.xpos,cur_dialog^.ypos,cur_dialog^.xpos1,cur_dialog^.ypos1);
       close_dialog(cur_dialog);
       cur_dialog := last_dialog;
       if cur_dialog<>nil then cur_dialog^.active := true;
       usewindowclip := true;
       redraw_all(false);
       repeat until not(leftmousekeypressed);
       exit;
     end;
   {Go through button list and see if a button was hit!}
   this_button := dlg^.first_button;
   while this_button<>nil do
     Begin
       with this_button^ do
        Begin
          if (this_button^.hbmp<>nil) then
          Begin
            w := this_button^.hbmp^.width+5;
            h := this_button^.hbmp^.height-12;
            if (h<0) then h := 0;
          end else
          Begin
            w := 0;
            h := 0;
          end;

          if mousein(this_button^.xpos+dlg^.x1+xofs,this_button^.ypos+dlg^.y1+yofs,
                     this_button^.xpos+dlg^.x1+this_button^.btext.length shl 3+6+xofs+w,
                     this_button^.ypos+dlg^.y1+16+yofs+h) then
          Begin
            if (this_button^.state = 0 ) and (this_button^.enabled) then
             this_button^.state := 1;
            if this_button^.enabled then draw_button(dlg,this_button);
            if this_button^.state=1 then
              Begin
                delay(100);
                dlg^.cur_button := this_button;
                execute_procedure(this_button^.funcnum);
                repeat handlemouse until not(leftmousekeypressed);
                exit;
              end;
            delay(100);
          end;
        end;
       this_button := this_button^.next;
     end;
   this_data := dlg^.first_data;
   while this_data<>nil do
     Begin
       with this_data^ do
        Begin
          if mousein(this_data^.x1+dlg^.x1+xofs,
                     this_data^.y1+dlg^.y1+yofs,
                     this_data^.x2+dlg^.x1+xofs,
                     this_data^.y2+dlg^.y1+yofs) then
                     Begin
                       setcursor(dlg,this_data);
                       drawcursor(dlg);
                       if this_data^.funcnum>0 then
                         Begin
                           dlg^.cur_data := this_data;
                           execute_procedure(this_data^.funcnum);
                           exit;
                         end;
                      end;
        end;
       this_data := this_data^.next;
     end;
   this_sb:= dlg^.first_sb;
   while this_sb<>nil do
     Begin
       if (this_sb<>dlg^.horz_sb) and (this_sb<>dlg^.vert_sb) then
       with this_sb^ do
        Begin
          if mousein(this_sb^.xpos+dlg^.x1+xofs,this_sb^.ypos+dlg^.y1+yofs,
                     this_sb^.xpos1+dlg^.x1+xofs,this_sb^.ypos1+dlg^.y1+yofs) and
            (this_sb^.min<this_sb^.max) then
          Begin
            Assign_PixPos(dlg,this_sb);
            case this_sb^.horv of
             HORZ : Begin
                      changed := true;
                      sb_info[1].x1 := this_sb^.xpos+dlg^.x1+xofs;
                      sb_info[1].y1 := this_sb^.ypos+dlg^.y1+yofs;
                      sb_info[1].x2 := sb_info[1].x1+13;
                      sb_info[1].y2 := sb_info[1].y1+11;
                      sb_info[4].x1 := this_sb^.xpos1+dlg^.x1-13+xofs;
                      sb_info[4].y1 := this_sb^.ypos1+dlg^.y1-11+yofs;
                      sb_info[4].x2 := sb_info[4].x1+13;
                      sb_info[4].y2 := sb_info[4].y1+11;
                      sb_info[2].x1 := sb_info[1].x2+1;
                      sb_info[2].y1 := sb_info[1].y1;
                      sb_info[2].x2 := this_sb^.curpixpos+xofs;
                      sb_info[2].y2 := sb_info[1].y2;
                      sb_info[3].x1 := sb_info[2].x2+13;
                      sb_info[3].y1 := sb_info[1].y1;
                      sb_info[3].x2 := sb_info[4].x1-1;
                      sb_info[3].y2 := sb_info[1].y2;
                    end;
             VERT : Begin
                      sb_info[1].x1 := this_sb^.xpos+dlg^.x1+xofs;
                      sb_info[1].y1 := this_sb^.ypos+dlg^.y1+yofs;
                      sb_info[1].x2 := sb_info[1].x1+11;
                      sb_info[1].y2 := sb_info[1].y1+13;
                      sb_info[4].x1 := this_sb^.xpos1+dlg^.x1-11+xofs;
                      sb_info[4].y1 := this_sb^.ypos1+dlg^.y1-13+yofs;
                      sb_info[4].x2 := sb_info[4].x1+11;
                      sb_info[4].y2 := sb_info[4].y1+13;
                      sb_info[2].x1 := sb_info[1].x1;
                      sb_info[2].y1 := sb_info[1].y2+1;
                      sb_info[2].x2 := sb_info[1].x2;
                      sb_info[2].y2 := this_sb^.curpixpos+yofs;
                      sb_info[3].x1 := sb_info[1].x1;
                      sb_info[3].y1 := sb_info[2].y2+13;
                      sb_info[3].x2 := sb_info[1].x2;
                      sb_info[3].y2 := sb_info[4].y1-1;
                      changed := true;
                   end;
            end;
            if mousein(sb_info[1].x1,sb_info[1].y1,
                       sb_info[1].x2,sb_info[1].y2) then
                        Begin
                          dec(this_sb^.curpos,this_sb^.step);
                          while (this_sb^.curpos<this_sb^.min) do inc(this_sb^.curpos);
                          draw_scrollbar(dlg,this_sb);
                          if (this_sb^.funcnum>0) then
                           Begin
                             cur_dialog^.cur_sb := this_sb;
                             execute_procedure(this_sb^.funcnum);
                             exit;
                           end;
                        end else
            if mousein(sb_info[4].x1,sb_info[4].y1,
                       sb_info[4].x2,sb_info[4].y2) then
                        Begin
                          inc(this_sb^.curpos,this_sb^.step);
                          while (this_sb^.curpos>this_sb^.max) do dec(this_sb^.curpos);
                          draw_scrollbar(dlg,this_sb);
                          if (this_sb^.funcnum>0) then
                           Begin
                             cur_dialog^.cur_sb := this_sb;
                             execute_procedure(this_sb^.funcnum);
                             exit;
                           end;
                        end else
            if mousein(sb_info[2].x1,sb_info[2].y1,
                       sb_info[2].x2,sb_info[2].y2) then
                        Begin
                          dec(this_sb^.curpos,this_sb^.jump);
                          while (this_sb^.curpos<this_sb^.min) do inc(this_sb^.curpos);
                          draw_scrollbar(dlg,this_sb);
                          if (this_sb^.funcnum>0) then
                           Begin
                             cur_dialog^.cur_sb := this_sb;
                             execute_procedure(this_sb^.funcnum);
                             exit;
                           end;
                        end else
            if mousein(sb_info[3].x1,sb_info[3].y1,
                       sb_info[3].x2,sb_info[3].y2) then
                        Begin
                          inc(this_sb^.curpos,this_sb^.jump);
                          while (this_sb^.curpos>this_sb^.max) do dec(this_sb^.curpos);
                          draw_scrollbar(dlg,this_sb);
                          if (this_sb^.funcnum>0) then
                           Begin
                             cur_dialog^.cur_sb := this_sb;
                             execute_procedure(this_sb^.funcnum);
                             exit;
                           end;
                        end;
          end;
        end;
       this_sb:= this_sb^.next;
     end;
   lbchanged := false;
   this_lb := dlg^.first_lb;
   while this_lb<>nil do
     Begin
       if (this_lb^.horz_sb<>nil) then
           if (this_lb^.horz_sb^.changed) then lbchanged := true;
       if (this_lb^.vert_sb<>nil) then
           if (this_lb^.vert_sb^.changed) then lbchanged := true;

       if lbchanged then draw_listbox(dlg,this_lb,false);
       lbchanged := false;
       this_lb := this_lb^.next;
     end;
  this_cb := dlg^.first_cb;
  while this_cb<>nil do
    Begin
      if mousein(this_cb^.xpos+x1+xofs,this_cb^.ypos+y1+yofs,this_cb^.xpos+14+x1+(this_cb^.data.length shl 3)+xofs,
                 this_cb^.ypos+12+y1+yofs) then
        if (this_cb^.enabled) then
        Begin
          this_cb^.selected := not(this_cb^.selected);
          hm;
          draw_checkbox(dlg,this_cb);
          sm;
          repeat until not(leftmousekeypressed);
          if (this_cb^.funcnum>0) then
            Begin
              dlg^.cur_cb := this_cb;
              Execute_Procedure(this_cb^.funcnum);
              exit;
            end;
        end else
        Begin
          repeat until not(leftmousekeypressed);
          if (this_cb^.funcnum>0) then
            Begin
              dlg^.cur_cb := this_cb;
              Execute_Procedure(this_cb^.funcnum);
              exit;
            end;
         end;
       this_cb := this_cb^.next;
    end;
  this_text := dlg^.first_text;
  while this_text<>nil do
    Begin
      if mousein(this_text^.xpos+x1+xofs,
                 this_text^.ypos+y1+yofs,
                 this_text^.xpos+x1+(length(this_text^.textdata) shl 3)+xofs,
                 this_text^.ypos+8+y1+yofs) then
          if (this_text^.funcnum>0) then
            Begin
              cur_dialog^.cur_text := this_text;
              Execute_Procedure(this_text^.funcnum);
              exit;
            end;
      this_text := this_text^.next;
    end;
  if mousein(cur_dialog^.x1,cur_dialog^.y1,cur_dialog^.x2,cur_dialog^.y2) and (cur_dialog^.inclientfunct>0) then
     Begin
       execute_procedure(cur_dialog^.inclientfunct);
       exit;
     end;
  end;
end;

Function Set_Menu_Item_Highlights(dlg:handle_dialog;this:ml;execute:boolean):boolean;
var
  xp,yp,mx1,my1,mx2,my2 : integer;
  changed : boolean;
  m,hl : handle_menu_item;
  adjust : byte;
begin
  if dlg=nil then exit;
  hl := nil;
  changed := false;
  if length(dlg^.name)=0 then adjust := 7 else adjust := 25;
  set_menu_item_highlights := false;
  if not(dlg^.pu_present) then exit;
     if this^.highlight then
      Begin
        xp := dlg^.xpos+this^.xpos1;
        yp := dlg^.ypos+adjust+12;
        mx1 := xp;
        my1 := yp;
        mx2 := this^.width+mx1;
        my2 := my1+12;
        m := this^.first_item;
        while (m<>nil) do
        Begin
          if mousein(mx1,my1,mx2,my2-1) then
             Begin
                 if not(m^.highlight) then changed := true;
                 m^.highlight := true;
                 hl := m;
             end else
             Begin
               if (m^.highlight) then changed := true;
               m^.highlight := false;
             end;
          inc(my1,12);
          inc(my2,12);
          m := m^.next;
        end;
      end;
    if (changed) then set_menu_item_highlights := true;
    if (execute) and (hl<>nil) then
       if (hl^.funcnum>0) then
       Begin
         restorebox(dlg);
         execute_procedure(hl^.funcnum);
         exit;
       end;
end;

Procedure HandleMenuBar(execute:boolean);
var
 mthis : ml;
 changed : boolean;
 v : boolean;
 hlmenu : ml;
 adjust : byte;
Begin
 if cur_dialog=nil then exit;
 hlmenu := nil;
 changed := false;
 with cur_dialog^ do
   Begin
     if first_menu<>nil then
       {On Menu Bar}
       if length(name)=0 then adjust := 7 else adjust := 25;
       if mousein(xpos,ypos+adjust-5{20},xpos1,ypos+adjust+10{35}) then
         Begin
           mthis := cur_dialog^.first_menu;
           while (mthis<>nil) do
             Begin
               if mousein(mthis^.xpos1+cur_dialog^.xpos,cur_dialog^.ypos+adjust-5,
                          mthis^.xpos2-10+cur_dialog^.xpos,cur_dialog^.ypos+adjust+10) then
               Begin
                 if not(mthis^.highlight) then changed := true;
                 hlmenu := mthis;
                 mthis^.highlight := true
               end else
               Begin
                 if (mthis^.highlight) then changed := true;
                 mthis^.highlight := false;
               end;
               mthis := mthis^.next;
             end;
           if changed then draw_highlight_menu(cur_dialog,true);
         end else
         Begin {We're not on the menu box}
           if (pu_present) then
            Begin
              if not mousein(pu_xpos,pu_ypos-15,pu_xpos1,pu_ypos1) then
                Begin
                  hm;
                   changed := false;
                   restorebox(cur_dialog);
                   mthis := first_menu;
                   while mthis<>nil do
                     Begin
                       if mthis^.highlight then
                         Begin
                           mthis^.highlight := false;
                           changed := true;
                         end;
                       mthis := mthis^.next;
                     end;
                     if (changed) then draw_highlight_menu(cur_dialog,true);
                  sm;
                end;
             end else
             Begin
               changed := false;
               mthis := first_menu;
               while mthis<>nil do
               Begin
                 if mthis^.highlight then
                 Begin
                   mthis^.highlight := false;
                   changed := true;
                 end;
                 mthis := mthis^.next;
               end;
               if (changed) then draw_highlight_menu(cur_dialog,true);
             end;
         end;
   end;

  if not(changed) then
    Begin
      hlmenu := cur_dialog^.first_menu;
      while (hlmenu<>nil) do
       Begin
         if hlmenu^.highlight then
          Begin
            v := set_menu_item_highlights(cur_dialog,hlmenu,execute);
            if (v) then draw_popup_text(cur_dialog,hlmenu);
          end;
         hlmenu := hlmenu^.next;
       end;
    end;
end;


Procedure HandleLeftmousekey;
var
 this,this2 : handle_dialog;
 hline : array[1..2,0..1024] of byte;
 vline : array[1..2,0..1024] of byte;
 x,y : integer;
 ax1,ay1 : integer;
 ax2,ay2 : integer;
 saved : boolean;

Procedure savexy;
var lx,ly : integer;
Begin
 while (ax2>clipx2) do
   Begin dec(ax2); dec(ax1); end;
 while (ax1<clipx1) do
   Begin inc(ax1); inc(ax2); end;
 while (ay2>clipy2) do
   Begin dec(ay2); dec(ay1); end;
 while (ay1<clipy1) do
   Begin inc(ay1); inc(ay2); end;
 hm;
 for lx := ax1 to ax2 do
   Begin
     hline[1,lx] := vget(lx,ay1);
     hline[2,lx] := vget(lx,ay2);
   end;
 for ly := ay1 to ay2 do
   Begin
     vline[1,ly] := vget(ax1,ly);
     vline[2,ly] := vget(ax2,ly);
   end;
 saved := true;
 sm;
end;

Procedure restorexy;
var lx,ly : integer;
Begin
 hm;
 if not(saved) then exit;
 for lx := ax1 to ax2 do
   Begin
     vplot(lx,ay1,hline[1,lx]);
     vplot(lx,ay2,hline[2,lx]);
   end;
 for ly := ay1 to ay2 do
   Begin
     vplot(ax1,ly,vline[1,ly]);
     vplot(ax2,ly,vline[2,ly]);
   end;
 sm;
end;

Begin
  if cur_dialog=nil then exit;
  set_client_offset(cur_dialog);
  ax1 := cur_dialog^.xpos;
  ay1 := cur_dialog^.ypos;
  ax2 := cur_dialog^.xpos1;
  ay2 := cur_dialog^.ypos1;
  x := mousex shr 1;
  y := mousey;
  saved := false;
  with (cur_dialog^) do
  if (pu_present) and (mousein(pu_xpos,pu_ypos,pu_xpos1,pu_ypos1)) then
   Handlemenubar(true) else

   with (cur_dialog^) do
     if not(mousein(xpos,ypos,xpos1,ypos1)) then
      Begin
        if bitset(cur_dialog^.flags,modal) then
        Begin
        this := last_dialog;
        while (this<>nil) do
           with this^ do
             Begin
               if mousein(xpos,ypos,xpos1,ypos1) then
                 Begin
                   if not(active) then
                     Begin
                       hm;
                       this2 := last_dialog;
                       while (this2<>nil) do
                         Begin
                           if (this2<>this) and (this2^.active) then
                             Begin
                               this2^.active := false;
                               if length(this2^.name)>0 then title_bar(this2);
                             end;
                           this2 := this2^.prev;
                         end;
                       active := true;
                       cur_dialog := this;
                       draw_dialog(this);
                       count := 0;
                       repeat until not(leftmousekeypressed);
                       sm;
                       exit;
                     end;
           end;
        this := this^.prev;
       end;
      end else
        Begin
          inc(count);
          if (count>1) then
           Begin
             sound(750);
             delay(50);
             nosound;
             repeat handlemouse; until not leftmousekeypressed;
           end else
          repeat handlemouse; until not leftmousekeypressed;
        end;
   end else
    Begin
      clipset(0,0,maxx,maxy);
      if (mousein(xpos+20,ypos,xpos1-55,ypos+20)) and (bitset(flags,moveable)) then
        Begin
          repeat
            handlemouse;
            restorexy;
            inc(ax1,(mousex shr 1)-x);
            inc(ax2,(mousex shr 1)-x);
            inc(ay1,(mousey)-y);
            inc(ay2,(mousey)-y);
            x := mousex shr 1;
            y := mousey;
            savexy;
            box(ax1,ay1,ax2,ay2,white);
          until not(leftmousekeypressed);
          hm;
          fill(xpos,ypos,xpos1,ypos1,background_color);
          windowclip(xpos,ypos,xpos1,ypos1);
          x1 := x1 - (xpos-ax1);
          y1 := y1 - (ypos-ay1);
          x2 := x2 - (xpos-ax1);
          y2 := y2 - (ypos-ay1);
          xpos := ax1;
          ypos := ay1;
          xpos1 := ax2;
          ypos1 := ay2;
          usewindowclip := true;
          redraw_all(true);
        end else
       if (mousein(xpos1-2,ypos,xpos1,ypos1-3)) and (bitset(flags,sizeable)) then
        Begin
          repeat
            handlemouse;
            restorexy;
            inc(ax2,(mousex shr 1)-x);
            x := mousex shr 1;
            y := mousey;
            savexy;
            if (leftmousekeypressed) then box(ax1,ay1,ax2,ay2,white);
          until not(leftmousekeypressed);
          hm;
          fill(xpos,ypos,xpos1,ypos1,background_color);
          windowclip(xpos,ypos,xpos1,ypos1);
          x2 := x2 - (xpos1-ax2);
          xpos1 := ax2;
          usewindowclip := true;
          set_dialog_scrollbars(cur_dialog);
          redraw_all(true);
        end else
       if (mousein(xpos1-2,ypos1-2,xpos1,ypos1)) and (bitset(flags,sizeable)) then
        Begin
          repeat
            handlemouse;
            restorexy;
            inc(ax2,(mousex shr 1)-x);
            inc(ay2,(mousey-y));
            x := mousex shr 1;
            y := mousey;
            savexy;
            if (leftmousekeypressed) then box(ax1,ay1,ax2,ay2,white);
          until not(leftmousekeypressed);
          hm;
          fill(xpos,ypos,xpos1,ypos1,background_color);
          windowclip(xpos,ypos,xpos1,ypos1);
          x2 := x2 - (xpos1-ax2);
          y2 := y2 - (ypos1-ay2);
          xpos1 := ax2;
          ypos1 := ay2;
          usewindowclip := true;
          set_dialog_scrollbars(cur_dialog);
          redraw_all(true);
        end else
       if (mousein(xpos,ypos1-2,xpos1,ypos1)) and (bitset(flags,sizeable)) then
        Begin
          repeat
            handlemouse;
            restorexy;
            inc(ay2,(mousey-y));
            x := mousex shr 1;
            y := mousey;
            savexy;
            if (leftmousekeypressed) then box(ax1,ay1,ax2,ay2,white);
          until not(leftmousekeypressed);
          hm;
          fill(xpos,ypos,xpos1,ypos1,background_color);
          windowclip(xpos,ypos,xpos1,ypos1);
          y2 := y2 - (ypos1-ay2);
          ypos1 := ay2;
          usewindowclip := true;
          set_dialog_scrollbars(cur_dialog);
          redraw_all(true);
       end else ProcessMouseKey(cur_dialog);
    end;
end;

Procedure Handle_Keyboard;
var
  this : handle_accelerator;
  efunct : longint;
Begin
  if cur_dialog=nil then exit;
  if (keypress) then
   Begin
     this := cur_dialog^.first_accelerator;
     while (this<>nil) do
      Begin
        if (keystroke[this^.functionkey]) and (keystroke[this^.character]) and
           (this^.funcnum>0) then
             Begin
               while keypressed do readkey;
               execute_procedure(this^.funcnum);
               repeat until not(keypress);
               exit;
             end;
        this := this^.next;
      end;
      efunct := 0;
      if (keystroke[alt]) then
        Begin
          if (keystroke[F4]) then
            Begin
              repeat until not keystroke[F4];
              if cur_dialog^.close_func>0 then efunct := cur_dialog^.close_func else
              standard_close(true);
            end else
          if (keystroke[TAB]) and (bitset(cur_dialog^.flags,MODAL)) then
            Begin
              if keystroke[LSHIFT] then
                Begin
                  cur_dialog := cur_dialog^.next;
                  if cur_dialog=nil then cur_dialog := first_dialog;
                  if cur_dialog<>nil then setactive(cur_dialog^.id);
                end else
                Begin
                  cur_dialog := cur_dialog^.prev;
                  if cur_dialog=nil then cur_dialog := last_dialog;
                  if cur_dialog<>nil then setactive(cur_dialog^.id);
                end;
              repeat until not keystroke[TAB];
            end;
        end else
      if (keystroke[ctrl]) then
        Begin
          {ESC brings up Task List}
        end else
        Begin
          if (keystroke[F1]) and (cur_dialog^.help_func>0) then efunct := cur_dialog^.help_func;
          {if (keystroke[F10]) and (cur_dialog^.close_func>0) then efunct := cur_dialog^.close_func;}
        end;
      if efunct>0 then
        Begin
          while keypressed do readkey;
          execute_procedure(efunct);
        end;
   end;
end;

Procedure EraseCursor(dlg:handle_dialog);
var
 cx,cy : integer;
Begin
  if (dlg=nil) then exit;
  if (dlg^.cur_data=nil) then exit;
  if not(dlg^.cursorvisible) then exit;
  Set_Client_Offset(dlg);
  vputrect(@cursor,dlg^.cursorx,dlg^.cursory,1,8,1,copy_put);
  dlg^.cursorvisible := false;
end;

Procedure DrawCursor(dlg:handle_dialog);
var
 cx,cy : integer;
 sl,fw : word;
Begin
  if (dlg=nil) then exit;
  if (dlg^.cur_data=nil) then exit;
  if not(dlg^.cursorvisible) then exit;
  Set_Client_Offset(dlg);
  erasecursor(dlg);
  dlg^.cursorvisible := true;

  cx := dlg^.cur_Data^.x1+dlg^.x1+xofs+2;
  cy := dlg^.cur_data^.y1+dlg^.y1+1+yofs+1;

  sl := dlg^.cur_data^.data.length;
  fw := dlg^.cur_data^.fieldwidth;

  while (sl>fw) do
   Begin
     inc(cy,9);
     dec(sl,fw);
   end;
  if (sl>0) then inc(cx,sl shl 3 + 2);

  with dlg^ do
    Begin
      vgetrect(@cursor,cx,cy,1,8,1);
      vrline(cy,cy+7,cx,random(16));
      cursorx := cx;
      cursory := cy;
    end;
end;

Procedure SetCursor(dlg:handle_dialog;data:handle_data);
var
 x1,y1 : integer;
 fw : word;
 sl : word;
Begin
  if (dlg=nil) then exit;
  if (data=nil) then exit;

  if (dlg^.cursorvisible) then erasecursor(dlg);

  Set_Client_Offset(dlg);
  x1 := data^.x1+dlg^.x1+xofs+2;
  y1 := data^.y1+dlg^.y1+1+yofs+1;

  sl := data^.data.length;
  fw := data^.fieldwidth;

  dlg^.cur_data := data;
  dlg^.cursorx := x1;
  dlg^.cursory := y1;
  while (sl>fw) do
   Begin
     inc(dlg^.cursory,9);
     dec(sl,fw);
   end;
  if (sl>0) then inc(dlg^.cursorx,sl shl 3);
  drawcursor(dlg);
  dlg^.cursorvisible := true;
end;

Procedure SetFilter(ft:byte);
Begin
 case ft of
   String_Field            : filter := strfilter;
   Phone_Field             : filter := numfilter;
   Amount_Field            : filter := amountfilter;
   Credit_Card_Field       : filter := creditfilter;
   Time_Field              : filter := timefilter;
   Date_Field              : filter := datefilter;
   Password_Field          : filter := strfilter;
   Character_Field         : filter := strfilter;
   Byte_Field              : filter := numfilter;
   Integer_Field           : filter := numfilter;
   Word_Field              : filter := numfilter;
   Real_Field              : filter := realfilter;
   Credit_Expiration_Field : filter := datefilter;
   Account_Field           : filter := numfilter;
 end;
end;

Function FormatAmount(s:string):string;
Procedure strip(var s:string;c:char);
begin
  while pos(c,s)>0 do delete(s,pos(c,s),1);
end;
Begin
  strip(s,'$');
  strip(s,'.');
  strip(s,' ');
  s := lpad(s,length(s));
  s := '$'+s;
  insert('.',s,length(s)-1);
  formatamount := rpad(s,length(s));
end;

Procedure FormatText(dlg:handle_dialog;d:handle_data);
var
 s,s2 : string;
 dt : byte;
Begin
  if (d^.fieldtype=DB_EDIT) then dt := d^.db_ftype else dt := d^.fieldtype;
  s := d^.data.pstr;
  s2 := '';
  case dt of
     PHONE_FIELD : Begin
                     if (length(s)=0) then s2 := s + '(303)' else
                     if (length(s)=4) then s2 := s + ')' else
                     if (length(s)=8) then s2 := s + '-';
                   end;
     DATE_FIELD : if (length(s) in [2,5]) then s2 := s + '/';
     TIME_FIELD : if (length(s) in [2,5]) then s2 := s + ':';
     CREDIT_CARD_FIELD : if (length(s) in [6,11,16]) then s2 := s + '-';
     CREDIT_EXPIRATION_FIELD : if (length(s) = 2) then s2 := s + '/';
     AMOUNT_FIELD : Begin
                      s2 := rpad(formatamount(s),d^.maxlength);
                      if (s2=s) then s2:='';
                    end;
     ACCOUNT_FIELD : if (length(s)=3) then s2 := s + '-';
  end;
 if (s2<>'') then
    Begin
      dlg^.cur_data^.data.done;
      dlg^.cur_data^.data.init(dlg^.cur_data^.maxlength);
      dlg^.cur_data^.data.addstring(s2);
      draw_data(dlg,dlg^.cur_data);
    end;
end;

Procedure HandleCharErase(dlg:handle_dialog;d:handle_data);
var
 dt : byte;
Begin
  if (d^.fieldtype=DB_EDIT) then dt := d^.db_ftype else dt := d^.fieldtype;
  case (dt) of
      Date_Field,
      Time_Field  : if (d^.data.length in [2,5]) then d^.data.deletechar;
      Phone_Field : if (d^.data.length in [4,8]) then d^.data.deletechar;
      Credit_Card_Field : if (d^.data.length in [6,11,16]) then d^.data.deletechar;
      Credit_Expiration_Field : if (d^.data.length = 2) then d^.data.deletechar;
      Account_Field : if (d^.data.length=3) then d^.data.deletechar;
  end;
end;

Procedure HandleEditControl(dlg:handle_dialog);
var
 ch : char;
 dt : byte;
 s,s2 : string;
Begin
  if (dlg=nil) then exit;
  if (dlg^.cur_data=nil) then exit;
  drawcursor(dlg);
  if (dlg^.cur_data^.fieldtype=DB_TEXT) then exit;
  if (dlg^.cur_data^.fieldtype=DB_EDIT) then dt := dlg^.cur_data^.db_ftype
     else dt := dlg^.cur_data^.fieldtype;

  formattext(dlg,dlg^.cur_data);
  if not(keypressed) then exit;
  ch := upcase(readkey);
  if ch=#0 then
    Begin
      ch := readkey;
      case (ch) of
        #15,chr(uarrow),
        chr(larrow) {Shift-Tab} : Begin
                            if dlg^.cur_data^.funcnum>0 then
                                execute_procedure(dlg^.cur_data^.funcnum);
                            repeat
                              dlg^.cur_data := dlg^.cur_data^.prev;
                            until (dlg^.cur_data=nil) or (dlg^.cur_data^.fieldtype<>DB_TEXT);
                            if (dlg^.cur_data=nil) then
                              Begin
                                dlg^.cur_data := dlg^.last_data;
                                if (dlg^.cur_data^.fieldtype=DB_TEXT) then
                                  repeat
                                  dlg^.cur_data := dlg^.cur_data^.prev;
                                until (dlg^.cur_data=nil) or (dlg^.cur_data^.fieldtype<>DB_TEXT);
                              end;
                          end;
        chr(darrow),
        chr(rarrow) :    Begin
                           if dlg^.cur_data^.funcnum>0 then
                               execute_procedure(dlg^.cur_data^.funcnum);
                           dlg^.cur_data := dlg^.cur_data^.next;
                           if (dlg^.cur_data=nil) then dlg^.cur_data := dlg^.first_data;
                         end;
      end;
     erasecursor(dlg);
     setcursor(dlg,dlg^.cur_data);
     drawcursor(dlg);
    end else
    begin
      case (ch) of
        #8 {Backspace} : Begin
                           dlg^.cur_data^.data.deletechar;
                           handlecharerase(dlg,dlg^.cur_data);
                           draw_data(dlg,dlg^.cur_data);
                         end;
        #9,#13 {Tab}
               {Enter} : Begin
                           if dlg^.cur_data^.funcnum>0 then
                               execute_procedure(dlg^.cur_data^.funcnum);
                           repeat
                             dlg^.cur_data := dlg^.cur_data^.next;
                           until (dlg^.cur_data=nil) or (dlg^.cur_data^.fieldtype<>DB_TEXT);
                           if (dlg^.cur_data=nil) then
                             Begin
                               dlg^.cur_data := dlg^.first_data;
                                if (dlg^.cur_data^.fieldtype=DB_TEXT) then
                                  repeat
                                  dlg^.cur_data := dlg^.cur_data^.next;
                                until (dlg^.cur_data=nil) or (dlg^.cur_data^.fieldtype<>DB_TEXT);
                             end;
                         end;
        else  Begin
                if (dlg^.cur_data^.fieldtype=DB_EDIT) then
                setfilter(dlg^.cur_data^.db_ftype) else
                setfilter(dlg^.cur_data^.fieldtype);
                if (ch in filter) then
                Begin
                  case dt of
                    Amount_Field : Begin
                                     s := dlg^.cur_data^.data.pstr;
                                     strip(s,' ');
                                     if length(s)<dlg^.cur_data^.maxlength then
                                       Begin
                                         s := s + ch;
                                         dlg^.cur_data^.data.done;
                                         dlg^.cur_data^.data.init(dlg^.cur_data^.maxlength);
                                         dlg^.cur_data^.data.addstring(rpad(formatamount(s),dlg^.cur_data^.maxlength));
                                       end else
                                       Begin
                                         sound(750);
                                         delay(10);
                                         nosound;
                                       end;
                                   end;
                    else dlg^.cur_data^.data.insertchar(ch);
                  end;
                 draw_data(dlg,dlg^.cur_data);
                end else
                Begin
                  sound(750);
                  delay(10);
                  nosound;
                end;
            end;
      end;
      erasecursor(dlg);
      setcursor(dlg,dlg^.cur_data);
      drawcursor(dlg);
    end;

end;

Procedure HandleButtonHighlight(dlg:handle_dialog);
var
 this : handle_button;
Begin
 this := dlg^.first_button;
 while (this<>nil) do
   Begin
     if this^.state=1 then
        Begin
          this^.state := 0;
          draw_button(dlg,this);
        end;
     this := this^.next;
   end;
end;

Procedure HandleClients;
var
 this : handle_client;
Begin
  if cur_dialog=nil then exit;
  this := cur_dialog^.first_client;
  while this<>nil do
    Begin
      if (timercounter>this^.nexttime) then
        Begin
          draw_client(cur_dialog,this);
          this^.nexttime := this^.speed+timercounter;
        end;
      this := this^.next;
    end;
end;

Procedure HandleCallbacks;
var
 this : handle_callback;
Begin
  if cur_dialog=nil then exit;
  this := cur_dialog^.first_callback;
  while this<>nil do
    Begin
      if (timercounter>this^.nexttime) then
        Begin
          execute_procedure(this^.funcnum);
          this^.nexttime := this^.speed+timercounter;
        end;
      this := this^.next;
    end;
end;

Procedure HandleDesktopCallbacks;
var
 this : handle_callback;
Begin
  this := first_callback;
  while this<>nil do
    Begin
      if (timercounter>this^.nexttime) then
        Begin
          execute_procedure(this^.funcnum);
          this^.nexttime := this^.speed+timercounter;
        end;
      this := this^.next;
    end;
end;



Procedure DialogMouseRoutine;
var
 mthis : ml;
 mx : integer;
 my : integer;
 changed : boolean;
 lmk,rmk : boolean;

Begin
 changed := false;
 handlemouse;
 lmk := leftmousekeypressed;
 rmk := rightmousekeypressed;

 if (first_dialog=nil) then fatal_error(1);
 if cur_dialog=nil then exit;

 reorder_windows;

 setclip(cur_dialog);

 if (cur_dialog<>nil) then
   Begin
     handlemenubar(false);
     if not(cur_dialog^.pu_present) then handle_keyboard;
     if not(cur_dialog^.pu_present) then handleeditcontrol(cur_dialog);
     if not(cur_dialog^.pu_present) then handlelistboxselection;
     if not(cur_dialog^.pu_present) then handlebuttonhighlight(cur_dialog);
     handleclients;
     handlecallbacks;
   end;
 handledesktopcallbacks;
 if lmk then handleleftmousekey;
end;

Procedure SetActive(id:longint);
var
 this,this2 : handle_dialog;
Begin
 if (cur_dialog<>nil) then erasecursor(cur_dialog);
 reorder_windows;
 count := 0;
 this := first_dialog;
 while (this<>nil) do
   Begin
     if this^.id=id then
      Begin
        cur_dialog := this;
        this^.active := true;
        this2 := first_dialog;
         while (this2<>nil) do
          Begin
            if (this2<>this) and (this2^.active) then
             Begin
               this2^.active := false;
               if length(this2^.name)>0 then title_bar(this2);
             end;
               this2 := this2^.next;
          end;
        this^.z := 255;
        reorder_windows;
        draw_dialog(this);
        if (this^.cur_data)<>nil then setcursor(this,this^.cur_data) else
          if (this^.first_data)<>nil then setcursor(this,this^.first_data) else
           Begin
             this^.cur_data := nil;
             this^.cursorvisible := false;
           end;
        exit;
      end;
     this := this^.next;
   end;
 if read_resource(id) then setactive(id);
end;

Procedure Message_Box(title,message:string;flags:byte;b1,b2:longint);
var
 x,y : integer;
 id : longint;
 s1,s2,s3,s4 : string[40];
 xp : integer;
 cnum : longint;
Begin
 cnum := b1;
 inc(mbox);
 s1 := message;
 s2 := '';
 s3 := '';
 s4 := '';
 if length(message)<40 then message := '';
 if length(message)>40 then
   Begin
     delete(message,1,40);
     if length(message)>40 then
      Begin
        s2 := message;
        delete(message,1,40);
     if length(message)>40 then
        Begin
          s3 := message;
          delete(message,1,40);
       if length(message)>40 then
          Begin
            s4 := message;
            delete(message,1,40);
          end;
        end;
      end;
    end;
 if length (message)>0 then
  Begin
    if length(s2)=0 then s2 := message else
    if length(s3)=0 then s3 := message else
    if length(s4)=0 then s4 := message;
  end;
 create_dialog(mbox,title,maxx shr 1-165,maxy shr 1-60,maxx shr 1+164,maxy shr 1+60,standard_dialog,
               moveable+help_button,0,0,0,0,0,0,0,0,0);
 add_text(mbox,cur_dialog,2,10,s1,0);
 if length(s2)>0 then add_text(mbox,cur_dialog,2,20,s2,0);
 if length(s3)>0 then add_text(mbox,cur_dialog,2,30,s3,0);
 if length(s4)>0 then add_text(mbox,cur_dialog,2,40,s4,0);

 xp := 230;
 if (flags and REBOOT_BUTTON)=REBOOT_BUTTON then
   Begin
     add_button(mbox,cur_dialog,xp,70,0,'&REBOOT',0,true,RES_REBOOT);
     add_accelerator(mbox,cur_dialog,alt,rkey,res_reboot);
     inc(xp,60);
   end;

 if (flags and YES)=YES then
   Begin
     add_button(mbox,cur_dialog,xp,70,0,'&YES',0,true,cnum);
     add_accelerator(mbox,cur_dialog,alt,ykey,cnum);
     cnum := b2;
     inc(xp,38);
   end;

 if (flags and NO)=NO  then
   Begin
     add_button(mbox,cur_dialog,xp,70,0,'&NO',0,true,cnum);
     add_accelerator(mbox,cur_dialog,alt,nkey,cnum);
     cnum := b2;
     inc(xp,30);
   end;

 if (flags and OK)=OK  then
   Begin
     add_button(mbox,cur_dialog,xp,70,0,'&OK',0,true,cnum);
     add_accelerator(mbox,cur_dialog,alt,Okey,cnum);
     cnum := b2;
     inc(xp,30);
   end;
 if (flags and CANCEL)=CANCEL then
   Begin
     add_button(mbox,cur_dialog,xp,70,0,'&CANCEL',0,true,cnum);
     add_accelerator(mbox,cur_dialog,alt,Ckey,cnum);
   end;
 setactive(mbox);
end;

Function Lpad(s:string;x:integer):string;
begin
 if length(s)>x then delete(s,x+1,255);
 while length(s)<x do
   s := s + ' ';
lpad := s;
end;

Function Rpad(s:string;x:integer):string;
begin
 while length(s)<x do
   s := ' '+s;
rpad := s;
end;

Function Cpad(s:string;x:integer):string;
var
 sstart : integer;
 y : integer;
 s2 : string;
begin
 if length(s)>x then delete(s,x+1,length(s)-x);

 sstart := (x shr 1)-(length(s) shr 1)-1;

 s2 := '';

 for y := 1 to sstart do
 s2 := ' '+s2;

 s2 := s2 + s;
 while length(s2)<x do
   s2 := s2+' ';

cpad := s2;
end;

Begin
  {InstallTimerHandler;}
  Enable09Int;
  First_Callback  := nil; Last_Callback := nil; Cur_Callback := nil;
  First_Dialog := nil; Last_Dialog := nil; Cur_Dialog := nil;
  dialog_id := 0;
  mbox := 65000;
  Background_Color := 18;
  Border_Color1    := White;
  Border_Color2    := DarkGray;
  Border_Color3    := Black;
  Menu_Color       := LightGray;
  Title_Color      := Black;
  Active_Title_Bar_Color   := LightGray;
  Disabled_Title_Bar_Color := DarkGray;
  Minimize_Color  := LightGray;
  Maximize_Color  := LightGray;
  Client_Background_Color := Blue;
  Client_Text_Color := Yellow;
  Close_Color    := LightGray;
  Scrollbar_Background := Active_Title_Bar_Color;
  Scrollbar_Border1   := Border_Color1;
  Scrollbar_Border2   := Border_Color2;
  Scrollbar_Text_Color:= Title_Color;
  Listbox_Border1     := Border_Color1;
  Listbox_Border2     := Border_Color2;
  Listbox_Background  := Active_Title_Bar_Color;
  ListBox_Text        := Title_Color;
  ListBox_Title       := Title_Color;
  CheckBox_Border1    := Border_Color1;
  CheckBox_Border2    := Border_Color2;
  CheckBox_Background := Active_Title_Bar_Color;
  Checkbox_Disabled   := Border_Color2;
  CheckBox_Text       := Client_Text_Color;
  Data_Border1        := Border_Color1;
  Data_Border2        := Border_Color2;
  Data_Background     := Active_Title_Bar_Color;
  Data_Text           := Title_Color;
  Menu_Border1        := Border_Color1;
  Menu_Border2        := Border_Color2;
  Menu_Background     := Active_Title_Bar_Color;
  Menu_Text           := Title_Color;
  Disabled_Menu       := Border_Color2;
  Popup_Border1       := Border_Color1;
  Popup_Border2       := Border_Color2;
  Popup_Background    := Active_Title_Bar_Color;
  Popup_Text          := Title_Color;
  Disabled_Popup      := Border_Color2;
  Button_Background   := Active_Title_Bar_Color;
  Button_Border1      := Border_Color1;
  Button_Border2      := Border_Color2;
  Button_Text         := Title_Color;
  Disabled_Button     := Border_Color2;
  curz := 0;
  count := 0;

  strfilter := [#32..#126];
  amountfilter := ['0'..'9','.','-'];
  datefilter := ['0'..'9'];
  charfilter := ['A'..'Z'];
  numfilter := ['0'..'9','-'];
  realfilter := ['0'..'9','.','-'];
  timefilter := ['0'..'9'];
  creditfilter := ['0'..'9','A'..'Z'];
end.
