Unit Routine;

Interface

Procedure Execute_Procedure(proc:longint);
Procedure PlayFlic;


var
 sb1d,SB1 : longint;
 grid : word;
 cb1,cb2,cb3 : longint;
 mode : byte;
 cb55:longint;
Implementation

Uses Crt,Dos,filer,fd_head,term,global,windows,
     resource,filedlg,colors,vesa,mouseu,skeld,
     desktop,heap,flplay,sysres,hdbf,constant;

Var
 did,tdid : longint;

{$I RECT.INC}
{$I ADDBTN.INC}

Procedure L_Resource;
var
 hdlg : handle_dialog;
Begin
  hdlg := get_handle_dialog(1);
  if load_resource(fd_frptr^.filename) then
    Begin
      if hdlg<>nil then hdlg^.name := fd_frptr^.filename;
      enable_button(115);
      enable_button(116);
      draw_dialog(hdlg);
    end else
    Begin
      message_box('Load Resource','Invalid Resource File!!!',OK,standard_close_dialog,0);
      if hdlg<>nil then hdlg^.name := 'Resource Editor';
    end;
end;

Procedure GetResInfo;
var
 f : file;
Begin
  if not(resource_loaded) then
    Begin
      sound(750);
      delay(100);
      nosound;
      exit;
    end;
  inc(mbox);
  Create_Dialog(mbox,'Resource Information',384,256,640,512,standard_dialog,
                      help_button+close_button+moveable+modal,0,0,0,0,0,0,0,0,0);
  inc(mbox);
  Add_ListBox(mbox,cur_dialog,'',20,15,236,216,unique_id,0,0,nil,0);
  Add_ListBox_Item(cur_dialog^.cur_lb,'ID : '+resource_header^.id,80,0);
  Add_ListBox_Item(cur_dialog^.cur_lb,'Major Version : '+itos(resource_header^.major_version),80,0);
  Add_ListBox_Item(cur_dialog^.cur_lb,'Minor Version : '+itos(resource_header^.minor_version),80,0);
  Add_ListBox_Item(cur_dialog^.cur_lb,'Preferred Mode : '+itos(resource_header^.mode),80,0);
  Add_ListBox_Item(cur_dialog^.cur_lb,'Serial Number : '+resource_header^.serialnum,80,0);
  Add_ListBox_Item(cur_dialog^.cur_lb,'Index Start : '+itos(resource_header^.index_start),80,0);
  Add_ListBox_Item(cur_dialog^.cur_lb,'Chunk Start : '+itos(resource_header^.chunk_start),80,0);
  Add_ListBox_Item(cur_dialog^.cur_lb,'Number of Chunks : '+itos(resource_header^.num_chunks),80,0);
  assign(f,resource_name);
  reset(f,1);
  Add_ListBox_Item(cur_dialog^.cur_lb,'Total Filesize : '+itos(filesize(f)),80,0);
  close(f);
  setactive(mbox-1);
end;

Procedure PlayFlic;
var
 hdlg : handle_dialog;
 uid : longint;
Begin
{  uid := unique_id;
  Create_Dialog(uid,'',(maxx shr 1)-163,(maxy shr 1)-103,(maxx shr 1)+163,(maxy shr 1)+103,
                standard_dialog,modal+moveable,0,0,0,0,0,0,0,0,0);
  Add_Client(unique_id,cur_dialog,0,0,320,200,1);
  setactive(uid);
  draw_dialog(cur_dialog);
  hdlg := get_handle_dialog(uid);
  if hdlg<>nil then PlayFli(MOVIEDIR+'TSP.FLI',hdlg,hdlg^.first_client);
  delay(2000);
  fadeout;
  setactive(uid);
  standard_close;}
  writebmp('TEST');
  soundoff;
end;


Procedure SelectResItem;
var
 x : integer;
 resid : longint;
Begin
  resid := unique_id;
  Create_Dialog(resid,'Select Resource Item',314,246,710,522,standard_dialog,
                help_button+close_button+moveable+modal,0,0,0,0,0,0,0,0,0);
  Add_ListBox(unique_id,cur_dialog,'',10,15,386,216,unique_id,unique_id,rc_selectres,nil,0);
  for x := 1 to 750 do
    if (Resource_Index^[x].ID=0) then
      Add_ListBox_Item(cur_dialog^.cur_lb,lpad('[#'+itos(x)+']',8)+' Unused',80,0) else
      Add_ListBox_Item(cur_dialog^.cur_lb,lpad('[#'+itos(x)+']',8)+lpad(itos(Resource_Index^[x].ID),12)+
                       '   '+lpad(resource_index^[x].filename,8)+'     '+lpad(resource_index^[x].title,60),255,
                       resource_index^[x].id);
  cb55 := unique_id;
  add_checkbox(cb55,cur_dialog,10,226,'Delete',true,false,0);
  setactive(resid);
end;

Procedure InsertIntoRes;
Begin
  if not(resource_loaded) then exit;
  message_box('Resource','Insert Dialog into Resource?',YES+NO,rc_addtores,standard_close_dialog);
end;

Procedure selectres;
var
 hdlg : handle_dialog;
 x : integer;
 okb : boolean;
Begin
  standard_close(true);
  okb := false;
  hdlg := get_handle_dialog(tdid);
  if hdlg<>nil then
   for x := 1 to 750 do
    if (resource_index^[x].id=0) or (resource_index^[x].id=hdlg^.id) then
    with resource_index^[x] do
    Begin
      okb := true;
      while (pos('\',fd_frptr^.filename)>0) do delete(fd_frptr^.filename,1,1);
      if (pos('.',fd_frptr^.filename)>0) then delete(fd_frptr^.filename,pos('.',fd_frptr^.filename),255);
      filename := fd_frptr^.filename;
      id := hdlg^.id;
      fileposition := 0;
      title := hdlg^.name;
      inc(resource_header^.num_chunks);
      exit;
    end;
  standard_close(true);
  if not(okb) then message_box('Resource Error','Unable to Insert Dialog into Resource',OK,standard_close_dialog,0);
end;

{$I CDLG.INC}

Procedure Import_DBS;
Begin
  fd_setsearch('*.DBS');
  openfile_dialog('Import DBS File',rcimport_dbsok,0);
  exit;
end;

Procedure Handle_New;
Begin
  case cur_dialog^.cur_lb^.cur_item^.ref of
    rc_newdialog : new_dialog;
    rcdbs_import : import_dbs;
    rc_addbtn : RCadd_button;
    rc_addlb : RCadd_listbox;
    rc_addhsb : RCAdd_HorzScrollbar;
    rc_addvsb : RCAdd_VertScrollbar;
    rc_adddata : RCAdd_Data;
    rc_addtext : RCAdd_Text;
    rc_addcheckbox : rcadd_checkbox;
    else  message_box('New Item','This feature has not been implemented',OK,standard_close_dialog,0);
  end;
end;

Procedure Delete_Dlg;
var
 hdlg : handle_dialog;
Begin
  hdlg := get_handle_dialog(tdid);
  if hdlg<>nil then close_dialog(hdlg);
  hdlg := get_handle_dialog(did);
  if hdlg<>nil then close_dialog(hdlg);
  refresh;
end;

{$I DBSIMP.INC}

Procedure Save_DlgOK;
Begin
  if not(Write_Dialog(fd_frptr^.filename,get_handle_dialog(tdid))) then
    message_box('Save Dialog','Error Saving Dialog to Disk!',ok,standard_close_dialog,0);
  execute_procedure(rc_insertintores);
end;

Procedure C_Resource;
Begin
  create_resource(RESOURCEDIR+'UNTITLED');
  enable_button(115);
  enable_button(116);
  setactive(1);
end;

Procedure Load_Dialog;
var
 nrid,rid : longint;
 hcb : handle_checkbox;
 x : integer;
Begin
  rid := cur_dialog^.cur_lb^.cur_item^.ref;
  if rid<=0 then exit;
  hcb := get_handle_checkbox(cb55);
  if hcb=nil then exit;

  if hcb^.selected then
    Begin
      delete_listbox_item(cur_dialog^.cur_lb,cur_dialog^.cur_lb^.cur_item,true);
      draw_listbox(cur_dialog,cur_dialog^.cur_lb,true);
          nrid := 0;
          for x := 1 to 750 do
              if (resource_index^[x].id = rid) then nrid := x;
          if nrid>0 then
           Begin
             resource_index^[nrid].id    := 0;
             resource_index^[nrid].title := '';
           end;
    end else
    Begin
      if read_resource(rid) then
        Begin
          convert_dialog(rid);
          setactive(rid);
        end;
    end;
end;

Procedure L_Dialog;
Begin
  FD_SETSEARCH('*.DLG');
  OpenFile_Dialog('Open Dialog',rc_loaddlgok,0);
end;

Procedure Load_DialogOK;
Begin
  if read_dialog(fd_frptr^.filename) then
    Begin
      convert_dialog(cur_dialog^.id);
      setactive(cur_dialog^.id);
     end;
end;

Procedure RCUpdate_Grid;
var
 sbv,dfv : word;
 hsb : handle_scrollbar;
 hd : handle_data;
Begin
 hsb := get_handle_scrollbar(sb1);
 hd := get_handle_data(sb1d);
 sbv := 0;
 dfv := 0;
 if (cur_dialog^.cur_sb<>nil) then
 if (cur_dialog^.cur_sb^.id=sb1) and (cur_dialog^.cur_sb^.changed) then
   begin
     sbv := cur_dialog^.cur_sb^.curpos;
     hsb^.changed := false;
     repeat handlemouse; until not(leftmousekeypressed);
   end;
 if hd<>nil then dfv := stoi(retrievepchar(sb1d));
 if (sbv>0) then
   Begin
     assign_string(itos(sbv),sb1d);
     grid := sbv;
     draw_data(cur_dialog,hd);
   end else
   Begin
     if (dfv<1) then
       Begin
         dfv := 1;
         assign_string(itos(dfv),sb1d);
         draw_data(cur_dialog,hd);
       end else
     if (dfv>50) then
       Begin
         dfv := 50;
         assign_string(itos(dfv),sb1d);
         draw_data(cur_dialog,hd);
       end;
     hsb^.curpos := dfv;
     draw_scrollbar(cur_dialog,hsb);
     grid := dfv;
   end
end;

Procedure Rc_handlecb1;
var
 hcb1 : handle_checkbox;
 hcb2 : handle_checkbox;
 hcb3 : handle_checkbox;
Begin
 hcb1 := cur_dialog^.cur_cb;
 hcb2 := get_handle_checkbox(cb2);
 hcb3 := get_handle_checkbox(cb3);

 if hcb1^.selected then mode := 1 else
   if hcb2^.selected then mode := 0 else mode := 2;

 if (hcb1^.selected) and (hcb2^.selected) then
   Begin
     hcb2^.selected := false;
     hm;
     draw_checkbox(cur_dialog,hcb2);
     mode := 1;
     sm;
   end;
 if (hcb1^.selected) and (hcb3^.selected) then
   Begin
     hcb3^.selected := false;
     hm;
     draw_checkbox(cur_dialog,hcb3);
     mode := 1;
     sm;
   end;

end;

Procedure Rc_handlecb2;
var
 hcb1 : handle_checkbox;
 hcb2 : handle_checkbox;
 hcb3 : handle_checkbox;
Begin
 hcb1 := get_handle_checkbox(cb1);
 hcb2 := cur_dialog^.cur_cb;
 hcb3 := get_handle_checkbox(cb3);

 if hcb2^.selected then mode := 0 else
   if hcb1^.selected then mode := 1 else mode := 2;

 if (hcb1^.selected) and (hcb2^.selected) then
   Begin
     hcb1^.selected := false;
     hm;
     draw_checkbox(cur_dialog,hcb1);
     mode := 0;
     sm;
   end;

 if (hcb2^.selected) and (hcb3^.selected) then
   Begin
     hcb3^.selected := false;
     hm;
     draw_checkbox(cur_dialog,hcb3);
     mode := 0;
     sm;
   end;
end;

Procedure Rc_handlecb3;
var
 hcb1 : handle_checkbox;
 hcb2 : handle_checkbox;
 hcb3 : handle_checkbox;
Begin
 hcb3 := cur_dialog^.cur_cb;
 hcb2 := get_handle_checkbox(cb2);
 hcb1 := get_handle_checkbox(cb1);

 if hcb3^.selected then mode := 3 else
   if hcb2^.selected then mode := 0 else
     if hcb1^.selected then mode := 1 else mode := 2;

 if (hcb3^.selected) and (hcb2^.selected) then
   Begin
     hcb2^.selected := false;
     hm;
     draw_checkbox(cur_dialog,hcb2);
     mode := 3;
     sm;
   end;

 if (hcb3^.selected) and (hcb1^.selected) then
   Begin
     hcb1^.selected := false;
     hm;
     draw_checkbox(cur_dialog,hcb1);
     mode := 3;
     sm;
   end;
end;


{$I TABLE.INC}


Procedure Execute_Procedure(proc:longint);
Begin
  case proc of
    Nothing      : exit;
    Res_Reboot   : Reboot;
    terminate    : Terminate_Program;
    terminate_yes: Terminate_ok;
    standard_close_dialog : standard_close(true);
    open_resource : l_resource;

    rc_resinfo : getresinfo;
    rc_selresitem : selectresitem;
    rc_handlenew : handle_new;
    rc_redrawdlg : redraw_dlg;
    rc_deletedlg : delete_dlg;
    rcimport_dbsok : import_dbsfile;
    rc_savedlg   : Begin
                     fd_setsearch('*.DLG');
                     OpenFile_Dialog('Save Dialog',rc_savedlgok,0);
                     exit;
                   end;
    rc_savedlgok : save_dlgok;
    rc_systemres : system_resources;
    rc_insertintores : insertintores;
    rc_addtores  : selectres;
    fd_newres    : c_resource;
    rc_selectres : load_dialog;
    rc_dbstores  : dbstores;
    rc_dbstoresok : dbstoresok;
    rc_newdialog : new_dialog;
    rcdbs_import : import_dbs;
    rc_addbtn : RCadd_button;
    rc_addlb : RCadd_listbox;
    rc_updategrid : RCUpdate_Grid;
    rc_addhsb : RCAdd_HorzScrollbar;
    rc_addvsb : RCAdd_VertScrollbar;

    rc_movebtn : ButtonMode;
    rc_movelb  : ListboxMode;
    rc_movesb  : ScrollbarMode;
    rc_movedata : DataMode;
    rc_movetext : TextMode;
    rc_movecb : CheckBoxmode;

    rc_adddata : RCAdd_Data;
    rc_addtext : RCAdd_Text;
    rc_loaddlg : l_dialog;
    rc_loaddlgok : load_dialogok;
    rc_addcheckbox : rcadd_checkbox;

    rc_cb1 : rc_handlecb1;
    rc_cb2 : rc_handlecb2;
    rc_cb3 : rc_handlecb3;

    rc_updatebutton : update_button;
    rc_updatecheckbox: update_checkbox;
    rc_updatetext : update_text;
    rc_updatedata : update_data;
    rc_updatelistbox : update_listbox;
    rc_editdlg : edit_dialog;
    rc_newtable : initializeTableWindow;
    rc_selectpas : selectpas;
    rc_selpas : add_list(fd_frptr^.filename);
    rc_playflic : playflic;
  end;
  fd_execute_procedure(proc);
  cd_execute_procedure(proc);
  desktop_execute_procedure(proc);
  memory_execute_procedure(proc);
end;

end.
