var
 h_line : array[1..2,0..1024] of byte;
 v_line : array[1..2,0..1024] of byte;
 bsaved : boolean;

 rect : Record
          x1,y1,x2,y2 : word;
        end;

Procedure Swapit(var v1,v2:word);
var
 t : word;
Begin
  if v1<v2 then
    Begin
      t := v2;
      v2 := v1;
      v1 := t;
    end;
end;




Procedure Adjust_Grid(var x1,y1,x2,y2:word);
Begin
  while (x1 mod grid)>0 do dec(x1);
  while (y1 mod grid)>0 do dec(y1);
  while (x2 mod grid)>0 do dec(x2);
  while (y2 mod grid)>0 do dec(y2);
end;

Procedure savexy(ax1,ay1,ax2,ay2:word);
var lx,ly : integer;
Begin
{ while (ax2>clipx2) do
   Begin dec(ax2); dec(ax1); end;
 while (ax1<clipx1) do
   Begin inc(ax1); inc(ax2); end;
 while (ay2>clipy2) do
   Begin dec(ay2); dec(ay1); end;
 while (ay1<clipy1) do
   Begin inc(ay1); inc(ay2); end;}
 hm;
 for lx := ax1 to ax2 do
   Begin
     h_line[1,lx] := vget(lx,ay1);
     h_line[2,lx] := vget(lx,ay2);
   end;
 for ly := ay1 to ay2 do
   Begin
     v_line[1,ly] := vget(ax1,ly);
     v_line[2,ly] := vget(ax2,ly);
   end;
 bsaved := true;
 sm;
end;

Procedure restorexy(ax1,ay1,ax2,ay2:word);
var lx,ly : integer;
Begin
 if not(bsaved) then exit;
 hm;
 for lx := ax1 to ax2 do
   Begin
     vplot(lx,ay1,h_line[1,lx]);
     vplot(lx,ay2,h_line[2,lx]);
   end;
 for ly := ay1 to ay2 do
   Begin
     vplot(ax1,ly,v_line[1,ly]);
     vplot(ax2,ly,v_line[2,ly]);
   end;
 sm;
end;

Function New_Sized_Rect(x1,y1,x2,y2:word):boolean;
var
 ax1,ay1,ax2,ay2 : word;
 x,y : word;
 hdlg : handle_dialog;
 hsb : handle_scrollbar;
 id1,id2 : longint;
begin
  new_sized_rect := false;
  setmouseextents(x1,y1,x2,y2);
  setmousecursorpos(x1 shl 1,y1);
  repeat handlemouse; until not leftmousekeypressed;
  bsaved := false;
  repeat handlemouse;
    ax1 := mousex shr 1;
    ay1 := mousey;
    ax2 := ax1;
    ay2 := ay1;
    adjust_grid(ax1,ay1,ax2,ay2);
    x := ax1;
    y := ay1;
    if rightmousekeypressed then
      Begin
        defaultmouseextents;
        fillchar(rect,sizeof(rect),0);
        exit;
      end;
  until leftmousekeypressed;
  while (leftmousekeypressed) do
   Begin
     handlemouse;
     restorexy(ax1,ay1,ax2,ay2);
     inc(ax2,(mousex shr 1)-x);
     inc(ay2,(mousey)-y);
     x := mousex shr 1;
     y := mousey;
     adjust_grid(ax1,ay1,ax2,ay2);
     adjust_grid(x,y,ax1,ay1);
     savexy(ax1,ay1,ax2,ay2);
     box(ax1,ay1,ax2,ay2,white);
   end;
  restorexy(ax1,ay1,ax2,ay2);
  rect.x1 :=ax1;
  rect.y1 :=ay1;
  rect.x2 :=ax2;
  rect.y2 :=ay2;
  new_sized_rect := true;
  defaultmouseextents;
end;

Function New_Rect(mx1,my1,mx2,my2,width,height:word;reset:boolean):boolean;
var
 t,ax1,ay1,ax2,ay2 : word;
 x,y : integer;
 hdlg : handle_dialog;
 hsb : handle_scrollbar;
 id1,id2 : longint;
 lax1,lay1,lax2,lay2 : word;
begin
  new_rect := false;
  setmouseextents(mx1,my1,mx2-(width-1),my2-(height-1));
  if reset then setmousecursorpos(mx1 shl 1,my1);
  repeat handlemouse; until not leftmousekeypressed;
  bsaved := false;
  repeat
    handlemouse;
    lax1 := ax1;
    lay1 := ay1;
    lax2 := ax2;
    lay2 := ay2;
    ax1 := mousex shr 1;
    ay1 := mousey;
    adjust_grid(ax1,ay1,ax2,ay2);
    adjust_grid(lax1,lay1,t,t);
    ax2 := ax1+(width)-1;
    ay2 := ay1+(height)-1;
    x := ax1;
    y := ay1;
    if rightmousekeypressed then
      Begin
        defaultmouseextents;
        fillchar(rect,sizeof(rect),0);
        restorexy(lax1,lay1,lax2,lay2);
        exit;
      end;
     if (ax1<>lax1) or (ay1<>lay1) then
     Begin
       x := mousex shr 1;
       y := mousey;
       restorexy(lax1,lay1,lax2,lay2);
       savexy(ax1,ay1,ax2,ay2);
       box(ax1,ay1,ax2,ay2,white);
     end;
     until leftmousekeypressed;
  restorexy(ax1,ay1,ax2,ay2);
  defaultmouseextents;
  rect.x1 :=ax1;
  rect.y1 :=ay1;
  rect.x2 :=ax2;
  rect.y2 :=ay2;
  new_rect := true;
end;

Function New_Sized_Width(x1,y1,x2,y2,min,max:word):boolean;
var
 lax1,lay1,lax2,lay2 : word;
 ax1,ay1,ax2,ay2 : word;
 t : word;
 x,y : word;
 hdlg : handle_dialog;
 hsb : handle_scrollbar;
 id1,id2 : longint;
begin
  new_sized_width := false;
  {clipset(x1,y1,x2+max,y2);}
  bsaved := false;
  ax1 := x1;
  ay1 := y1;
  ax2 := x2;
  ay2 := y2;
  while (ax2-ax1)>max do dec(ax2);
  while (ax2-ax1)<min do inc(ax2);
  setmousecursorpos(ax2 shl 1,(ay2-ay1) shr 1+ay1);
  handlemouse;
       savexy(ax1,ay1,ax2,ay2);
       box(ax1,ay1,ax2,ay2,white);
  while leftmousekeypressed do
  Begin
     handlemouse;
     lax1 := ax1;
     lay1 := ay1;
     lax2 := ax2;
     lay2 := ay2;
     ax2 := mousex shr 1;
     if (ax2<ax1) then ax2 := ax1+min-1;
     while (ax2-ax1)>max do dec(ax2);
     while (ax2-ax1)<min do inc(ax2);
     adjust_grid(ax1,y,ax2,y);

     if (ax2<>lax2) then
     Begin
       restorexy(lax1,lay1,lax2,lay2);
       savexy(ax1,ay1,ax2,ay2);
       box(ax1,ay1,ax2,ay2,white);
     end;
  end;
  restorexy(ax1,ay1,ax2,ay2);
  rect.x1 :=ax1;
  rect.y1 :=ay1;
  rect.x2 :=ax2;
  rect.y2 :=ay2;
  new_sized_width := true;
  defaultmouseextents;
end;

Function New_Sized_Height(x1,y1,x2,y2,min,max:word):boolean;
var
 lax1,lay1,lax2,lay2 : word;
 ax1,ay1,ax2,ay2 : word;
 t : word;
 x,y : word;
 hdlg : handle_dialog;
 hsb : handle_scrollbar;
 id1,id2 : longint;
begin
  new_sized_height := false;
  bsaved := false;
  ax1 := x1;
  ay1 := y1;
  ax2 := x2;
  ay2 := y2;
  while (ay2-ay1)>max do dec(ay2);
  while (ay2-ay1)<min do inc(ay2);
  setmousecursorpos(((ax2-ax1) shr 1+ax1) shl 1,ay2);
  handlemouse;
       savexy(ax1,ay1,ax2,ay2);
       box(ax1,ay1,ax2,ay2,white);
  while leftmousekeypressed do
  Begin
     handlemouse;
     lax1 := ax1;
     lay1 := ay1;
     lax2 := ax2;
     lay2 := ay2;
     ay2 := mousey;
     if (ay2<ay1) then ay2 := ay1+min-1;
     while (ay2-ay1)>max do dec(ay2);
     while (ay2-ay1)<min do inc(ay2);
     adjust_grid(x,ay1,x,ay2);

     if (ay2<>lay2) then
     Begin
       restorexy(lax1,lay1,lax2,lay2);
       savexy(ax1,ay1,ax2,ay2);
       box(ax1,ay1,ax2,ay2,white);
     end;
  end;
  restorexy(ax1,ay1,ax2,ay2);
  rect.x1 :=ax1;
  rect.y1 :=ay1;
  rect.x2 :=ax2;
  rect.y2 :=ay2;
  new_sized_height := true;
  defaultmouseextents;
end;


Function New_Sized(x1,y1,x2,y2,minx,maxx,miny,maxy:word):boolean;
var
 lax1,lay1,lax2,lay2 : word;
 ax1,ay1,ax2,ay2 : word;
 t : word;
 x,y : word;
 hdlg : handle_dialog;
 hsb : handle_scrollbar;
 id1,id2 : longint;
begin
  new_sized := false;
  {clipset(x1,y1,x2+maxx,y2+maxy);}
  bsaved := false;
  ax1 := x1;
  ay1 := y1;
  ax2 := x2;
  ay2 := y2;
  while (ay2-ay1)>maxy do dec(ay2);
  while (ay2-ay1)<miny do inc(ay2);
  while (ax2-ax1)>maxx do dec(ax2);
  while (ax2-ax1)<minx do inc(ax2);
  setmousecursorpos(ax2 shl 1,ay2);
  handlemouse;
       savexy(ax1,ay1,ax2,ay2);
       box(ax1,ay1,ax2,ay2,white);
  while leftmousekeypressed do
  Begin
     handlemouse;
     lax1 := ax1;
     lay1 := ay1;
     lax2 := ax2;
     lay2 := ay2;
     ay2 := mousey;
     ax2 := mousex shr 1;
     if (ay2<ay1) then ay2 := ay1+miny-1;
     if (ax2<ax1) then ax2 := ax1+minx-1;

     while (ay2-ay1)>maxy do dec(ay2);
     while (ay2-ay1)<miny do inc(ay2);
     while (ax2-ax1)>maxx do dec(ax2);
     while (ax2-ax1)<minx do inc(ax2);

     adjust_grid(ax1,ay1,ax2,ay2);

     if (ay2<>lay2) or (ax2<>lax2) then
     Begin
       restorexy(lax1,lay1,lax2,lay2);
       savexy(ax1,ay1,ax2,ay2);
       box(ax1,ay1,ax2,ay2,white);
     end;
  end;
  restorexy(ax1,ay1,ax2,ay2);
  rect.x1 :=ax1;
  rect.y1 :=ay1;
  rect.x2 :=ax2;
  rect.y2 :=ay2;
  new_sized := true;
  defaultmouseextents;
end;
