


Procedure Int9Handler   ;Near; Assembler;
Asm
   iret
   pusha
   push ds
   mov bx,seg @DATA
   mov ds,bx
   mov al,0adh
   call @@set
   cli
@@l1:
   in al,64h
   test al,02
   loopnz @@l1
   in al,60h
   sti
   test al,80h
   mov _isend,TRUE
@@l2:
   mov al,0aeh
   call @@set
   mov al,20h
   out 20h,al
   pop ds
   popa
   iret
@@set:
   push ax
   cli
@@l3:
   in al,64h
   test al,2
   loopnz @@l3
   pop ax
   out 64h,al
   sti
   ret
End;

Procedure Amplifier     ;Near; Assembler;
Asm
   push ds
   push bx
   push cx
   mov  bx,seg @DATA
   mov  ds,bx
   cmp  byte ptr volume,1
   jz   @@ampend
   cmp  al,080h                 { if al > 080h      }
   ja   @@bigger                { yep               }
   je   @@ampend
   mov  bl,080h
   xchg al,bl
   sub  al,bl
   mov  bl,volume
   mul  bl                      { ax = al*bl        }
   cmp  al,07fh                 { al > 080h         }
   jbe  @@notbig                { no,               }
   mov  al,07fh                 { make al=max.      }
@@notbig:
   mov  bl,080h                 { bl = 80h          }
   xchg al,bl                   { al = bl ; bl = al }
   sub  al,bl                   { al = 80h - al     }
   jmp  @@ampend
@@bigger:
   mov  bl,080h                 { bl = 80h          }
   sub  al,bl                   { al = al - 80h     }
   mov  bl,volume
   mul  bl                      { ax = al*bl        }
   cmp  al,080h                 { ax > 80h ?        }
   jb   @@notbig2               { no                }
   mov  al,07fh                 { make al=max.      }
@@notbig2:
   add  al,080h
@@ampend:
   pop  cx
   pop  bx
   pop  ds
   ret
End;

Procedure SetNext4      ;Near; Assembler;
Asm
   cli
   mov  ax,4400h
   mov  bx,_emsupage
   mov  dx,_emshandle
   mov  cx,4
@@getpages:
   push cx
   push dx
   push bx
   push ax
   int  67h
   pop  ax
   pop  bx
   pop  dx
   inc  bx
   inc  ax
   pop  cx
   loop @@getpages
   mov  _emsupage,bx
   sti
   ret
End;



Procedure PCHandler   ;Far; Assembler;
Asm
   cli
   pushf
   pusha
   push    bp
   push    es
   push    ds
   mov     ax,seg @DATA
   mov     ds,ax
   cmp     _isend,true
   jz      @@nexttime
   in      al,60h                  { Read Keyboard    }
   cmp     al,1                    { Is it ESC ?      }
   jnz     @@noquit                { No, Goon playing }
   mov     _isend,true             { Set it to end    }
@@noquit:
   mov     bx,_smpoff              { bx = smpoff      }
   mov	   es,_emsbase             { es = emsbase     }
   mov	   al,es:[bx]              { al = emsbase:smpoff }
   cmp     _signed,true            { is sample signed    }
   jne     @@notsigned             { no }
   add	   al,80h                  { yep,make it unsigned }
@@notsigned:
   cmp     _amplify,true           { will we amplify it }
   jne     @@noamplify             { no }
   call    amplifier               { yep,make it big ...}
@@noamplify:
   shr     al,2
   jnz     @@dontinc
   inc     al
@@dontinc:
   out     42h,al
   cmp     _twin,true              { will we play this one again ? }
   jne     @@notwin                { no rate fast enough }
   dec	   _cntr                   { yep,make counter 1 to remember }
   jnz     @@nexttime              { do not increment smpoff this time }
@@notwin:

   mov     al,_maxcntr
   mov     _cntr,al
   inc     bx                      { smpoff = smpoff + 1 }
   mov     _smpoff,bx              { smpoff = bx }
   jnz	   @@l1                    { do we finished segment ? }
   call    setnext4                { yep, get next segment }
@@l1:
   dec     _smplenlo               { dec(smplenlo) }
   jnz     @@l2                    { smplenlo ?= 0 }
   cmp     _smplenhi,0             { yep, smplenhi ?= 0 }
   jz      @@smpend                { yep, finish playing }
   dec     _smplenhi               { dec(smplenhi) }
   jmp     @@l2                    { jmp routine end }
@@smpend:
   mov     _isend,true             { tell that it finished }
@@l2:
@@nexttime:
   mov     al,20h                  { clear keyboard buffer }
   out     20h,al
   pop     ds
   pop     es
   pop     bp
   popa
   popf
   sti
   iret
End;

Procedure LPT1Handler   ;Far; Assembler;
Asm
   cli
   pushf
   pusha
   push    bp
   push    es
   push    ds
   mov     ax,seg @DATA
   mov     ds,ax
   cmp     _isend,true
   jz      @@nexttime
   in      al,60h                  { Read Keyboard    }
   cmp     al,1                    { Is it ESC ?      }
   jnz     @@noquit                { No, Goon playing }
   mov     _isend,true             { Set it to end    }
@@noquit:
   mov     bx,_smpoff              { bx = smpoff      }
   mov	   es,_emsbase             { es = emsbase     }
   mov	   al,es:[bx]              { al = emsbase:smpoff }
   cmp     _signed,true            { is sample signed    }
   jne     @@notsigned             { no }
   add	   al,80h                  { yep,make it unsigned }
@@notsigned:
   cmp     _amplify,true           { will we amplify it }
   jne     @@noamplify             { no }
   call    amplifier               { yep,make it big ...}
@@noamplify:
   mov     dx,LPT1
   out     dx,al
   cmp     _twin,true              { will we play this one again ? }
   jne     @@notwin                { no rate fast enough }
   dec	   _cntr                   { yep,make counter 1 to remember }
   jnz     @@nexttime              { do not increment smpoff this time }
@@notwin:
   mov     al,_maxcntr
   mov     _cntr,al
   inc     bx                      { smpoff = smpoff + 1 }
   mov     _smpoff,bx              { smpoff = bx }
   jnz	   @@l1                    { do we finished segment ? }
   call    setnext4                { yep, get next segment }
@@l1:
   dec     _smplenlo               { dec(smplenlo) }
   jnz     @@l2                    { smplenlo ?= 0 }
   cmp     _smplenhi,0             { yep, smplenhi ?= 0 }
   jz      @@smpend                { yep, finish playing }
   dec     _smplenhi               { dec(smplenhi) }
   jmp     @@l2                    { jmp routine end }
@@smpend:
   mov     _isend,true             { tell that it finished }
@@l2:
@@nexttime:
   mov     al,20h                  { clear keyboard buffer }
   out     20h,al
   pop     ds
   pop     es
   pop     bp
   popa
   popf
   sti
   iret
End;

Procedure LPT2Handler   ;Far; Assembler;
Asm
   cli
   pushf
   pusha
   push    bp
   push    es
   push    ds
   mov     ax,seg @DATA
   mov     ds,ax
   cmp     _isend,true
   jz      @@nexttime
   in      al,60h                  { Read Keyboard    }
   cmp     al,1                    { Is it ESC ?      }
   jnz     @@noquit                { No, Goon playing }
   mov     _isend,true             { Set it to end    }
@@noquit:
   mov     bx,_smpoff              { bx = smpoff      }
   mov	   es,_emsbase             { es = emsbase     }
   mov	   al,es:[bx]              { al = emsbase:smpoff }
   cmp     _signed,true            { is sample signed    }
   jne     @@notsigned             { no }
   add	   al,80h                  { yep,make it unsigned }
@@notsigned:
   cmp     _amplify,true           { will we amplify it }
   jne     @@noamplify             { no }
   call    amplifier               { yep,make it big ...}
@@noamplify:
   mov     dx,LPT2
   out     dx,al
   cmp     _twin,true              { will we play this one again ? }
   jne     @@notwin                { no rate fast enough }
   dec	   _cntr                   { yep,make counter 1 to remember }
   jnz     @@nexttime              { do not increment smpoff this time }
@@notwin:
   mov     al,_maxcntr
   mov     _cntr,al
   inc     bx                      { smpoff = smpoff + 1 }
   mov     _smpoff,bx              { smpoff = bx }
   jnz	   @@l1                    { do we finished segment ? }
   call    setnext4                { yep, get next segment }
@@l1:
   dec     _smplenlo               { dec(smplenlo) }
   jnz     @@l2                    { smplenlo ?= 0 }
   cmp     _smplenhi,0             { yep, smplenhi ?= 0 }
   jz      @@smpend                { yep, finish playing }
   dec     _smplenhi               { dec(smplenhi) }
   jmp     @@l2                    { jmp routine end }
@@smpend:
   mov     _isend,true             { tell that it finished }
@@l2:
@@nexttime:
   mov     al,20h                  { clear keyboard buffer }
   out     20h,al
   pop     ds
   pop     es
   pop     bp
   popa
   popf
   sti
   iret
End;

(*
Procedure BoxScroll;Near;Assembler;
Asm
   push ds
   cld
   mov ax,0a000h
   mov es,ax
   mov di,_osilooff
   mov si,_osilooff
   inc si
   mov cx,_osilowidth
@@nextline:
   push cx
   push di
   push si
   mov cx,_osilolen
   push ds
   push es
   pop  ds
   rep movsb
   pop  ds
   dec si
   mov byte ptr es:[si],boxcolor
   pop si
   pop di
   pop cx
   add si,MAXX
   add di,MAXX
   inc di
   inc si
   loop @@nextline
   pop ds
   ret
End;

Procedure OsiloScroll;Near;Assembler;
Asm
   push    ds
   push    es
   mov     ax,seg @DATA
   mov     ds,ax
   mov     si,_smpoff
   mov	   ax,0a000H
   mov	   es,ax
   mov     di,_osilooff
   mov	   cx,_osilolen
   add     di,cx
   mov     ax,maxx
   inc     ax
   mov     word ptr cs:[@@mymaxx],ax
   mov     al,_amplify
   mov     byte ptr cs:[@@myamplify],al
   mov     al,_signed
   mov     byte ptr cs:[@@mysign],al
   mov     ax,_emsbase
   mov     ds,ax
@@osilomain:
   mov     bl,ds:[si]
   cmp     byte ptr cs:[@@mysign],true
   jnz     @@notsigned
   add     bl,80h
@@notsigned:
   cmp     byte ptr cs:[@@myamplify],true
   jnz     @@noamphi
   mov     al,bl
   call    amplifier
   mov     bl,al
@@noamphi:
   mov     al,00h { 0ffh ? }
   sub     al,bl
   mov     bl,al
   shr	   bl,2
   mov	   ax,word ptr cs:[@@mymaxx]
   mov	   bh,0
   mul	   bx
   add	   di,ax
   mov     byte ptr es:[di],osilocolor
   pop es
   pop ds
   ret
@@mymaxx:
   dw      0
@@myamplify:
   db      0
@@mysign:
   db      0
End;

*)
Procedure BoxClear;Near;Assembler;
Asm
   mov  ax,0a000h
   mov  es,ax
   mov  di,_osilooff
   mov  cx,_osilowidth
   mov  ax,boxcolor+boxcolor*256
   mov  bx,_osilolen
@@nextline:
   push cx
   push di
   mov  cx,bx
   shr  cx,1
   rep  stosw
@@enter2:
   pop  di
   add  di,maxx
   inc  di
   pop  cx
   loop @@nextline
   ret
End;


Procedure Osilo;Near;Assembler;
Asm
   push    ds
   push    es
   mov     ax,seg @DATA
   mov     ds,ax
   mov     si,_smpoff
   mov	   ax,0a000H
   mov	   es,ax
   mov     di,_osilooff
   mov	   cx,_osilolen
   mov     ax,maxx
   inc     ax
   mov     word ptr cs:[@@mymaxx],ax
   mov     al,_amplify
   mov     byte ptr cs:[@@myamplify],al
   mov     al,_signed
   mov     byte ptr cs:[@@mysign],al
   mov     ax,_emsbase
   mov     ds,ax
@@osilomain:
   push    cx
   push    di
   mov     bl,ds:[si]
   cmp     byte ptr cs:[@@mysign],true
   jnz     @@notsigned
   add     bl,80h
@@notsigned:
   cmp     byte ptr cs:[@@myamplify],true
   jnz     @@noamphi
   mov     al,bl
   call    amplifier
   mov     bl,al
@@noamphi:
   mov     al,00h { 0ffh ? }
   sub     al,bl
   mov     bl,al
   shr	   bl,2
   mov	   ax,word ptr cs:[@@mymaxx]
   mov	   bh,0
   mul	   bx
   add	   di,ax
   mov     byte ptr es:[di],osilocolor
   pop     di
   inc     di
   inc     si
   pop     cx
   loop    @@osilomain
   pop es
   pop ds
   ret
@@mymaxx:
   dw      0
@@myamplify:
   db      0
@@mysign:
   db      0
End;
{
Procedure DoSomething;Near;
Var
   li : LongInt;
Begin
     ShowPos;
     li := _smplenhi;
     li := li * 65535;
     li := li + _smplenlo;
     li := BlockEnd - li;
     position := li;
     ShowPos;
End;
}
Procedure StartPlaying  ;Near; Assembler;
Asm
   push    ss
   push    sp
   push    bp
   push    ds
   call    vertwait
   mov     ah,35h
   mov     al,8
   int     21h                     { get old int 8 vector }
   mov     _old8o,bx               { store it }
   mov     _old8s,es
   mov     ah,35h
   mov     al,9
   int     21h                     { get old int 9 vector }
   mov     _old9o,bx               { store it }
   mov     _old9s,es
   in      al,21h                  { get old 21h value }
   mov     _old21,al               { store it }
   cli
   mov     al,0ffh
   out     21h,al                  { disable all }
   sti
   mov     dx,handler
   push    ds
   push    cs
   pop     ds
   mov     ah,25h
   mov     al,8
   int     21h                     { set new int 8 vector }
   mov     ah,25h
   mov     al,9
   lea     dx,int9handler
   int     21h                     { set new int 9 vector }
   pop     ds
   mov     al,00110100b
   out     43h,al
   mov     ax,_magic
   mov     bl,_baserate
   cmp     _twin,true
   jnz     @@notwin
   mov     bh,bl
   add     bl,bl
   cmp     cntr3,true
   jnz     @@notwin
   add     bl,bh
@@notwin:
   div     bl
   out     40h,al
   mov     al,0
   out     40h,al
   mov     al,90h
   out     43h,al
   in      al,61h
   or      al,3
   out     61h,al
   cli
   mov     al,11100110b            { enable only mouse end keyboard }
   out     21h,al
   sti
   xor     cx,cx
   mov     _isend,false
@@finish:
   mov     al,_maxcntr
   cmp     _cntr,al
   jnz     @@nograph
   cmp     ShowOsilo,True
   jnz     @@Nograph
   pusha
   push ds
   push es
   call vertwait
   call boxclear
   call osilo
   call vertwait
{
   call DoSomething
}
   pop es
   pop ds
   popa
@@nograph:
   cmp     _isend,true
   jnz     @@finish
   cli
   mov     al,0ffh
   out     21h,al
   sti
   in      al,61h
   and     al,0fch
   out     61h,al
   mov     al,34h
   out     43h,al
   mov     ax,0
   out     40h,al
   mov     al,ah
   out     40h,al
   mov     al,0b6h
   out     43h,al
   mov     ax,0533h
   out     42h,al
   mov     al,ah
   out     42h,al
   push    ds
   mov     ah,25h
   mov     al,8
   mov     dx,_old8o
   mov     ds,_old8s
   int     21h
   pop     ds
   push    ds
   mov     ah,25h
   mov     al,9
   mov     dx,_old9o
   mov     ds,_old9s
   int     21h
   pop     ds
   cli
   mov     al,_old21
   out     21h,al
   sti
   pop     ds
   pop     bp
   pop     sp
   pop     ss
End;
{
Procedure RawPlay(RawData:Pointer;Len,RawRate:Word;Vol:Byte;Cntr:Byte);
Var
   OldRATE      : Word;
   OldBASE      : Word;
   OldVolume    : Byte;
   OldBussy     : Byte;
   OldCntr      : Byte;
   OldShowOsilo : Boolean;
Begin
     OldBussy := BussyState;
     Bussy;
     OldRate   := Rate;
     OldBase   := EMSBase;
     OldVolume := Volume;
     OldCntr   := _maxcntr;
     OldShowOsilo := ShowOsilo;
     volume    := Vol;
     _maxcntr  := Cntr;
     cntr1 := False;
     cntr2 := False;
     cntr3 := False;
     Case _maxcntr of
          1 : Cntr1 := True;
          2 : Cntr2 := True;
          3 : Cntr3 := True;
     End;
     _cntr       := Cntr;
     _emsbase    := Seg(RawData^);
     _smpoff     := Ofs(RawData^);
     _baserate   := RawRate div 256;
     _samplerate := RawRate div 256;
     _smplenhi   := 0;
     _smplenlo   := Len;
     ShowOsilo   := False;
     Playing := True;
     StartPlaying;
     Playing := False;
     Rate    := OldRate;
     EMSBase := OldBase;
     Volume  := OldVolume;
     ShowOsilo := OldShowOsilo;
     _maxcntr   := OldCntr;
     cntr1 := False;
     cntr2 := False;
     cntr3 := False;
     Case _maxcntr of
          1 : Cntr1 := True;
          2 : Cntr2 := True;
          3 : Cntr3 := True;
     End;
     if OldBussy = 0 then Notbussy;
End;
}