Unit HDBF;

Interface

Uses Windows,Filer,global;

Const
   MAXINDEXES = 5;
   HDBF_PROCESS = 20;
   HDBF_CALLBACK_MS = 2;

   SQL_IDLE = 0;
   SQL_INIT = 1;
   SQL_PROCESS = 2;
   SQL_ENDPROCESS = 3;
   SQL_APPEND = 4;
   SQL_REPLACE = 5;
   SQL_DELETE = 6;
   SQL_RETRIEVE = 7;

   SQL_NOTHING = 0;
   SQL_COLUMN = 1;
   SQL_MATCHALL = 2;
   SQL_MATCHSOME = 3;
   SQL_MATCHSOME_FIRST = 4;
   SQL_DATE_GREATER = 5;
   SQL_EXCLUDEALL = 6;
   SQL_EXCLUDESOME = 7;
   SQL_EXCLUDESOME_FIRST = 8;
   SQL_USEINDEX = 9;
   SQL_RANGESTART = 10;
   SQL_RANGEEND = 11;
   SQL_RECORDNUM = 12;
Type
   psql = ^SQL_TYPE;
   SQL_TYPE = Record
                sql_type : byte;
                fieldname : string[11];
                fieldnum  : byte; {internal use}
                searchpref : string;
                ldata : longint; {store record # etc...}
                prev,next : psql;
              end;
   handle_dbf_object = ^DBF_OBJECT;
   DBF_Object = Record
                  id : longint;
                  filename   : string;
                  numindexes : byte;
                  indexes    : array[1..MAXINDEXES] of Record
                                                filename:string;
                                                indexedby:string;
                                              end;
                  privilege  : longint;
                  fileopen   : boolean;
                  fullindex  : string;
                  curindex   : byte;
                  status     : byte;
                  gsobarea   : byte;
                  currecno   : longint;
                  mfl : longint;
                  maxlength  : longint;
                  rangestart,
                  rangeend : longint;
                  first_sql,
                  last_sql,
                  cur_sql : psql;
                  dlg        : longint;
                  columndef : array[1..256] of Record
                                                 fieldnum : byte;
                                                 fieldlength : byte;
                                               end;
                  numcolumns : byte;
                  prev,next  : handle_dbf_object;
                end;

Var
  first_dbf,
  last_dbf,
  cur_dbf : handle_dbf_object;
  fposused : array[1..40] of longint;  {tracks all used spots of files!}
  HDBF_CALLBACK_ID : longint;

Function  Get_Handle_DBF(id:longint):handle_dbf_object;
Function  Add_DBF(id,priv:longint;dlg:longint;filename:string;ml,mfl:longint):handle_dbf_object;
Procedure Delete_DBF(var tlp:handle_dbf_object);
Procedure Delete_All_DBFS;
Procedure Add_Index(dbf:handle_dbf_object;filename:string);
Procedure Initialize_File_Handler;

Procedure HDBF_Execute_Procedure(proc:longint);

Procedure SQL_Insert(dbf:handle_dbf_object;sql_type:byte;fieldname:string;searchpref:string);
Procedure SQL_Reset(dbf:handle_dbf_object);
Procedure SQL_Execute(dbf:handle_dbf_object);

Function  DBF_GO(dbf:handle_dbf_object;rn:longint) : Boolean;
Function  DBF_FIND(dbf:handle_dbf_object;searchpref:string;s:string) : Boolean;
Function  DBF_SKIP(dbf:handle_dbf_object;amount:longint) : Boolean;
Function  DBF_CURREC(dbf:handle_dbf_object) : Longint;
Function  DBF_STRINGPUT(dbf:handle_dbf_object;fieldname,value:string) : Boolean;
Function  DBF_STRINGGET(dbf:handle_dbf_object;fieldname:string) : String;
Function  DBF_APPEND(dbf:handle_dbf_object) : Boolean;
Function  DBF_REPLACE(dbf:handle_dbf_object) : Boolean;
Function  DBF_DELETE(dbf:handle_dbf_object) : Boolean;
Function  DBF_FIELDEXISTS(dbf:handle_dbf_object;s:string):boolean;

Procedure DBF_FILL_DLG_FIELDS(dbf:handle_dbf_object;dlg:handle_dialog);
Procedure DBF_FILL_FIELDS(dbf:handle_dbf_object;dlg:handle_dialog);
Procedure DBF_CLEAR_DLG_FIELDS(dbf:handle_dbf_object;dlg:handle_dialog);

Function unique(fname:string) : string;
Procedure File_Sound;

Function File_Erase(fname:string):Boolean;
Function File_Rename(fname,newfname:string):Boolean;
Function uc(s:string):string;

Implementation

Uses GSOBSHEL,GSOB_DBF,CRT;

Procedure File_Sound;
Begin
  sound(1000);
  delay(75);
  nosound;
  sound(1250);
  delay(25);
  nosound;
end;


Procedure Adjust_File_Pointer(dbf:handle_dbf_object);
Begin
  if dbf=nil then exit;
  if dbfareas[dbf^.gsobarea]<>dbfactive then DBFSelect(dbf^.gsobarea);
end;

Function Free_Area:byte;
var
 x : byte;
Begin
  free_area := 0;
  for x := 1 to 40 do
      if fposused[x]=0 then
        Begin
          free_area := x;
          exit;
        end;
end;

Function Num_Fields:byte;
var
 nf : byte;
Begin
 if dbfactive<>nil then
 nf := DBFactive^.numfields else
 nf := 0;
end;

Function Data_Size:longint;
var
 ds : longint;
 x : byte;
 fr : GSP_DBFFIELD;
Begin
 ds := 0;
 if num_fields>0 then
   for x := 1 to num_fields do
      Begin
        fr := GetFieldInfo(x);
        if fr<>nil then ds := ds + fr^.fieldlen;
      end;
 data_size := ds;
end;

Function Add_DBF(id,priv:longint;dlg:longint;filename:string;ml,mfl:longint):handle_dbf_object;
var
 this : handle_dbf_object;
Begin
 filename := dbdir+filename;
 add_dbf := nil;
 new(this);
 this^.id := id;
 this^.privilege := priv;
 this^.filename := filename;
 this^.numindexes := 0;
 this^.currecno := 0;
 fillchar(this^.indexes,sizeof(this^.indexes),#0);
 this^.curindex := 0;
 this^.fullindex := '';
 this^.status := 0;
 this^.gsobarea := free_area;
 this^.first_sql := nil;
 this^.last_sql  := nil;
 this^.cur_sql   := nil;
 this^.dlg := dlg;
 this^.numcolumns := 0;
 fillchar(this^.columndef,sizeof(this^.columndef),0);
 if this^.gsobarea=0 then
   Begin
     dispose(this);
     fatal_error(2);
   end;
 if not(exists(filename+'.DBF')) then
   Begin
     dispose(this);
     message_box('DBF Error',lpad('Data file does not exist!',40)+
                             lpad(filename+'.DBF',40),OK,standard_close_dialog,0);
     exit;
   end;
 fposused[this^.gsobarea] := this^.id;
 DBFSelect(this^.gsobarea);
 use(this^.filename);
 this^.fileopen := true;
 this^.rangestart:= 0;
 this^.rangeend  := reccount;
 this^.maxlength := ml;
 this^.mfl := mfl;
 this^.next := nil;
 this^.prev := last_dbf;
 if first_dbf=nil then first_dbf := this;
 if last_dbf<>nil then last_dbf^.next := this;
 last_dbf:= this;
 cur_dbf:= this;
 add_dbf := this;
end;

Procedure Delete_DBF(var tlp:handle_dbf_object);
Begin
  if tlp=nil then exit;
  {if(tlp^.dsize>0) then freemem(tlp^.data,tlp^.dsize);}
  sql_reset(tlp);
  if tlp=first_dbf then first_dbf := tlp^.next;
  if tlp=last_dbf then last_dbf := tlp^.prev;
  if tlp=cur_dbf then cur_dbf := nil;
  if (tlp^.prev<>nil) then tlp^.prev^.next := tlp^.next;
  if (tlp^.next<>nil) then tlp^.next^.prev := tlp^.prev;
  if tlp^.fileopen then
    Begin
      closedbfarea(tlp^.gsobarea);
      fposused[tlp^.gsobarea] := 0;
    end;
  dispose(tlp);
  tlp := nil;
end;

Procedure Delete_All_DBFS;
Begin
   while (first_dbf<>nil) do delete_dbf(first_dbf);
end;

Function Get_Handle_DBF(id:longint):handle_dbf_object;
var
 this : handle_dbf_object;
Begin
 get_handle_dbf := nil;
 this := first_dbf;
 while this<>nil do
   Begin
     if this^.id=id then
       Begin
         Get_Handle_DBF := this;
         exit;
       end;
     this := this^.next;
   end;
end;

Procedure Add_Index(dbf:handle_dbf_object;filename:string);
var
 indexedby : string;
Begin
  filename := dbdir+filename;
  if dbf=nil then exit;
  if (dbf^.numindexes>=MAXINDEXES) then
     Begin
       message_box('DBF Error',lpad('Maximum # of Index Files are already',40)+
                               lpad('in use!',40),OK,standard_close_dialog,0);
       exit;
     end;
  if not(exists(filename+'.NTX')) then
     Begin
       message_box('DBF Error',lpad('Index file does not exist!',40)+
                               lpad(filename+'.NTX',40),OK,standard_close_dialog,0);
       exit;
     end;
  dbf^.curindex := 1;
  inc(dbf^.numindexes);
  dbf^.indexes[dbf^.numindexes].filename  := filename;
  adjust_file_pointer(dbf);
  index(filename);
  dbf^.indexes[dbf^.numindexes].indexedby := DBFActive^.IndexMaster^.ixKey_Form;
  if (dbf^.numindexes=1) then dbf^.fullindex := filename else
                              dbf^.fullindex := dbf^.fullindex+','+filename;
  index(dbf^.fullindex);
  dbf^.curindex := dbf^.numindexes;
end;

Procedure Initialize_File_Handler;
Begin
  HDBF_CALLBACK_ID := unique_id;
  Add_Callback(HDBF_CALLBACK_ID,nil,HDBF_CALLBACK_ID,HDBF_CALLBACK_MS);
end;

{Initializes Query, open appropriate indexes and reset files}
Procedure SQL_Initialize(dbf:handle_dbf_object);
var
 this : psql;
Begin
  If dbf=nil then exit;
  Adjust_File_Pointer(dbf);

  { Initializes Pointer }
  if dbf^.rangestart=0 then gotop else go(dbf^.rangestart);

  { Initializes Index to Use}
  if length(dbf^.fullindex)>0 then
  Begin
    index(dbf^.fullindex);
    setorderto(dbf^.curindex);
    this := dbf^.first_sql;
    while this<>nil do
      Begin
        if pos(this^.fieldname,dbf^.indexes[dbf^.curindex].indexedby)=1 then
         Begin
           find(this^.searchpref);
           if not(found) and not(this^.sql_type=SQL_DATE_GREATER) then
             Begin
               dbf^.status := SQL_ENDPROCESS;
               exit;
             end;
         end;
        this := this^.next;
      end;
  end;
  dbf^.status := SQL_PROCESS;
end;

Function Qualify(this:psql):boolean;
var
 s : string;
Begin
  qualify := true;
  while this<>nil do
    Begin
      s := stringget(this^.fieldname);
      case this^.sql_type of
       SQL_MATCHALL : if (s<>this^.searchpref) then qualify := false;
       SQL_MATCHSOME_FIRST : if (pos(this^.searchpref,s)<>1) then qualify := false;
       SQL_MATCHSOME : if (pos(this^.searchpref,s)=0) then qualify := false;
       SQL_EXCLUDEALL : if (s=this^.searchpref) then qualify := false;
       SQL_EXCLUDESOME : if (pos(this^.searchpref,s)>0) then qualify := false;
       SQL_EXCLUDESOME_FIRST : if (pos(this^.searchpref,s)=1) then qualify := false;
       {SQL_DATE_GREATER : if (str2jul(s)<=this^.ldata) then qualify := false;}
      end;
     this := this^.next;
    end;
end;

{Compares HDBF_PROCESS # of records and update listboxes etc...}
Procedure SQL_Process_OBJECT(dbf:handle_dbf_object);
var
 x,y,loop : byte;
 hlb  : handle_listbox;
 hdlg : handle_dialog;
 s,s2,s3 : string;
 sl : word;
 cp : longint;
 dlglost : boolean;
Begin
  s2 := '';s3 := '';
  dlglost := false;
  If dbf=nil then exit;
  Adjust_File_Pointer(dbf);

  {Get Handle to Listbox thingy}
  if dbf^.privilege>0 then hlb := get_handle_listbox(dbf^.privilege) else hlb := nil;
  {Get Handle to Freagin Dialog Box}
  if dbf^.dlg>0 then
     Begin
       hdlg := get_handle_dialog(dbf^.dlg);
       if hdlg=nil then dlglost := true;
     end else hdlg := nil;

  for loop := 1 to HDBF_PROCESS do
    Begin
      if not(dlglost) then
      if qualify(dbf^.first_sql) then
      Begin
        if hlb<>nil then
          Begin
            s := '';
            if dbf^.numcolumns>0 then
            for x := 1 to dbf^.numcolumns do
              Begin
                if hlb^.first_item=nil then
                Begin
                  s2 := s2 + lpad(field(dbf^.columndef[x].fieldnum),dbf^.columndef[x].fieldlength);
                  for y := 1 to dbf^.columndef[x].fieldlength do s3 := s3 + '';
                  if x<dbf^.numcolumns then
                    Begin
                      s2 := s2 + '  ';
                      s3 := s3 + '';
                    end;
                end;
                s := s + lpad(stringgetn(dbf^.columndef[x].fieldnum),dbf^.columndef[x].fieldlength);
                if x<dbf^.numcolumns then s := s +'  ';
              end;
            if (hlb^.first_item=nil) then
              Begin
                Add_Listbox_Item(hlb,s2,dbf^.maxlength,0);
                Add_Listbox_Item(hlb,s3,dbf^.maxlength,0);
              end;
            Add_Listbox_Item(hlb,s,dbf^.maxlength,recno);
            if (loop=HDBF_PROCESS) or (DEOF) then
              if (hdlg<>nil) then
                 if (hdlg=cur_dialog) then
                   Begin
                     if hlb^.vert_sb<>nil then
                         cp := hlb^.vert_sb^.curpos+((hlb^.ypos1-hlb^.ypos-8) div 8+1) else
                         cp := (hlb^.ypos1-hlb^.ypos-8) shr 3 + 1;
                         if (hlb^.numitems<=cp shl 1) or (deof) then Draw_Listbox(hdlg,hlb,false);
                         if (hlb^.vert_sb<>nil) then Draw_Scrollbar(hdlg,hlb^.vert_sb);
                   end;
          end;
      end;
      skip(1);
      if (deof) or ((recno>dbf^.rangeend) and not(dbf^.rangeend=0)) or (dlglost) then
        Begin
          dbf^.status := SQL_ENDPROCESS;
          exit;
        end;
    end;
end;

{Resets file positions and variables in DBF_OBJECT}
Procedure SQL_End_Process(dbf:handle_dbf_object);
var
 hdlg : handle_dialog;
 hlb : handle_listbox;
Begin
  If dbf=nil then exit;
  Adjust_File_Pointer(dbf);
  dbf^.status := 0;
  if dbf^.privilege>0 then hlb := get_handle_listbox(dbf^.privilege) else hlb := nil;
  hdlg := get_handle_dialog(dbf^.dlg);
  Draw_Listbox(hdlg,hlb,false);
  file_sound;
end;

{Uses Information in data field of DBF_OBJECT and appends it to Data File}
Procedure Append_to_File(dbf:handle_dbf_object);
Begin
  If dbf=nil then exit;
  Adjust_File_Pointer(dbf);
  Append;
end;

{Replaces CURRECNO data with data field of DBF_OBJECT}
Procedure Replace_Record(dbf:handle_dbf_object);
Begin
  If dbf=nil then exit;
  Adjust_File_Pointer(dbf);
  Replace;
end;

{Deletes CURRECNO from file}
Procedure Delete_Record(dbf:handle_dbf_object);
Begin
 if dbf=nil then exit;
 Adjust_File_Pointer(dbf);
 DeleteRec;
end;

{Loads CURRECNO into data field of DBF_OBJECT}
Procedure Get_Record(dbf:handle_dbf_object);
Begin
 if dbf=nil then exit;
 Adjust_File_Pointer(dbf);

end;

Procedure Process_DBF_Object(dbf:handle_dbf_object);
Begin
  if dbf=nil then exit;
  case dbf^.status of
    SQL_IDLE       : exit;
    SQL_INIT       : SQL_Initialize(dbf);
    SQL_PROCESS    : SQL_Process_OBJECT(dbf);
    SQL_ENDPROCESS : SQL_End_Process(dbf);
    SQL_APPEND     : Append_to_File(dbf);
    SQL_REPLACE    : Replace_Record(dbf);
    SQL_DELETE     : Delete_Record(dbf);
    SQL_RETRIEVE   : Get_Record(dbf);
    else
      Begin
        dbf^.status := 0;
        message_box('DBF Error',lpad('Invalid File Status',40)+lpad('Disabling Thread',40)+
                    lpad(dbf^.filename,40),OK,standard_close_dialog,0);
      end;
  end;
end;

Procedure Process_DBF_Callbacks;
var
 dbf : handle_dbf_object;
Begin
 dbf := first_dbf;
 while dbf<>nil do
   Begin
     process_DBF_object(dbf);
     dbf := dbf^.next;
   end;
end;

Procedure HDBF_Execute_Procedure(proc:longint);
Begin
  if (proc=HDBF_CALLBACK_ID) then process_DBF_callbacks;
end;

Procedure SQL_Insert(dbf:handle_dbf_object;
                     sql_type:byte;
                     fieldname:string;
                     searchpref:string);
var
 this : psql;
 fr : GSP_DBFFIELD;
 x : byte;
 s : string;
Begin
 fr := nil;
 if dbf=nil then exit;
 Adjust_File_Pointer(dbf);
 new(this);
 this^.sql_type  := sql_type;
 if sql_type in [SQL_COLUMN..SQL_EXCLUDESOME] then
 Begin
   this^.fieldname := fieldname;
   fr := getfieldnum(fieldname);
   if fr=nil then
     Begin
       dispose(this);
       message_box('SQL Error in '+dbf^.filename,lpad('Invalid Field Name in SQL Search:',40)+
                                   fieldname,OK,standard_close_dialog,0);
       exit;
    end;
    this^.fieldnum  := fr^.fieldnum;
 end else
 Begin
   this^.fieldname := '';
   this^.fieldnum := 0;
 end;

 case sql_type of
   SQL_USEINDEX : Begin
                    if (dbf^.numindexes=0) then
                      Begin
                        dispose(this);
                        exit;
                      end;
                    for x := 1 to dbf^.numindexes do
                      Begin
                        if (dbf^.indexes[x].indexedby=searchpref) then
                           Begin
                             dispose(this);
                             dbf^.curindex := x;
                             exit;
                           end;
                      end;
                    dispose(this);
                    exit;
                  end;
   SQL_RANGESTART : Begin
                      dispose(this);
                      if stoi(searchpref)<0 then
                        dbf^.rangestart := 0 else
                        dbf^.rangestart := stoi(searchpref);
                      exit;
                    end;
   SQL_RANGEEND  : Begin
                     dispose(this);
                     if stoi(searchpref)>reccount then
                        dbf^.rangeend := reccount else
                        dbf^.rangeend := stoi(searchpref);
                      exit;
                    end;
   SQL_RECORDNUM : Begin
                     dispose(this);
                     if stoi(searchpref)>reccount then
                        Begin
                          dbf^.rangeend   := reccount;
                          dbf^.rangestart := reccount;
                        end else
                        Begin
                          dbf^.rangeend   := stoi(searchpref);
                          dbf^.rangestart := stoi(searchpref);
                        end;
                      exit;
                    end;
    SQL_COLUMN  : Begin
                    if (dbf^.numcolumns<256) then
                      Begin
                        inc(dbf^.numcolumns);
                        dbf^.columndef[dbf^.numcolumns].fieldnum    := this^.fieldnum;
                        if fr^.fieldlen>dbf^.mfl then
                        dbf^.columndef[dbf^.numcolumns].fieldlength := dbf^.mfl else
                        dbf^.columndef[dbf^.numcolumns].fieldlength := fr^.fieldlen;
                        dispose(this);
                        exit;
                      end else
                      Begin
                        dispose(this);
                        exit;
                      end;
                  end;
   else Begin
          this^.searchpref := searchpref;
          {if sql_type=SQL_DATE_GREATER then this^.ldata := str2jul(searchpref);}
          this^.next := nil;
          this^.prev := dbf^.last_sql;
          if dbf^.first_sql=nil then dbf^.first_sql := this;
          if dbf^.last_sql<>nil then dbf^.last_sql^.next := this;
          dbf^.last_sql := this;
          dbf^.cur_sql:= this;
        end;
   end;
end;

Procedure SQL_Reset(dbf:handle_dbf_object);
var
 next,this : psql;
Begin
 if (dbf=nil) then exit;
 this := dbf^.first_sql;
 while this<>nil do
   Begin
     next := this^.next;
     dispose(this);
     this := next;
   end;
end;

Procedure SQL_Execute(dbf:handle_dbf_object);
Begin
  if (dbf=nil) then exit;
  if dbf^.status<>SQL_IDLE then exit;
  dbf^.status := SQL_INIT;
end;

Function DBF_GO(dbf:handle_dbf_object;rn:longint) : Boolean;
Begin
 dbf_go := false;
 Adjust_File_Pointer(dbf);
 if not(dbf^.fileopen) then exit;
 dbf^.status := 0;
 go(rn);
 if not(rn=recno) then exit;
 DBF_GO := true;
end;

Function  DBF_FIND(dbf:handle_dbf_object;searchpref:string;s:string) : Boolean;
var
  x : byte;
  ok : boolean;
Begin
  DBF_FIND := false;
  Adjust_File_Pointer(dbf);
  if not(dbf^.fileopen) then exit;
  if dbf^.numindexes=0 then exit;
  ok := true;
  if (dbf^.indexes[dbf^.curindex].indexedby<>searchpref) then
  for x := 1 to dbf^.numindexes do
    Begin
      ok := false;
      if (dbf^.indexes[x].indexedby=searchpref) then
       Begin
         ok := true;
         {index(dbf^.indexes[x].filename);}
         setorderto(x);
         dbf^.curindex := x;
         break;
       end;
    end;
  if not(ok) then exit;
  find(s);
  DBF_FIND := found;
end;


Function DBF_SKIP(dbf:handle_dbf_object;amount:longint) : Boolean;
Begin
 dbf_skip := false;
 Adjust_File_Pointer(dbf);
 if not(dbf^.fileopen) then exit;
 skip(amount);
 DBF_SKIP := true;
end;

Function DBF_CURREC(dbf:handle_dbf_object) : Longint;
Begin
 dbf_currec := 0;
 Adjust_File_Pointer(dbf);
 if not(dbf^.fileopen) then exit;
 DBF_currec := recno;
end;

Function DBF_STRINGPUT(dbf:handle_dbf_object;fieldname,value:string) : Boolean;
Begin
  dbf_stringput := false;
  Adjust_File_Pointer(dbf);
  if not(dbf^.fileopen) then exit;
  stringput(fieldname,value);
  dbf_stringput := true;
end;

Function DBF_STRINGGET(dbf:handle_dbf_object;fieldname:string) : String;
Begin
  dbf_stringget := '';
  Adjust_File_Pointer(dbf);
  if not(dbf^.fileopen) then exit;
  DBF_STRINGGET := stringget(fieldname);
end;

Function DBF_APPEND(dbf:handle_dbf_object) : Boolean;
Begin
  dbf_append := false;
  Adjust_File_Pointer(dbf);
  if not(dbf^.fileopen) then exit;
  append;
  dbf_append := true;
end;

Function DBF_REPLACE(dbf:handle_dbf_object) : Boolean;
Begin
  dbf_replace := false;
  Adjust_File_Pointer(dbf);
  if not(dbf^.fileopen) then exit;
  replace;
  dbf_replace := true;
end;

Function DBF_DELETE(dbf:handle_dbf_object) : Boolean;
Begin
  dbf_delete := false;
  Adjust_File_Pointer(dbf);
  if not(dbf^.fileopen) then exit;
  deleterec;
  DBF_DELETE := true;
end;

Function uc(s:string):string;
var
 x : byte;
Begin
 uc := s;
 if length(s)=0 then exit;
 for x := 1 to length(s) do s[x] := upcase(s[x]);
 uc := s;
end;

Function DBF_FIELDEXISTS(dbf:handle_dbf_object;s:string):boolean;
var
  x : integer;
Begin
  DBF_FIELDEXISTS := false;
  Adjust_File_Pointer(dbf);
  s := uc(s);
  for x := 1 to fieldcount do
    if (s=field(x)) then
      Begin
        DBF_FIELDEXISTS := true;
        exit;
      end;
end;

Procedure DBF_FILL_DLG_FIELDS(dbf:handle_dbf_object;dlg:handle_dialog);
var
 td : handle_data;
Begin
  if (dbf=nil) or (dlg=nil) then exit;
  if not(dbf^.fileopen) then exit;
  Adjust_File_Pointer(dbf);
  td := dlg^.first_data;
  while (td<>nil) do
    Begin
      if (td^.fieldtype=DB_EDIT) or (td^.fieldtype=DB_TEXT) then
        if dbf_fieldexists(dbf,td^.fieldname) then
        Begin
          td^.data.done;
          td^.data.init(td^.maxlength);
          td^.data.addstring(stringget(td^.fieldname));
        end;
      td := td^.next;
    end;
end;

Procedure DBF_FILL_FIELDS(dbf:handle_dbf_object;dlg:handle_dialog);
var
 td : handle_data;
Begin
  if (dbf=nil) or (dlg=nil) then exit;
  if not(dbf^.fileopen) then exit;
  Adjust_File_Pointer(dbf);
  td := dlg^.first_data;
  while (td<>nil) do
    Begin
      if (td^.fieldtype=DB_EDIT) or (td^.fieldtype=DB_TEXT) then
          stringput(td^.fieldname,td^.data.pstr);
      td := td^.next;
    end;
end;


Procedure DBF_CLEAR_DLG_FIELDS(dbf:handle_dbf_object;dlg:handle_dialog);
var
 td : handle_data;
Begin
  if (dbf=nil) or (dlg=nil) then exit;
  if not(dbf^.fileopen) then exit;
  Adjust_File_Pointer(dbf);
  td := dlg^.first_data;
  while (td<>nil) do
    Begin
      if (td^.fieldtype=DB_EDIT) or (td^.fieldtype=DB_TEXT) then
          Begin
            td^.data.done;
            td^.data.init(td^.maxlength);
            td^.data.addstring('');
            {stringput(td^.fieldname,td^.data.pstr);}
          end;
      td := td^.next;
    end;
end;


Function unique(fname:string) : string;
var
 son : string;
 sonum : longint;
 e : integer;
 hadbf : handle_dbf_object;
Begin
 hadbf := Add_DBF(unique_id,0,0,fname,0,0);
 gotop;
 if recno=0 then
 Begin
   sound(1000);
   delay(100);
   nosound;
   son := '1000000';
   stringput('DATA',son);
   DBF_append(hadbf);
 end else
 Begin
   son := DBF_StringGet(hadbf,'DATA');
   val(son,sonum,e);
   inc(sonum);
   str(sonum,son);
   while (length(son)<7) do son := '0'+son;
   if (sonum<1000000) then son := '1000000';
   dbf_stringput(hadbf,'DATA',son);
   dbf_replace(hadbf);
 end;
 flushdbf;
 unique := son;
 delete_dbf(hadbf);
end;

Function File_Erase(fname:string):Boolean;
var
 f : file;
 x : integer;
Begin
 File_Erase := False;
 if not(exists(fname)) then exit;
 assign(f,fname);
 x := 1;
 repeat
   erase(f);
   inc(x);
 until (IORESULT=0) or (x>1000);
 if (x>1000) then exit;
 File_Erase := True;
end;

Function File_Rename(fname,newfname:string):Boolean;
var
 f : file;
 x : integer;
Begin
 File_Rename := False;
 if not(exists(fname)) then exit;
 if (exists(newfname)) then exit;
 assign(f,fname);
 x := 1;
 repeat
   rename(f,newfname);
   inc(x);
 until (IORESULT=0) or (x>1000);
 if (x>1000) then exit;
 File_Rename := True;
end;


Begin
  filemode := 66;
  first_dbf := nil;
  last_dbf := nil;
  cur_dbf := nil;
  fillchar(fposused,sizeof(fposused),0);
  SetExactOff;
end.
