Unit FileDlg;

Interface

Uses Crt,Dos,Vesa,Windows,Mouseu,global,routine;

Type
  FrPtr = ^File_Result;
  File_Result = Record
                  filename : string;
                  return : byte;
                end;

Var
  fd_frptr : frptr;
  fd_cdir : string;
  driveavailable : array[0..25] of boolean;
  fd_searchspec : string;
  fd_active : longint;
  fd_close_ok,
  fd_close_cancel : longint;

Procedure OpenFile_Dialog(title:string;close_ok,close_cancel : longint);
Procedure ChangeDirectory;
Procedure CloseFile_Dialog_OK;
Procedure CloseFile_Dialog_CANCEL;
Procedure FD_SETSEARCH(s:string);

Implementation

Uses fd_head;

Procedure FD_SETSEARCH(s:string);
Begin
  fd_searchspec := s;
end;

Procedure CheckDrives;
Var
   dummybyte : byte;
   Exist : Boolean;
Begin
     Asm
        Mov ah,19h
        int 21h
        push ax
     End;
     For DummyByte := 0 to 25 do
     Begin
          Asm
             mov ah,0eh
             mov dl,DummyByte
             int 21h
             mov ah,19h
             int 21h
             mov exist,FALSE
             cmp al,DummyByte
             jne @@NotExist
             mov exist,TRUE
@@notexist:
         End;
         DriveAvailAble[DummyByte] := Exist;
    End;
    Asm
        pop ax
        mov ah,0eh
        mov dl,al
        int 21h
    End;
    { Now check for Drive B existance }
    Asm
       mov ah,15h
       mov dl,1
       int 13h
       mov exist,TRUE
       cmp ah,00h
       jne @@bexist
       mov exist,FALSE
@@bexist:
    End;
    DriveAvailable[1] := Exist;
End;

Procedure FD_CDERROR(s:string);
var
 p : string;
Begin
 GetDir(0,P);
 s := p+'\'+s;
 message_box('Drive Error',LPAD('Cannot Change to directory:',40)+s,OK,standard_close_dialog,0);
end;

Procedure CloseFile_Dialog_OK;
var
 fd : string;
Begin
  getdir(0,fd_frptr^.filename);
  fd_frptr^.filename := fd_frptr^.filename+'\'+cur_dialog^.first_data^.data.pstr;
  if pos('.',fd_frptr^.filename)=0 then
    Begin
      fd := fd_searchspec;
      if pos('.',fd)>0 then
        delete(fd,1,pos('.',fd)-1);
      fd_frptr^.filename := fd_frptr^.filename+fd;
    end;
  fd_frptr^.return := 0;
  {$I-}
  chdir(fd_cdir);
  if IORESULT<>0 then
    Begin
      FD_CDERROR(fd_cdir);
      exit;
    end;
  {$I+}
  standard_close(true);
  if (fd_close_ok>0) then execute_procedure(fd_close_ok);
end;

Procedure CloseFile_Dialog_CANCEL;
Begin
  getdir(0,fd_frptr^.filename);
  fd_frptr^.filename := fd_frptr^.filename+cur_dialog^.first_data^.data.pstr;
  fd_frptr^.return := 255;
  {$I-}
  chdir(fd_cdir);
  if IORESULT<>0 then
    Begin
      FD_CDERROR(fd_cdir);
      exit;
    end;
  {$I+}
  standard_close(true);
  if (fd_close_cancel)>0 then execute_procedure(fd_close_cancel);
end;

Procedure GetDirs(list:handle_listbox);
var
 d : searchrec;
Begin
  FindFirst('*.',Directory, D); { Same as DIR *.PAS }
  while DosError = 0 do
  begin
    Add_ListBox_Item(list,D.Name,80,0);
    FindNext(D);
  end;
  sort_listbox(list);
end;

Procedure GetFiles(list:handle_listbox);
var
 d : searchrec;
Begin
  FindFirst(fd_searchspec,Archive, D); { Same as DIR *.PAS }
  while DosError = 0 do
  begin
    Add_ListBox_Item(list,D.Name,80,0);
    FindNext(D);
  end;
  sort_listbox(list);
end;

Procedure GetDrives;
var
 x : byte;
Begin
{ CheckDrives;}
 for x := 0 to 25 do
   if driveavailable[x] then Add_Listbox_Item(cur_dialog^.cur_lb,chr(x+65)+':',80,0);
end;

Procedure Initialize_File_Dialog;
var
 x : integer;
Begin
 Add_Data(fd_active,cur_dialog,11,20,false,12,12,string_field,'','',0);
 Add_ListBox(fd_active,cur_dialog,'File List',10,60,130,244,NO_HSB,unique_id,fd_selfile,cur_dialog^.first_data,0);
 Add_ListBox(fd_active,cur_dialog,'Directories',185,60,306,244,NO_HSB,unique_id,fd_chdir,nil,0);
 GetDirs(cur_dialog^.cur_lb);
 GetFiles(cur_dialog^.first_lb);
 GetDrives;
end;

Procedure ChangeDirectory;
var
 s : string;
Begin
  if cur_dialog=nil then exit;
  s := cur_dialog^.cur_lb^.cur_item^.data.pstr;
  {$I-}
  chdir(s);
  if IORESULT<>0 then
    Begin
      FD_CDERROR(s);
      exit;
    end;
  {$I+}
  if cur_dialog=nil then exit;
  Delete_All_Listbox_items(cur_dialog^.cur_lb);
  Delete_All_Listbox_items(cur_dialog^.first_lb);
  Getdirs(cur_dialog^.cur_lb);
  GetFiles(cur_dialog^.first_lb);
  GetDrives;
  {freemem(cur_dialog^.first_lb^.data_field^.data,cur_dialog^.first_lb^.data_field^.maxlength+1);
  getmem(cur_dialog^.first_lb^.data_field^.data,cur_dialog^.first_lb^.data_field^.maxlength+1);
  addstr('',cur_dialog^.first_lb^.data_field^.data,cur_dialog^.first_lb^.data_field^.maxlength+1);}
  cur_dialog^.first_lb^.data_field^.data.done;
  cur_dialog^.first_lb^.data_field^.data.init(cur_dialog^.first_lb^.data_field^.maxlength);
  cur_dialog^.first_lb^.data_field^.data.addstring('');
  hm;
  Draw_Data(cur_dialog,cur_dialog^.first_lb^.data_field);
  Draw_Listbox(cur_dialog,cur_dialog^.first_lb,true);
  Draw_Listbox(cur_dialog,cur_dialog^.first_lb^.next,true);
  Draw_Scrollbar(cur_dialog,cur_dialog^.first_lb^.vert_sb);
  Draw_Scrollbar(cur_dialog,cur_dialog^.first_lb^.next^.vert_sb);
  sm;
end;

Procedure OpenFile_Dialog(title:string;close_ok,close_cancel:longint);
var
 xpos,ypos,
 xpos1,ypos1 : integer;
 mbox : longint;
Begin
 if fd_frptr=nil then new(fd_frptr);

 getdir(0,fd_cdir);
 {480x320}
 mbox := unique_id;
 fd_active := mbox;
 xpos := (maxx shr 1)-160;
 ypos := (maxy shr 1)-160;
 xpos1 := xpos+320;
 ypos1 := ypos+320;
 fd_close_ok := close_ok;
 fd_close_cancel := close_cancel;
 Create_Dialog(mbox,title,xpos,ypos,xpos1,ypos1,standard_dialog,Close_Button+Help_Button+Moveable,
                    0,0,0,fd_closefunc2,0,0,0,0,0);
 Add_Button(fd_active,Cur_Dialog,222,268,0,'&OK',0,true,fd_closefunc);
 Add_Button(fd_active,Cur_Dialog,252,268,0,'&Cancel',0,true,fd_closefunc2);
 Add_Accelerator(unique_id,cur_dialog,alt,Okey,fd_closefunc);
 Add_Accelerator(unique_id,cur_dialog,alt,Ckey,fd_closefunc2);

 Initialize_File_Dialog;
 setactive(fd_active);
end;

Begin
 {checkdrives;}
 fd_searchspec := '*.RES';
 fd_close_ok := 0;
 fd_close_cancel := 0;
 fd_frptr := nil;
End.
