Unit Desktop;

Interface

Uses Crt,Dos,Vesa,Windows,Mouseu,global,routine,printer;

Procedure Initialize_Desktop;
Procedure Reset_Desktop;
Procedure Desktop_Execute_Procedure(proc:longint);
Function  Browser(fname:string):Boolean;

Var
  Desktop_Id : Longint;
  Desktop_Handle : handle_dialog;
  desktop_grid : array[1..32,1..32] of byte;
  desktop_maxx,desktop_maxy : byte;
  desktop_bmp1 : longint;
  desktop_bmp2 : longint;
  desktop_bmp3 : longint;

  desktop_button_hit : longint;
  desktop_print : longint;
  desktop_bid : longint;

Implementation


Function Add_To_Desktop(bmpid:longint;fname:string):Boolean;
var
 x,y : integer;
Begin
  Add_To_Desktop := False;
  for x := 1 to desktop_maxx do
    for y := 1 to desktop_maxy do
        if (desktop_grid[x,y]=0) then
          Begin
            desktop_grid[x,y]:=1;
            Add_To_Desktop := True;
            Add_Button(unique_id,desktop_handle,(x-1) shl 7+20,(y-1) shl 5+4,0,lpad(fname,12),bmpid,true,desktop_button_hit);
            exit;
          end;
end;

Procedure Desktop_Getfiles(sspec:string;bmpid:longint);
var
 d : searchrec;
Begin
  if sspec='*.' then
  Begin
    FindFirst(sspec,Directory, D); { Same as DIR *.PAS }
    while DosError = 0 do
    begin
      Add_to_Desktop(desktop_bmp1,d.name);
      FindNext(D);
    end;
  end else
  Begin
    FindFirst(sspec,Archive, D); { Same as DIR *.PAS }
    while DosError = 0 do
    begin
      Add_to_Desktop(bmpid,d.name);
      FindNext(D);
    end;
  end;
end;

Procedure Initialize_Desktop;
Begin
  desktop_id := unique_id;
  Create_Dialog(desktop_id,'Computer Desktop',0,0,maxx,maxy,Standard_Dialog,
                modal+close_button+sizeable+maximize_button+moveable,
                0,0,0,0,0,nothing,nothing,nothing,nothing);
  desktop_bmp1 := unique_id;
  desktop_bmp2 := unique_id;
  desktop_bmp3 := unique_id;


  desktop_maxx := maxx div 96; if desktop_maxx>32 then desktop_maxx := 32;
  desktop_maxy := maxy div 32+1; if desktop_maxy>32 then desktop_maxy := 32;
  desktop_handle := get_handle_dialog(desktop_id);

  Add_Bmp(desktop_bmp1,desktop_handle,-1,0,MASKED_PUT,'\RESEDIT\ICONS\I1.BMP',0);
  Add_Bmp(desktop_bmp2,desktop_handle,-1,0,MASKED_PUT,'\RESEDIT\ICONS\I2.BMP',0);
  Add_Bmp(desktop_bmp3,desktop_handle,-1,0,MASKED_PUT,'\RESEDIT\ICONS\I6.BMP',0);

  Desktop_Button_Hit := unique_id;
  Desktop_Getfiles('*.',desktop_bmp3);
  Desktop_Getfiles('*.EXE',desktop_bmp1);
  Desktop_Getfiles('*.DLG',desktop_bmp2);
  Desktop_Getfiles('*.RES',desktop_bmp2);
  Desktop_Getfiles('*.PAS',desktop_bmp2);
  Desktop_Getfiles('*.TXT',desktop_bmp2);

  setactive(desktop_id);
end;

Procedure Reset_Desktop;
Begin
  delete_all_buttons(desktop_handle);
  fillchar(desktop_grid,sizeof(desktop_grid),0);
  refresh;
end;

Function Browser(fname:string):Boolean;
var
 f : text;
 x1,y1,x2,y2 : integer;
 s : string;
Begin
  Browser := false;
  if not(exists(fname)) then exit;
  x1 := maxx shr 1 - 240;
  y1 := maxy shr 1 - 180;
  x2 := x1 + 480;
  y2 := y1 + 360;

  desktop_bid := unique_id;
  Create_Dialog(desktop_bid,fname,x1,y1,x2,y2,standard_dialog,
                help_button+close_button+moveable+modal,0,0,0,standard_close_dialog,0,0,0,0,0);
  Add_ListBox(desktop_bid,cur_dialog,'',10,10,(x2-x1)-16,(y2-y1)-50,unique_id,unique_id,0,nil,0);
  Add_Menu(cur_dialog,'File');
  Add_Menu_Item(unique_id,cur_dialog^.cur_menu,'&Print',desktop_print);
  assign(f,fname);
  reset(f);
  while not eof(f) do
    Begin
      readln(f,s);
      add_listbox_item(cur_dialog^.cur_lb,s,80,0);
    end;
  close(f);
  browser := true;
  setactive(desktop_bid);
end;

Procedure Handle_DesktopButton;
var
 fname : string;
 ext : string;
Begin
 fname := cur_dialog^.cur_button^.btext.pstr;
 ext := fname;
 if pos('.',ext)>0 then delete(ext,1,pos('.',ext));
 Browser(fname);
end;

Procedure Print_File;
var
 hlb : handle_listbox;
 lbi : lt;
Begin
 sound(1000);
 delay(50);
 nosound;
 hlb := get_handle_listbox(desktop_bid);
 if hlb=nil then exit;
 lbi := hlb^.first_item;
 sound(1000);
 delay(50);
 nosound;
 while lbi<>nil do
   Begin
     writeln(lst,lbi^.data.pstr);
     lbi := lbi^.next;
   end;
  writeln(lst,#12);
end;


Procedure Desktop_Execute_Procedure(proc:longint);
Begin
  if proc=desktop_button_hit then Handle_DesktopButton else
  if proc=desktop_print then Print_File;
end;

Begin
  desktop_id := 0;
  fillchar(desktop_grid,sizeof(desktop_grid),0);
  desktop_maxx := 0;
  desktop_maxy := 0;
  desktop_print := 2134567890;
{  writeln('Desktop Extension v1.0');
  delay(750);}
end.
