var
 lf : text;

Procedure Openlog;
Begin
 assign(lf,'DBS.LOG');
 rewrite(lf);
end;

Procedure Closelog;
Begin
 close(lf);
end;

Procedure Log(s:string);
Begin
 writeln(lf,s);
end;

Procedure importdbsfile;
var
 s : boolean;
 hdbf : handle_dbf_object;
 hdlg : handle_dialog;
 x,y : integer;
 t,t2 : string;
 ft : byte;
 t2uid,tuid : longint;
Begin
  curdbs := fd_frptr^.filename;
  read_dbs(curdbs);
  tuid := unique_id;
  t := curdbs;
  while pos('\',t)>0 do delete(t,1,1);
  if pos('.',t)>0 then delete(t,pos('.',t),255);
  t2 := t;
  tdid := unique_id;
  create_dialog(tdid,t,0,0,639,479,Standard_Dialog,modal+moveable+help_button+close_button,
                nothing,nothing,nothing,nothing,0,0,0,0,0);
  hdlg := get_handle_dialog(tdid);

  {add_dbf(tuid,0,tid,'\RESEDIT\CSI\'+t2);
  hdbf := get_handle_dbf(tuid);}

  log('[DBS INFO] ID : '+itos(tdid)+'   DB ID : '+itos(tuid));
  if nt>0 then
    for x := 1 to nt do
        Begin
          Add_Text(unique_id,hdlg,(tt[x].xpos-1)shl 3+3,(tt[x].ypos-1)*19+4,tt[x].s,0);
          log('          [TEXT] '+tt[x].s);
        end;
  curfield := firstfield;
  while curfield<>nil do
    with curfield^ do
    Begin
      x := (xpos shl 3);
      y := (ypos-1)*19+2;
      if (display) then
        Begin
          if (fieldname[1]=#255) then
             Begin
               fieldname := '';
               s := true;
             end else s := false;
          case fieldtype of
           'S' : ft := string_field;
           'A' : ft := amount_field;
           'P' : ft := Phone_Field;
           'M' : ft := Credit_Card_Field;
           'T' : ft := Time_Field;
           'D' : ft := Date_Field;
           '*' : ft := Password_Field;
           'C' : ft := Character_Field;
           'B' : ft := Byte_Field;
           'I' : ft := Integer_Field;
           'W' : ft := Word_Field;
           'R' : ft := Real_Field;
           'P' : ft := Memo_Field;
           'E' : ft := Credit_Expiration_Field;
           'Z' : ft := Account_Field;
          end;
          t2uid := unique_id;
          if s then
          add_data(t2uid,hdlg,x,y,true,fieldwidth,fieldlength,DB_TEXT,fieldname,
                   '['+itos(tuid)+';'+db4name+';'+itos(ft)+']',0) else
          add_data(t2uid,hdlg,x,y,true,fieldwidth,fieldlength,DB_EDIT,fieldname,
                   '['+itos(tuid)+';'+db4name+';'+itos(ft)+']',0);
          log('          [DATA] '+lpad('ID : '+itos(t2uid),20)+
              lpad('DB : '+db4name,20)+lpad('TYPE : '+fieldtype,10)+'('+fieldname+')');
        end;
      curfield := curfield^.next;
    end;
  deinit_dbs;
  {write_table(DBDIR+t2,hdbf);
  delete_dbf(hdbf);}
  convert_dialog(tdid);
end;

Procedure import_dbsfile;
var
 hdlg : handle_dialog;
Begin
  importdbsfile;
  setactive(tdid);
  hdlg := get_handle_dialog(tdid);
  did := unique_id;
  create_dialog(did,'DBS : '+curdbs,0,312,639,maxy,Standard_Dialog,
                help_button+close_button+moveable,0,0,0,rc_deletedlg,0,0,0,0,0);

  Add_CheckBox(91,cur_dialog,10,130,'Modal',true,true,rc_redrawdlg);
  Add_CheckBox(92,cur_dialog,200,130,'Moveable',true,true,rc_redrawdlg);
  Add_CheckBox(93,cur_dialog,10,150,'Sizeable',true,false,rc_redrawdlg);
  Add_CheckBox(94,cur_dialog,200,150,'Help',true,true,rc_redrawdlg);
  Add_CheckBox(95,cur_dialog,10,170,'Minimize',true,false,rc_redrawdlg);
  Add_CheckBox(96,cur_dialog,200,170,'Maximize',true,false,rc_redrawdlg);
  Add_CheckBox(97,cur_dialog,10,190,'Close',true,true,rc_redrawdlg);
  Add_CheckBox(98,cur_dialog,200,190,'Horz. Scrollbar',true,False,rc_redrawdlg);
  Add_CheckBox(99,cur_dialog,10,210,'Vert. Scrollbar',true,False,rc_redrawdlg);
  Add_CheckBox(100,cur_dialog,200,210,'Menu',true,False,rc_redrawdlg);
  Add_Data(90,cur_dialog,10,25,true,11,11,string_field,      'Resource ID ',itos(hdlg^.id),rc_redrawdlg);
  Add_Data(85,cur_dialog,10,45,true,60,60,string_field,'Name        ',hdlg^.name,rc_redrawdlg);
  Add_Data(86,cur_dialog,10,65,true,4,4,string_field, 'XPOS        ',itos(hdlg^.xpos),rc_redrawdlg);
  Add_Data(87,cur_dialog,200,65,true,4,4,string_field,'YPOS ',itos(hdlg^.ypos),rc_redrawdlg);
  Add_Data(88,cur_dialog,10,85,true,4,4,string_field, 'XPOS1       ',itos(hdlg^.xpos1),rc_redrawdlg);
  Add_Data(89,cur_dialog,200,85,true,4,4,string_field,'YPOS1',itos(hdlg^.ypos1),rc_redrawdlg);
  Add_Button(unique_id,cur_dialog,430,240,0,'&Save',0,true,rc_savedlg);
  Add_Button(unique_id,cur_dialog,500,240,0,'&Done',0,true,standard_close_dialog);
  Add_Button(unique_id,cur_dialog,570,240,0,'&Close',0,true,rc_deletedlg);

  Add_Accelerator(unique_id,cur_dialog,alt,skey,rc_savedlg);
  Add_Accelerator(unique_id,cur_dialog,alt,dkey,standard_close_dialog);
  Add_Accelerator(unique_id,cur_dialog,alt,ckey,rc_deletedlg);

  defaultmouseextents;
  setactive(did);
end;

Procedure DBStoRes;
Begin
  fd_setsearch('*.DBS');
  OpenFile_Dialog('Convert DBS Directory to RES',rc_dbstoresok,0);
end;

Procedure Add_DBS;
var
 hdlg : handle_dialog;
 x : integer;
 okb : boolean;
Begin
  okb := false;
  hdlg := get_handle_dialog(tdid);
  if hdlg<>nil then
   for x := 1 to 750 do
    if (resource_index^[x].id=0) or (resource_index^[x].id=hdlg^.id) then
    with resource_index^[x] do
    Begin
      okb := true;
      while (pos('\',fd_frptr^.filename)>0) do delete(fd_frptr^.filename,1,1);
      if (pos('.',fd_frptr^.filename)>0) then delete(fd_frptr^.filename,pos('.',fd_frptr^.filename),255);
      filename := fd_frptr^.filename;
      id := hdlg^.id;
      fileposition := 0;
      title := hdlg^.name;
      inc(resource_header^.num_chunks);
      log('    [DIALOG ID] '+itos(id));
      exit;
    end;
  if not (okb) then message_box('Resource Error','Error Adding Dialog',OK,standard_close_dialog,0);
end;

Procedure DBStoResOk;
var
 dir : string;
 cdir : string;
 d : searchrec;
 f2 : string;
 ca : longint;
Begin
 openlog;

 log('Database Script file to Resource Log file');log('');

 Create_Resource(RESOURCEDIR+'DBS');

 log('Resource : '+resourcedir+'DBS');

 ca := cur_dialog^.id;
 dir := fd_frptr^.filename;
 if pos('.',dir)>0 then delete(dir,pos('.',dir),255);
 dir := dir;
 FindFirst(dir+'*.DBS', Archive, D);
 while DosError = 0 do
 begin
   fd_frptr^.filename := dir+d.name;
   f2 := d.name;
   if pos('.',f2)>0 then delete(f2,pos('.',f2),255);
   f2 := DIALOGDIR+f2 +'.DLG';
   log('');
   log('[DIALOG] '+f2);
   importdbsfile;
   Add_DBS;
   write_dialog(f2,get_handle_dialog(tdid));
   close_dialog(get_handle_dialog(tdid));
   log('');
   FindNext(D);
 end;
 Save_Resource(RESOURCEDIR+'DBS.RES');
 enable_button(115);
 enable_button(116);
 setactive(ca);
 closelog;
 browser('DBS.LOG');
end;
