Procedure Edit_Dialog;
var
 tid : longint;
 hdlg : handle_dialog;
 hsb : handle_scrollbar;
 id1,id2 : longint;
begin
  did := unique_id;
  hdlg := cur_dialog;
  create_dialog(did,'Edit Dialog Box',0,240,639,maxy,Standard_Dialog,
                help_button+close_button+moveable,0,0,0,rc_deletedlg,0,0,0,0,0);

  Add_CheckBox(91,cur_dialog,10,170,'Modal',true,bitset(hdlg^.flags,modal),rc_redrawdlg);
  Add_CheckBox(92,cur_dialog,200,170,'Moveable',true,bitset(hdlg^.flags,moveable),rc_redrawdlg);
  Add_CheckBox(93,cur_dialog,10,190,'Sizeable',true,bitset(hdlg^.flags,sizeable),rc_redrawdlg);
  Add_CheckBox(94,cur_dialog,200,190,'Help',true,bitset(hdlg^.flags,help_button),rc_redrawdlg);
  Add_CheckBox(95,cur_dialog,10,210,'Minimize',true,bitset(hdlg^.flags,minimize_button),rc_redrawdlg);
  Add_CheckBox(96,cur_dialog,200,210,'Maximize',true,bitset(hdlg^.flags,maximize_button),rc_redrawdlg);
  Add_CheckBox(97,cur_dialog,10,230,'Close',true,bitset(hdlg^.flags,close_button),rc_redrawdlg);
  Add_CheckBox(98,cur_dialog,200,230,'Horz. Scrollbar',true,hdlg^.horz_sb<>nil,rc_redrawdlg);
  Add_CheckBox(99,cur_dialog,10,250,'Vert. Scrollbar',true,hdlg^.vert_sb<>nil,rc_redrawdlg);
  Add_CheckBox(100,cur_dialog,200,250,'Menu',true,hdlg^.first_menu<>nil,rc_redrawdlg);

  Add_Data(90,cur_dialog,10,25,true,11,11,string_field,      'Resource ID ',itos(hdlg^.id),rc_redrawdlg);

  Add_Data(85,cur_dialog,10,45,true,60,60,string_field,'Name        ',hdlg^.name,rc_redrawdlg);

  Add_Data(86,cur_dialog,10,65,true,4,4,string_field, 'XPOS        ',itos(hdlg^.xpos),rc_redrawdlg);

  Add_Data(87,cur_dialog,200,65,true,4,4,string_field,'YPOS ',itos(hdlg^.ypos),rc_redrawdlg);

  Add_Data(88,cur_dialog,10,85,true,4,4,string_field, 'XPOS1       ',itos(hdlg^.xpos1),rc_redrawdlg);

  Add_Data(89,cur_dialog,200,85,true,4,4,string_field,'YPOS1',itos(hdlg^.ypos1),rc_redrawdlg);

  Add_Data(130,cur_dialog,10,110,true,11,11,string_field,'Close Funct    ',itos(hdlg^.tclose_func),rc_redrawdlg);
  Add_Data(131,cur_dialog,300,110,true,11,11,string_field,'Help Funct     ',itos(hdlg^.thelp_func),rc_redrawdlg);
  Add_Data(132,cur_dialog,10,130,true,11,11,string_field,'Minimize Funct ',itos(hdlg^.tminimize_func),rc_redrawdlg);
  Add_Data(133,cur_dialog,300,130,true,11,11,string_field,'Maximize Funct ',itos(hdlg^.tmaximize_func),rc_redrawdlg);

  Add_Button(unique_id,cur_dialog,430,240,0,'&Save',0,true,rc_savedlg);
  Add_Button(unique_id,cur_dialog,500,240,0,'&Done',0,true,standard_close_dialog);
  Add_Button(unique_id,cur_dialog,570,240,0,'&Close',0,true,rc_deletedlg);

  Add_Accelerator(unique_id,cur_dialog,alt,skey,rc_savedlg);
  Add_Accelerator(unique_id,cur_dialog,alt,dkey,standard_close_dialog);
  Add_Accelerator(unique_id,cur_dialog,alt,ckey,rc_deletedlg);

  setactive(did);
end;

Procedure New_Dialog;
var
 tid : longint;
 hdlg : handle_dialog;
 hsb : handle_scrollbar;
{ id1,id2 : longint;}
begin
  clipset(0,0,maxx,maxy);
  if not(new_sized_rect(0,0,1023,767)) then exit;

  tdid := unique_id;
  create_dialog(tdid,'New Dialog Box',rect.x1,rect.y1,rect.x2,rect.y2,Standard_Dialog,modal+moveable+help_button+close_button,
                0,0,0,0,rc_editdlg,0,0,0,0);
  setactive(tdid);
  hdlg := get_handle_dialog(tdid);
  did := unique_id;
  create_dialog(did,'New Dialog Box',0,480,639,maxy,Standard_Dialog,
                help_button+close_button+moveable,0,0,0,rc_deletedlg,0,0,0,0,0);

  Add_CheckBox(91,cur_dialog,10,130,'Modal',true,true,rc_redrawdlg);
  Add_CheckBox(92,cur_dialog,200,130,'Moveable',true,true,rc_redrawdlg);
  Add_CheckBox(93,cur_dialog,10,150,'Sizeable',true,false,rc_redrawdlg);
  Add_CheckBox(94,cur_dialog,200,150,'Help',true,true,rc_redrawdlg);
  Add_CheckBox(95,cur_dialog,10,170,'Minimize',true,false,rc_redrawdlg);
  Add_CheckBox(96,cur_dialog,200,170,'Maximize',true,false,rc_redrawdlg);
  Add_CheckBox(97,cur_dialog,10,190,'Close',true,true,rc_redrawdlg);
  Add_CheckBox(98,cur_dialog,200,190,'Horz. Scrollbar',true,False,rc_redrawdlg);
  Add_CheckBox(99,cur_dialog,10,210,'Vert. Scrollbar',true,False,rc_redrawdlg);
  Add_CheckBox(100,cur_dialog,200,210,'Menu',true,False,rc_redrawdlg);

  Add_Data(90,cur_dialog,10,25,true,11,11,string_field,      'Resource ID ',itos(hdlg^.id),rc_redrawdlg);
  Add_Data(85,cur_dialog,10,45,true,60,60,string_field,'Name        ',hdlg^.name,rc_redrawdlg);
  Add_Data(86,cur_dialog,10,65,true,4,4,string_field, 'XPOS        ','',rc_redrawdlg);
  assign_string(itos(rect.x1),86);
  Add_Data(87,cur_dialog,200,65,true,4,4,string_field,'YPOS ','',rc_redrawdlg);
  assign_string(itos(rect.y1),87);
  Add_Data(88,cur_dialog,10,85,true,4,4,string_field, 'XPOS1       ','',rc_redrawdlg);
  assign_string(itos(rect.x2),88);
  Add_Data(89,cur_dialog,200,85,true,4,4,string_field,'YPOS1','',rc_redrawdlg);
  assign_string(itos(rect.y2),89);

  Add_Button(unique_id,cur_dialog,430,240,0,'&Save',0,true,rc_savedlg);
  Add_Button(unique_id,cur_dialog,500,240,0,'&Done',0,true,standard_close_dialog);
  Add_Button(unique_id,cur_dialog,570,240,0,'&Close',0,true,rc_deletedlg);

  Add_Accelerator(unique_id,cur_dialog,alt,skey,rc_savedlg);
  Add_Accelerator(unique_id,cur_dialog,alt,dkey,standard_close_dialog);
  Add_Accelerator(unique_id,cur_dialog,alt,ckey,rc_deletedlg);

  defaultmouseextents;
  setactive(did);
end;



Procedure Redraw_Dlg;
var
 x1,y1,x2,y2 : integer;
 name : string;
 hdlg : handle_dialog;
 flags : byte;
 hcb : handle_checkbox;
 hsb,vsb : longint;
 parray : array[1..20] of pointer;
 h_sb : handle_scrollbar;
 cf,minf,maxf,hf : longint;

Procedure Save_State;
Begin
  parray[1] := hdlg^.first_button;
  parray[2] := hdlg^.last_button;
  parray[3] := hdlg^.first_lb;
  parray[4] := hdlg^.first_sb;
  parray[5] := hdlg^.first_cb;
  parray[6] := hdlg^.first_text;
  parray[7] := hdlg^.first_menu;
  parray[8] := hdlg^.first_data;
  parray[9] := hdlg^.first_bmp;
  parray[10] := hdlg^.last_lb;
  parray[11] := hdlg^.last_sb;
  parray[12] := hdlg^.last_cb;
  parray[13] := hdlg^.last_text;
  parray[14] := hdlg^.last_menu;
  parray[15] := hdlg^.last_data;
  parray[16] := hdlg^.last_bmp;

  hdlg^.first_button := nil;
  hdlg^.last_button := nil;
  hdlg^.first_lb := nil;
  hdlg^.first_sb := nil;
  hdlg^.first_cb := nil;
  hdlg^.first_text := nil;
  hdlg^.first_menu := nil;
  hdlg^.first_data := nil;
  hdlg^.first_bmp := nil;
  hdlg^.last_lb := nil;
  hdlg^.last_sb := nil;
  hdlg^.last_cb := nil;
  hdlg^.last_text := nil;
  hdlg^.last_menu := nil;
  hdlg^.last_data := nil;
  hdlg^.last_bmp := nil;
end;

Procedure Restore_State;
Begin
  hdlg^.first_button := parray[1];
  hdlg^.last_button := parray[2];
  hdlg^.first_lb :=parray[3];
  hdlg^.first_sb :=parray[4];
  hdlg^.first_cb :=parray[5];
  hdlg^.first_text :=parray[6];
  hdlg^.first_menu :=parray[7];
  hdlg^.first_data :=parray[8];
  hdlg^.first_bmp :=parray[9];
  hdlg^.last_lb := parray[10];
  hdlg^.last_sb := parray[11];
  hdlg^.last_cb := parray[12];
  hdlg^.last_text := parray[13];
  hdlg^.last_menu := parray[14];
  hdlg^.last_data := parray[15];
  hdlg^.last_bmp := parray[16];
end;

Begin
 {reset_checkboxes;}
 flags := 0;
 hdlg := get_handle_dialog(tdid);
 name := retrievepchar(85);
 x1 := stoi(retrievepchar(86));
 y1 := stoi(retrievepchar(87));
 x2 := stoi(retrievepchar(88));
 y2 := stoi(retrievepchar(89));
 tdid := stoi(retrievepchar(90));
 hf := stoi(retrievepchar(131));
 minf := stoi(retrievepchar(132));
 maxf := stoi(retrievepchar(133));
 cf := stoi(retrievepchar(130));

 hcb := get_handle_checkbox(91);
 if (hcb<>nil) then if hcb^.selected then flags := flags + modal;

 hcb := get_handle_checkbox(92);
 if (hcb<>nil) then
   if hcb^.selected then flags := flags + moveable;

 hcb := get_handle_checkbox(93);
 if (hcb<>nil) then
   if hcb^.selected then flags := flags + sizeable;

 hcb := get_handle_checkbox(94);
 if (hcb<>nil) then
   if hcb^.selected then flags := flags + help_button;

 hcb := get_handle_checkbox(95);
 if (hcb<>nil) then
   if hcb^.selected then flags := flags + minimize_button;

 hcb := get_handle_checkbox(96);
 if (hcb<>nil) then
   if hcb^.selected then flags := flags + maximize_button;

 hcb := get_handle_checkbox(97);
 if (hcb<>nil) then
   if hcb^.selected then flags := flags + close_button;

 hsb := 0;
 vsb := 0;
 hcb := get_handle_checkbox(98);
 if (hcb<>nil) then
   if hcb^.selected then hsb := unique_id;

 hcb := get_handle_checkbox(99);
 if (hcb<>nil) then
   if hcb^.selected then vsb := unique_id;

 save_state;
 close_dialog(hdlg);
 create_dialog(tdid,name,x1,y1,x2,y2,Standard_Dialog,flags,
               hf,minf,maxf,cf,rc_editdlg,hsb,vsb,0,0);

 hdlg := get_handle_dialog(tdid);
 restore_state;

 hcb := get_handle_checkbox(100);
 if (hcb<>nil) then
   Begin
     if (hcb^.selected) and (cur_dialog^.first_menu=nil) then Add_Menu(cur_dialog,'[Menu Bar]') else
     delete_all_menu(cur_dialog);
   end;

 h_sb := get_handle_scrollbar(hsb);
   if h_sb<>nil then set_scrollbar(h_sb,0,1000,0,10,30);
 h_sb := get_handle_scrollbar(vsb);
   if h_sb<>nil then set_scrollbar(h_sb,0,1000,0,10,30);

 draw_dialog(cur_dialog);
 setactive(did);
end;

