Unit Remote;

Interface

Uses Vesa,mouseu;

Const
  REMOTE_HEADER = 'TSP';

Var
  Use_Remote : Boolean;
  Remote_Active : Array[1..25] of byte;  { 1 - 4 : Com Ports
                                           5     : IPX/SPX
                                           6     : TCPIP }
  Remote_On : Boolean;

  {Procedure REMOTE_setpaletteDAC(Var pal:pal_type);}
  Procedure REMOTE_setvesamode(video_mode:word;useLFB:boolean);
  Procedure REMOTE_Fill(x1,y1,x2,y2:integer;color:byte);
  Procedure REMOTE_InitMouse;
  Procedure REMOTE_HandleMouse;
  Procedure REMOTE_sm;
  Procedure REMOTE_hm;
  Procedure REMOTE_SetVesaMouse(mask: graphcursmasktype);
  Procedure REMOTE_Hline(x1,x2,y:integer;color:byte);
  Procedure REMOTE_Vrline(y1,y2,x:integer;color:byte);
  Procedure REMOTE_Box(x1,y1,x2,y2:integer;color:byte);


  Procedure REMOTE_vline(x1,y1,x2,y2:Word;Color:Byte);
  Procedure REMOTE_VPlot(xpos,ypos:word;color:byte);
  Procedure REMOTE_vhrzline(y,x1,x2:integer;c:byte);
  Procedure REMOTE_vputrect(buffer:Pointer;x,y,xlen,ylen,width:word;PutType:Byte);
   Procedure REMOTE_vgetrect(buffer:Pointer;x,y,xlen,ylen,width:word);
  Procedure REMOTE_SETPAL(Palette:Pointer);
  Procedure REMOTE_FadeOut;
  Procedure REMOTE_Hourglass;
  Procedure REMOTE_Arrow;
  Procedure REMOTE_Textxystr(s:string;xpos,ypos:integer);

  Procedure Initialize_Remote_Server;
  Procedure Handle_Remote;

Implementation

Uses win,global;

{Set Palette
 ID = 0
 Palette = 768 bytes
}
Procedure REMOTE_setpaletteDAC(Var pal:pal_type);
var
 x : byte;
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#0);}
  for x := 0 to 255 do
    Begin
      {sendchar(chr(pal[x].r));
      sendchar(chr(pal[x].g));
      sendchar(chr(pal[x].b));}
    end;
end;

{Set Vesa Mode
 ID = 1
 video_mode
 uselfb}
Procedure REMOTE_setvesamode(video_mode:word;useLFB:boolean);
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_Header+#1);
  sendchar(chr(video_mode));
  if uselfb then sendchar('1') else sendchar('0');}
end;

Procedure REMOTE_Fill(x1,y1,x2,y2:integer;color:byte);
Begin
  if not(remote_on) then exit;
{  sendstr(REMOTE_HEADER+#2);
  sendint(x1);
  sendint(y1);
  sendint(x2);
  sendint(y2);
  sendchar(chr(color));}
end;

Procedure REMOTE_InitMouse;
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#3);}
end;

Procedure REMOTE_HandleMouse;
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#4);}
end;

Procedure REMOTE_sm;
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#5);}
end;

Procedure REMOTE_hm;
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#6);}
end;

Procedure REMOTE_SetVesaMouse(mask: graphcursmasktype);
Begin
  if not(remote_on) then exit;
end;

Procedure REMOTE_Hline(x1,x2,y:integer;color:byte);
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#7);
  sendint(x1);
  sendint(x2);
  sendint(y);
  sendchar(chr(color));}
end;

Procedure REMOTE_Vrline(y1,y2,x:integer;color:byte);
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#8);
  sendint(y1);
  sendint(y2);
  sendint(x);
  sendchar(chr(color));}
end;

Procedure REMOTE_Box(x1,y1,x2,y2:integer;color:byte);
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#9);
  sendint(x1);
  sendint(y1);
  sendint(x2);
  sendint(y2);
  sendchar(chr(color));}
end;

Procedure REMOTE_vline(x1,y1,x2,y2:Word;Color:Byte);
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#10);
  sendint(x1);
  sendint(y1);
  sendint(x2);
  sendint(y2);
  sendchar(chr(color));}
end;

Procedure REMOTE_VPlot(xpos,ypos:word;color:byte);
Begin
  if not(remote_on) then exit;
{  sendstr(REMOTE_HEADER+#11);
  sendint(xpos);
  sendint(ypos);
  sendchar(chr(color));}
end;

Procedure REMOTE_vhrzline(y,x1,x2:integer;c:byte);
Begin
  if not(remote_on) then exit;
{  sendstr(REMOTE_HEADER+#12);
  sendint(y);
  sendint(x1);
  sendint(x2);
  sendchar(chr(c));}
end;

Procedure REMOTE_vputrect(buffer:Pointer;x,y,xlen,ylen,width:word;PutType:Byte);
Begin
  if not(remote_on) then exit;
end;

Procedure REMOTE_vgetrect(buffer:Pointer;x,y,xlen,ylen,width:word);
Begin
  if not(remote_on) then exit;
end;

Procedure REMOTE_SETPAL(Palette:Pointer);
Begin
  if not(remote_on) then exit;
end;

Procedure REMOTE_FadeOut;
Begin
  if not(remote_on) then exit;
end;

Procedure REMOTE_Hourglass;
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#17);}
end;

Procedure REMOTE_Arrow;
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#18);}
end;

Procedure REMOTE_Textxystr(s:string;xpos,ypos:integer);
var
 x : integer;
Begin
  if not(remote_on) then exit;
  {sendstr(REMOTE_HEADER+#19);
  sendint(xpos);
  sendint(ypos);
  for x := 0 to length(s) do sendchar(s[x]);}
end;

Procedure Initialize_Remote_Server;
var
{ dbf : handle_dbf_object;}
 com : word;
 speed : longint;
 initstr : string;
Begin
 {dbf := _REMOTE(0,0,0);
 dbf_gotop(dbf);
 if dbf_currec(dbf)<>1 then message_box('Remote Services',lpad('Remote Services has not been',40)+
                                   lpad('setup yet!',40),OK,4,0) else
 Begin
   com := stoi(dbf_stringget(dbf,'COM'));
   speed := stoi(dbf_stringget(dbf,'BAUD'));
   initstr := dbf_stringget(dbf,'INIT');
   InitializeAsync;
   setparam(com,speed,TRUE,true);
   sendinit(initstr+#13);
   use_remote := true;
   file_sound;
 end;
 delete_dbf(dbf);}
end;

Procedure handle_remote;
Begin
  if not (use_remote) then exit;
  if remote_on then exit;
{  if carrier then
    Begin
      remote_on := true;
      refresh;
    end else remote_on := false;}
end;

Begin
  Fillchar(remote_active,sizeof(remote_active),0);
  Remote_On := False;
  Use_Remote := False;
end.
