Unit mouseu;

interface

uses crt,dos,video,binu,input;

type
    graphcursmasktype = record
                      mask : array [0..1,0..15] of word;
                      horzhotspot,
                      verthotspot : integer;
                      end;
    var
       usefm : boolean;
       lastmousex,lastmousey : word;
       fmx,fmy : word;
       mousemaxx,mousemaxy : word;
       standardshapecurs, uparrowcurs, leftarrowcurs, checkmarkcurs,
       pointinghandcurs, diagonalcrosscurs, rectangularcrosscurs,smallcrosscurs,
       hourglasscurs,dotcurs: graphcursmasktype;

       mousex,mousey,buttonpresscount,buttonreleasecount: word;

       nummousekeys : byte;
       lbactive : boolean;
       mousepresent : boolean;

       mkey : (none,left,right,both);

Function LeftKeyReleased:Boolean;
procedure resetmouse;
procedure virtualscreensize (var maxx,maxy,cellsizex,cellsizey : word);
procedure showmousecursor;
procedure hidemousecursor;
procedure getbuttonstatus;
procedure setmousecursorpos (x,y : word);
procedure getbuttonpressinfo (keynum : word);
procedure getbuttonreleaseinfo (keynum : word);
procedure setminmaxhorzcurspos (min,max : word);
procedure setminmaxvertcurspos (min,max : word);
procedure setgraphicscursor (var mask : graphcursmasktype);
procedure setsofttextcursor (textscrmask, textcursmask : word);
procedure sethardtextcursorbig;
procedure sethardtextcursorsmall;
procedure readmousemotioncounters (var hcount, vcount : word);
procedure lightpenemulon;
procedure lightpenemuloff;
procedure setmickeytopixels (hratio,vratio : word);
procedure conditionaloff (x1,y1,x2,y2 : word);
procedure setdoublespeed (speed : word);
procedure savemousedriverstate;
procedure restoremousedriverstate;
procedure setcrtpagenumber (page : word);
procedure getcrtpagenumber (var page : word);

function anymousekeypressed : boolean;
function leftmousekeypressed : boolean;
function rightmousekeypressed : boolean;
function bothmousekeyspressed : boolean;

implementation

uses win;

const
     mousedelay = 0;
var
   mousesavebuffer : pointer;
   mkp,mousevisible : boolean;
   mousebuffersize : word;

   regs : registers;

procedure definestandardshape;
begin
with standardshapecurs do
begin

 mask [0,0] := bintoword('0011111111111111');
 mask [0,1] := bintoword('0001111111111111');
 mask [0,2] := bintoword('0000111111111111');
 mask [0,3] := bintoword('0000011111111111');
 mask [0,4] := bintoword('0000001111111111');
 mask [0,5] := bintoword('0000000111111111');
 mask [0,6] := bintoword('0000000011111111');
 mask [0,7] := bintoword('0000000001111111');
 mask [0,8] := bintoword('0000000000111111');
 mask [0,9] := bintoword('0000000000011111');
mask [0,10] := bintoword('0000000111111111');
mask [0,11] := bintoword('0001000011111111');
mask [0,12] := bintoword('0011000011111111');
mask [0,13] := bintoword('1111100001111111');
mask [0,14] := bintoword('1111100001111111');
mask [0,15] := bintoword('1111110000111111');

 mask [1,0]  := bintoword('0000000000000000');
 mask [1,1]  := bintoword('0100000000000000');
 mask [1,2]  := bintoword('0110000000000000');
 mask [1,3]  := bintoword('0111000000000000');
 mask [1,4]  := bintoword('0111100000000000');
 mask [1,5]  := bintoword('0111110000000000');
 mask [1,6]  := bintoword('0111111000000000');
 mask [1,7]  := bintoword('0111111100000000');
 mask [1,8]  := bintoword('0111111110000000');
 mask [1,9]  := bintoword('0111111111000000');
mask [1,10]  := bintoword('0111110000000000');
mask [1,11]  := bintoword('0100011000000000');
mask [1,12]  := bintoword('0000011000000000');
mask [1,13]  := bintoword('0000001100000000');
mask [1,14]  := bintoword('0000001100000000');
mask [1,15]  := bintoword('0000000110000000');

horzhotspot := -1;
verthotspot := -1;
end;
end;

procedure defineuparrow;
begin
with uparrowcurs do
     begin
 mask [0,0]  := bintoword('11111001111111111');
 mask [0,1]  := bintoword('11110000111111111');
 mask [0,2]  := bintoword('11100000011111111');
 mask [0,3]  := bintoword('11100000011111111');
 mask [0,4]  := bintoword('11000000001111111');
 mask [0,5]  := bintoword('11000000001111111');
 mask [0,6]  := bintoword('10000000000111111');
 mask [0,7]  := bintoword('10000000000111111');
 mask [0,8]  := bintoword('00000000000011111');
 mask [0,9]  := bintoword('00000000000011111');
 mask [0,10] := bintoword('11110000111111111');
 mask [0,11] := bintoword('11110000111111111');
 mask [0,12] := bintoword('11110000111111111');
 mask [0,13] := bintoword('11110000111111111');
 mask [0,14] := bintoword('11110000111111111');
 mask [0,15] := bintoword('11110000111111111');

 mask [1,0]  := bintoword('0000000000000000');
 mask [1,1]  := bintoword('0000011000000000');
 mask [1,2]  := bintoword('0000111100000000');
 mask [1,3]  := bintoword('0000111100000000');
 mask [1,4]  := bintoword('0001111110000000');
 mask [1,5]  := bintoword('0001111110000000');
 mask [1,6]  := bintoword('0011111111000000');
 mask [1,7]  := bintoword('0011111111000000');
 mask [1,8]  := bintoword('0111111111100000');
 mask [1,9]  := bintoword('0000011000000000');
 mask [1,10] := bintoword('0000011000000000');
 mask [1,11] := bintoword('0000011000000000');
 mask [1,12] := bintoword('0000011000000000');
 mask [1,13] := bintoword('0000011000000000');
 mask [1,14] := bintoword('0000011000000000');
 mask [1,15] := bintoword('0000000000000000');

 horzhotspot := 5;
 verthotspot := 0;
 end;
end;

procedure defineleftarrow;
begin
        with leftarrowcurs do
begin

 mask [0,0] := bintoword('1111111000011111');
 mask [0,1] := bintoword('1111000000011111');
 mask [0,2] := bintoword('0000000000000000');
 mask [0,3] := bintoword('0000000000000000');
 mask [0,4] := bintoword('0000000000000000');
 mask [0,5] := bintoword('1111000000011111');
 mask [0,6] := bintoword('1111111000011111');
 mask [0,7] := bintoword('1111111111111111');
 mask [0,8] := bintoword('1111111111111111');
 mask [0,9] := bintoword('1111111111111111');
mask [0,10] := bintoword('1111111111111111');
mask [0,11] := bintoword('1111111111111111');
mask [0,12] := bintoword('1111111111111111');
mask [0,13] := bintoword('1111111111111111');
mask [0,14] := bintoword('1111111111111111');
mask [0,15] := bintoword('1111111111111111');

 mask [1,0] := bintoword('0000000000000000');
 mask [1,1] := bintoword('0000000011000000');
 mask [1,2] := bintoword('0000011111000000');
 mask [1,3] := bintoword('0111111111111110');
 mask [1,4] := bintoword('0000011111000000');
 mask [1,5] := bintoword('0000000011000000');
 mask [1,6] := bintoword('0000000000000000');
 mask [1,7] := bintoword('0000000000000000');
 mask [1,8] := bintoword('0000000000000000');
 mask [1,9] := bintoword('0000000000000000');
mask [1,10] := bintoword('0000000000000000');
mask [1,11] := bintoword('0000000000000000');
mask [1,12] := bintoword('0000000000000000');
mask [1,13] := bintoword('0000000000000000');
mask [1,14] := bintoword('0000000000000000');
mask [1,15] := bintoword('0000000000000000');
                                               
horzhotspot := 0;
verthotspot := 3;
end;
end;





procedure definecheckmark;
begin
with checkmarkcurs do
        begin

mask [0,0] := bintoword  ('1111111111110000');
mask [0,1] := bintoword  ('1111111111100000');
mask [0,2] := bintoword  ('1111111111000000');
mask [0,3] := bintoword  ('1111111110000001');
mask [0,4] := bintoword  ('1111111100000011');
mask [0,5] := bintoword  ('0000011000000111');
mask [0,6] := bintoword  ('0000000000001111');
mask [0,7] := bintoword  ('0000000000011111');
mask [0,8] := bintoword  ('1100000000111111');
mask [0,9] := bintoword  ('1111000001111111');
mask [0,10] := bintoword ('1111111111111111');
mask [0,11] := bintoword ('1111111111111111');
mask [0,12] := bintoword ('1111111111111111');
mask [0,13] := bintoword ('1111111111111111');
mask [0,14] := bintoword ('1111111111111111');
mask [0,15] := bintoword ('1111111111111111');

mask [1,0] := bintoword  ('0000000000000000');
mask [1,1] := bintoword  ('0000000000000110');
mask [1,2] := bintoword  ('0000000000001100');
mask [1,3] := bintoword  ('0000000000011000');
mask [1,4] := bintoword  ('0000000000110000');
mask [1,5] := bintoword  ('0000000001100000');
mask [1,6] := bintoword  ('0111000011000000');
mask [1,7] := bintoword  ('0001110110000000');
mask [1,8] := bintoword  ('0000011100000000');
mask [1,9] := bintoword  ('0000000000000000');
mask [1,10] := bintoword ('0000000000000000');
mask [1,11] := bintoword ('0000000000000000');
mask [1,12] := bintoword ('0000000000000000');
mask [1,13] := bintoword ('0000000000000000');
mask [1,14] := bintoword ('0000000000000000');
mask [1,15] := bintoword ('0000000000000000');
horzhotspot := 6;
verthotspot := 7;
end;
end;

procedure definepointinghand;
begin
with pointinghandcurs do
begin
 mask [0,0] := bintoword('1110000111111111');
 mask [0,1] := bintoword('1110000111111111');
 mask [0,2] := bintoword('1110000111111111');
 mask [0,3] := bintoword('1110000111111111');
 mask [0,4] := bintoword('1110000111111111');
 mask [0,5] := bintoword('1110000000000011');
 mask [0,6] := bintoword('1110000000000001');
 mask [0,7] := bintoword('1110000000000000');
 mask [0,8] := bintoword('0000000000000000');
 mask [0,9] := bintoword('0000000000000000');
mask [0,10] := bintoword('0000000000000000');
mask [0,11] := bintoword('0000000000000000');
mask [0,12] := bintoword('0000000000000000');
mask [0,13] := bintoword('0000000000000000');
mask [0,14] := bintoword('0000000000000000');
mask [0,15] := bintoword('0000000000000000');

 mask [1,0] := bintoword('0001111000000000');
 mask [1,1] := bintoword('0001001000000000');
 mask [1,2] := bintoword('0001001000000000');
 mask [1,3] := bintoword('0001001000000000');
 mask [1,4] := bintoword('0001001000000000');
 mask [1,5] := bintoword('0001001111111100');
 mask [1,6] := bintoword('0001001001001010');
 mask [1,7] := bintoword('0001001001001001');
 mask [1,8] := bintoword('1110001001001001');
 mask [1,9] := bintoword('1000000000000001');
mask [1,10] := bintoword('1000000000000001');
mask [1,11] := bintoword('1000000000000001');
mask [1,12] := bintoword('1000000000000001');
mask [1,13] := bintoword('1000000000000001');
mask [1,14] := bintoword('1000000000000001');
mask [1,15] := bintoword('1111111111111111');

horzhotspot := 5;
verthotspot := 0;
end;
end;

procedure definediagonalcross;
begin

with diagonalcrosscurs do
begin

 mask [0,0] := bintoword('0000011111100000');
 mask [0,1] := bintoword('0000000110000000');
 mask [0,2] := bintoword('0000000000000000');
 mask [0,3] := bintoword('1100000000000011');
 mask [0,4] := bintoword('1111000000001111');
 mask [0,5] := bintoword('1100000000000011');
 mask [0,6] := bintoword('0000000000000000');
 mask [0,7] := bintoword('0000000110000000');
 mask [0,8] := bintoword('0000011111100000');
 mask [0,9] := bintoword('1111111111111111');
mask [0,10] := bintoword('1111111111111111');
mask [0,11] := bintoword('1111111111111111');
mask [0,12] := bintoword('1111111111111111');
mask [0,13] := bintoword('1111111111111111');
mask [0,14] := bintoword('1111111111111111');
mask [0,15] := bintoword('1111111111111111');

 mask [1,0] := bintoword('0000000000000000');
 mask [1,1] := bintoword('0111000000001110');
 mask [1,2] := bintoword('0001110000111000');
 mask [1,3] := bintoword('0000011111100000');
 mask [1,4] := bintoword('0000001111000000');
 mask [1,5] := bintoword('0000011111100000');
 mask [1,6] := bintoword('0001110000111000');
 mask [1,7] := bintoword('0111000000001110');
 mask [1,8] := bintoword('0000000000000000');
 mask [1,9] := bintoword('0000000000000000');
mask [1,10] := bintoword('0000000000000000');
mask [1,11] := bintoword('0000000000000000');
mask [1,12] := bintoword('0000000000000000');
mask [1,13] := bintoword('0000000000000000');
mask [1,14] := bintoword('0000000000000000');
mask [1,15] := bintoword('0000000000000000');

horzhotspot := 7;
verthotspot :=4;
end;
end;

procedure definerectangularcross;
begin
with rectangularcrosscurs do
begin
mask [0,0] := bintoword('1111110000111111');
mask [0,1] := bintoword('1111110000111111');
mask [0,2] := bintoword('1111110000111111');
mask [0,3] := bintoword('0000000000000000');
mask [0,4] := bintoword('0000000000000000');
mask [0,5] := bintoword('0000000000000000');
mask [0,6] := bintoword('1111110000111111');
mask [0,7] := bintoword('1111110000111111');
mask [0,8] := bintoword('1111110000111111');
mask [0,9] := bintoword('1111111111111111');
mask [0,10] := bintoword('1111111111111111');
mask [0,11] := bintoword('1111111111111111');
mask [0,12] := bintoword('1111111111111111');
mask [0,13] := bintoword('1111111111111111');
mask [0,14] := bintoword('1111111111111111');
mask [0,15] := bintoword('1111111111111111');

mask [1,0] := bintoword('0000000000000000');
mask [1,1] := bintoword('0000000110000000');
mask [1,2] := bintoword('0000000110000000');
mask [1,3] := bintoword('0000000110000000');
mask [1,4] := bintoword('1111111111111111');
mask [1,5] := bintoword('0000000110000000');
mask [1,6] := bintoword('0000000110000000');
mask [1,7] := bintoword('0000000110000000');
mask [1,8] := bintoword('0000000000000000');
mask [1,9] := bintoword('0000000000000000');
mask [1,10] := bintoword('0000000000000000');
mask [1,11] := bintoword('0000000000000000');
mask [1,12] := bintoword('0000000000000000');
mask [1,13] := bintoword('0000000000000000');
mask [1,14] := bintoword('0000000000000000');
mask [1,15] := bintoword('0000000000000000');

horzhotspot := 7;
verthotspot := 4;
end;
end;


procedure definesmallcurs;
begin
with smallcrosscurs do
begin
mask [0,0] :=  bintoword('0011111111111111');
mask [0,1] :=  bintoword('0001111111111111');
mask [0,2] :=  bintoword('0000111111111111');
mask [0,3] :=  bintoword('0000011111111111');
mask [0,4] :=  bintoword('0000001111111111');
mask [0,5] :=  bintoword('0000000111111111');
mask [0,6] :=  bintoword('0000011111111111');
mask [0,7] :=  bintoword('0110001111111111');
mask [0,8] :=  bintoword('1111001111111111');
mask [0,9] :=  bintoword('1111111111111111');
mask [0,10] := bintoword('1111111111111111');
mask [0,11] := bintoword('1111111111111111');
mask [0,12] := bintoword('1111111111111111');
mask [0,13] := bintoword('1111111111111111');
mask [0,14] := bintoword('1111111111111111');
mask [0,15] := bintoword('1111111111111111');

mask [1,0] :=  bintoword('0000000000000000');
mask [1,1] :=  bintoword('0100000000000000');
mask [1,2] :=  bintoword('0110000000000000');
mask [1,3] :=  bintoword('0111000000000000');
mask [1,4] :=  bintoword('0111100000000000');
mask [1,5] :=  bintoword('0111110000000000');
mask [1,6] :=  bintoword('0101000000000000');
mask [1,7] :=  bintoword('0000100000000000');
mask [1,8] :=  bintoword('0000000000000000');
mask [1,9] :=  bintoword('0000000000000000');
mask [1,10] := bintoword('0000000000000000');
mask [1,11] := bintoword('0000000000000000');
mask [1,12] := bintoword('0000000000000000');
mask [1,13] := bintoword('0000000000000000');
mask [1,14] := bintoword('0000000000000000');
mask [1,15] := bintoword('0000000000000000');

horzhotspot := -1;
verthotspot := -1 ;
end;
end;


procedure definehourglass;
begin
with hourglasscurs do
begin
 mask [0,0] := bintoword('1111111111111111');
 mask [0,1] := bintoword('1000000000000001');
 mask [0,2] := bintoword('1000000000000001');
 mask [0,3] := bintoword('1100000000000011');
 mask [0,4] := bintoword('1110000000000111');
 mask [0,5] := bintoword('1110000000000111');
 mask [0,6] := bintoword('1110100000010111');
 mask [0,7] := bintoword('1110100000010111');
 mask [0,8] := bintoword('1110000000000111');
 mask [0,9] := bintoword('1110000000000111');
mask [0,10] := bintoword('1100000000000011');
mask [0,11] := bintoword('1000000000000001');
mask [0,12] := bintoword('1000000000000001');
mask [0,13] := bintoword('1000000000000001');
mask [0,14] := bintoword('1111111111111111');
mask [0,15] := bintoword('1111111111111111');

 mask [1,0] := bintoword('0000000000000000');
 mask [1,1] := bintoword('0000000000000000');
 mask [1,2] := bintoword('0011111111111100');
 mask [1,3] := bintoword('0001100000011000');
 mask [1,4] := bintoword('0001110000111000');
 mask [1,5] := bintoword('0001011001101000');
 mask [1,6] := bintoword('0001001111001000');
 mask [1,7] := bintoword('0001001111001000');
 mask [1,8] := bintoword('0001001001001000');
 mask [1,9] := bintoword('0001011001101000');
mask [1,10] := bintoword('0001110000111000');
mask [1,11] := bintoword('0001100000011000');
mask [1,12] := bintoword('0011111111111100');
mask [1,13] := bintoword('0000000000000000');
mask [1,14] := bintoword('0000000000000000');
mask [1,15] := bintoword('0000000000000000');

horzhotspot := 7;
verthotspot := 7;

end;
end;

procedure definedotcurs;
begin
with dotcurs do
begin
mask [0,0] :=  bintoword('1111111111111111');
mask [0,1] :=  bintoword('1111111111111111');
mask [0,2] :=  bintoword('1111111101111111');
mask [0,3] :=  bintoword('1111111101111111');
mask [0,4] :=  bintoword('1111111101111111');
mask [0,5] :=  bintoword('1111111101111111');
mask [0,6] :=  bintoword('1111111101111111');
mask [0,7] :=  bintoword('1111111111111111');
mask [0,8] :=  bintoword('1110000111000011');
mask [0,9] :=  bintoword('1111111111111111');
mask [0,10] := bintoword('1111111101111111');
mask [0,11] := bintoword('1111111101111111');
mask [0,12] := bintoword('1111111101111111');
mask [0,13] := bintoword('1111111101111111');
mask [0,14] := bintoword('1111111111111111');
mask [0,15] := bintoword('1111111111111111');

mask [1,0] :=  bintoword('0000000000000000');
mask [1,1] :=  bintoword('0000000000000000');
mask [1,2] :=  bintoword('0000000010000000');
mask [1,3] :=  bintoword('0000000010000000');
mask [1,4] :=  bintoword('0000000010000000');
mask [1,5] :=  bintoword('0000000010000000');
mask [1,6] :=  bintoword('0000000010000000');
mask [1,7] :=  bintoword('0000000000000000');
mask [1,8] :=  bintoword('0001111000111100');
mask [1,9] :=  bintoword('0000000000000000');
mask [1,10] := bintoword('0000000010000000');
mask [1,11] := bintoword('0000000010000000');
mask [1,12] := bintoword('0000000010000000');
mask [1,13] := bintoword('0000000010000000');
mask [1,14] := bintoword('0000000000000000');
mask [1,15] := bintoword('0000000000000000');

horzhotspot := 8;
verthotspot := 8;
end;
end;

procedure setkeystatus (mstatus : word);
begin
     case mstatus of
     0: mkey := none;
     1: mkey := left;
     2: mkey := right;
     3: mkey := both;
     end;
end;

procedure resetmouse;
begin
regs.ax := 0;
intr($33,regs);
with regs do
     begin
     mousepresent := ax > 0;
     if mousepresent then
     nummousekeys := bx
     else
         nummousekeys := 0;
     end;
     mousevisible := false;
end;

procedure virtualscreensize(var maxx,maxy,cellsizex,cellsizey : word);

begin
regs.ah := $0f;
intr ($10,regs);
case regs.al of

     0,1:
     begin
     maxx := 640;
     maxy := 200;
     cellsizex := 16;
     cellsizey := 8;
     end;

     2,3,7 :
     begin
     maxx := 640;
     maxy := 200;
     cellsizex := 8;
     cellsizey := 8;
     end;

     4,5:
     begin
     maxx := 640;
     maxy := 200;
     cellsizex := 2;
     cellsizey := 1;
     end;

     6:
     begin
     maxx := 640;
     maxy := 200;
     cellsizex := 1;
     cellsizey := 1;
     end;

     13:
     begin
     maxx := 640;
     maxy := 200;
     cellsizex := 16;
     cellsizey := 8;
     end;

     14,15:
     begin
     maxx := 640;
     maxy := 350;
     cellsizex := 1;
     cellsizey := 1;
     end;

    end;
end;

procedure showmousecursor;
begin
     if not mousevisible then
     begin
     regs.ax := 1;
     intr($33,regs);
     mousevisible := true;
     end;
end;

procedure hidemousecursor;
begin
     if mousevisible then
     begin
     regs.ax := 2;
     intr ($33,regs);
     mousevisible := false;
     end;
end;

procedure getbuttonstatus;
begin
     lastmousex := mousex;
     lastmousey := mousey;
     regs.ax := 3;
     intr($33,regs);
     with regs do
     begin
       setkeystatus (bx);
       mousex := cx;
       mousey := dx;
       if (lastmousex<>mousex) or (lastmousey<>mousey) then usefm := false;
     end;
end;

procedure setmousecursorpos (x,y : word);
begin
     with regs do
          begin
          ax :=4;
          cx :=x;
          dx :=y;
          end;

          intr($33,regs);
          mousex := x;
          mousey := y;
          end;

          procedure getbuttonpressinfo (keynum : word);
          begin
               with regs do
               begin
               ax := 5;
               bx := keynum -1;
               end;
               intr($33,regs);
               with regs do
               begin
               setkeystatus (AX);
               buttonpresscount := bx;
               mousex := cx;
               mousey := dx;
               end;
          end;

          procedure getbuttonreleaseinfo (keynum : word);
          begin
               with regs do
               begin
               ax := 6;
               bx := keynum -1;
               end;
               intr($33,regs);
               with regs do
               begin
               setkeystatus (AX);
               buttonreleasecount := bx;
               mousex := cx;
               mousey := dx;
               end;
          end;

Function LeftKeyReleased : Boolean;
Begin
 GetButtonPressInfo(1);
 LeftKeyReleased := Not (Regs.Ax = 1);
end;

procedure setminmaxhorzcurspos (min,max : word);
begin
     with regs do
     begin
     ax := 7;
     cx := min;
     dx := max;
     end;
     intr ($33,regs);
     end;

procedure setminmaxvertcurspos (min,max : word);
begin
     with regs do
     begin
     ax := 8;
     cx := min;
     dx := max;
     end;
     intr($33,regs);
     end;

     procedure setgraphicscursor (var mask: graphcursmasktype);
     begin
          with regs do
               begin
               ax := 9;
               bx := word(mask.horzhotspot);
               cx := word(mask.verthotspot);
               dx := ofs(mask);
               es := seg(mask);
               end;
               intr($33,regs);
               end;

procedure setsofttextcursor (textscrmask, textcursmask : word);
begin
     with regs do
      begin
     ax := 10;
     bx := 0;
     cx := textscrmask;
     dx := textcursmask;
     end;
     intr($33,regs);
     end;

procedure sethardtextcursorbig;
begin
     with regs do
     begin
ax := 10;
bx := 1;
if stype = mono then
   begin
   cx := 0;
   dx := 13;
   end
   else
       begin
       cx := 0;
       dx := 7;
       end;
   end;
intr ($33,regs);
end;

procedure sethardtextcursorsmall;
begin
     with regs do
     begin
     ax := 10;
     bx := 1;
     if stype = mono then
        begin
        cx := 12;
        dx := 13;
        end
     else
         begin
         cx := 6;
         dx := 7;
         end;
     end;
intr ($33,regs);
end;

procedure readmousemotioncounters (var hcount, vcount : word);
begin
regs.ax := 11;
intr($33,regs);
with regs do
begin
hcount := cx;
vcount := dx;
end;
end;

procedure lightpenemulon;
begin
regs.ax := 13;
intr ($33,regs);
end;

procedure lightpenemuloff;
begin
regs.ax := 14;
intr ($33,regs);
end;


procedure setmickeytopixels (hratio, vratio : word);
begin
with regs do
begin
ax := 15;
cx := hratio;
dx := vratio;
end;
intr($33,regs);
end;

procedure conditionaloff (x1,y1,x2,y2 : word);
begin
     with regs do
     begin
     ax := 16;
     cx := x1;
     dx := y1;
     si := x2;
     di := y2;
     end;
intr ($33,regs);
end;

procedure setdoublespeed (speed : word);
begin
with regs do
begin
ax := 19;
dx := speed;
end;
intr ($33,regs);
end;

procedure getmousesavesize;
begin
regs.ax := 21;
intr ($33,regs);
mousebuffersize := regs.bx;
end;

procedure savemousedriverstate;
begin
getmem(mousesavebuffer,mousebuffersize);
with regs do
     begin
     ax := 22;
     dx := ofs(mousesavebuffer^);
     es := seg(mousesavebuffer^);
     end;
  intr($33,regs);
end;

procedure restoremousedriverstate;
begin
with regs do
     begin
     ax := 23;
     dx := ofs(mousesavebuffer^);
     es := seg(mousesavebuffer^);
     end;
intr ($33,regs);
freemem(mousesavebuffer,mousebuffersize);
end;

procedure setcrtpagenumber (page : word);
begin
     with regs do
     begin
     ax := 29;
     bx := page;
     end;
     intr($33,regs);
end;

procedure getcrtpagenumber (var page : word);
begin
  regs.ax := 23;
     intr($33,regs);

 page := regs.bx;
 end;

 function anymousekeypressed : boolean;
 begin
      if mkp then
      delay (mousedelay);
 getbuttonstatus;
 mkp := mkey <> none;
 anymousekeypressed := mkp;
 end;


 function leftmousekeypressed : boolean;
 begin
 if mkp then delay(mousedelay);
 getbuttonstatus;
 mkp := mkey = left;
 if not mkp then
    {Begin}
      {if (cur_dialog^.first_data=nil) then
         if keystroke(enter,false) then mkp := true;}
      if keystroke(f10,false) then mkp := true;
    {end;}
 leftmousekeypressed := mkp;
 end;

 function rightmousekeypressed : boolean;
 begin
 if mkp then
 delay (mousedelay);
 getbuttonstatus;
 mkp := mkey = right;
 rightmousekeypressed := mkp;
 end;

 function bothmousekeyspressed : boolean;
 begin
 if mkp then
 delay(mousedelay);
 getbuttonstatus;
 mkp := mkey = both;
 bothmousekeyspressed := mkp;
 end;

 begin
 resetmouse;
 definestandardshape;
 defineuparrow;
 defineleftarrow;
 definecheckmark;
 definepointinghand;
 definediagonalcross;
 definerectangularcross;
 definehourglass;
 definesmallcurs;
 definedotcurs;
 mkp := false;
 usefm := false;
 end.


