Unit Colors;

Interface

Uses Vesa;

Type
  pbyte=^byte;

Procedure Color_Dialog;
Function CD_Execute_Procedure(procnum:longint) : boolean;
Procedure Load_Default_Colors;

Function  Color_Used(c:byte):Boolean;
Function  Add_Color(r,g,b:byte):Byte;
Function  Color_Exists(r,g,b:byte):boolean;
Function  Color_Num(r,g,b:byte):byte;
Procedure Remap(bmp:pbyte;pal:pal_ptr;width,height:integer);
Procedure SetNewPal;

Var
 cd_active : longint;
 dcl : array[1..46] of byte;
 cl : array[1..46] of byte;
 csb1,csb46 : longint;
 modpal : pal_type;
 cused : array[0..255] of byte;

Implementation

Uses win,Routine,Global,Mouseu;

Procedure Save_Colors;
Begin
  cl[1] := Background_Color;
  cl[2] := Border_Color1;
  cl[3] := Border_Color2;
  cl[4] := Border_Color3;
  cl[5] := Menu_Color;
  cl[6] := Title_Color;
  cl[7] := Active_Title_Bar_Color;
  cl[8] := Disabled_Title_Bar_Color;
  cl[9] := Minimize_Color;
  cl[10]:= Maximize_Color;
  cl[13]:= Client_Background_Color;
  cl[12]:= Client_Text_Color;
  cl[11]:= Close_Color;
  cl[14] := Scrollbar_Background;
  cl[15] := Scrollbar_Border1;
  cl[16] := Scrollbar_Border2;
  cl[17] := Scrollbar_Text_Color;
  cl[18] := Listbox_Border1;
  cl[19] := Listbox_Border2;
  cl[20] := Listbox_Background;
  cl[21] := ListBox_Text;
  cl[22] := ListBox_Title;
  cl[23] := CheckBox_Border1;
  cl[24] := CheckBox_Border2;
  cl[25] := CheckBox_Background;
  cl[26] := Checkbox_Disabled;
  cl[27] := CheckBox_Text;
  cl[28] := Data_Border1;
  cl[29] := Data_Border2;
  cl[30] := Data_Background;
  cl[31] := Data_Text;
  cl[32] := Menu_Border1;
  cl[33] := Menu_Border2;
  cl[34] := Menu_Background;
  cl[35] := Menu_Text;
  cl[36] := Disabled_Menu;
  cl[37] := Popup_Border1;
  cl[38] := Popup_Border2;
  cl[39] := Popup_Background;
  cl[40] := Popup_Text;
  cl[41] := Disabled_Popup;
  cl[42] := Button_Background;
  cl[43] := Button_Border1;
  cl[44] := Button_Border2;
  cl[45] := Button_Text;
  cl[46] := Disabled_Button;
end;

Procedure Assign_Default;
Begin
  move(cl,dcl,sizeof(cl));
end;

Procedure Restore_Colors;
Begin
  Background_Color := cl[1];
  Border_Color1 := cl[2];
  Border_Color2 := cl[3];
  Border_Color3 := cl[4];
  Menu_Color := cl[5];
  Title_Color := cl[6];
  Active_Title_Bar_Color := cl[7];
  Disabled_Title_Bar_Color := cl[8];
  Minimize_Color := cl[9];
  Maximize_Color := cl[10];
  Client_Background_Color := cl[13];
  Client_Text_Color := cl[12];
  Close_Color := cl[11];

  Scrollbar_Background := cl[14];
  Scrollbar_Border1   := cl[15];
  Scrollbar_Border2   := cl[16];
  Scrollbar_Text_Color:= cl[17];
  Listbox_Border1     := cl[18];
  Listbox_Border2     := cl[19];
  Listbox_Background  := cl[20];
  ListBox_Text        := cl[21];
  ListBox_Title       := cl[22];
  CheckBox_Border1    := cl[23];
  CheckBox_Border2    := cl[24];
  CheckBox_Background := cl[25];
  Checkbox_Disabled   := cl[26];
  CheckBox_Text       := cl[27];
  Data_Border1        := cl[28];
  Data_Border2        := cl[29];
  Data_Background     := cl[30];
  Data_Text           := cl[31];
  Menu_Border1        := cl[32];
  Menu_Border2        := cl[33];
  Menu_Background     := cl[34];
  Menu_Text           := cl[35];
  Disabled_Menu       := cl[36];
  Popup_Border1       := cl[37];
  Popup_Border2       := cl[38];
  Popup_Background    := cl[39];
  Popup_Text          := cl[40];
  Disabled_Popup      := cl[41];
  Button_Background   := cl[42];
  Button_Border1      := cl[43];
  Button_Border2      := cl[44];
  Button_Text         := cl[45];
  Disabled_Button     := cl[46];
end;

Procedure Change_Color(c:longint);
var
 xpos,ypos,xpos1,ypos1 : integer;
Begin
  hm;
  clipset(0,0,maxx,maxy);
  c := c-color_c1+1;
  cl[c] := cur_dialog^.cur_sb^.curpos;
  cur_dialog^.cur_sb^.changed := false;
     if (background_color<>cl[1]) then
       Begin
         restore_colors;
         fill(0,0,maxx,maxy,background_color);
       end else restore_colors;
     redraw_all(true);
  sm;
end;

Procedure Set_Color_SB;
var
 x : longint;
 z : integer;
 hsb : handle_scrollbar;
Begin
  z := 1;
  for x := csb1 to csb46 do
    Begin
     hsb := get_handle_scrollbar(x);
     if hsb<>nil then
       Begin
         hsb^.curpos := cl[z];
       end;
      inc(z);
    end;

end;

Procedure DCL_RESET;
Begin
  move(dcl,cl,sizeof(cl));
  restore_colors;
  clipset(0,0,maxx,maxy);
  fill(0,0,maxx,maxy,background_color);
  set_color_sb;
  redraw_all(true);
end;

Procedure ICF;
Begin
  message_box('Color File','Invalid Color File',OK,standard_close_dialog,0);
end;

Procedure CL_OK;
var
 f : file;
 x : integer;
 br : word;
 head : string[8];
 rhead : string[8];
Begin
{  head := 'TSPCOLOR';
  rhead := '';
  $I-
  assign(f,fd_frptr^.filename);
  reset(f,1);
  if IORESULT<>0 then
    Begin
      icf;
      exit;
    end;
  $I+
  blockread(f,rhead,sizeof(head),br);
  if (br<>sizeof(head)) or (head<>rhead) then
    Begin
      close(f);
      icf;
      exit;
    end;
  blockread(f,cl,sizeof(cl),br);
  if br<>sizeof(cl) then
    Begin
      close(f);
      icf;
      exit;
    end;
  restore_colors;
  set_color_sb;
  clipset(0,0,maxx,maxy);
  fill(0,0,maxx,maxy,Background_Color);
  fillchar(cused,sizeof(cused),0);
  for x := 1 to 46 do
     Begin
       cused[cl[x]] := 1;
       modpal[cl[x]].r := pal[cl[x]].r;
       modpal[cl[x]].g := pal[cl[x]].g;
       modpal[cl[x]].b := pal[cl[x]].b;
     end;
  setnewpal;
  redraw_all(true);
  sm;}
end;

Procedure CS_OK;
var
 f : file;
 x : integer;
 br : word;
 head : string[8];
Begin
  head := 'TSPCOLOR';
  {$I-}
{  assign(f,fd_frptr^.filename);
  rewrite(f,1);
  if IORESULT<>0 then
    Begin
      icf;
      exit;
    end;}
  {$I+}
{  blockwrite(f,head,sizeof(head),br);
  if (br<>sizeof(head)) then
    Begin
      close(f);
      icf;
      exit;
    end;
  blockwrite(f,cl,sizeof(cl),br);
  if br<>sizeof(cl) then
    Begin
      close(f);
      icf;
      exit;
    end;
  sm;}
end;

Procedure Color_Load;
Begin
  {FD_SETSEARCH('*.COL');
  OpenFile_Dialog('Load Windows Color File',color_load_ok,0);}
end;

Procedure Color_Save;
Begin
  {FD_SETSEARCH('*.COL');
  OpenFile_Dialog('Save Windows Color File',color_save_ok,0);}
end;

Procedure Color_Dialog;
var
 xpos,ypos,xpos1,ypos1 : integer;
Begin
 inc(mbox);
 cd_active := mbox;
 xpos := (maxx shr 1)-258;
 ypos := (maxy shr 1)-240;
 xpos1 := xpos+516;
 ypos1 := ypos+480;
 Create_Dialog(mbox,'Color Selection',xpos,ypos,xpos1,ypos1,standard_dialog,Close_Button+Help_Button+Moveable,
               0,0,0,0,0,0,0,0,0);
 Add_Menu(Cur_Dialog,'File');

 inc(mbox);
 Add_Menu_Item(mbox,Cur_Dialog^.cur_menu,'Load',load_color);
 inc(mbox);
 Add_Menu_Item(mbox,Cur_Dialog^.cur_menu,'Save',save_color);

 Add_Button(cd_active,Cur_Dialog,479,410,0,'OK',0,true,standard_close_dialog);
 Add_Button(cd_active,Cur_Dialog,10,410,0,'RESET',0,true,reset_color);

 Save_Colors;
 Assign_default;
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,320,100,0,255,cl[1],1,20,horz,color_c1);
 csb1 := mbox;
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,50,100,0,255,cl[2],1,20,horz,color_c2);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,80,100,0,255,cl[3],1,20,horz,color_c3);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,110,100,0,255,cl[4],1,20,horz,color_c4);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,140,100,0,255,cl[5],1,20,horz,color_c5);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,170,100,0,255,cl[6],1,20,horz,color_c6);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,200,100,0,255,cl[7],1,20,horz,color_c7);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,230,100,0,255,cl[8],1,20,horz,color_c8);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,260,100,0,255,cl[9],1,20,horz,color_c9);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,290,100,0,255,cl[10],1,20,horz,color_c10);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,320,100,0,255,cl[11],1,20,horz,color_c11);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,350,100,0,255,cl[12],1,20,horz,color_c12);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,10,380,100,0,255,cl[13],1,20,horz,color_c13);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,50,100,0,255,cl[14],1,20,horz,color_c14);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,80,100,0,255,cl[15],1,20,horz,color_c15);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,110,100,0,255,cl[16],1,20,horz,color_c16);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,140,100,0,255,cl[17],1,20,horz,color_c17);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,170,100,0,255,cl[18],1,20,horz,color_c18);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,200,100,0,255,cl[19],1,20,horz,color_c19);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,230,100,0,255,cl[20],1,20,horz,color_c20);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,260,100,0,255,cl[21],1,20,horz,color_c21);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,290,100,0,255,cl[22],1,20,horz,color_c22);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,320,100,0,255,cl[23],1,20,horz,color_c23);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,350,100,0,255,cl[24],1,20,horz,color_c24);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,140,380,100,0,255,cl[25],1,20,horz,color_c25);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,50,100,0,255,cl[26],1,20,horz,color_c26);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,80,100,0,255,cl[27],1,20,horz,color_c27);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,110,100,0,255,cl[28],1,20,horz,color_c28);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,140,100,0,255,cl[29],1,20,horz,color_c29);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,170,100,0,255,cl[30],1,20,horz,color_c30);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,200,100,0,255,cl[31],1,20,horz,color_c31);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,230,100,0,255,cl[32],1,20,horz,color_c32);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,260,100,0,255,cl[33],1,20,horz,color_c33);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,290,100,0,255,cl[34],1,20,horz,color_c34);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,320,100,0,255,cl[35],1,20,horz,color_c35);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,350,100,0,255,cl[36],1,20,horz,color_c36);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,270,380,100,0,255,cl[37],1,20,horz,color_c37);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,50,100,0,255,cl[38],1,20,horz,color_c38);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,80,100,0,255,cl[39],1,20,horz,color_c39);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,110,100,0,255,cl[40],1,20,horz,color_c40);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,140,100,0,255,cl[41],1,20,horz,color_c41);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,170,100,0,255,cl[42],1,20,horz,color_c42);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,200,100,0,255,cl[43],1,20,horz,color_c43);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,230,100,0,255,cl[44],1,20,horz,color_c44);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,260,100,0,255,cl[45],1,20,horz,color_c45);
 inc(mbox);
 Add_Scrollbar(mbox,cur_dialog,400,290,100,0,255,cl[46],1,20,horz,color_c46);
 csb46 := mbox;

 inc(mbox);
 add_text(mbox,cur_dialog,10,40,'Border 1',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,70,'Border 2',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,100,'Border 3',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,130,'Help Menu',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,160,'Title',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,190,'Active T-Bar',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,220,'Disable T-Bar',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,250,'Minimize Btn',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,280,'Maximize Btn',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,310,'Close Btn',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,340,'Client Text',0);
 inc(mbox);
 add_text(mbox,cur_dialog,10,370,'Client Bgnd',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,40,'S-Bar Bgnd',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,70,'S-Bar Bdr 1',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,100,'S-Bar Bdr 2',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,130,'S-Bar Text',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,160,'Listbox Bdr 1',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,190,'Listbox Bdr 2',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,220,'Listbox Bgnd',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,250,'Listbox Text',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,280,'Listbox Title',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,310,'Checkbox Bdr 1',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,340,'Checkbox Bdr 2',0);
 inc(mbox);
 add_text(mbox,cur_dialog,140,370,'Checkbox Bgnd',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,40,'Checkbox Dis.',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,70,'Checkbox Text',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,100,'Data Bdr 1',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,130,'Data Bdr 2',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,160,'Data Bgnd',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,190,'Data Text',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,220,'Menu Bdr 1',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,250,'Menu Bdr 2',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,280,'Menu Bgnd',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,310,'Menu Text',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,340,'Dis. Menu',0);
 inc(mbox);
 add_text(mbox,cur_dialog,270,370,'Popup Bdr 1',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,40,'Popup Bdr 2',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,70,'Popup Bgnd',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,100,'Popup Text',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,130,'Dis. Popup',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,160,'Button Bgnd',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,190,'Button Bdr 1',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,220,'Button Bdr 2',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,250,'Button Text',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,280,'Dis. Button',0);
 inc(mbox);
 add_text(mbox,cur_dialog,400,310,'Background',0);
 setactive(cd_active);
end;

Function CD_Execute_Procedure(procnum:longint) : Boolean;
Begin
  CD_EXECUTE_PROCEDURE := True;
 if procnum=color_change  then color_dialog else
 if (procnum>=color_c1) and (procnum<=color_c46) then change_color(procnum) else
 if procnum=load_color then color_load else
 if procnum=save_color then color_save else
 if procnum=color_load_ok then cl_ok else
 if procnum=color_save_ok then cs_ok else
 if procnum=reset_color then dcl_reset else CD_EXECUTE_PROCEDURE := FALSE;
end;

Procedure Load_Default_Colors;
var
 f : file;
 x : integer;
 br : word;
 head : string[8];
 rhead : string[8];
Begin
  head := 'TSPCOLOR';
  rhead := '';
  {$I-}
  assign(f,colorsdir+'DEFAULT.COL');
  reset(f,1);
  if IORESULT<>0 then exit;
  {$I+}
  blockread(f,rhead,sizeof(head),br);
  if (br<>sizeof(head)) or (head<>rhead) then
    Begin
      close(f);
      exit;
    end;
  blockread(f,cl,sizeof(cl),br);
  if br<>sizeof(cl) then
    Begin
      close(f);
      icf;
      exit;
    end;
  restore_colors;
  fillchar(cused,sizeof(cused),0);
  for x := 1 to 46 do
     Begin
       cused[cl[x]] := 1;
       modpal[cl[x]].r := pal[cl[x]].r;
       modpal[cl[x]].g := pal[cl[x]].g;
       modpal[cl[x]].b := pal[cl[x]].b;
     end;
end;

Function  Color_Used(c:byte):Boolean;
Begin
  if (cused[c]=1) then color_used := true else color_used := false;
end;

Function Add_Color(r,g,b:byte):byte;
var
 x : integer;
Begin
 for x := 0 to 255 do
   if not(color_used(x)) then
     Begin
       cused[x] := 1;
       modpal[x].r := r;
       modpal[x].g := g;
       modpal[x].b := b;
       add_color := x;
       exit;
     end;
  add_color := 0;
end;

Function Color_Exists(r,g,b:byte):boolean;
var
 x : integer;
Begin
  for x := 0 to 255 do
    if (cused[x]=1) then
    Begin
      if (modpal[x].r=r) and (modpal[x].g=g) and (modpal[x].b=b) then
        Begin
          color_exists := true;
          exit;
        end;
    end;
  color_exists := false;
end;

Function Color_Num(r,g,b:byte):byte;
var
 x : integer;
Begin
  for x := 0 to 255 do
    if (cused[x]=1) then
    Begin
      if (modpal[x].r=r) and (modpal[x].g=g) and (modpal[x].b=b) then
        Begin
          color_num := x;
          exit;
        end;
    end;
  color_num := 0;
end;

Procedure Remap(bmp:pbyte;pal:pal_ptr;width,height:integer);
var
 x : word;
Begin
  for x := 1 to (width*height) do
    Begin
      if color_exists(pal^[bmp^].r,pal^[bmp^].g,pal^[bmp^].b) then
         bmp^ := color_num(pal^[bmp^].r,pal^[bmp^].g,pal^[bmp^].b) else
         bmp^ := add_color(pal^[bmp^].r,pal^[bmp^].g,pal^[bmp^].b);
      inc(bmp);
    end;
end;

Procedure SetNewPal;
Begin
  SetPaletteDAC(modpal);
end;

Begin
  cd_active := 0;
end.

