{$G+}

program ShadingBobs;
{ Principles of shaded bobs, see comment below, by Bas van Gaalen, Holland, PD }
uses dos;
const
colors : array[1..768] of byte =(
 43, 0, 54, 44, 0, 54, 45, 0, 55, 46, 0, 56,
 48, 0, 56, 49, 0, 57, 50, 0, 58, 52, 0, 59, 53, 0, 59, 54, 0, 60, 56, 0, 61,
 57, 0, 61, 58, 0, 62, 60, 0, 62, 61, 0, 63, 63, 0, 63, 63, 0, 61, 62, 0, 60,
 61, 0, 57, 60, 0, 54, 59, 0, 51, 58, 0, 48, 56, 0, 45, 55, 0, 42, 54, 0, 39,
 53, 0, 36, 52, 0, 33, 51, 0, 30, 49, 0, 27, 48, 0, 24, 47, 0, 21, 45, 0, 15,
 45,  0, 0, 46,  1, 0, 47,  2, 0, 48,  4, 0, 49,  6, 0, 50,  8, 0, 51,  9, 0,
 51, 10, 0, 52, 11, 0, 52, 13, 0, 53, 14, 0, 53, 15, 0, 54, 17, 0, 54, 19, 0,
 55, 20, 0, 55, 21, 0, 56, 21, 0, 56, 22, 0, 56, 23, 0, 56, 25, 0, 57, 26, 0,
 57, 27, 0, 58, 29, 0, 58, 30, 0, 59, 31, 0, 59, 33, 0, 60, 34, 0, 60, 36, 0,
 61, 38, 0, 61, 39, 0, 62, 40, 0, 63, 42, 0, 63, 42, 0, 63, 43, 0, 63, 44, 0,
 63, 46, 0, 63, 47, 0, 63, 48, 0, 63, 50, 0, 63, 52, 0, 63, 53, 0, 63, 55, 0,
 63, 56, 0, 63, 57, 0, 63, 59, 0, 63, 60, 0, 63, 62, 0, 63, 63, 0, 62, 63, 0,
 62, 62, 0, 61, 62, 0, 60, 62, 0, 59, 62, 0, 58, 61, 0, 57, 61, 0, 55, 61, 0,
 54, 61, 0, 53, 60, 0, 51, 60, 0, 50, 60, 0, 49, 60, 0, 48, 59, 0, 47, 59, 0,
 46, 59, 0, 45, 59 ,0, 44, 59, 0, 43, 59, 0, 42, 59, 0, 41, 59, 0, 40, 59, 0,
 39, 59, 0, 38, 59, 0, 38, 58, 0, 37, 58, 0, 36, 58, 0, 35, 58, 0, 34, 58, 0,
 33, 58, 0, 32, 58, 0, 31, 58, 0, 30, 58, 0, 29, 57, 0, 27, 55, 0, 25, 54, 0,
 23, 52, 0, 21, 51, 0, 19, 49, 0, 17, 48, 0, 15, 46, 0, 13, 45, 0, 11, 43, 0,
  9, 42, 0, 07, 40, 0, 05, 38, 0, 03, 37, 0,  0, 36, 0, 0, 35,  0, 0, 36,  3,
 0, 37,  5, 0, 38,  7, 0, 39,  9, 0, 40, 11, 0, 41, 13, 0, 42, 15, 0, 43, 17,
 0, 44, 18, 0, 45, 19, 0, 46, 21, 0, 47, 22, 0, 48, 23, 0, 49, 24, 0, 49, 25,
 0, 49, 26, 0, 49, 27, 0, 49, 29, 0, 50, 31, 0, 50, 33, 0, 50, 35, 0, 50, 37,
 0, 51, 39, 0, 51, 41, 0, 51, 43, 0, 52, 45, 0, 52, 47, 0, 52, 49, 0, 52, 51,
 0, 53, 52, 0, 53, 53, 0, 52, 53, 0, 51, 53, 0, 50, 53, 0, 49, 54, 0, 47, 54,
 0, 46, 54, 0, 44, 55, 0, 43, 55, 0, 41, 55, 0, 40, 56, 0, 38, 56, 0, 37, 56,
 0, 35, 57, 0, 34, 57, 0, 32, 57, 0, 30, 58, 0, 29, 58, 0, 28, 58, 0, 27, 58,
 0, 26, 58, 0, 25, 58, 0, 24, 58, 0, 23, 58, 0, 22, 58, 0, 21, 57, 0, 20, 57,
 0, 19, 57, 0, 19, 57, 0, 18, 57, 0, 17, 57, 0, 16, 57, 0, 16, 57, 0, 15, 57,
 0, 14, 56, 0, 13, 56, 0, 12, 55, 0, 11, 55, 0, 10, 55, 0,  9, 54, 0,  8, 54,
 0, 07, 53, 0, 06, 53, 0, 05, 52, 0, 04, 52, 0, 03, 51, 0, 03, 51, 0, 02, 51,
 0, 01, 50,  0, 0, 50,  4, 0, 50,  8, 0, 50, 12, 0, 51, 16, 0, 51, 18, 0, 51,
 21, 0, 51, 24, 0, 52, 27, 0, 52, 30, 0, 52, 33, 0, 53, 35, 0, 53, 37, 0, 53,
 39, 0, 53, 41, 0, 54, 42, 0, 54, 43, 0, 54, 44, 0, 54, 45, 0, 55, 46, 0, 56,
 48, 0, 56, 49, 0, 57, 50, 0, 58, 52, 0, 59, 53, 0, 59, 54, 0, 60, 56, 0, 61,
 57, 0, 61, 58, 0, 62, 60, 0, 62, 61, 0, 63, 63, 0, 63, 63, 0, 61, 62, 0, 60,
 61, 0, 57, 60, 0, 54, 59, 0, 51, 58, 0, 48, 56, 0, 45, 55, 0, 42, 54, 0, 39,
 53, 0, 36, 52, 0, 33, 51, 0, 30, 49, 0, 27, 48, 0, 24, 47, 0, 21, 45, 0, 15);

  Gseg : word = $a000;
  Sofs = 40; Samp = 50; Slen = 255;
  SprPic : array[0..15,0..15] of byte = (
    (0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0),
    (0,0,0,0,2,2,1,1,1,1,2,2,0,0,0,0),
    (0,0,0,2,1,1,1,1,1,1,1,1,2,0,0,0),
    (0,0,2,1,1,1,1,1,1,1,1,1,1,2,0,0),
    (0,2,1,1,1,1,1,1,1,1,1,1,1,1,2,0),
    (0,2,1,1,1,1,1,1,1,1,1,1,1,1,2,0),
    (2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2),
    (2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2),
    (2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,2),
    (0,2,1,1,1,1,1,1,1,1,1,1,1,1,2,0),
    (0,2,1,1,1,1,1,1,1,1,1,1,1,1,2,0),
    (0,0,2,1,1,1,1,1,1,1,1,1,1,2,0,0),
    (0,0,2,1,1,1,1,1,1,1,1,1,1,2,0,0),
    (0,0,0,2,1,1,1,1,1,1,1,1,2,0,0,0),
    (0,0,0,0,2,2,1,1,1,1,2,2,0,0,0,0),
    (0,0,0,0,0,0,2,2,2,2,0,0,0,0,0,0));
type SinArray = array[0..Slen] of word;
var Stab : SinArray;

procedure CalcSinus; var I : word; begin
  for I := 0 to Slen do Stab[I] := round(sin(I*4*pi/Slen)*Samp)+Sofs; end;

procedure SetGraphics(Mode : word); assembler; asm
  mov ax,Mode; int 10h end;

function keypressed : boolean; assembler; asm
  mov ah,0bh; int 21h; and al,0feh; end;

procedure DrawSprite(X,Y : integer; W,H : byte; Sprite : pointer); assembler;
asm
  push ds
  lds si,[Sprite]
  mov es,Gseg
  cld
  mov ax,[Y]
  shl ax,6
  mov di,ax
  shl ax,2
  add di,ax
  add di,[X]
  mov bh,[H]
  mov cx,320
  sub cl,[W]
  sbb ch,0
 @L:
  mov bl,[W]
 @L2:
  lodsb
  or al,al
  jz @S
  mov dl,[es:di]
  add dl,al
  and dl,63
  mov [es:di],dl
 @S:
  inc di
  dec bl
  jnz @L2
  add di,cx
  dec bh
  jnz @L
  pop ds
end;

procedure Retrace; assembler; asm
  mov dx,3dah;
  @l1: in al,dx; test al,8; jnz @l1;
  @l2: in al,dx; test al,8; jz @l2; end;

procedure Setpalette;
var I : byte;
begin
  for I := 1 to 64 do begin
    port[$3c8] := I;
    port[$3c9] := 10+I div 3;
    port[$3c9] := 5+I div 2;
    port[$3c9] := I;
  end;
end;

{Procedure redac;
var regs : registers;
begin
  regs.ah := $10;
  regs.al := $12;
  regs.bx := $00;
  regs.cx := $100;
  regs.dx := ofs(colors);
  regs.es := seg(colors);
  intr($10, regs);
end;}

procedure Bobs;
var X,Y : integer; I1,I2,J1,J2 : byte;
begin
  I1 := 60; I2 := 100; J1 := 55; J2 := 200;
  repeat
    X := Stab[I1]+Stab[I2]; Y := Stab[J1]+Stab[J2];
    inc(I1,2); inc(I2,3); inc(J1); inc(J2,2);
    Retrace;
    DrawSprite(80+X,Y,16,16,addr(SprPic));
  until keypressed;
end;

begin
  CalcSinus;
  SetGraphics($13);
  SetPalette;
  {redac;}
  Bobs;
  SetGraphics(3);
end.

{ DrawSprite procedure taken from Sean Palmer (again).
  It contained some minor bugs: [X] was added to AX, should be DI, and
  jz @S was jnz @S, so the sprite wasn't drawn. Now it is...
  And of course it was changed to INCREASE the video-mem, not to poke it.

  If you get rid of the Retrace it goes a LOT faster. }
