/********************************************************************
 FILENAME: VIEW_UT.CPP
 AUTHOR  : JAKE HILL
 DATE    : 12/1/94

 Copyright (c) 1994 by Jake Hill:
 If you use any part of this code in your own project, please credit
 me in your documentation and source code.  Thanks.
********************************************************************/

#include "VIEW.HPP"
#include "TRIG.HPP"


// This function returns TRUE it the player is on the right
// of the node indexed by node_num.
char View::OnRight( short node_num )
{
   node *ThisNode = PNode_Array[node_num];
   long x1 = ThisNode->x;
   long y1 = ThisNode->y;
   long x2 = x1 + ThisNode->dx;
   long y2 = y1 + ThisNode->dy;

   if ( ((x1-x2)*(Py-y2)) >= ((y1-y2)*(Px-x2)) )
      return 1;
   return 0;
};

// This function returns TRUE it the player is on the right
// of the line segment created by the vertexes indexed by from, and to.
char View::OnRight(short from, short to)
{
   vertex *Vertex = &Vertex_Array[from];
   long x1 = Vertex->x;
   long y1 = Vertex->y;
   Vertex = &Vertex_Array[to];
   long x2 = Vertex->x;
   long y2 = Vertex->y;

   if ( ((x1-x2)*(Py-y2)) >= ((y1-y2)*(Px-x2)) )
      return 1;
   return 0;
};

// Note concerning LeftSideInCone & RightSideInCone.
// These functions are based on the quadrants that the
// view cone intersects.  The minimum resolution is an
// entire quadrant.  This is not very accurate, and therefore
// does not cull out as many nodes as would be ideal, but it
// is a quick and dirty method that is fairly effective.
// It could DEFINATELY be improved upon.

// This function returns TRUE if the LEFT Child Node
// of the node indexed by node_num is in the view cone.
char View::LeftSideInCone( short node_num )
{
   if ( LeftAngle < 0x4000 )
   {
      if ( PNode_Array[node_num]->lx2 > Px ) return 1;
   }
   else if ( LeftAngle < 0x8000 )
   {
      if ( PNode_Array[node_num]->ly2 > Py ) return 1;
   }
   else if ( LeftAngle < 0xC000 )
   {
      if ( PNode_Array[node_num]->lx1 < Px ) return 1;
   }
   else
   {
      if ( PNode_Array[node_num]->ly1 < Py ) return 1;
   }

   return 0;
};

// This function returns TRUE if the RIGHT Child Node
// of the node indexed by node_num is in the view cone.
char View::RightSideInCone( short node_num )
{
   if ( LeftAngle < 0x4000 )
   {
      if ( PNode_Array[node_num]->rx2 > Px ) return 1;
   }
   else if ( LeftAngle < 0x8000 )
   {
      if ( PNode_Array[node_num]->ry2 > Py ) return 1;
   }
   else if ( LeftAngle < 0xC000 )
   {
      if ( PNode_Array[node_num]->rx1 < Px ) return 1;
   }
   else
   {
      if ( PNode_Array[node_num]->ry1 < Py ) return 1;
   }

   return 0;
};

// This function sets the view's x,y, height, and angle values.
void View::SetView(short x, short y, short h, unsigned short a)
{
   Px = x;
   Py = y;
   Ph = h;
   Pangle = a;
   LeftAngle = Pangle + 0x2000;
   SinPangle = sine( 0x00-Pangle );
   CosPangle = cosine( 0x00-Pangle );
};

// This function returns the view's x,y height and angle values.
void View::GetView(short *x, short *y, short *h, unsigned short *a)
{
   *x = Px;
   *y = Py;
   *h = Ph;
   *a = Pangle;
};
