/********************************************************************
 FILENAME: KEYBOARD.CPP
 AUTHOR  : JAKE HILL
 DATE    : 12/1/94

********************************************************************/


/********************************************************************

INS  = 82 / 210          /     = 53 / 181
DEL  = 83 / 211          *     = 55 / 183
HOME = 71 / 199          -     = 74 / 202
END  = 79 / 207          +     = 78 / 206
PGUP = 73 / 201          SPACE = 57 / 185
PGDN = 81 / 209          ENTER = 28 / 156

********************************************************************/

#include <dos.h>
#include <conio.h>
#include <stdlib.h>

#include "KEYBOARD.HPP"

short key;
short key_flags = 0;
short key_init = 0;

#if defined __BORLANDC__
void interrupt (*OldInterrupt)(...);
#elif defined _MSC_VER
void (__interrupt __far __cdecl *OldInterrupt)();
#endif

#if defined __BORLANDC__
void interrupt NewInterrupt(...)
#elif defined _MSC_VER
void (__interrupt __far __cdecl NewInterrupt)()
#endif
{
   unsigned char c;

   key = inp(0x60);

   c = inp(0x61);
   outp(0x61, c | 0x80);
   outp(0x61, c & 0x7F);

   outp(0x20, 0x20);

   switch(key)
   {
      case PR_UP:    key_flags |= FLAG_UP;
                     break;

      case PR_DOWN:  key_flags |= FLAG_DOWN;
                     break;

      case PR_RIGHT: key_flags |= FLAG_RIGHT;
                     break;

      case PR_LEFT:  key_flags |= FLAG_LEFT;
                     break;

      case PR_LSHF:  key_flags |= FLAG_LSHF;
                     break;
      case PR_RSHF:  key_flags |= FLAG_RSHF;
                     break;
      case PR_CTRL:  key_flags |= FLAG_CTRL;
                     break;
      case PR_ALT:   key_flags |= FLAG_ALT;
                     break;



      case RL_UP:    key_flags &= NFLAG_UP;
                     break;

      case RL_DOWN:  key_flags &= NFLAG_DOWN;
                     break;

      case RL_RIGHT: key_flags &= NFLAG_RIGHT;
                        break;

      case RL_LEFT:  key_flags &= NFLAG_LEFT;
                     break;

      case RL_LSHF:  key_flags &= NFLAG_LSHF;
                     break;
      case RL_RSHF:  key_flags &= NFLAG_RSHF;
                     break;
      case RL_CTRL:  key_flags &= NFLAG_CTRL;
                     break;
      case RL_ALT:   key_flags &= NFLAG_ALT;
                     break;
      default: break;
   }
}

void ResetKeyboardInt(void)
{
    if ( key_init )
        _dos_setvect(9, OldInterrupt);
}

void SetKeyboardInt(void)
{
    atexit( ResetKeyboardInt );
    OldInterrupt = _dos_getvect(9);
    _dos_setvect(9, NewInterrupt);
    key_init = 1;
}
