UNIT StrProcs;
{
	A unit with a few extra string functions...
	- Bjarke Viksoe
	jul 1994 - jan 1995
}

INTERFACE

USES Dos;

Function Upper(StrIn : String) : String;
{ Convert a string to upper case }
Function Lower(StrIn : String) : String;
{ Convert a string to lower case }

Function PathOnly(FileName : String) : String;
{ Strip any filename information from a file specification }
Function NameOnly(FileName : String) : String;
{ Strip any path information from a file specification }
Function BaseNameOnly(FileName : String) : String;
{ Strip any path and extension information from a file specification }
Function ExtOnly(FileName : String) : String;
{ Return only the extension portion of a filename }

Function IntStr(Int : LongInt; Form : Integer) : String;
{ Convert an Integer variable to a string }
Function RealStr(R : Real; Form : Integer) : String;
{ Convert a Real variable to a string }
Function StrReal(S : String) : Real;
{ Convert a String variable to a real }
Function StrInt(S : String) : LongInt;
{ Convert a String variable to an integer }


IMPLEMENTATION

(*=-------------------------------------------------------=*)
(*=-                 CASE CONVERTION                     -=*)
(*=-------------------------------------------------------=*)

Function Upper(StrIn : String) : String;
Begin
	asm
		PUSH    DS                { Save DS}
		PUSH	  SS
		POP     DS
		LEA     SI,StrIn          { Get source string address}
		LES	  DI,@Result        { Get result string address}
		CLD                       { Forward direction for strings}
		LODSB                     { Get length of source string}
		STOSB                     { Copy to result string}
		XOR     CH,CH
		MOV     CL,AL             { Move string length to CL}
		JCXZ    @Exit             { Skip if null string}
@UpCase1:
		LODSB                     { Get next source character}
		CMP     AL,'a'            { Check if lower-case letter}
		JB      @UpCase2
		CMP     AL,'z'
		JA      @UpCase2
		SUB     AL,'a'-'A'        { Convert to uppercase}
@UpCase2:
		STOSB                     { Store in result}
		LOOP    @UpCase1
@Exit:
		POP     DS 				      { Restore DS}
	end;
End; {Upper}

Function Lower(StrIn : String) : String;
Begin
	asm
		PUSH    DS                { Save DS}
		PUSH	  SS
		POP     DS
		LEA     SI,StrIn          { Get source string address}
		LES	  DI,@Result        { Get result string address}
		CLD                       { Forward direction for strings}
		LODSB                     { Get length of source string}
		STOSB                     { Copy to result string}
		XOR     CH,CH
		MOV     CL,AL             { Move string length to CL}
		JCXZ    @Exit             { Skip if null string}
@Lowcase1:
		LODSB                     { Get next source character}
		CMP     AL,'A'            { Check if lower-case letter}
		JB      @Lowcase2
		CMP     AL,'Z'
		JA      @Lowcase2
		ADD     AL,'a'-'A'        { Convert to uppercase}
@Lowcase2:
		STOSB                     { Store in result}
		LOOP    @Lowcase1
@Exit:
		POP     DS 				      { Restore DS}
	end;
End; {Lower}


(*=-------------------------------------------------------=*)
(*=-                     FILE STRINGS                    -=*)
(*=-------------------------------------------------------=*)

Function PathOnly(FileName : String) : String;
var
	Dir  : DirStr;
	Name : NameStr;
	Ext  : ExtStr;
Begin
	FSplit(FileName, Dir, Name, Ext);
	PathOnly := Dir;
End; {PathOnly}


Function NameOnly(FileName : String) : String;
{ Strip any path information from a file specification }
Var
	Dir  : DirStr;
	Name : NameStr;
	Ext  : ExtStr;
Begin
	FSplit(FileName, Dir, Name, Ext);
	NameOnly := Name + Ext;
End; {NameOnly}


Function BaseNameOnly(FileName : String) : String;
{ Strip any path and extension from a file specification }
Var
	Dir  : DirStr;
	Name : NameStr;
	Ext  : ExtStr;
Begin
	FSplit(FileName, Dir, Name, Ext);
	BaseNameOnly := Name;
End; {BaseNameOnly}


Function ExtOnly(FileName : String) : String;
{ Strip the path and name from a file specification.  Return only the }
{ filename extension. The dot '.' is also removed }
Var
	Dir  : DirStr;
	Name : NameStr;
	Ext  : ExtStr;
Begin
	FSplit(FileName, Dir, Name, Ext);
	If Pos('.', Ext)<>0 then Delete(Ext, 1, 1);
	ExtOnly := Ext;
End; {ExtOnly}


(*=-------------------------------------------------------=*)
(*=-                  TYPE CONVERSION                    -=*)
(*=-------------------------------------------------------=*)

Function IntStr(Int : LongInt; Form : Integer) : String;
Var
	S : String;
Begin
	If Form = 0 then Str(Int, S) else Str(Int:Form, S);
	IntStr:=S;
End; {IntStr}

Function RealStr(R : Real; Form : Integer) : String;
Var
	S : String;
Begin
	If Form = 0 then Str(R, S) else Str(R:Form, S);
	RealStr:=S;
End; {RealStr}

Function StrReal(S : String) : Real;
Var
	r : Real;
	Code : integer;
Begin
	Val(s,r,Code);
	StrReal:=r;
End; {StrReal}

Function StrInt(S : String) : LongInt;
Var
	i : LongInt;
	Code : integer;
Begin
	Val(s,i,Code);
	StrInt:=i;
End; {StrInt}


End.

