PROGRAM GOURAUD1;
{
	Gouraud Shading.
	Created by Bjarke Viksoe, jan 1996
	E-mail me at: bjarke.viksoe@ntsrv.capacity.dk

	Doing it the easy way.
}

{{$DEFINE DEBUG}
{$DEFINE SORT}

{$S-,R-,N+,G+}

USES
	DEMOINIT, STRPROCS, X3DS;

TYPE
	tNewCoord = RECORD {size is 16 bytes}
		x,y,z : integer;
		light : integer;
		count : word;
		pad1, pad2, pad3 : integer;
	end;
	tCoordBuffer = array[0..ARRAY_MAXCOORDS] of tCoordRec;
	tFaceArray = array[0..ARRAY_MAXFACES] of tFaceRec;
	tRotatedCoordBuffer = array[0..ARRAY_MAXCOORDS] of tNewCoord;
	tSlopeType = array[0..320*2] of integer;

VAR
	{Aargh, we allocate arrays in local data segment!
	 This may very well cause an overflow with very large objects.
	 But that's your problem... :}
	slope, zslope : tSlopeType;
	face          : tFaceArray;          {holds face-definitions}
	coords        : tCoordBuffer;        {holds original coordinates}
	cbuffer       : tRotatedCoordBuffer; {holds rotated coordinates}
	number_faces  : word;
	number_coords : word;
	Dummy,SqrtTable : array[0..4095] of byte;

	minx,maxx : integer;

	sinustabel : array[0..639] of integer;
	v1,v2,v3   : word;
	cos1,sin1,cos2,sin2,cos3,sin3 : integer;

CONST
	display1 : word = $0000;
	display2 : word = $4000;
	display3 : word = $8000;


(*------------------------------------------------*)
(*             INITIALIZE RENDERING               *)
(*------------------------------------------------*)

Procedure SetupSinus;
Var
	i : integer;
	v, vadd : real;
Begin
	v:=0.0;
	vadd:=(2.0*pi/512.0);
	for i:=0 to 639 do begin
		sinustabel[i]:=round(sin(v)*32767);
		v:=v+vadd;
	end;
End;


Procedure InitDemo;
Var
	i,j : integer;
Begin
	Screen_Off;
	ClearWholeScreen;
	SetupSinus;

	v1:=0; v2:=0; v3:=128;

	{make a nice yellow coloured duck}
	SetRGB(0, 0,0,0);
	for i:=1 to 128 do SetRGB( i, LongDiv(SinusTabel[i],720),LongDiv(SinusTabel[i],360),(i AND 1) );
	for i:=128 to 255 do SetRGB(i, 0,0,0);

	j:=0;
	FillChar(Dummy,4096,0);
	for i:=0 TO 4095 do begin
		if (j+1)*(j+1)=i then Inc(j);
		SqrtTable[i]:=j;
	end;

	Screen_On;
End;


(*------------------------------------------------*)
(*            START RENDERING PROCESS             *)
(*------------------------------------------------*)

Procedure SwapDisplay;
Var
	temp : word;
Begin
	temp:=display3;
	display3:=display2;
	display2:=display1;
	display1:=temp;
	SetAddress( Ptr(SEGA000,display2) );
End;

Procedure ClearScreen; assembler;
Asm
	mov	dx,$3C4
	mov	ax,$0F02
	out	dx,ax

	mov	es,[SEGA000]
	mov	di,[display1]
	mov	cx,(WIDTH*HEIGHT)/2
	xor	ax,ax
	rep stosw
End;

Procedure FindFaceZ; Assembler;
{Finds the medium z-value for each face-record}
Asm
	lea	si,face+tFaceRec.l1
	lea	di,cbuffer+tNewCoord.z {point a first z-coord in coordbuffer... easy to index}
	cld
	mov	cx,[number_faces]
@loop:
{ face[i].z := (z1 + z2 + z3) DIV 3; }
	lodsw
	shl	ax,4
	mov	bx,ax
	mov	dx,[di+bx]
	lodsw
	shl	ax,4
	mov	bx,ax
	add	dx,[di+bx]
	sar	dx,1
	lodsw
	shl	ax,4
	mov	bx,ax
	add	dx,[di+bx]
	sar	dx,1
	mov	[si-8],dx {put result in face[i].z}
	add	si,2
	dec	cx
	jnz	@loop
End;

Procedure QuickSort(lo,hi:integer);
 Procedure Sort(l,r:integer);
 Var
	 i,j,x,n : integer;
 Begin
	i:=l; j:=r;
	x:=face[(l+r) SHR 1].z;
	repeat
	  while face[i].z < x do inc(i);
	  while x < face[j].z do dec(j);
	  if i <= j then begin
		 asm
			 lea	si,face	{ swap face records... face[i] <-> face[j] }
			 mov	di,si
			 mov	ax,[i]
			 shl	ax,3
			 add	di,ax
			 mov	ax,[j]
			 shl	ax,3
			 add	si,ax
			 DB LONG; mov ax,[di]
			 DB LONG; xchg [si],ax
			 DB LONG; stosw;
			 DB LONG; mov ax,[di]
			 DB LONG; xchg [si+4],ax
			 DB LONG; stosw;
		 end;
		 inc(i); dec(j);
	  end;
	until i > j;
	if l < j then Sort(l,j);
	if i < r then Sort(i,r);
 End;
Begin
	asm
		mov	ax,ds {we hope that BP won't change ES for a while...}
		mov	es,ax
	end;
	Sort(lo,hi);
End;


(*------------------------------------------------*)
(*       CALCULATE FACES POSITION ON SCREEN       *)
(*------------------------------------------------*)

Procedure ClearSlope; assembler;
Asm
	mov	ax,ds
	mov	es,ax
	lea	di,slope
	DB LONG; mov ax,$8000; DW $8000;
	cld
	mov	cx,TYPE(tSlopeType)/4
	rep; DB LONG; stosw
End;

Procedure CalcSlope(l1,l2 : word); assembler;
Var
	z1,z2,coladd : word;
	xlowadd : word;
	ysize : integer;
Asm
	lea	si,cbuffer
	DB LONG; xor cx,cx
	mov	bx,[l1]							{get first coords}
	shl	bx,4
	mov	ax,[si+bx+tNewCoord.light]	{get light value}
	mov	[z2],ax
	mov	dx,[si+bx+tNewCoord.x]		{get x/y coords}
	mov	cx,[si+bx+tNewCoord.y]

	mov	ax,[l2]							{get second coords}
	shl	ax,4
	add	si,ax
	mov	ax,[si+tNewCoord.light]		{get z value}
	mov	[z1],ax
	mov	ax,[si+tNewCoord.x]			{get x/y coords}
	mov	bx,[si+tNewCoord.y]

	cmp	bx,cx								{make sure we go downwards...}
	jle	@noswap
	mov	si,[z1]							{swap z}
	xchg	[z2],si
	mov	[z1],si
	xchg	ax,dx								{swap x}
	xchg	bx,cx								{sway y}
@noswap:

	or		bx,bx
	js		@zero
	cmp	bx,[minx]						{record miny and maxy}
	jae	@min_x
	mov	[minx],bx
@min_x:
	cmp	cx,[maxx]
	jbe	@max_x
	mov	[maxx],cx
@max_x:

	sub	cx,bx								{find y-size}
	jcxz	@zero
	mov	[ysize],cx
	add	bx,bx
	add	bx,bx
	lea	si,[slope]
	add	si,bx

	push	ax
	sub	dx,ax

	mov	ax,dx								{calc x-slope run}
	DB LONG; shl	ax,16
	{cdq} DB $66,$99
	DB LONG; idiv	cx
	DB LONG; mov	dx,ax
	DB LONG; shr	dx,16
	mov	[xlowadd],ax
	{DX also loaded... but kept alive}

	push	dx									{also calc z-slope run}
	mov	dh,BYTE PTR [z1]
	mov	ah,BYTE PTR [z2]
	sub	ah,dh
	xor	al,al
	cwd
	idiv	cx
	mov	[coladd],ax
	pop	dx
@one:
	pop	cx

	xor	bx,bx
	mov	ah,BYTE PTR [z1] 				{prepare also z-slope calc. z1:=z1*256}
	xor	al,al
	mov	di,$8000
@loop:
	cmp	[si],di							{is first slot filled?}
	jne	@other							{yes, put it in 2nd}
	mov	[si+TYPE(tSlopeType)],ah	{insert z-coord}
	mov	[si],cx							{insert x-coord}
	add	bx,[xlowadd]					{add to x-coord}
	adc	cx,dx
	add	ax,[coladd]						{add to z-coord}
	add	si,4								{prepare next slot...}
	dec	[ysize]
	jnz	@loop
	jmp	NEAR PTR @zero
@other:
	mov	[si+TYPE(tSlopeType)+2],ah {insert in 2nd slot}
	mov	[si+2],cx
	add	bx,[xlowadd]
	adc	cx,dx
	add	ax,[coladd]
	add	si,4
	dec	[ysize]
	jnz	@loop
@zero:
End;


(*------------------------------------------------*)
(*       PREPARE AND DO ROTATION OF POINTS        *)
(*------------------------------------------------*)

Procedure CalcAngle;
Begin
	{get sinus values}
	sin1:=sinustabel[v1]; cos1:=sinustabel[v1+128];
	sin2:=sinustabel[v2]; cos2:=sinustabel[v2+128];
	sin3:=sinustabel[v3]; cos3:=sinustabel[v3+128];
	{rotate object a bit}
	v1:=(v1+3) AND 511;
	v2:=(v2-2) AND 511;
	v3:=(v3+2) AND 511;
End;

Procedure RotateAllCoords; assembler;
{Rotate all coords in "coords" around all 3 axis and make
 perspective calcualtion. Store x,y,z results in "cbuffer"}
Var
	xcoord,ycoord,zcoord, n : integer;
Asm
	mov	ax,ds
	mov	es,ax
	lea	si,[coords]
	lea	di,[cbuffer]
	mov	ax,[number_coords]
	mov	[n],ax
	cld
@loop:
	lodsw
	mov	[xcoord],ax
	lodsw
	mov	[ycoord],ax
	lodsw
	mov	[zcoord],ax

	mov	ax,[xcoord]             {rotate around Z-axis}
	push	ax
	imul	[Cos1]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[ycoord]
	imul	[Sin1]
	add	ax,ax
	adc	dx,dx
	sub	bx,dx
	mov	[xcoord],bx
	pop	ax
	imul	[Sin1]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[ycoord]
	imul	[Cos1]
	add	ax,ax
	adc	dx,dx
	add	bx,dx
	mov	[ycoord],bx

	mov	ax,[ycoord]             {rotate around Y-axis}
	push	ax
	imul	[Cos2]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[zcoord]
	imul	[Sin2]
	add	ax,ax
	adc	dx,dx
	sub	bx,dx
	mov	[ycoord],bx
	pop	ax
	imul	[Sin2]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[zcoord]
	imul	[Cos2]
	add	ax,ax
	adc	dx,dx
	add	bx,dx
	mov	[zcoord],bx

	mov	ax,[xcoord]             {rotate around X-axis}
	push	ax
	imul	[Cos3]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[zcoord]
	imul	[Sin3]
	add	ax,ax
	adc	dx,dx
	sub   bx,dx
	mov	[xcoord],bx
	pop	ax
	imul	[Sin3]
	add	ax,ax
	adc	dx,dx
	mov	bx,dx
	mov	ax,[zcoord]
	imul	[Cos3]
	add	ax,ax
	adc	dx,dx
	add	bx,dx
	mov	[zcoord],bx

	add	bx,800
	or		bx,bx
	jnz	@zero
	mov	bl,1
@zero:

	mov	ax,[xcoord]
	cwd
	mov	dl,ah
	mov	ah,al
	xor	al,al
	idiv	bx
	add	ax,100
	stosw

	mov	ax,[ycoord]
	cwd
	mov	dl,ah
	mov	ah,al
	xor	al,al
	idiv	bx
	add	ax,160
	stosw

	mov	ax,bx
	sub	ax,800
	stosw
	DB LONG; xor ax,ax
	stosw
	DB LONG; stosw
	DB LONG; stosw

	dec	[n]
	jnz	@loop
End;


Function FaceShown(l1,l2,l3 : word) : boolean;
Var
	a,b : longint;
Begin
	asm
		mov	cx,[l1] {*16 because a 'cbuffer' record is 16 bytes long}
		shl	cx,4
		shl	[l2],4
		shl	[l3],4
		lea	si,cbuffer
{ a := x1-x2 * y3-y2; }
		mov	bx,cx
		mov	ax,[si+bx]
		mov	bx,[l3]
		mov	dx,[si+bx+2]
		mov	bx,[l2]
		sub	ax,[si+bx]
		sub	dx,[si+bx+2]
		imul	dx
		mov	WORD PTR [a+2],ax
		mov	WORD PTR [a],dx
{ b := y1-y2 * x3-x2; }
		mov	bx,cx
		mov	ax,[si+bx+2]
		mov	bx,[l3]
		mov	dx,[si+bx]
		mov	bx,[l2]
		sub	ax,[si+bx+2]
		sub	dx,[si+bx]
		imul	dx
		mov	WORD PTR [b+2],ax
		mov	WORD PTR [b],dx
	end;
	FaceShown := (a-b) > 0;
End;


Function GetLight(l1,l2,l3 : word) : integer;
Var
	 VAX,VAY,VAZ,VBX,VBY,VBZ : integer;
	 NX,NY,NZ : longint;
	 P11,P12,P13 : integer;
	 Quadrat : integer;
Begin
	P11:=cbuffer[l1].x;
	P12:=cbuffer[l1].y;
	P13:=cbuffer[l1].z;
	VAX:=cbuffer[l2].x-P11;
	VAY:=cbuffer[l2].y-P12;
	VAZ:=cbuffer[l2].z-P13;
	VBX:=cbuffer[l3].x-P11;
	VBY:=cbuffer[l3].y-P12;
	VBZ:=cbuffer[l3].z-P13;
	NX:=LongMul(VAY,VBZ)-LongMul(VAZ,VBY);
	NY:=LongMul(VAZ,VBX)-LongMul(VAX,VBZ);
	NZ:=LongMul(VAX,VBY)-LongMul(VAY,VBX);
	ASM
		 DB LONG; mov ax,word ptr [nx]
		 DB LONG; cbw
		 DB LONG; mov cx,ax
		 DB LONG; imul cx
		 DB LONG; mov bx,ax

		 DB LONG; mov ax,word ptr [ny]
		 DB LONG; cbw
		 DB LONG; mov cx,ax
		 DB LONG; imul cx
		 DB LONG; add bx,ax

		 DB LONG; mov ax,word ptr [nz]
		 DB LONG; cbw
		 DB LONG; mov cx,ax
		 DB LONG; imul cx
		 DB LONG; add bx,ax
		 DB LONG; shr bx,13 {12}
		 inc bx
		 DB LONG; div bx
		 cmp ax,63*63
		 jl @1
		 mov ax,63*63
@1:    mov [quadrat],ax
	END;
	IF NZ<0 THEN GetLight:=-SqrtTable[Quadrat] ELSE GetLight:=SqrtTable[Quadrat];
END;

Procedure CalcLight(l1,l2,l3 : word);
Var
	x2,y2,z2 : integer;
	a1,a2,b1,b2,c1,c2 : longint;
	Light : word;
Begin
	Light:=GetLight(l2,l1,l3);
	Asm
		lea	si,cbuffer+tNewCoord.light
		lea	di,cbuffer+tNewCoord.count
		mov	cx,1
		mov 	ax,WORD PTR [light]
		mov	bx,[l1]
		shl	bx,4
		add	[si+bx],ax
		add	[di+bx],cx
		mov	bx,[l2]
		shl	bx,4
		add	[si+bx],ax
		add	[di+bx],cx
		mov	bx,[l3]
		shl	bx,4
		add	[si+bx],ax
		add	[di+bx],cx
	End;
End;

Procedure FillShape(x,xsize : integer); assembler;
Var
	z1,z2 : byte;
	bitxpos : byte;
Asm
	mov	ax,[xsize]
	jz		@done
	cmp	ax,320
	jae	@done
	mov	ax,[x]				{find VGA display offset}
	sar	ax,2
	add	ax,[display1]
	mov	di,ax

	lea	si,[slope]        {find x1/x2 pos in 'slope' array}
	mov	ax,[x]
	mov	cx,ax
	shl	ax,2
	add	si,ax

	and	cl,3
	mov	al,$11
	shl	al,cl
	mov	[bitxpos],al

	mov	es,[SEGA000]
	mov	dx,$3C4
	mov	al,$02
	out	dx,al
	cld
@xloop:
	mov	bh,[si+TYPE(tSlopeType)] {fetch z value}
	lodsw									 {fetch first xpos}
	mov	dx,ax
	mov	bl,[si+TYPE(tSlopeType)] {fetch second z value}
	lodsw									 {fetch second xpos}
	cmp	ax,dx                    {make sure we go downwards...}
	jle	@exchange
	xchg	ax,dx
	xchg	bl,bh
@exchange:
	mov	[z1],bl
	mov	[z2],bh

	cmp	dx,0
	jl		@filledout_fast
	cmp	ax,200
	jge	@filledout_fast
	cmp	ax,0
	jge	@cut1
	xor	ax,ax
@cut1:
	cmp	dx,199
	jle	@cut2
	mov	dx,199
@cut2:
	push	si
	push	di

	mov	bx,ax					{ajust VGA address offset}
	add	bx,bx
	add	di,[OFFSET ytabel+bx]

	mov	cx,dx					{find height of line}
	sub	cx,ax
	jcxz	@filledout

	mov	ah,[z2]				{prepare z-slope run}
	sub	ah,[z1]
	xor	al,al
	cwd
	idiv	cx
	mov	bx,ax

	mov	dx,$3C5				{set VGA bitplane register}
	mov	al,[bitxpos]
	out	dx,al

	mov	ah,[z1]		  		{prepare z-slope run}
	xor	al,dl
	mov	dx,WIDTH
@loop:
	add	ax,bx					{add to z-coord run}
	mov	[es:di],ah			{put z-coord on VGA display as colour}
	add	di,dx					{find next VGA line}
	dec	cl
	jnz	@loop

@filledout:
	pop	di
	pop	si
@filledout_fast:
	rol	[bitxpos],1
	adc	di,0					{find next x-position}
	dec	[xsize]
	jnz	@xloop
@done:
End;


(*------------------------------------------------*)
(*                      MAIN                      *)
(*------------------------------------------------*)

Procedure RunOnce;
Var
	i : integer;
Begin
{$IFDEF DEBUG}
	SwapDisplay;
	VBLANK;
{$ELSE}
	SwapDisplay;
	while retraces = 0 do ;
	retraces := 0;
{$ENDIF}

{$IFDEF DEBUG}
	SetRGB(0,30,0,0);
{$ENDIF}

	ClearScreen;
	CalcAngle;
	RotateAllCoords;
{$IFDEF SORT}
	FindFaceZ;
	QuickSort(0,number_faces-1);
{$ENDIF}

	for i := 0 to number_faces-1 do with face[i] do
		CalcLight(l1,l2,l3);
	for i := 0 to number_coords-1 do with cbuffer[i] do
		if count>0 then Light:=LongDiv(Light, count);

	for i := number_faces-1 downto 0 do begin
		with face[i] do if FaceShown(l1,l2,l3) then begin
			ClearSlope;
			minx := 320; maxx := 0;
			CalcSlope(l1,l2);
			CalcSlope(l2,l3);
			CalcSlope(l3,l1);
			FillShape(minx, maxx-minx);
		end;
	end;

{$IFDEF DEBUG}
	SetRGB(0,0,0,0);
	while KeyHit[26] do ; {Hit 'P' to pause}
{$ENDIF}
End;


Begin
	{include all objects you wish to render here...}
	{use '*' to include all meshes!}
	IncludeObject[1]:='Object03';
	IncludeObject[2]:=''; {end with empty string}
	{now extract all coords and faces...}
	{Parameters:
	 1. .3ds filename
	 2. scale (6:1 ratio chosen with duck)
	 rest are internal to renderer...}
	if NOT Load3dsObject( 'DUCK.3DS', 6.0, face, coords, number_faces, number_coords ) then halt;

	{do the rendering thing...}
	OpenScreen;
	InitDemo;
	SetAllInterrupts;
	repeat RunOnce until Key='e';
	RestoreAllInterrupts;
	CloseScreen;
End.
