UNIT DLPLAY;
{
  DL ANIMATION PLAYER by Bjarke Viksoe
  Begun: Dec 1995
  Last Revised: Dec 1995

  - hmm, looks like it plays DL animations alright?
  -- DL version 1 format is pretty simply (too simple, in fact).
	  No compression, no nothing...
  --- only support of "medium" frames (160*100) on 320*200 screens!
}

INTERFACE

USES
	PICTURE;

Function DLInit(const filename : string) : Boolean;
Function DLDone : Boolean;
Function DLReadFrame(i : word) : Boolean;
Function DLDisplayFrame( screen : pointer ) : Boolean;

Type
	{Version 1 header}
	DL1HEADER = RECORD
		version : byte;
		title : array[0..19] of char;
		num_scrn : byte;
		ctl_len : byte;
		pad : byte;
	end;

VAR
	header : DL1HEADER;
	cmap_changed : Boolean;


IMPLEMENTATION

Type
	{Just for the record, here's the version 2 header}
	DL2HEADER = RECORD
		version : byte;
		format : byte;
		title : array[0..19] of char;
		author : array[0..19] of char;
		num_scrn : byte;
		ctl_len : byte;
		pad : array[1..3] of byte;
	end;
	{Our 320*200 bytes large buffer}
	DLBuffer = array[0..63999] of byte;

VAR
	f : FILE;
	buffer : ^DLBuffer;
	screen : byte;        {what screen are we using right now}
	quad : byte;          {what frame should we pick from current screen}
	bFrameRead : Boolean; {used for sanity check}

{$I-}

(*========================================================*)


Function DLReadHeader : Boolean;
var
	i, Result : word;
Begin
	DLReadHeader := FALSE;
	BlockRead(f, header, SizeOf(DL1HEADER), Result );
	BlockRead(f, CMAP, SizeOf(CMAP) );
	if IOResult<>0 then exit;
	with header do begin
		{sanity check}
		if (version<>1) then exit; {only supports version #1 for now!
											 Have the specs for v2, but l8r...}
	end;
	{decrypt data in header}
	with header do begin
		for i:=0 to SizeOf(Title) do Title[i]:=Chr(Ord(Title[i]) XOR 255);
		for i:=0 to SizeOf(Title) do if Title[i]=#255 then Title[i]:=#0;
		num_scrn := num_scrn XOR 255;
	end;
	cmap_changed := TRUE;
	DLReadHeader := TRUE;
end;

Function DLInit(const filename : string) : Boolean;
Var
	Result : word;
Begin
	DLInit:=FALSE;

	buffer:=NIL;
	Result:=IOResult; {Clear IOResult}
	Assign(F, filename);
	Reset(F,1);
	if IOResult<>0 then exit;
	if NOT DLReadHeader then exit;

	if MaxAvail < SizeOf(DLBuffer) then exit;
	New( buffer );
	if Ofs(buffer^)<>0 then exit; {DLBuffer must be at segment-border!}

	bFrameRead:=FALSE;
	screen:=$FF;
	quad:=0;

	DLInit:=TRUE;
End;

Function DLDone : Boolean;
Begin
	DLDone:=FALSE;
	if Assigned(buffer) then Dispose( buffer );
	buffer:=NIL;
	Close(f);
	if IOResult<>0 then exit;
	DLDone:=TRUE;
End;

(*========================================================*)


Function DLReadFrame(i : word) : Boolean;
Begin
	DLReadFrame:=FALSE;
	cmap_changed := FALSE;
	{Make sure frame number is within valid range}
	i:=i MOD (header.num_scrn * 4);

	if (i DIV 4) <> screen then begin
		screen:=i DIV 4;
		Seek(f, SizeOf(DL1HEADER) + (256*3) + (longint(screen)*320*200) );
		BlockRead(f, buffer^, SizeOf(DLBUFFER) );
		if IOResult<>0 then exit;
	end;
	quad:=i MOD 4;

	bFrameRead:=TRUE;
	DLReadFrame:=TRUE;
end;

(*========================================================*)


Function DLDisplayFrame( screen : pointer ) : Boolean;
var
	i : integer;
	srcpos, dstpos : word;
	p : pBuffer;
Begin
	DLDisplayFrame:=FALSE;
	if NOT bFrameRead then exit;

	srcpos:=((quad DIV 2)*100*320) + ((quad MOD 2) * 160);
	p:=screen;
	dstpos:=1;
	for i:=1 to 100 do begin
		Move( buffer^[srcpos], p^[dstpos], 160 );
		Inc(srcpos,320);
		Inc(dstpos,320);
	end;

	bFrameRead:=FALSE;
	DLDisplayFrame:=TRUE;
End;


End.
