{$M 16384, 196608, 196608}
Program orange; {(c) 1996 Daniel Vollmer, based on something
                 by Paul H. Kahler.}
const
     ratio=1.2;
     xcenter=160;ycenter=100;
     x=12900*2;y=16384;
type Screeny   = array[1..65535] of byte;
Var
      SinTable,CosTable: Array[0..255] of integer;
      Sin2Table,Cos2Table: Array[0..255] of integer;
      convert:array[0..127,0..127] of byte;
      vmap,screenptr,vscreen:^Screeny;
      vseg,Map,screen:word; {used as a pointer to the bitmap}
      rot:byte;
      dist:word;
      c,c2,c3:word;

Procedure MakeTables;                   {Creates sin/cos tables}
Var angle:real;
begin
     For c:=0 to 255 do begin   {use 256 degrees in circle}
         angle:=c;
         angle:=angle*pi/128;
         SinTable[c]:=round(Sin(angle)*256);
         CosTable[c]:=round(Cos(angle)*256);
         Sin2Table[c]:=round(Sin(angle+pi/2)*256*ratio);
         Cos2Table[c]:=round(Cos(angle+pi/2)*256*ratio);
     end;                 { the 1.2 accounts for pixel aspect ratio }
     for c:=0 to 127 do for c2:=0 to 127 do convert[c,c2]:=Round(c*(c2/127));
end;

procedure smooth_cut(seg,dest,count:word);external;
{$l graph2}

procedure dopal(c,r,g,b:byte);assembler;
asm
   mov dx,3c8h
   mov al,c
   out dx,al
   inc dx
   mov al,r
   out dx,al
   mov al,g
   out dx,al
   mov al,b
   out dx,al
end;

Procedure DrawScreen(x,y,scale:word; rot:byte; sourceseg,targseg:word);
var Temp:LongInt;
    ddx,ddy,d2x,d2y:integer;
    i,j:word;

begin
{ the following 8 lines of code calculate a 'right' and 'down' vector used
  for scanning the source bitmap. I use quotes because these directions
  depend on the rotation. For example, with a rotation, 'right' could mean
  up and to the left while 'down' means up and to the right. Since the
  destination image (screen) is scanned left-right/top-bottom, the bitmap
  needs to be scanned in arbitrary directions to get a rotation. }

     Temp:=(CosTable[rot]);Temp:=(Temp*Scale) div 256;
     ddx:=Temp;
     Temp:=(SinTable[rot]);Temp:=(Temp*Scale) div 256;
     ddy:=Temp;

{ Different tables are used for the 'down' vector to account for the non-
  square pixels in mode 13h (320x200). The 90 degree difference is built
  into the tables. If you don't like that, then use (rot+64)and255 here
  and take the pi/2 out of CreateTables. To each his own I guess. }

     Temp:=(Cos2Table[rot]);Temp:=(Temp*SCALE) div 256;
     d2x:=Temp;
     Temp:=(Sin2Table[rot]);Temp:=(Temp*SCALE) div 256;
     d2y:=Temp;

{ Since we want to rotate around the CENTER of the screen and not the upper
  left corner, we need to move 160 pixels 'left' and 100 'up' in the bitmap.}

     i:=(x-ddx*xcenter-d2x*ycenter) and 65535;
     j:=(y-ddy*xcenter-d2y*ycenter) and 65535;

{ The following chunk of assembly does the good stuff. It redraws the entire
  screen by scanning left-right/top-bottom on screen while also scanning the
  bitmap in the arbitrary directions determined above. }

         ASM
                 push ds
                 mov  ds,sourceseg
                 mov  es,targseg
                 xor  di,di         {the video memory at beginning}
                 mov  si,ddx        {add ax,si  faster than  add ax,[ddx] }
                 mov  cx,200        {Number of rows on Screen}
         @vloop:
                 push cx
                 mov  ax,[i]        {start scanning the source bitmap}
                 mov  dx,[j]        {at i,j which were calculated above.}
                 mov  cx,320        {Number of coulumns on screen}
         @hloop1:
                 add  ax,si        {add the 'right' vector to the current}
                 add  dx,[ddy]     {bitmap coordinates.  8.8 fixed point}
                 mov  bl,ah        {  bx = 256*int(y)+int(x)  }
                 mov  bh,dh
                 mov  bl,[ds:bx]   { load a pixel from source }
                 mov  [es:di],bl   { copy it to destination }
                 inc  di           { advance to next destination pixel }

                 dec  cx
                 jnz  @hloop1        {End of horizontal loop}
                 mov  ax,d2x        { get the 'down' vector }
                 mov  dx,d2y

{                 add  si,2     {** uncomment this instr. for extra fun **}

                 add  i,ax          { i,j is the starting coords for a line }
                 add  j,dx          { so this moves down one line }
                 pop  cx            { get the row count back and loop }
                 dec  cx
                 jnz  @vloop         { End of verticle loop }
                 pop  ds            { Restore the ds }
         end;
end;

PROCEDURE  loadpcx(targseg:word);
VAR q                          : FILE;
    b                          : ARRAY[0..2047] OF BYTE;
    anz, pos, c, w, h, e, pack : WORD;
    x, y                       : WORD;

BEGIN
  x := 0; y := 0;
  ASSIGN(q, paramstr(0)); RESET(q, 1);
  seek(q,filesize(q)-2515);
  BLOCKREAD(q, b, 128, anz);
  IF (b[0] <> 10) OR (b[3] <> 8) THEN BEGIN
    CLOSE(q);
    halt;
  END;
  w := SUCC((b[9] - b[5]) SHL 8 + b[8] - b[4]);
  h := SUCC((b[11] - b[7]) SHL 8 + b[10] - b[6]);
  pack := 0; c := 0; e := y + h;
  REPEAT
    BLOCKREAD(q, b, 2048, anz);
    pos := 0;
    WHILE (pos < anz) AND (y < e) DO BEGIN
      IF pack <> 0 THEN BEGIN
        FOR c := c TO c + pack DO mem[Targseg:y*w+c]:=b[pos];
        pack := 0;
      END ELSE
        IF (b[pos] AND $C0) = $C0 THEN pack := b[pos] AND $3F
        ELSE BEGIN
          mem[Targseg:y*w+c]:=b[pos];
          INC(c);
        END;
      INC(pos);
      IF c = w THEN BEGIN
        c := 0;
        INC(y);
      END;
    END;
  UNTIL (anz = 0) OR (y = e);
  SEEK(q, FILESIZE(q) - 3 SHL 8 - 1);
  BLOCKREAD(q, b, 3 SHL 8 + 1);
  IF b[0] = 12 THEN
    FOR x := 1 TO 3 SHL 8 + 1 DO
      b[x] := b[x] SHR 2;
  CLOSE(q);
END;

procedure vlb;assembler;
asm
  mov dx,3dah
@vert1:
  in al,dx
  test al,8
  jz @vert1
@vert2:
  in al,dx
  test al,8
  jnz @vert2
end;

procedure switch(source, dest : word);assembler;
asm
   push ds
   mov  es,dest
   mov  ds,source
   xor  si,si
   xor  di,di
   mov  cx,16000
   db $66
   rep  movsw
   pop  ds
end;

procedure cls(dest : word;col:byte);assembler;
asm
   mov  es,dest
   xor  di,di
   mov  al,col
   mov  ah,al
   mov  cx,32000
   rep  stosw
end;

procedure overlay(source,dest:word);assembler;
asm
   push  ds
   mov   es,dest
   mov   ds,source
   mov   cx,64000
   xor   di,di
   cld
@loop:
   xor   al,al
   repnz scasb
   dec   di
   mov   al,ds:[di]
   stosb
   or    cx,cx
   jnz   @loop
   pop   ds
end;

Begin
     getmem(vscreen,65535);
     vseg:=seg(vscreen^);
     getmem(vmap,65535);
     map:=seg(vmap^);
     getmem(screenptr,65535);
     screen:=seg(screenptr^);
     fillchar(vmap^,65535,255);
     mem[map:65535]:=255;mem[map:0]:=255;
     LoadPcx(map);
     fillchar(ScreenPtr^,sizeof(screen),0);
     for c:=1000 to 65000 do ScreenPtr^[c]:=Random(128-13)+13;
     for c:=1 to 3 do smooth_cut(screen,screen,65535);
     move(screenptr^[1000],screenptr^[1],64000);
     MakeTables;
     for c:=$2a downto 0 do begin
         dopal(7,c,c,c);
         vlb;
     end;
     asm
        Mov     Ax,13h
        Int     10h
     end;
     for c:=0 to 255 do dopal(c,0,0,0);
     rot:=0;c2:=0;dist:=4096+128*32;
     repeat
         for c:=0 to 127 do begin
             c3:=convert[c,c2];
             dopal(c,c3 div 4,0,c3 div 6);
             dopal(c+128,c3 div 6,c3 div 20,c3 div 4);
         end;
         DrawScreen(x,y,dist,rot,map,vseg);
         dec(dist,32);
         overlay(screen,vseg);
         switch(vseg,$a000);
         inc(c2);
     until dist=4096;
     repeat
        DrawScreen(x,y,dist,rot,map,vseg);
        dec(dist,32);
        overlay(screen,vseg);
        switch(vseg,$a000);
     until dist<=200;
     for rot:=0 to 207 do begin
        DrawScreen(x,y,dist,rot,map,vseg);
        overlay(screen,vseg);
        switch(vseg,$a000);
     end;
     repeat
        rot:=(rot+1) and 255;
        DrawScreen(x,y,dist,rot,map,vseg);
        dec(dist,4);
        overlay(screen,vseg);
        switch(vseg,$a000);
     until dist<=2;
     cls($a000,255);
     for c:=127 downto 0 do begin
         dopal(255,c div 6,c div 20,c div 4);
         vlb;
     end;
     freemem(vscreen,65535);
     freemem(vmap,65535);
     freemem(screenptr,65535);
     ASM {back to 80x25}
      MOV AX,3
      INT 10h
     END;
     writeln('(c) 1996 by Fusion aka Daniel Vollmer.');
     dopal(7,0,0,0);
     for c:=0 to $2a do begin
         dopal(7,c,c,c);
         vlb;
     end;
end.