// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

#include <unpack.hpp>
#include <unptabl.hpp>
#include <string.h>

//--------------------------------BITREAD-------------------------------------
void bitread::initread() {
  bufbitofs=bufbyteofs=bytesback=0;
}

signed char bitread::readbit() {
  if(bytesback<=0) {
    bytesback=read(buffer,FILEBUFLEN);
    if(bytesback<=0) return 0; // Burde ikke kunne ske...
    bufbyteofs=bufbitofs=0;
  }
  signed char s=getbytebit(buffer[bufbyteofs],bufbitofs++);
  if(bufbitofs==8) {
    bytesback--; bufbyteofs++; bufbitofs=0;
  }
  return !!s;
}

//-------------------------------BYTEWRITE-----------------------------------
void bytewrite::putbyte(unsigned char byte) {
  buffer[bufbyteofs++]=byte;
  if(bufbyteofs==FILEBUFLEN) {
    write(buffer,bufbyteofs); bufbyteofs=0;
  }
}

void bytewrite::flushbuf() { write(buffer,bufbyteofs); }

//------------------------------UNPACK_HUFFMAN--------------------------------
// Denne klasser tager sig af dynamisk huffman dekomprimering.
// Den stiller dels readbit() og dels getcode() til rdighed.
// readbit bruges til at lse en bit fra kilden og getcode til
// at hente en code gemt med huffman (se PACK.CPP)

int unpack_huffman::getcode() {
  unsigned c;

  c = son[R];

  /* travel from root to leaf, */
  /* choosing the smaller child node (son[]) if the read bit is 0, */
  /* the bigger (son[]+1} if 1 */
  while (c < T) {
    int a=readbit();
    c += a;
    c = son[c];
  }
  c -= T;
  update(c);
  return c;
}
//---------------------------------DECODE-------------------------------------
// Denne klasse tager sig af dekompriering. Jeg vil henvise til
// PACK.CPP og PACK.H for yderligere forklaring p princippet.
// Herefter skulle udpakningen give sig selv.

#ifdef USETABL
  // Ved at sl en byte op i huff_code (med scratch indhold i de bits der
  // ikke benyttes i den pgldende kode (de mindste betydende bit
  // kan indeholde scratch)) fr man original vrdien. Tilsvarende glder
  // for huff_len, her fs bare lngden p den storede bit sekvens

  extern unsigned char huff_unpack_code[];
  extern unsigned char huff_unpack_len[];
#endif

int decode::getpos() {
  #ifdef USETABL
    // Se forklaringer i tabel kommentaterer

    // Ls den frste byte:
    unsigned char readbuf=0;
    for(signed char a=0; a<8; a++) if(readbit()) setbytebit(readbuf,a);
    char hufflen=huff_unpack_len[readbuf];
    unsigned bufofs=huff_unpack_code[readbuf]<<6; // Indst 6 mest betydende del af adresse

    // Ls nu resten. St frst de bytes der allerede er lst for
    // meget ind p deres nye, rette plads:
    readbuf>>=hufflen;
    // Og ls s resten
    for(a=(8-hufflen);a<6;a++) if(readbit()) setbytebit(readbuf,a);

    bufofs+=readbuf;
  #else
    unsigned bufofs=0;
    for(signed char a=0; a<=11; a++) if(readbit()) setbytebit(bufofs,a);
  #endif


  if(bufofs!=ENDOFS)
    return bufofs;
  else
    return -1;
}

void decode::do_decode() {
  unpack_huffman::inithuff(); initwrite(); initread();

  unsigned curchar=0;
  for(;;) {
    int chr=getcode();
    if(chr==-1) break;
    if(chr<256) {
      putbyte(ascbuf[curchar]=chr);
      curchar=normal(curchar+1);
    } else {
      unsigned bufofs;
      int q=getpos(); if(q==-1) break;

      bufofs=dist(curchar,q);

      for(int a=0; a<chr-256+MIN_PACK_LEN; a++) {
  putbyte(ascbuf[curchar]=ascbuf[bufofs]);
  curchar=normal(curchar+1);
  bufofs=normal(bufofs+1);
      }
    }
  }
  flushbuf();
}