// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

#include <packint.hpp>
#include <huffman.hpp>
#include <string.h>

void base_huff::inithuff() {
  int i, j;

  // De frste N_CHAR noder sttes til de frste N_CHAR karakterer
  // og der etableres sn/forldre forbindelser med de sidste
  // N_CHAR karakterer af prnt. Dette sikkrer at den verste del
  // af denne tabel hele tiden bliver opdateret.
  // Frekvensen af alle leaf nodes sttes til 1:
  for (i = 0; i < N_CHAR; i++) {
    freq[i] = 1;
    prnt[i + T] = i;
    son[i] = i + T;
  }

  // I de sidste N_CHAR-1 karakterer af tret opbygges der en pn
  // pyramide der peger ned p de frste N_CHAR elementer.
  // Hvis der i en rkke er et ulige antal noder connectes den
  // direkete sammen med rkken ovenover
  i = 0; j = N_CHAR;
  while (j <= R) {
    freq[j] = freq[i] + freq[i + 1];
    son[j] = i;
    prnt[i] = prnt[i + 1] = j;
    i += 2; j++;
  }

  // Angiv hvor roden er:
  prnt[R] = 0;
  // En anden vil aldrig kunne have forldrenen i index 0 da
  // dette er noden med den laveste prioritet

  // Angiv, at nr vi kommer her til i update nr vi sger
  // efter hje frekvenser, s skal vi ikke lngere:
  freq[T] = 0xffff;
}

void base_huff::reconst() {
  #ifdef OLD_RECONST
    int i, j, k;
    unsigned f, l;

    // G tret igennem, og gr flgende ved alle noder der peger
    // p en karakter:
    //   1) St deres frekvens til den gamle frekvens +1 / 2
    //   2) St karakterene ind i den frst del af tabellen, der hvor
    //      de ogs stod ved init af tret. Undlad dog at opdatere
    //      parrent.
    // [collect leaf nodes in the first half of the table]
    // [and replace the freq by (freq + 1) / 2.]
    j = 0;
    for (i = 0; i < T; i++) {
      if (son[i] >= T) {
        freq[j] = (freq[i] + 1) / 2;
        son[j] = son[i];
        j++;
      }
    }

    // begin constructing tree by connecting sons
    for (i = 0, j = N_CHAR; j < T; i += 2, j++) {
      k = i + 1;
      // Vi gr nu igennem tret p samme mde som ved init
      // Flgende variabler er defineret
      // i = Venstre del af den over node vi processer
      // k = Hjre del af den over node vi processer
      // j = Den overnode vi er i
      f = freq[j] = freq[i] + freq[k];
      // f= Frekvens for denne over node
      for (k = j - 1; f < freq[k]; k--);
      k++;
      l = (j - k) * 2;
      memmove(&freq[k + 1], &freq[k], l);
      freq[k] = f;
      memmove(&son[k + 1], &son[k], l);
      son[k] = i;
    }

    // connect prnt
    for (i = 0; i < T; i++) {
      if ((k = son[i]) >= T) {
        prnt[k] = i;
      } else {
        prnt[k] = prnt[k + 1] = i;
      }
    }
  #else
    // Dette er vores egen opdaterings rutiner:
    freq[R]++; // Ellers kalde update reconst ved nedenstende kald
    for(int a=T; a<T+N_CHAR; a++) // G i gennem alle leaf nodes
      if(freq[prnt[a]] & 1) // Hvis en leaf node har en ullige frekvens
        update(a-T); // S opdater tret s det har en lige
    freq[R]--;
    // Divider nu ALLE frekvenser med 2. Vi risikerer ikke at vi
    // kommer til at forstyre den overordende rkkeflge, da alle
    // frekvenser m vre lige da alle leaf nodes er lige.
    for(a=0; a<T; a++) freq[a]/=2;
  #endif
}

void base_huff::update(int c) {
  int i, j, k, l;

  // Hvis vi har net maximum frekvensen s rekomstruer tret:
  if(freq[R] == MAX_FREQ)
    reconst();

  // Find den egentlige leaf node:
  c = prnt[c + T];

  // G nu hele vejen op til roden:
  do {
    k = ++freq[c]; // Forg frekvensen for denne node eller leaf

    // Hvis ndringen i frekvensen betyder, at tret ikke lngere
    // er sorteret efter frekvenser:
    if (k > freq[l = c + 1]) {

      // Sg op i tret s lnge frekvensen er strre:
      while (k > freq[++l]);
      l--;

      // Nu skal noden i index l byttes om med noden i index c
      // Byt frst om p frekvenserne, frekvensen i c er allerede gemt i k:
      freq[c] = freq[l];
      freq[l] = k;

      // De noder der fr var sn til c skal nu vre sn til l.
      // Angende sidste af nedenstende linier: Hvis vi er i en
      // karakter og ikke bare en mellem node, s er der kun en sn
      // og det er referencen til karakterne. Og s skal vi kun
      // opdatere en gang.
      i = son[c];
      prnt[i] = l;
      if (i < T) prnt[i + 1] = l;

      // De noder der fr var sn til l skal nu vre sn til c
      j = son[l];
      prnt[j] = c;
      if (j < T) prnt[j + 1] = c;

      // Lad c og l pege p deres nye snner:
      son[c] = j;
      son[l] = i;

      // Fortst nu videre op i hieraktiet fra det nye sted. Den
      // vej op vi forlader m jo ndvendigvis vre ok da den node
      // vi har sat derhen m have samme sandsynlighed som den node
      // vi fjernede havde fr denne rutine blev kaldt.
      c = l;
    }
  } while ((c = prnt[c]) != 0);  // Bliv ved til vi nr roden
}

int dist(int bufplace, int offset) {
  bufplace-=1; // Bufplace peger altid p den frste unbrugt char, lad
               // den nu pege p den sidste brugte
  if(bufplace<0) bufplace+=BUFSIZE;
  // nu skal der returnerede det antal bytes som offset er t.v. for bufplace
  if(offset<=bufplace) return bufplace-offset;
  return (BUFSIZE-offset)+bufplace;
}