// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

// Dette er et eksempel p et program der bruger C++ pakke rutinerne.
// Dette sker ved at bruge standard C++ fil funktioner.
// Jeg har aldrig brugt disse fr, s jeg garanterer ikke for noget :-)

#include <pack.hpp>
#include <unpack.hpp>
#include <fstream.h>
#include <ctype.h>

// Template der tager sig af filio - bruges bde af pakker og udpakker:
template <class base>
class fileio:public base {
  ofstream outfile; // Destinations fil
  ifstream infile;  // Source fil
  long rd,written;  // Antal bytes lst/skrevet

  void write_status() {
    cout<<"\rRead "<<rd<<". Written "<<written<<'.';
  }

  virtual int read(char* buffer, int bufsize) {
    infile.read(buffer,bufsize); // Ls fra filen
    int a=infile.gcount();       // Der er lst a antal bytes
    rd+=a;
    return a;
  }

  virtual void write(char* buffer, int bufsize) {
    outfile.write(buffer,bufsize); // Skriv det givne
    written+=bufsize;
    write_status();
  }

  public:

  fileio(char* ifile, char* ofile) :
    infile(ifile,ios::binary), outfile(ofile,ios::binary), rd(0), written(0)
    { write_status(); }

  ~fileio() { write_status(); cout<<'\n'; }
};

main(int argc, char* argv[]) {
  if((argc!=4) || ((toupper(argv[1][0])!='A') && (toupper(argv[1][0])!='E'))) {
    cout<<"Syntax: SUPPACK.EXE a|e packedfile unpackedfile\n";
    return 1;
  }

  if(toupper(argv[1][0])=='E') { // Pak ud
    fileio<decode>* e=new fileio<decode>(argv[2],argv[3]);
    e->do_decode();
    delete e;
  } else { // Pak
    fileio<encode>* e=new fileio<encode>(argv[3],argv[2]);
    e->do_encode();
    delete e;
  }

  return 0;
}