; These packing routines are based on the LZHUF.C program by
; Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

include ctrl\unpkint.ah
include shuffman\unptabl.ah
include ctrl\decode.ah

; Dette modul srger for selve udpakningen og inkluderer, hvis det
; nskes, selv den statiske huffman

pack_text segment

decode proc near
  call bitread_init   ; Initer bitread modulet
  call huff_init      ; Initer dynamisk huffman
  call lzss_init      ; Initer LZSS

  xor ch,ch           ; Indtil videre er alt lst fra AX
  xor ax,ax           ; Som derfor ogs er tom

  de_comp_loop:
    call read_bits    ; Indls sdan at AX indeholder 16 gyldige bits fra
                      ; input strmmen
    jc ferror         ; Hop ved fejl

    call huff_decode_char ; Lad dynamisk huffman fortolke nste kode
    or bh,bh              ; Er det en stooret char i intervallet [0..255]?
    jz char               ; S hop

    ; Vi har har gemt en position i bufferen - ls fra bufferen igen:
    push bx
    call read_bits ; Indls sdan at AX indeholder 16 gyldige bits fra
                   ; input strmmen
    pop bx
    jc ferror      ; Hop ved fejl

    ifdef usetabl
      ; Hvis positionen er gemt med statisk huffman:
      mov di,ax                   ; Gem AX
      xor ah,ah
      mov si,ax
      mov ax,di                   ; Genetabler AX
      mov cl,huff_unpack_len[si]  ; CL=Lngden af koden
      mov dh,huff_unpack_code[si] ; DH=6 mest betydende bits af offset
      shr ax,cl                   ; Fjern det lste antal bits
      mov dl,al
      shl dl,2                    ; DL=6 mindst betydende bits << 2
      shr dx,2                    ; DX=Offsetet
      shr ax,6                    ; Fjern yderligere 6 bits fra AX
      add cl,6
      sub ch,cl                   ; St CH til antallet af lste bits
      ; DX indeholder offsetet
      mov si,dx
    else
      ; Positionen er ikke gemt med dynamisk huffman
      mov si,ax
      and si,(1 shl 12)-1
      shr ax,12
      sub ch,12
    endif
    cmp si,endofs           ; Er det en slut kode?
    jz end_compress         ; S hop
    push cx
    push ax                 ; Gem bit-info
                            ; SI indeholder offsetet p vores streng
    sub bx,256-min_pack_len ; BX indeholder lngden p den
    call lzss_putstring     ; Send strengen
    jc ferrorpop            ; Hop ved fejl
    pop ax
    pop cx
    jmp de_comp_loop        ; Ls nste kode

  char:
  push cx
  push ax
  call lzss_putchar ; Send charen
  jc ferrorpop      ; Hop ved fejl
  pop ax
  pop cx
  jmp de_comp_loop  ; Ls nste kode

  end_compress:
  ; Kompressionen er succesfyldt afsluttet. Skriv det sidste:
  call lzss_done
  jc ferror
  ; Vi er nu helt frdige:
  clc     ; Angiv at der ikke er sket fejl.
  ferror: ; (Returner med den givne fejl kode)
  ret     ; Og returner
  ferrorpop:
  add sp,4 ; Fjern to vrdier fra stakken
  stc      ; Angiv at der er sket fejl
  ret      ; Og returner
endp

ends
end
