; These packing routines are based on the LZHUF.C program by
; Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

include ctrl\unpkint.ah

comment\
Virkemde for dele af read_bits rutinen. Eksempel:

Fra brugeren:
  0000123456789612, 12 bits tilbage
Fra bufferen
  ABCDEFGHIKJLMNOP, kr fra bit 6

Hvis vi nu skifter bufferen 6 mod hjre indeholder
den det vi skal bruge. Derefter skal den shiftes
12 til venstre for at st ud for bufferen.
Dette gr godt s lnge der i vores buffer word er flere eller samme antal
bits end der er lst af brugeren. Hvis derimod
16-6<16-12 <=> 6>12 skal der foretages ekstra processing.
\

pack_text segment
  ; Hrer til read_bits:

  end_reach:
  ; Vi har lst forbi slutningen og brugeren bliver ved med at ville
  ; lse data. Angiv, at vi ikke kan lse mere:
  mov ax,-1  ; Angiv EOF
  stc
  ret

  file_error:
  add sp,4   ; Fjern CX og AX fra stakken
  stc        ; Angiv fejl
  ret

  read_more:
  ; Der er ikke s meget tilbage i vores buffer som der burde vre
  cmp br.brendreac,0 ; Har vi lst alt hvad der er at lse?
  jnz end_reach      ; S hop.

  ; Flyt det af bufferen vi ikke har lst ned i starten af bufferen:
  mov dx,word ptr br.brbuf[bitread_bufsize-2] ; DX=Sidste word i bufferen
  mov word ptr br.brbuf,dx                    ; Flyt det ned i starten

  ; St sted
  mov dx,bitread_bufsize-2 ; DX=Antallet bytes der er plads til i bufferen
  mov si,offset br.brbuf+2 ; SI=Det sted vi skal hente bytes ind til

  push cx
  push ax ; Disse to bruges gennerelt

  call user_read ; Kald bruger-ls funktion.

  cmp ax,0
  jnz file_error ; Hop hvis der signaleres fejl

  pop ax
  pop cx

  ; bitread_bufsize-2=Lngde der blev requested lst, DX=Lngde der blev lst

  ; St slut p buffer:
  mov br.brendofs,offset br.brbuf
  add br.brendofs,dx ; rbufendofs=Den nste sidste byte i bufferen
  ; Og st nuvrende position:
  sub br.brbyteofs,bitread_bufsize-2
  mov si,br.brbyteofs

  ; Tjek for om vi har net EOF:
  cmp dx,bitread_bufsize-2
  jz buf_read        ; Bufferen er fyldt helt op - alt er ok
  mov br.brendreac,1 ; Vi kan ikke lse mere
  add br.brendofs,3  ; Vi skal frst stoppe nr vi er kommet forbi bufferen
  jmp buf_read       ; Fortst nu

read_bits proc near
  mov si,br.brbyteofs ; SI=Det nuvrende offset i bufferen

  ; Tjek for om bufferen er fyldt:
  cmp si,br.brendofs ; Har vi passeret slutningen?
  jae read_more      ; Hvis ja, s hop
  buf_read:          ; Nu er bufferen lst

  mov bx,[si]        ; BX=Buffer word
  mov cl,br.brbitofs ; CL=Antal bit vi er inde i buffer word
  shr bx,cl          ; BX=buffer wordet der hvor vi er kommet til
  xchg cl,ch         ; CL=Antal bits tilbage i brugerens word
  shl bx,cl          ; Scroll BX p plads
  or ax,bx           ; Lg de nye bits over i AX
  ; Variabel status:
  ; AX=Vores nye kode
  ; CL=Antal bits der oprindeligt var tilbage i brugerens word
  ; CH=Antal bits vi oprindeligt var inde i buffer wordet
  sub ch,cl
  ja extra_processing ; Der skal ske mere - se forklaring

  ; Opdater nu rbufbitofs og rbufbyte ofs:
  ; Der m vre lst 16-CL bits
  mov dl,br.brbitofs
  add dl,16
  sub dl,cl           ; DL=Antal bit vi er vk fra rbufbyteofs
  mov dh,dl           ; DH=DL
  and dh,111b         ; DH=Den nye rbufbitofs
  mov br.brbitofs,dh  ; Gem den
  shr dl,3
  xor dh,dh
  add br.brbyteofs,dx ; Opdater den nye byte position

  extra_end:
  ; Vi har lst alt - AX indeholder det nye word
  mov ch,16 ; Den er fyldt
  clc       ; Vi har ingen fejl
  ret       ; Returner

  extra_processing:
  ; Vi skal til at lse mere fra bufferen.
  ; CH indeholder det antal bits vi skal lse
  mov bx,[si+2] ; Ls det nste word i bufferen
  mov cl,16
  sub cl,ch
  shl bx,cl     ; Flyt de bytes vi skal bruge op verst i wordet
  or ax,bx      ; Og lg dem over i AX
  mov dl,16     ; Der er lst 16 bits fra oprindelige rbufbyteofs
  add dl,ch     ; Plus dette antal
  mov dh,dl     ; =DH=DL
  and dh,111b   ; Gem nu de nye vrdier
  mov br.brbitofs,dh
  shr dl,3
  xor dh,dh
  add br.brbyteofs,dx
  jmp extra_end
endp

bitread_init proc near
  ; Initer de forskellige variabler.
  ; Frst de simple:
  mov br.brbitofs,0
  mov br.brendreac,0

  ; Angiv s at vi er net slutningen af bufferen og at vi
  ; har lst den hele buffer
  mov br.brbyteofs,offset br.brbuf+bitread_bufsize
  mov br.brendofs,offset br.brbuf+bitread_bufsize-2

  ret
endp

ends
end
