Unit VGAGraph;

Interface

Procedure InitGraph;
Procedure CloseGraph;
Procedure PutPixel( x, y : Integer; c : Byte );
Procedure SetColor( c : Byte );
Procedure Line( x1, y1, x2, y2 : Integer );
Procedure SetRGBPalette( i, r, g, b : Byte );
Procedure GetRGBPalette( i : byte;  var r, g, b : Byte );

Function GetPixel( x, y : Integer ) : Byte;

Implementation

var
   FColor : Byte;

Function GetPixel( x, y : Integer ) : Byte;
begin
     GetPixel := Mem[$A000:(y*320)+x];
end;

Procedure InitGraph;  Assembler;
asm
  mov ax, 0013h
  int 10h
end;

Procedure CloseGraph;  Assembler;
asm
  mov ax, 0003h
  int 10h
end;

Procedure PutPixel( x, y : Integer; c : Byte );
begin
  Mem[$A000:(y*320)+x] := c;
end;

Procedure SetColor( c : Byte );
begin
     FColor := c;
end;

Procedure Line( x1, y1, x2, y2 : Integer );
var
   Slope : Real;
   RSlope : Real;
   i : Integer;
   DifX, DifY : Integer;
begin
     If (x1-x2)=0 then
       begin
            If y2 >= y1 then
               For i := y1 to y2 do
                 PutPixel( x1, i, FColor );
            If y1 > y2 then
               For i := y2 to y1 do
                 PutPixel( x1, i, FColor );
            Exit;
       end;
     If (y1-y2)=0 then
       begin
            If x1 < x2 then
               For i := x1 to x2 do
                   PutPixel( i, y1, FColor );
            If x1 >= x2 then
               For i := x2 to x1 do
                   PutPixel( i, y1, FColor );
            Exit;
       end;

     Slope := (y1 - y2) / (x1 - x2);
     DifX := Abs( x1 - x2 );
     DifY := Abs( y1 - y2 );
{     If x1 > x2 then
        x1 := x2;
     If y1 > y2 then
        y1 := y2;}
     If DifX <= DifY then
       begin
            If y1 > y2 then
              begin
                x1 := x2;
                y1 := y2;
              end;
            RSlope := 1 / Slope;
            For i := 0 to DifY do
                PutPixel( Trunc( i * RSlope ) + x1, i + y1, FColor );
       end
      else
        begin
          If x1 > x2 then
            begin
              x1 := x2;
              y1 := y2;
            end;
            For i := 0 to DifX do
                PutPixel( i + x1, Trunc( Slope * i ) + y1, FColor );
        end;
end;

Procedure SetRGBPalette( i, r, g, b : Byte );
begin
  Port[$3C8] := i;
  Port[$3C9] := r;
  Port[$3C9] := g;
  Port[$3C9] := b;
end;

Procedure GetRGBPalette( i : byte;  var r, g, b : Byte );
begin
  Port[$3C8] := i;
  r := Port[$3C9];
  g := Port[$3C9];
  b := Port[$3C9];
end;

Begin
  FColor := 15;
End.
